/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.DestinationSessionProxy;
import com.ibm.ws.sib.comms.client.OrderingContextProxy;
import com.ibm.ws.sib.comms.client.Transaction;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsLightTrace;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ProducerSessionProxy
extends DestinationSessionProxy
implements ProducerSession {
    private static String CLASS_NAME = ProducerSessionProxy.class.getName();
    private static final TraceComponent tc = SibTr.register(ProducerSessionProxy.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private ReentrantReadWriteLock closeLock;
    private short lowestPriority = (short)12;
    private static final boolean exchangeTransactedSends = CommsUtils.getRuntimeBooleanProperty("sib.comms.ForceTransactedSendExchange", "false");
    private static final boolean exchangeExpressSends = CommsUtils.getRuntimeBooleanProperty("sib.comms.ForceExpressSendExchange", "false");
    private OrderingContextProxy oc = null;
    private final DestinationType destType;

    public ProducerSessionProxy(Conversation con, ConnectionProxy cp, OrderingContextProxy oc, CommsByteBuffer buf, SIDestinationAddress destAddr, DestinationType destType) {
        super(con, cp);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{con, cp, oc, buf, destAddr, destType});
        }
        this.oc = oc;
        this.destType = destType;
        this.setDestinationAddress(destAddr);
        this.inflateData(buf);
        this.closeLock = cp.closeLock;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(SIBusMessage msg, SITransaction tran) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        block12: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{msg, tran});
            }
            try {
                this.closeLock.readLock().lockInterruptibly();
                try {
                    this.checkAlreadyClosed();
                    if (tran != null) {
                        SITransaction sITransaction = tran;
                        synchronized (sITransaction) {
                            if (!((Transaction)tran).isValid()) {
                                throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1022", null, null));
                            }
                            this._send(msg, tran);
                            break block12;
                        }
                    }
                    this._send(msg, null);
                }
                finally {
                    this.closeLock.readLock().unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    private void _send(SIBusMessage msg, SITransaction tran) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_send");
        }
        boolean sendSuccessful = false;
        short jfapPriority = JFapChannelConstants.getJFAPPriority(msg.getPriority());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Sending with JFAP priority of " + jfapPriority));
        }
        this.updateLowestPriority(jfapPriority);
        boolean requireReply = tran != null && !exchangeTransactedSends ? false : (exchangeExpressSends ? true : msg.getReliability() != Reliability.BEST_EFFORT_NONPERSISTENT && msg.getReliability() != Reliability.EXPRESS_NONPERSISTENT);
        HandshakeProperties props = this.getConversation().getHandshakeProperties();
        if (props.getFapLevel() >= 9) {
            this.sendChunkedMessage(tran, msg, requireReply, jfapPriority);
        } else {
            this.sendEntireMessage(tran, msg, null, requireReply, jfapPriority);
        }
        sendSuccessful = true;
        if (TraceComponent.isAnyTracingEnabled()) {
            CommsLightTrace.traceMessageId(tc, "SendMsgTrace", msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_send");
        }
    }

    private void sendEntireMessage(SITransaction tran, SIBusMessage msg, List<DataSlice> messageSlices, boolean requireReply, short jfapPriority) throws SIResourceException, SISessionUnavailableException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendEntireMessage", (Object)new Object[]{tran, msg, messageSlices, requireReply, jfapPriority});
        }
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.putShort(this.getConnectionObjectID());
        request.putShort(this.getProxyID());
        request.putSITransaction(tran);
        if (messageSlices == null) {
            request.putClientMessage(msg, this.getCommsConnection(), this.getConversation());
        } else {
            request.putMessgeWithoutEncode(messageSlices);
        }
        this.sendData(request, jfapPriority, requireReply, tran, 75, 76, 203);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendEntireMessage");
        }
    }

    private void sendChunkedMessage(SITransaction tran, SIBusMessage msg, boolean requireReply, short jfapPriority) throws SIResourceException, SISessionUnavailableException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendChunkedMessage", (Object)new Object[]{tran, msg, requireReply, jfapPriority});
        }
        CommsByteBuffer request = this.getCommsByteBuffer();
        List<DataSlice> messageSlices = null;
        try {
            messageSlices = request.encodeFast((AbstractMessage)((JsMessage)msg), this.getCommsConnection(), this.getConversation());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Message encoded into " + messageSlices.size() + " slice(s)"));
            }
        }
        catch (SIConnectionDroppedException e) {
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendChunkedMessage"), (String)"1-004-0003", (Object[])new Object[]{msg, this});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to encode message", (Object)e);
            }
            throw new SIResourceException((Throwable)e);
        }
        int msgLen = 0;
        for (DataSlice slice : messageSlices) {
            msgLen += slice.getLength();
        }
        if (msgLen < 1024000) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Message is smaller than 1024000");
            }
            this.sendEntireMessage(tran, msg, messageSlices, requireReply, jfapPriority);
        } else {
            for (int x = 0; x < messageSlices.size(); ++x) {
                DataSlice slice;
                slice = messageSlices.get(x);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Sending slice:", (Object)slice);
                }
                boolean first = x == 0;
                boolean last = x == messageSlices.size() - 1;
                byte flags = 0;
                if (first) {
                    flags = (byte)(flags | 1);
                }
                if (last) {
                    flags = (byte)(flags | 4);
                } else if (!first) {
                    flags = (byte)(flags | 2);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Flags: " + flags));
                }
                if (!first) {
                    request = this.getCommsByteBuffer();
                }
                request.putShort(this.getConnectionObjectID());
                request.putShort(this.getProxyID());
                request.putSITransaction(tran);
                request.put(flags);
                request.putDataSlice(slice);
                if (!last) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Sending first / middle chunk");
                    }
                    this.jfapSend(request, 115, jfapPriority, false, Conversation.ThrottlingPolicy.BLOCK_THREAD);
                    continue;
                }
                this.sendData(request, jfapPriority, requireReply, tran, 114, 115, 245);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendChunkedMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void sendData(CommsByteBuffer request, short jfapPriority, boolean requireReply, SITransaction tran, int outboundSegmentType, int outboundNoReplySegmentType, int replySegmentType) throws SIResourceException, SISessionUnavailableException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && ProducerSessionProxy.tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)ProducerSessionProxy.tc, (String)"sendData", (Object)new Object[]{request, jfapPriority, requireReply, tran, outboundSegmentType, outboundNoReplySegmentType, replySegmentType});
        }
        if (requireReply) {
            reply = this.jfapExchange(request, outboundSegmentType, jfapPriority, false);
            try {
                err = reply.getCommandCompletionCode(replySegmentType);
                if (err == 0) ** GOTO lbl28
                this.checkFor_SISessionUnavailableException(reply, err);
                this.checkFor_SISessionDroppedException(reply, err);
                this.checkFor_SIConnectionUnavailableException(reply, err);
                this.checkFor_SIConnectionDroppedException(reply, err);
                this.checkFor_SIResourceException(reply, err);
                this.checkFor_SIConnectionLostException(reply, err);
                this.checkFor_SILimitExceededException(reply, err);
                this.checkFor_SINotAuthorizedException(reply, err);
                this.checkFor_SIIncorrectCallException(reply, err);
                this.checkFor_SINotPossibleInCurrentConfigurationException(reply, err);
                this.checkFor_SIErrorException(reply, err);
                this.defaultChecker(reply, err);
            }
            finally {
                if (reply != null) {
                    reply.release();
                }
            }
        } else {
            this.jfapSend(request, outboundNoReplySegmentType, jfapPriority, false, Conversation.ThrottlingPolicy.BLOCK_THREAD);
            if (tran != null) {
                ((Transaction)tran).updateLowestMessagePriority(jfapPriority);
            }
        }
lbl28:
        // 5 sources

        if (TraceComponent.isAnyTracingEnabled() && ProducerSessionProxy.tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)ProducerSessionProxy.tc, (String)"sendData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SIResourceException, SIConnectionLostException, SIErrorException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
        }
        if (!this.isClosed()) {
            try {
                this.closeLock.writeLock().lockInterruptibly();
                try {
                    CommsByteBuffer request = this.getCommsByteBuffer();
                    request.putShort(this.getConnectionObjectID());
                    request.putShort(this.getProxyID());
                    CommsByteBuffer reply = this.jfapExchange(request, 74, this.lowestPriority, true);
                    try {
                        short err = reply.getCommandCompletionCode(202);
                        if (err != 0) {
                            this.checkFor_SIConnectionDroppedException(reply, err);
                            this.checkFor_SIResourceException(reply, err);
                            this.checkFor_SIConnectionLostException(reply, err);
                            this.checkFor_SIErrorException(reply, err);
                            this.defaultChecker(reply, err);
                        }
                    }
                    finally {
                        if (reply != null) {
                            reply.release();
                        }
                    }
                    this.setClosed();
                    if (this.oc != null) {
                        this.oc.decrementUseCount();
                    }
                }
                finally {
                    this.closeLock.writeLock().unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    private void updateLowestPriority(short messagePriorty) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateLowestPriority", (Object)("" + messagePriorty));
        }
        if (messagePriorty < this.lowestPriority) {
            this.lowestPriority = messagePriorty;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateLowestPriority");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/ProducerSessionProxy.java, SIB.comms, WASX.SIB, uu1215.01 1.80");
        }
    }
}

