/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.AcceptListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapHeartbeatTimeoutException;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.framework.IOConnectionContext;
import com.ibm.ws.sib.jfapchannel.framework.IOReadRequestContext;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.impl.BaseConnectionReadCallback;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.ConversationTable;
import com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser;
import com.ibm.ws.sib.jfapchannel.impl.JFapUtils;
import com.ibm.ws.sib.jfapchannel.netty.NettyIOConnectionContext;
import com.ibm.ws.sib.jfapchannel.netty.NettyIOReadRequestContext;
import com.ibm.ws.sib.jfapchannel.netty.NettyNetworkConnection;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import io.openliberty.netty.internal.exception.NettyException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;

public class NettyConnectionReadCompletedCallback
extends BaseConnectionReadCallback {
    private static final TraceComponent tc = SibTr.register(NettyConnectionReadCompletedCallback.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private Connection thisConnection = null;
    private ConversationImpl conversation;
    private NettyIOConnectionContext tcpCtx;
    private NettyIOReadRequestContext readCtx;
    private volatile boolean receivePhysicalCloseRequest = false;
    private final SynchronizedFlag awaitingHeartbeatResponse = new SynchronizedFlag();
    private int currentHeartbeatTimeout;
    private boolean connectionClosing = false;
    private Object connectionClosingLock = new Object();
    private InboundTransmissionParser xmitParser;
    private Object invocationCountLock = new Object();
    private int invocationCount = 0;
    private Thread lastInvokedOnThread = null;
    private static final int MAX_INVOCATIONS_BEFORE_THREAD_SWITCH = 10;

    protected NettyConnectionReadCompletedCallback(Connection c, boolean onClient, AcceptListener al, ConversationTable ct, ConversationImpl conv, IOConnectionContext x) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{c, "" + onClient, al, ct, conv, x});
        }
        this.thisConnection = c;
        this.conversation = conv;
        if (x != null && !(x instanceof NettyIOConnectionContext)) {
            throw new SIResourceException("Invalid connection context passed");
        }
        this.tcpCtx = (NettyIOConnectionContext)x;
        this.readCtx = (NettyIOReadRequestContext)x.getReadInterface();
        this.xmitParser = new InboundTransmissionParser(c, al, onClient);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readCompleted(WsByteBuffer buff, IOReadRequestContext rctx, NettyNetworkConnection vc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readCompleted", (Object)new Object[]{buff});
        }
        Object object = this.invocationCountLock;
        synchronized (object) {
            if (this.lastInvokedOnThread == Thread.currentThread()) {
                ++this.invocationCount;
            } else {
                this.invocationCount = 1;
                this.lastInvokedOnThread = Thread.currentThread();
            }
        }
        try {
            object = this;
            synchronized (object) {
                boolean done = false;
                do {
                    int timeout;
                    done = true;
                    WsByteBuffer contextBuffer = buff;
                    contextBuffer.flip();
                    if (this.conversation.getConversationType() == Conversation.CLIENT) {
                        this.xmitParser.setType(Conversation.CLIENT);
                    } else if (this.conversation.getConversationType() == Conversation.ME) {
                        this.xmitParser.setType(Conversation.ME);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        JFapUtils.debugTraceWsByteBuffer(this, tc, contextBuffer, 16, "data received");
                    }
                    this.xmitParser.parse(contextBuffer);
                    if (rctx == null || this.receivePhysicalCloseRequest) continue;
                    if (this.awaitingHeartbeatResponse.isSet()) {
                        timeout = this.currentHeartbeatTimeout;
                        if (timeout < 1) {
                            timeout = 1;
                        }
                    } else {
                        timeout = this.thisConnection.getHeartbeatInterval();
                    }
                    if (timeout > 0) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("setting heartbeat timeout to: " + timeout * 1000 + " milliseconds"));
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"not using a heartbeat timeout");
                        }
                        timeout = 0;
                    }
                    boolean closing = false;
                    Object object2 = this.connectionClosingLock;
                    synchronized (object2) {
                        closing = this.connectionClosing;
                    }
                    if (closing) continue;
                    boolean forceQueue = false;
                    Object object3 = this.invocationCountLock;
                    synchronized (object3) {
                        if (this.invocationCount > 10) {
                            forceQueue = true;
                            this.lastInvokedOnThread = null;
                        }
                    }
                    if (this.thisConnection.isLoggingIOEvents()) {
                        this.thisConnection.getConnectionEventRecorder().logDebug("invoking readCtx.read() on context " + System.identityHashCode(rctx) + " with a timeout of " + timeout);
                    }
                    try {
                        vc.setHearbeatInterval(timeout);
                        done = rctx.read(1, this, forceQueue, timeout) == null;
                    }
                    catch (NettyException e) {
                        throw new RuntimeException(e);
                    }
                } while (!done);
            }
        }
        catch (Error error) {
            FFDCFilter.processException((Throwable)error, (String)"com.ibm.ws.sib.jfapchannel.impl.NettyConnectionReadCompletedCallback", (String)"00050013", (Object)this.thisConnection.getDiagnostics(true));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)error);
            }
            this.thisConnection.invalidate(false, error, "Error caught in NettyConnectionReadCompletedCallback.complete()");
            throw error;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.jfapchannel.impl.NettyConnectionReadCompletedCallback", (String)"00050015", (Object)this.thisConnection.getDiagnostics(true));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)runtimeException);
            }
            this.thisConnection.invalidate(false, runtimeException, "RuntimeException caught in NettyConnectionReadCompletedCallback.complete");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readCompleted");
        }
    }

    @Override
    public void complete(NetworkConnection vc, IOReadRequestContext rctx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"complete", (Object)new Object[]{vc, rctx});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
            SibTr.error((TraceComponent)tc, (String)"Can't call this method for Netty specifics", (Object)rctx);
        }
        RuntimeException runtimeException = new RuntimeException("Invalid method called for Netty");
        FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.jfapchannel.impl.NettyConnectionReadCompletedCallback", (String)"00050015", (Object)this.thisConnection.getDiagnostics(true));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)runtimeException);
        }
        this.thisConnection.invalidate(false, runtimeException, "RuntimeException caught in NettyConnectionReadCompletedCallback.complete");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error(NetworkConnection vc, IOReadRequestContext rrc, IOException t) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"error", (Object)new Object[]{vc, rrc, t});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && t != null) {
            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)t);
        }
        if (this.thisConnection.isLoggingIOEvents()) {
            this.thisConnection.getConnectionEventRecorder().logDebug("error method invoked on read context " + System.identityHashCode(rrc) + " with exception " + t);
        }
        try {
            NettyConnectionReadCompletedCallback nettyConnectionReadCompletedCallback = this;
            synchronized (nettyConnectionReadCompletedCallback) {
                if (this.receivePhysicalCloseRequest) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"ignoring as in process of close");
                    }
                } else if (t instanceof SocketTimeoutException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"error is as a result of a timeout");
                    }
                    if (this.awaitingHeartbeatResponse.isSet()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"timed out waiting for heartbeat response");
                        }
                        this.thisConnection.getConnectionEventRecorder().logDebug("timed out waiting for heartbeat response");
                        String remoteHostAddress = "<Unknown>";
                        String remoteHostPort = "<Unknown>";
                        String chainName = this.thisConnection.chainName;
                        if (this.tcpCtx != null) {
                            InetAddress addr = this.tcpCtx.getRemoteAddress();
                            if (addr != null) {
                                remoteHostAddress = addr.getHostAddress();
                            }
                            remoteHostPort = "" + this.tcpCtx.getRemotePort();
                        }
                        if (this.thisConnection.isInbound()) {
                            if (this.conversation.getConversationType() == Conversation.ME) {
                                SibTr.error((TraceComponent)tc, (SibTr.Suppressor)SibTr.Suppressor.ALL_FOR_A_WHILE_SIMILAR_INSERTS, (String)"ME_NOT_RESPONDING_SICJ0041", (Object)new Object[]{remoteHostAddress, chainName, "" + this.currentHeartbeatTimeout});
                            } else if (this.conversation.getConversationType() == Conversation.CLIENT) {
                                SibTr.error((TraceComponent)tc, (SibTr.Suppressor)SibTr.Suppressor.ALL_FOR_A_WHILE_SIMILAR_INSERTS, (String)"CLIENT_NOT_RESPONDING_SICJ0042", (Object)new Object[]{remoteHostAddress, chainName, "" + this.currentHeartbeatTimeout});
                            }
                        } else if (this.conversation.getConversationType() == Conversation.ME) {
                            SibTr.error((TraceComponent)tc, (SibTr.Suppressor)SibTr.Suppressor.ALL_FOR_A_WHILE_SIMILAR_INSERTS, (String)"ME_NOT_RESPONDING_OUTBOUND_SICJ0070", (Object)new Object[]{remoteHostAddress, remoteHostPort, chainName, "" + this.currentHeartbeatTimeout});
                        } else if (this.conversation.getConversationType() == Conversation.CLIENT) {
                            SibTr.error((TraceComponent)tc, (SibTr.Suppressor)SibTr.Suppressor.ALL_FOR_A_WHILE_SIMILAR_INSERTS, (String)"CLIENT_NOT_RESPONDING_OUTBOUND_SICJ0071", (Object)new Object[]{remoteHostAddress, remoteHostPort, chainName, "" + this.currentHeartbeatTimeout});
                        }
                        JFapHeartbeatTimeoutException exception = new JFapHeartbeatTimeoutException("Connection dropped after heartbeat request went unacknowledged");
                        exception.initCause(t);
                        FFDCFilter.processException((Throwable)((Object)exception), (String)"com.ibm.ws.sib.jfapchannel.impl.NettyConnectionReadCompletedCallback", (String)"00050007", (Object)this.thisConnection.getDiagnostics(true));
                        this.thisConnection.invalidate(false, (Throwable)((Object)exception), "heartbeat request was not acknowledged");
                    } else {
                        if (this.thisConnection.getHeartbeatInterval() == 0) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"timed out but heartbeating now switched off");
                            }
                            Object remoteHostAddress = this.connectionClosingLock;
                            synchronized (remoteHostAddress) {
                                if (!this.connectionClosing) {
                                    if (this.thisConnection.isLoggingIOEvents()) {
                                        this.thisConnection.getConnectionEventRecorder().logDebug("invoking readCtx.read() on context " + System.identityHashCode(this.readCtx) + " with no timeout");
                                    }
                                    try {
                                        ((NettyNetworkConnection)vc).setHearbeatInterval(0);
                                        this.readCtx.read(1, this, false, -1);
                                    }
                                    catch (NettyException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"sending heartbeat request");
                        }
                        this.awaitingHeartbeatResponse.set();
                        this.currentHeartbeatTimeout = this.thisConnection.getHeartbeatTimeout();
                        this.thisConnection.getConnectionEventRecorder().logDebug("sending heartbeat request and waiting up to " + this.currentHeartbeatTimeout + " seconds for a response");
                        Throwable sendException = null;
                        try {
                            this.thisConnection.sendHeartbeat();
                        }
                        catch (SIConnectionLostException e) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Exception received when heartbeating peer (" + e.toString() + ").  Dropping connection"));
                            }
                            sendException = e;
                        }
                        catch (SIConnectionDroppedException e) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Exception received when heartbeating peer (" + e.toString() + ").  Dropping connection"));
                            }
                            sendException = e;
                        }
                        if (sendException == null) {
                            int timeout = this.currentHeartbeatTimeout * 1000;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("setting heartbeat timeout to: " + timeout + " milliseconds"));
                            }
                            Object object = this.connectionClosingLock;
                            synchronized (object) {
                                if (!this.connectionClosing) {
                                    if (this.thisConnection.isLoggingIOEvents()) {
                                        this.thisConnection.getConnectionEventRecorder().logDebug("invoking readCtx.read() on context " + System.identityHashCode(this.readCtx) + " with a timeout of " + timeout);
                                    }
                                    try {
                                        ((NettyNetworkConnection)vc).setHearbeatInterval(this.currentHeartbeatTimeout);
                                        this.readCtx.read(1, this, false, timeout);
                                    }
                                    catch (NettyException e) {
                                        this.thisConnection.invalidate(false, e, "exception caught while attempting to send heartbeat");
                                    }
                                }
                            }
                        }
                        this.thisConnection.invalidate(false, sendException, "exception caught while attempting to send heartbeat");
                    }
                } else {
                    this.thisConnection.invalidate(false, t, "IOException received for connection - " + t.getMessage());
                    NettyIOReadRequestContext req = this.readCtx;
                    WsByteBuffer[] buffers = req.getBuffers();
                    if (buffers != null) {
                        for (WsByteBuffer buffer : buffers) {
                            try {
                                buffer.release();
                            }
                            catch (RuntimeException e) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught exception on releasing buffer.", (Object)e);
                            }
                        }
                        req.setBuffers(null);
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Request has no buffers: " + req));
                    }
                }
            }
        }
        catch (Error error) {
            FFDCFilter.processException((Throwable)error, (String)"com.ibm.ws.sib.jfapchannel.impl.NettyConnectionReadCompletedCallback", (String)"00050014", (Object)this.thisConnection.getDiagnostics(true));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)error);
            }
            this.thisConnection.invalidate(false, error, "Error caught in NettyConnectionReadCompletedCallback.error()");
            throw error;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.jfapchannel.impl.NettyConnectionReadCompletedCallback", (String)"00050016", (Object)this.thisConnection.getDiagnostics(true));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)runtimeException);
            }
            this.thisConnection.invalidate(false, runtimeException, "RuntimeException caught in NettyConnectionReadCompletedCallback.error()");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void physicalCloseNotification() {
        Object object = this.connectionClosingLock;
        synchronized (object) {
            this.connectionClosing = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void heartbeatReceived() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"heartbeatReceived");
        }
        SynchronizedFlag synchronizedFlag = this.awaitingHeartbeatResponse;
        synchronized (synchronizedFlag) {
            if (this.awaitingHeartbeatResponse.isSet()) {
                this.awaitingHeartbeatResponse.clear();
                this.thisConnection.getConnectionEventRecorder().logDebug("received heartbeat response");
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Spurious heartbeat!");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"heartbeatReceived");
        }
    }

    @Override
    protected void stopReceiving() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stopReceiving");
        }
        this.receivePhysicalCloseRequest = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stopReceiving", (Object)("" + this.receivePhysicalCloseRequest));
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/NettyConnectionReadCompletedCallback.java, SIB.comms, WASX.SIB, uu1215.01 1.58");
        }
    }

    private static class SynchronizedFlag {
        private boolean flag;

        private SynchronizedFlag() {
        }

        protected synchronized void set() {
            this.flag = true;
        }

        protected synchronized void clear() {
            this.flag = false;
        }

        protected boolean isSet() {
            return this.flag;
        }
    }
}

