/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.netty;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.framework.IOReadCompletedCallback;
import com.ibm.ws.sib.jfapchannel.framework.IOReadRequestContext;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.NettyConnectionReadCompletedCallback;
import com.ibm.ws.sib.jfapchannel.netty.NettyIOReadRequestContext;
import com.ibm.ws.sib.jfapchannel.netty.NettyNetworkConnection;
import com.ibm.ws.sib.jfapchannel.netty.NettyNetworkConnectionFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.Attribute;
import io.openliberty.netty.internal.exception.NettyException;
import java.net.SocketTimeoutException;

public class NettyJMSHeartbeatHandler
extends IdleStateHandler {
    private static final TraceComponent tc = SibTr.register(NettyJMSHeartbeatHandler.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");

    public NettyJMSHeartbeatHandler(int heartbeatTimeSeconds) {
        super(heartbeatTimeSeconds, 0, 0);
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"<init>", (Object)heartbeatTimeSeconds);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"<init>");
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"channelActive", (Object)ctx.channel());
        }
        super.channelActive(ctx);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"channelActive", (Object)ctx.channel());
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"handlerAdded", (Object)ctx.channel());
        }
        super.handlerAdded(ctx);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"handlerAdded", (Object)ctx.channel());
        }
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("channelIdleTriggered for: " + ctx.channel()));
        }
        this.userEventTriggered(ctx, evt);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"userEventTriggered", (Object)new Object[]{ctx.channel(), evt});
        }
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent event = (IdleStateEvent)evt;
            if (event.state() != IdleState.READER_IDLE) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                    SibTr.warning((TraceComponent)tc, (String)"userEventTriggered: Event triggered was not a read timeout. Event will be moved through the pipeline.", (Object)evt);
                }
            } else {
                Attribute attr = ctx.channel().attr(NettyNetworkConnectionFactory.CONNECTION);
                Connection connection = (Connection)attr.get();
                if (connection != null) {
                    IOReadCompletedCallback callback = connection.getReadCompletedCallback();
                    IOReadRequestContext readCtx = connection.getReadRequestContext();
                    NetworkConnection networkConnection = connection.getNetworkConnection();
                    if (callback instanceof NettyConnectionReadCompletedCallback && readCtx instanceof NettyIOReadRequestContext && networkConnection instanceof NettyNetworkConnection) {
                        String ioeMessage = "Socket operation timed out before it could be completed";
                        ioeMessage = ioeMessage + " local=" + ctx.channel().localAddress() + " remote=" + ctx.channel().remoteAddress();
                        ((NettyConnectionReadCompletedCallback)callback).error(connection.getNetworkConnection(), readCtx, new SocketTimeoutException(ioeMessage));
                        return;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                        SibTr.warning((TraceComponent)tc, (String)"userEventTriggered: Something's wrong. Callback, network connection, or read context is not netty specific. This shouldn't happen.", (Object)new Object[]{connection, callback, readCtx, networkConnection});
                    }
                    this.exceptionCaught(ctx, new NettyException("Illegal callback type for channel."));
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                    SibTr.warning((TraceComponent)tc, (String)"userEventTriggered", (Object)"could not associate an incoming event with a Connection. Event will be moved through pipeline.");
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"userEventTriggered: Event triggered was not a timeout. Event will be moved through pipeline.", (Object)evt);
        }
        super.userEventTriggered(ctx, evt);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"userEventTriggered", (Object)ctx.channel());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/netty/jfapchannel/NettyJMSHeartbeatHandler.java, SIB.comms, WASX.SIB, uu1215.01 1.1");
        }
    }
}

