/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.netty;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.messaging.lifecycle.SingletonsReady;
import com.ibm.ws.sib.jfapchannel.framework.FrameworkException;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionFactory;
import com.ibm.ws.sib.jfapchannel.impl.CommsClientServiceFacade;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.netty.NettyJMSClientHandler;
import com.ibm.ws.sib.jfapchannel.netty.NettyNetworkConnection;
import com.ibm.ws.sib.utils.ras.SibTr;
import io.netty.util.AttributeKey;
import io.openliberty.netty.internal.BootstrapExtended;
import io.openliberty.netty.internal.NettyFramework;
import io.openliberty.netty.internal.exception.NettyException;
import io.openliberty.netty.internal.tls.NettyTlsProvider;
import java.util.HashMap;
import java.util.Map;

public class NettyNetworkConnectionFactory
implements NetworkConnectionFactory {
    private static final TraceComponent tc = SibTr.register(NettyNetworkConnectionFactory.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private BootstrapExtended bootstrap;
    private String chainName;
    private NettyFramework nettyBundle;
    private Map<Object, Object> sslOptions;
    private NettyTlsProvider tlsProvider;
    public static final AttributeKey<Connection> CONNECTION;
    public static final String HEARTBEAT_HANDLER_KEY = "heartBeatHandler";
    public static final String SSL_HANDLER_KEY = "sslHandler";
    public static final String DECODER_HANDLER_KEY = "decoder";
    public static final String ENCODER_HANDLER_KEY = "encoder";
    public static final String JMS_CLIENT_HANDLER_KEY = "jmsClientHandler";
    public static final String JMS_SERVER_HANDLER_KEY = "jmsServerHandler";

    public NettyNetworkConnectionFactory(String chainName, Map<String, Object> tcpOptions, Map<Object, Object> sslOptions, NettyTlsProvider tlsProvider) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)chainName);
        }
        this.chainName = chainName;
        this.sslOptions = sslOptions;
        this.tlsProvider = tlsProvider;
        this.nettyBundle = ((CommsClientServiceFacade)SingletonsReady.requireService(CommsClientServiceFacade.class)).getNettyFramework();
        HashMap<String, Object> options = new HashMap<String, Object>(tcpOptions);
        options.put("ExternalName", chainName);
        try {
            this.bootstrap = this.nettyBundle.createTCPBootstrapOutbound(options);
            this.bootstrap.attr(NettyJMSClientHandler.CHAIN_ATTR_KEY, (Object)chainName);
        }
        catch (NettyException e) {
            SibTr.error((TraceComponent)tc, (String)"<init>: Failure initializing Netty Bootstrap", (Object)((Object)e));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public NetworkConnection createConnection(Object endpoint) throws FrameworkException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConnection", (Object)endpoint);
        }
        throw new FrameworkException("Not implemented yet for Netty. Currently only used on tWAS not Liberty.");
    }

    @Override
    public NetworkConnection createConnection() throws FrameworkException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConnection");
        }
        NettyNetworkConnection conn = null;
        conn = new NettyNetworkConnection(this.bootstrap, this.chainName, this.nettyBundle, this.sslOptions, this.tlsProvider, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConnection", (Object)conn);
        }
        return conn;
    }

    @Override
    public void destroy() throws FrameworkException {
        this.bootstrap = null;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/netty/jfapchannel/NettyNetworkConnectionFactory.java, SIB.comms, WASX.SIB, uu1215.01 1.1");
        }
        CONNECTION = AttributeKey.valueOf((String)"CONNECTION");
    }
}

