/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EmptyStackException;
import java.util.StringTokenizer;

public class DefaultErrorReporter
extends HttpServlet {
    private static final long serialVersionUID = 3763096349528044856L;
    private static TraceNLS nls = TraceNLS.getTraceNLS(DefaultErrorReporter.class, (String)"com.ibm.ws.webcontainer.resources.Messages");

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PrintWriter out;
        try {
            out = response.getWriter();
        }
        catch (IllegalStateException e) {
            FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.DefaultErrorReporter.service", "48", (Object)this);
            out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), response.getCharacterEncoding()));
        }
        ServletErrorReport error = (ServletErrorReport)((Object)request.getAttribute("ErrorReport"));
        DefaultErrorReporter.reportErrorAsHTML(out, error, request.getRequestURL().toString());
    }

    public static void reportErrorAsHTML(PrintWriter out, ServletErrorReport error, String url) {
        out.println("<HTML>\n<HEAD><TITLE>" + nls.getString("Error.Report", "Error Report") + "</TITLE></HEAD>\n<BODY>");
        if (error == null) {
            out.println(nls.getString("No.Error.to.Report", "No Error to Report"));
        } else {
            out.println("<H1>Error " + error.getErrorCode() + "</H1>");
            out.println("<H3>" + nls.getString("error.occured.processing.request", "An error has occurred while processing request: ") + DefaultErrorReporter.encodeChars(url) + "</H3>");
            out.println("<H3><B>" + nls.getString("Message", "Message:") + "</B> " + error.getMessage() + "</H3><BR>");
            out.println("<B>" + nls.getString("Target.Servlet", "Target Servlet:") + " </B>" + DefaultErrorReporter.encodeChars(error.getTargetServletName()) + "<BR>");
            out.println("<B>" + nls.getString("StackTrace", "StackTrace:") + " </B>");
            DefaultErrorReporter.printFullStackTrace(out, error);
        }
        out.println("\n</BODY>\n</HTML>");
        out.flush();
    }

    public static void printFullStackTrace(PrintWriter out, ServletException e) {
        Throwable th = null;
        while (e != null) {
            th = e.getRootCause();
            if (th == null) {
                th = e;
                break;
            }
            e = th instanceof ServletException ? (ServletException)th : null;
        }
        try {
            if (th instanceof ServletErrorReport) {
                out.println("<HR width=\"100%\">\n" + th.getMessage() + "<BR>");
            } else {
                out.println("<HR width=\"100%\">\n" + DefaultErrorReporter.encodeChars(th.getMessage()) + "<BR>");
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            th.printStackTrace(pw);
            pw.flush();
            String traceOut = th instanceof ServletErrorReport ? sw.toString() : DefaultErrorReporter.encodeChars(sw.toString());
            StringTokenizer st = new StringTokenizer(traceOut, "\n");
            while (st.hasMoreTokens()) {
                out.println(st.nextToken());
                out.println("<BR>&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            out.println("<BR>");
        }
        catch (EmptyStackException ex) {
            FFDCWrapper.processException(ex, "com.ibm.ws.webcontainer.servlet.DefaultErrorReporter.printFullStackTrace", "158");
        }
    }

    public static void printShortStackTrace(PrintWriter out, ServletException e) {
        Throwable th = null;
        while (e != null) {
            th = e.getRootCause();
            if (th == null) {
                th = e;
                break;
            }
            e = th instanceof ServletException ? (ServletException)th : null;
        }
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            th.printStackTrace(pw);
            pw.flush();
            String traceOut = th instanceof ServletErrorReport ? sw.toString() : DefaultErrorReporter.encodeChars(sw.toString());
            StringTokenizer st = new StringTokenizer(traceOut, "\n");
            while (st.hasMoreTokens()) {
                out.println(st.nextToken());
                out.println("<BR>&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            out.println("<BR>");
        }
        catch (EmptyStackException ex) {
            FFDCWrapper.processException(ex, "com.ibm.ws.webcontainer.servlet.DefaultErrorReporter.printShortStackTrace", "217");
        }
    }

    public static String encodeChars(String iString) {
        if (iString == null) {
            return "";
        }
        int strLen = iString.length();
        if (strLen < 1) {
            return iString;
        }
        StringBuffer retString = new StringBuffer(strLen * 2);
        block12: for (int i = 0; i < strLen; ++i) {
            switch (iString.charAt(i)) {
                case '<': {
                    retString.append("&lt;");
                    continue block12;
                }
                case '>': {
                    retString.append("&gt;");
                    continue block12;
                }
                case '&': {
                    retString.append("&amp;");
                    continue block12;
                }
                case '\"': {
                    retString.append("&quot;");
                    continue block12;
                }
                case '+': {
                    retString.append("&#43;");
                    continue block12;
                }
                case '(': {
                    retString.append("&#40;");
                    continue block12;
                }
                case ')': {
                    retString.append("&#41;");
                    continue block12;
                }
                case '\'': {
                    retString.append("&#39;");
                    continue block12;
                }
                case '%': {
                    retString.append("&#37;");
                    continue block12;
                }
                case ';': {
                    retString.append("&#59;");
                    continue block12;
                }
                default: {
                    retString.append(iString.charAt(i));
                }
            }
        }
        return retString.toString();
    }
}

