/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ws.webcontainer.extension.DefaultExtensionProcessor;
import com.ibm.ws.webcontainer.servlet.FileServletWrapper;
import com.ibm.ws.webcontainer.util.ZipFileResource;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class ZipFileServletWrapper
extends FileServletWrapper {
    private long fileSize = -1L;
    private ZipFileResource zipFileResource;

    public ZipFileServletWrapper(IServletContext parent, DefaultExtensionProcessor parentProcessor, ZipFileResource zipFileResource) {
        super(parent, parentProcessor);
        this.zipFileResource = zipFileResource;
        this.isZip = true;
    }

    @Override
    public String getServletName() {
        return "Zip File wrapper";
    }

    @Override
    public String getName() {
        return "Zip File wrapper";
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        return this.zipFileResource.getIS();
    }

    @Override
    protected long getLastModified() {
        long time = this.zipFileResource.getZipEntry().getTime();
        return time;
    }

    @Override
    protected int getContentLength() {
        return this.getContentLength(true);
    }

    @Override
    protected long getFileSize(boolean update) {
        if (this.fileSize == -1L || update) {
            this.fileSize = this.zipFileResource.getZipEntry().getSize();
        }
        return this.fileSize;
    }

    @Override
    public void setParent(IServletContext parent) {
    }

    @Override
    public boolean isAvailable() {
        return new File(this.zipFileResource.getZipFile().getName()).exists();
    }

    @Override
    protected RandomAccessFile getRandomAccessFile() throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(ServletRequest req, ServletResponse res, WebAppDispatcherContext dispatchContext) throws Exception {
        try {
            super.handleRequest(req, res, dispatchContext);
        }
        catch (Throwable throwable) {
            if (System.getSecurityManager() != null) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws IOException {
                            ZipFileServletWrapper.this.zipFileResource.getZipFile().close();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw new IOException(pae.getMessage());
                }
            } else {
                this.zipFileResource.getZipFile().close();
            }
            throw throwable;
        }
        if (System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            }
            catch (PrivilegedActionException pae) {
                throw new IOException(pae.getMessage());
            }
        } else {
            this.zipFileResource.getZipFile().close();
        }
    }
}

