/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.comms.MEConnection;
import com.ibm.ws.sib.comms.common.ClientCommsDiagnosticModule;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATOrderingContext;
import com.ibm.ws.sib.comms.server.clientsupport.ServerSideConnection;
import com.ibm.ws.sib.comms.server.clientsupport.ServerTransportAcceptListener;
import com.ibm.ws.sib.jfapchannel.ConnectionInterface;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.server.ServerConnectionManager;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ServerCommsDiagnosticModule
extends ClientCommsDiagnosticModule {
    private static final TraceComponent tc = SibTr.register(ServerCommsDiagnosticModule.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static ServerCommsDiagnosticModule _serverSingleton = null;

    public static ServerCommsDiagnosticModule getInstance() {
        if (_serverSingleton == null) {
            _serverSingleton = new ServerCommsDiagnosticModule();
        }
        return _serverSingleton;
    }

    private ServerCommsDiagnosticModule() {
    }

    public static void dump(FormattedWriter writer, String arg) {
        ServerCommsDiagnosticModule.getInstance().dumpCommunications(writer, arg);
    }

    protected void dumpJFapServerStatus(IncidentStream is) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpJFapServerStatus", (Object)is);
        }
        this.dumpMEtoMEConversations(is);
        this.dumpInboundConversations(is);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpJFapServerStatus");
        }
    }

    private void dumpMEtoMEConversations(IncidentStream is) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpMEtoMEConversations", (Object)is);
        }
        List<Conversation> obc = ServerConnectionManager.getActiveOutboundMEtoMEConversations();
        is.writeLine("", "");
        is.writeLine("\n------ ME to ME Conversation Dump ------ ", ">");
        if (obc != null) {
            Map connectionToConversationMap = this.convertToMap(is, obc);
            for (Map.Entry entry : connectionToConversationMap.entrySet()) {
                is.writeLine("\nOutbound connection:", entry.getKey());
                LinkedList conversationList = (LinkedList)entry.getValue();
                while (!conversationList.isEmpty()) {
                    Conversation c = (Conversation)conversationList.removeFirst();
                    is.writeLine("\nOutbound Conversation[" + c.getId() + "]: ", c.getFullSummary());
                    try {
                        this.dumpMEtoMEConversation(is, c);
                    }
                    catch (Throwable t) {
                        is.writeLine("\nUnable to dump conversation", (Object)t);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpMEtoMEConversations");
        }
    }

    private void dumpInboundConversations(IncidentStream is) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpInboundConversations", (Object)is);
        }
        List serverConvs = ServerTransportAcceptListener.getInstance().getActiveConversations();
        is.writeLine("", "");
        is.writeLine("\n------ Inbound Conversation Dump ------ ", ">");
        if (serverConvs != null) {
            HashMap<ConnectionInterface, LinkedList> connectionToConversationMap = new HashMap<ConnectionInterface, LinkedList>();
            Iterator i = serverConvs.iterator();
            while (i.hasNext()) {
                try {
                    LinkedList conversationList;
                    Conversation c = (Conversation)i.next();
                    ConnectionInterface connectionObject = c.getConnectionReference();
                    if (!connectionToConversationMap.containsKey(connectionObject)) {
                        conversationList = new LinkedList();
                        connectionToConversationMap.put(connectionObject, conversationList);
                    } else {
                        conversationList = (LinkedList)connectionToConversationMap.get(connectionObject);
                    }
                    conversationList.add(c);
                }
                catch (Throwable t) {
                    is.writeLine("\nUnable to dump conversation", (Object)t);
                }
            }
            Set entries = connectionToConversationMap.entrySet();
            for (Map.Entry entry : entries) {
                Object connectionObject = entry.getKey();
                is.writeLine("\nInbound connection:", connectionObject);
                LinkedList conversationList = (LinkedList)entry.getValue();
                while (!conversationList.isEmpty()) {
                    Conversation c = (Conversation)conversationList.removeFirst();
                    is.writeLine("\nInbound Conversation[" + c.getId() + "]: ", c.getFullSummary());
                    try {
                        this.dumpServerConversation(is, c);
                    }
                    catch (Throwable t) {
                        is.writeLine("\nUnable to dump conversation", (Object)t);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpInboundConversations");
        }
    }

    private void dumpServerConversation(IncidentStream is, Conversation conv) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpServerConversation", (Object)new Object[]{is, conv});
        }
        ConversationState convState = (ConversationState)conv.getAttachment();
        List allObjs = convState.getAllObjects();
        is.writeLine("Number of associated resources", allObjs.size());
        for (Object obj : allObjs) {
            if (obj instanceof SICoreConnection) {
                SICoreConnection conn = (SICoreConnection)obj;
                is.writeLine("  ", "SICoreConnection@" + Integer.toHexString(obj.hashCode()) + ": ME Name: " + conn.getMeName() + " [" + conn.getMeUuid() + "] Version: " + conn.getApiLevelDescription());
                continue;
            }
            is.writeLine("  ", obj);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpServerConversation");
        }
    }

    private void dumpMEtoMEConversation(IncidentStream is, Conversation conv) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpMEtoMEConversation", (Object)new Object[]{is, conv});
        }
        ConversationState convState = (ConversationState)conv.getAttachment();
        MEConnection commsConnection = (MEConnection)convState.getCommsConnection();
        is.writeLine("  Connected using: ", (Object)commsConnection);
        JsMessagingEngine me = commsConnection.getMessagingEngine();
        String meInfo = me == null ? "<null>" : me.getName() + " [" + me.getUuid() + "]";
        is.writeLine("  Local ME: ", meInfo);
        is.writeLine("  Target ME: ", commsConnection.getTargetInformation());
        is.introspectAndWriteLine("Introspection of the conversation state:", (Object)convState);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpMEtoMEConversation");
        }
    }

    private void dumpCommunications(FormattedWriter writer, String arg) {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpCommunications", (Object)new Object[]{writer, arg});
            }
            StringTokenizer st = new StringTokenizer(arg, ":");
            boolean found = false;
            while (st.hasMoreElements()) {
                if (!st.nextToken().endsWith("ServerCommsDiagnosticDump")) continue;
                found = true;
                break;
            }
            try {
                if (found) {
                    writer.newLine();
                    writer.startTag(((Object)((Object)this)).getClass().getSimpleName());
                    writer.indent();
                    writer.newLine();
                    writer.startTag("MEtoMECommunications");
                    writer.indent();
                    this.dumpMEtoMEConversations(writer);
                    writer.outdent();
                    writer.newLine();
                    writer.endTag("MEtoMECommunications");
                    writer.newLine();
                    writer.startTag("InboundCommunications");
                    writer.indent();
                    this.dumpInboundConversations(writer);
                    writer.outdent();
                    writer.newLine();
                    writer.endTag("InboundCommunications");
                    writer.outdent();
                    writer.newLine();
                    writer.endTag(((Object)((Object)this)).getClass().getSimpleName());
                }
            }
            catch (Exception exception) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Exception caught writing ServerCommunications dump!", (Object)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpCommunications");
        }
    }

    private void dumpMEtoMEConversations(FormattedWriter writer) throws IOException {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpMEtoMEConversations", (Object)writer);
            }
            try {
                List<Conversation> conversations = ServerConnectionManager.getActiveOutboundMEtoMEConversations();
                Map<Object, LinkedList<Conversation>> connectionToConversationMap = this.buildConnectionMap(conversations);
                for (Map.Entry<Object, LinkedList<Conversation>> entry : connectionToConversationMap.entrySet()) {
                    Object connectionObject = entry.getKey();
                    writer.newLine();
                    writer.startTag("CommsConnection");
                    writer.newLine();
                    writer.taggedValue("ME-ME connection", connectionObject);
                    for (Conversation conversation : entry.getValue()) {
                        this.dumpMEtoMEConversation(writer, conversation);
                    }
                    writer.outdent();
                    writer.newLine();
                    writer.endTag("CommsConnection");
                }
            }
            catch (Throwable t) {
                if (writer == null) break block6;
                writer.write("\nUnable to dump MEtoMEConversations " + (Object)((Object)this) + " " + t);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpMEtoMEConversations");
        }
    }

    private void dumpInboundConversations(FormattedWriter writer) throws IOException {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpInboundConversations", (Object)writer);
            }
            try {
                List conversations = ServerTransportAcceptListener.getInstance().getActiveConversations();
                Map<Object, LinkedList<Conversation>> connectionToConversationMap = this.buildConnectionMap(conversations);
                for (Map.Entry<Object, LinkedList<Conversation>> entry : connectionToConversationMap.entrySet()) {
                    Object connectionObject = entry.getKey();
                    writer.newLine();
                    writer.startTag("CommsConnection");
                    writer.newLine();
                    writer.taggedValue("Inbound connection", connectionObject);
                    for (Conversation conversation : entry.getValue()) {
                        this.dumpServerConversation(writer, conversation);
                    }
                    writer.outdent();
                    writer.newLine();
                    writer.endTag("CommsConnection");
                }
            }
            catch (Throwable t) {
                if (writer == null) break block6;
                writer.write("\nUnable to dump InboundConversations " + (Object)((Object)this) + " " + t);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpInboundConversations");
        }
    }

    private Map<Object, LinkedList<Conversation>> buildConnectionMap(List<Conversation> serverConvs) {
        HashMap<Object, LinkedList<Conversation>> connectionToConversationMap = new HashMap<Object, LinkedList<Conversation>>();
        if (serverConvs != null) {
            for (Conversation c : serverConvs) {
                try {
                    LinkedList conversationList;
                    ConnectionInterface connectionObject = c.getConnectionReference();
                    if (!connectionToConversationMap.containsKey(connectionObject)) {
                        conversationList = new LinkedList();
                        connectionToConversationMap.put(connectionObject, conversationList);
                    } else {
                        conversationList = (LinkedList)connectionToConversationMap.get(connectionObject);
                    }
                    conversationList.add(c);
                }
                catch (Throwable throwable) {}
            }
        }
        return connectionToConversationMap;
    }

    private void dumpServerConversation(FormattedWriter writer, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpServerConversation", (Object)new Object[]{writer, conversation});
        }
        try {
            writer.newLine();
            writer.startTag("Conversation");
            writer.indent();
            writer.newLine();
            writer.taggedValue("Summary", (Object)conversation.getFullSummary());
            ConversationState conversationState = (ConversationState)conversation.getAttachment();
            List conversatiobObjects = conversationState.getAllObjects();
            for (Object object : conversatiobObjects) {
                if (object instanceof CATConnection) {
                    writer.newLine();
                    writer.taggedValue("CATConnection", (Object)((CATConnection)object));
                    continue;
                }
                if (object instanceof ServerSideConnection) {
                    writer.newLine();
                    writer.startTag("ServerSideConnection");
                    writer.indent();
                    ServerSideConnection conn = (ServerSideConnection)((Object)object);
                    writer.newLine();
                    writer.taggedValue("toString", (Object)conn);
                    writer.newLine();
                    writer.taggedValue("CommsConnection", (Object)conn.getCommsConnection());
                    writer.newLine();
                    writer.taggedValue("Info", (Object)conn.getConnectionInfo());
                    writer.newLine();
                    writer.taggedValue("ObjectID", (long)conn.getConnectionObjectID());
                    writer.newLine();
                    writer.taggedValue("MetaData", (Object)conn.getMetaData());
                    writer.newLine();
                    writer.taggedValue("RequestNumber", (long)conn.getRequestNumber());
                    writer.outdent();
                    writer.newLine();
                    writer.endTag("ServerSideConnection");
                    continue;
                }
                if (object instanceof CATOrderingContext) {
                    writer.newLine();
                    writer.taggedValue("CATOrderingContext", (Object)((CATOrderingContext)object));
                    continue;
                }
                if (object instanceof CATMainConsumer) {
                    ((CATMainConsumer)object).dump(writer);
                    continue;
                }
                writer.newLine();
                writer.taggedValue("other", object);
            }
            writer.outdent();
            writer.newLine();
            writer.endTag("Conversation");
        }
        catch (Throwable t) {
            try {
                writer.write("\nUnable to dump conversation " + t);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpServerConversation");
        }
    }

    private void dumpMEtoMEConversation(FormattedWriter writer, Conversation conversation) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpMEtoMEConversation", (Object)new Object[]{writer, conversation});
        }
        try {
            writer.newLine();
            writer.startTag("Conversation");
            writer.indent();
            writer.newLine();
            writer.taggedValue("Summary", (Object)conversation.getFullSummary());
            ConversationState convState = (ConversationState)conversation.getAttachment();
            MEConnection commsConnection = (MEConnection)convState.getCommsConnection();
            writer.taggedValue("commsConnection", (Object)commsConnection);
            JsMessagingEngine me = commsConnection.getMessagingEngine();
            String meInfo = me == null ? "<null>" : me.getName() + " [" + me.getUuid() + "]";
            writer.taggedValue("Local ME: ", (Object)meInfo);
            writer.taggedValue("Target ME: ", (Object)commsConnection.getTargetInformation());
            writer.outdent();
            writer.newLine();
            writer.endTag("Conversation");
        }
        catch (Throwable t) {
            try {
                writer.write("\nUnable to dump conversation " + t);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpMEtoMEConversation");
        }
    }
}

