/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.cache.ConfigSerializer;
import io.openliberty.microprofile.openapi20.internal.utils.LoggingUtils;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexWriter;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CacheEntry {
    private static final TraceComponent tc = Tr.register(CacheEntry.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private static final String CACHE_DIR = "cache";
    private static final String MODEL_FILE = "model";
    private static final String CONFIG_FILE = "config";
    private static final String FILES_LIST_FILE = "files";
    private static final String INDEX_FILE = "index";
    private String appName;
    private final Path cacheDir;
    private final ConfigSerializer configSerializer;
    private Index index;
    private OpenAPI model;
    private OpenApiConfig config;
    private Properties configProperties;
    private List<String> fileEntries = new ArrayList<String>();
    private static final FileVisitor<Path> RECURSIVE_DELETER = new SimpleFileVisitor<Path>(){
        static final long serialVersionUID = -989793675007779367L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.delete(dir);
            return FileVisitResult.CONTINUE;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.cache.CacheEntry$1", 1.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
        }
    };
    static final long serialVersionUID = 7696315617676239644L;

    public static CacheEntry createNew(String applicationName, Path baseDir, ConfigSerializer configSerializer) {
        return new CacheEntry(applicationName, baseDir, configSerializer);
    }

    /*
     * WARNING - void declaration
     */
    public static CacheEntry read(String applicationName, Path baseDir, ConfigSerializer configSerializer) {
        CacheEntry cacheEntry = new CacheEntry(applicationName, baseDir, configSerializer);
        if (!Files.isDirectory(cacheEntry.cacheDir, new LinkOption[0])) {
            return null;
        }
        try {
            if (!cacheEntry.read()) {
                return null;
            }
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"io.openliberty.microprofile.openapi20.internal.cache.CacheEntry", (String)"132", null, (Object[])new Object[]{applicationName, baseDir, configSerializer});
            Tr.warning((TraceComponent)tc, (String)"Unexpected error attempting to read cache for the {0} application. The error is {1}", (Object[])new Object[]{applicationName, e.toString()});
            return null;
        }
        return cacheEntry;
    }

    /*
     * WARNING - void declaration
     */
    private CacheEntry(String applicationName, Path baseDir, ConfigSerializer configSerializer) {
        try {
            this.appName = URLEncoder.encode(applicationName, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void e;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"io.openliberty.microprofile.openapi20.internal.cache.CacheEntry", (String)"143", (Object)this, (Object[])new Object[]{applicationName, baseDir, configSerializer});
            throw new RuntimeException("Unable to use UTF-8 encoding", (Throwable)e);
        }
        this.cacheDir = baseDir.resolve(CACHE_DIR).resolve(this.appName);
        this.configSerializer = configSerializer;
    }

    public void addDependentFile(Path file) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(file.toAbsolutePath().toString());
        sb.append(",");
        sb.append(Files.size(file));
        sb.append(",");
        sb.append(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis());
        this.fileEntries.add(sb.toString());
    }

    public void setConfig(OpenApiConfig config) {
        this.config = config;
        this.configProperties = null;
    }

    public void setModel(OpenAPI model) {
        this.model = model;
    }

    public OpenAPI getModel() {
        return this.model;
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    @Trivial
    public boolean modelUpToDate(CacheEntry current) {
        if (this.model == null || this.configProperties == null) {
            throw new IllegalStateException("isUpToDateWith called on CacheEntry not read from disk");
        }
        Objects.requireNonNull(current, "cache entry for current state must be given");
        if (!Objects.equals(this.appName, current.appName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Cache out of date because app name is not the same?!", (Object[])new Object[]{this.appName, current.appName});
            }
            return false;
        }
        if (current.config.modelReader() != null || current.config.filter() != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Cache not usable because a filter or reader is registered", (Object[])new Object[0]);
            }
            return false;
        }
        Properties currentConfigProperties = current.getConfigProperties(this.model);
        if (!Objects.equals(this.configProperties, currentConfigProperties)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Cache out of date because config is not the same", (Object[])new Object[]{this.configProperties, currentConfigProperties});
            }
            return false;
        }
        if (!Objects.equals(this.fileEntries, current.fileEntries)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Cache out of date because files have changed", (Object[])new Object[]{this.fileEntries, current.fileEntries});
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Cache is up to date", (Object[])new Object[0]);
        }
        return true;
    }

    @Trivial
    public boolean indexUpToDate(CacheEntry current) {
        if (this.model == null || this.configProperties == null) {
            throw new IllegalStateException("isUpToDateWith called on CacheEntry not read from disk");
        }
        Objects.requireNonNull(current, "cache entry for current state must be given");
        if (this.index == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Index out of date because no index in cache", (Object[])new Object[0]);
            }
            return false;
        }
        if (!Objects.equals(this.appName, current.appName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Index out of date because app name is not the same?!", (Object[])new Object[]{this.appName, current.appName});
            }
            return false;
        }
        Properties currentScanningProperties = current.getScanningConfig();
        Properties ourScanningProperties = this.getScanningConfig();
        if (!Objects.equals(ourScanningProperties, currentScanningProperties)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Index out of date because indexing config is not the same", (Object[])new Object[]{ourScanningProperties, currentScanningProperties});
            }
            return false;
        }
        if (!Objects.equals(this.fileEntries, current.fileEntries)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Index out of date because files have changed", (Object[])new Object[]{this.fileEntries, current.fileEntries});
            }
            return false;
        }
        return true;
    }

    private Properties getConfigProperties(OpenAPI model) {
        if (this.configProperties != null) {
            return this.configProperties;
        }
        if (this.config != null) {
            return this.configSerializer.serializeConfig(this.config, model);
        }
        return null;
    }

    private Properties getScanningConfig() {
        if (this.configProperties != null) {
            Set<String> scanningKeys = this.configSerializer.getIndexingConfigKeys();
            Properties result = new Properties();
            for (Map.Entry<Object, Object> entry : this.configProperties.entrySet()) {
                if (!scanningKeys.contains(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }
        if (this.config != null) {
            return this.configSerializer.getIndexingConfig(this.config);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void write() throws IOException {
        if (this.appName == null || this.model == null || this.configProperties == null && this.config == null || this.fileEntries.isEmpty()) {
            if (LoggingUtils.isDebugEnabled(tc)) {
                if (this.appName == null) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Not writing cache entry, AppName is null", (Object[])new Object[0]);
                }
                if (this.model == null) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Not writing cache entry, model is null", (Object[])new Object[0]);
                }
                if (this.configProperties == null && this.config == null) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Not writing cache entry, config is null", (Object[])new Object[0]);
                }
                if (this.fileEntries.isEmpty()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Not writing cache entry, fileEntries is empty", (Object[])new Object[0]);
                }
            }
            return;
        }
        if (LoggingUtils.isDebugEnabled(tc)) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Writing cache entry", (Object[])new Object[0]);
        }
        try {
            if (Files.exists(this.cacheDir, new LinkOption[0])) {
                if (Files.isDirectory(this.cacheDir, new LinkOption[0])) {
                    Files.walkFileTree(this.cacheDir, RECURSIVE_DELETER);
                } else {
                    throw new IOException("Non-directory found in cache location: " + this.cacheDir.toAbsolutePath());
                }
            }
            Files.createDirectories(this.cacheDir, new FileAttribute[0]);
            this.writeFileList(this.cacheDir.resolve(FILES_LIST_FILE));
            this.writeConfig(this.cacheDir.resolve(CONFIG_FILE));
            this.writeModel(this.cacheDir.resolve(MODEL_FILE));
            if (this.index != null) {
                this.writeIndex(this.cacheDir.resolve(INDEX_FILE));
            }
            if (LoggingUtils.isDebugEnabled(tc)) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Cache entry written", (Object[])new Object[0]);
            }
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.openapi20.internal.cache.CacheEntry", (String)"409", (Object)this, (Object[])new Object[0]);
            Tr.warning((TraceComponent)tc, (String)"An unexpected error occurred while writing the cache for application {0}. The error is {1}", (Object[])new Object[]{this.appName, e.toString()});
        }
    }

    private boolean read() throws IOException {
        Path modelFile = this.cacheDir.resolve(MODEL_FILE);
        Path configFile = this.cacheDir.resolve(CONFIG_FILE);
        Path filesListFile = this.cacheDir.resolve(FILES_LIST_FILE);
        Path indexFile = this.cacheDir.resolve(INDEX_FILE);
        if (!(Files.exists(modelFile, new LinkOption[0]) && Files.exists(configFile, new LinkOption[0]) && Files.exists(filesListFile, new LinkOption[0]))) {
            return false;
        }
        this.readModel(modelFile);
        this.readConfig(configFile);
        this.readFileList(filesListFile);
        if (Files.exists(indexFile, new LinkOption[0])) {
            this.readIndex(indexFile);
        }
        return true;
    }

    private void readModel(Path input) throws IOException {
        FileInputStream is = new FileInputStream(input.toFile());
        try {
            OpenApiStaticFile openApiFile = new OpenApiStaticFile((InputStream)is, Format.JSON);
            this.model = OpenApiProcessor.modelFromStaticFile((OpenApiStaticFile)openApiFile);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.microprofile.openapi20.internal.cache.CacheEntry", (String)"437", (Object)this, (Object[])new Object[]{input});
            try {
                ((InputStream)is).close();
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"io.openliberty.microprofile.openapi20.internal.cache.CacheEntry", (String)"437", (Object)this, (Object[])new Object[]{input});
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((InputStream)is).close();
    }

    private void writeModel(Path output) throws IOException {
        String jsonModel = OpenApiSerializer.serialize((OpenAPI)this.model, (Format)Format.JSON);
        Files.write(output, jsonModel.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readConfig(Path input) throws IOException {
        Properties result;
        block4: {
            result = new Properties();
            InputStream is = Files.newInputStream(input, new OpenOption[0]);
            try {
                result.load(is);
                if (is == null) break block4;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.microprofile.openapi20.internal.cache.CacheEntry", (String)"450", (Object)this, (Object[])new Object[]{input});
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"io.openliberty.microprofile.openapi20.internal.cache.CacheEntry", (String)"450", (Object)this, (Object[])new Object[]{input});
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            is.close();
        }
        this.configProperties = result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeConfig(Path output) throws IOException {
        OutputStream os = Files.newOutputStream(output, new OpenOption[0]);
        try {
            this.getConfigProperties(this.model).store(os, "");
            if (os == null) return;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.microprofile.openapi20.internal.cache.CacheEntry", (String)"457", (Object)this, (Object[])new Object[]{output});
            if (os == null) throw throwable;
            try {
                os.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"io.openliberty.microprofile.openapi20.internal.cache.CacheEntry", (String)"457", (Object)this, (Object[])new Object[]{output});
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        os.close();
    }

    private void readFileList(Path input) throws IOException {
        this.fileEntries = Files.readAllLines(input, StandardCharsets.UTF_8);
    }

    private void writeFileList(Path output) throws IOException {
        Files.write(output, this.fileEntries, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readIndex(Path input) throws IOException {
        InputStream in = Files.newInputStream(input, new OpenOption[0]);
        try {
            IndexReader reader = new IndexReader(in);
            this.index = reader.read();
            if (in == null) return;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.microprofile.openapi20.internal.cache.CacheEntry", (String)"471", (Object)this, (Object[])new Object[]{input});
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"io.openliberty.microprofile.openapi20.internal.cache.CacheEntry", (String)"471", (Object)this, (Object[])new Object[]{input});
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        in.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeIndex(Path output) throws IOException {
        OutputStream out = Files.newOutputStream(output, new OpenOption[0]);
        try {
            IndexWriter writer = new IndexWriter(out);
            writer.write(this.index);
            if (out == null) return;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.microprofile.openapi20.internal.cache.CacheEntry", (String)"478", (Object)this, (Object[])new Object[]{output});
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"io.openliberty.microprofile.openapi20.internal.cache.CacheEntry", (String)"478", (Object)this, (Object[])new Object[]{output});
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        out.close();
    }
}

