/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.merge;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.merge.NameProcessor;
import io.openliberty.microprofile.openapi20.internal.merge.NameType;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelVisitor;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RenameReferenceVisitor
implements OpenAPIModelVisitor {
    private final NameProcessor.DocumentNameProcessor documentNameProcessor;
    private static final Pattern PATH_REF_PATTERN;
    static final long serialVersionUID = 2779198300528366300L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public RenameReferenceVisitor(NameProcessor.DocumentNameProcessor documentNameProcessor) {
        this.documentNameProcessor = documentNameProcessor;
    }

    private void updateReference(Reference<?> referrer, NameType nameType) {
        String newName;
        String oldName;
        String reference = referrer.getRef();
        String prefix = nameType.getReferencePrefix();
        if (reference != null && reference.startsWith(prefix) && !(oldName = reference.split("/")[3]).equals(newName = this.documentNameProcessor.lookupName(nameType, oldName))) {
            referrer.setRef(prefix + newName);
        }
    }

    @Override
    public Example visitExample(OpenAPIModelWalker.Context context, Example example) {
        this.updateReference((Reference<?>)example, NameType.EXAMPLES);
        return example;
    }

    @Override
    public Example visitExample(OpenAPIModelWalker.Context context, String key, Example example) {
        return this.visitExample(context, example);
    }

    @Override
    public Header visitHeader(OpenAPIModelWalker.Context context, String key, Header header) {
        this.updateReference((Reference<?>)header, NameType.HEADERS);
        return header;
    }

    @Override
    public Link visitLink(OpenAPIModelWalker.Context context, String key, Link link) {
        if (link.getRef() != null) {
            this.updateReference((Reference<?>)link, NameType.LINKS);
        } else {
            link.setOperationId(this.documentNameProcessor.lookupName(NameType.OPERATION_ID, link.getOperationId()));
            link.setOperationRef(this.updateOperationRef(link.getOperationRef()));
        }
        return link;
    }

    private String updateOperationRef(String operationRef) {
        String newPath;
        if (operationRef == null) {
            return null;
        }
        Matcher m = PATH_REF_PATTERN.matcher(operationRef);
        if (!m.matches()) {
            return operationRef;
        }
        String oldPath = RenameReferenceVisitor.decodePathReference(m.group(1));
        if (!oldPath.equals(newPath = this.documentNameProcessor.lookupName(NameType.PATHS, oldPath))) {
            String newRef = operationRef.substring(0, m.start(1)) + RenameReferenceVisitor.encodePathReference(newPath) + operationRef.substring(m.end(1));
            return newRef;
        }
        return operationRef;
    }

    private static String decodePathReference(String pathReference) {
        return pathReference.replace("~1", "/").replace("~0", "~");
    }

    private static String encodePathReference(String path) {
        return path.replace("~", "~0").replace("/", "~1");
    }

    @Override
    public Parameter visitParameter(OpenAPIModelWalker.Context context, Parameter p) {
        this.updateReference((Reference<?>)p, NameType.PARAMETERS);
        return p;
    }

    @Override
    public Parameter visitParameter(OpenAPIModelWalker.Context context, String key, Parameter p) {
        return this.visitParameter(context, p);
    }

    @Override
    public RequestBody visitRequestBody(OpenAPIModelWalker.Context context, RequestBody rb) {
        this.updateReference((Reference<?>)rb, NameType.REQUEST_BODIES);
        return rb;
    }

    @Override
    public RequestBody visitRequestBody(OpenAPIModelWalker.Context context, String key, RequestBody rb) {
        return this.visitRequestBody(context, rb);
    }

    @Override
    public APIResponse visitResponse(OpenAPIModelWalker.Context context, String key, APIResponse response) {
        this.updateReference((Reference<?>)response, NameType.RESPONSES);
        return response;
    }

    @Override
    public Schema visitSchema(OpenAPIModelWalker.Context context, Schema schema) {
        this.updateReference((Reference<?>)schema, NameType.SCHEMAS);
        return schema;
    }

    @Override
    public Schema visitSchema(OpenAPIModelWalker.Context context, String key, Schema schema) {
        return this.visitSchema(context, schema);
    }

    @Override
    public SecurityScheme visitSecurityScheme(OpenAPIModelWalker.Context context, String key, SecurityScheme scheme) {
        this.updateReference((Reference<?>)scheme, NameType.SECURITY_SCHEMES);
        return scheme;
    }

    @Override
    public SecurityRequirement visitSecurityRequirement(OpenAPIModelWalker.Context context, SecurityRequirement secReq) {
        Map schemes = secReq.getSchemes();
        if (schemes != null) {
            HashMap<String, List> newSchemes = new HashMap<String, List>();
            for (Map.Entry entry : schemes.entrySet()) {
                String newName = this.documentNameProcessor.lookupName(NameType.SECURITY_SCHEMES, (String)entry.getKey());
                newSchemes.put(newName, (List)entry.getValue());
            }
            secReq.setSchemes(newSchemes);
        }
        return secReq;
    }

    @Override
    public Callback visitCallback(OpenAPIModelWalker.Context context, String key, Callback callback) {
        this.updateReference((Reference<?>)callback, NameType.CALLBACKS);
        return callback;
    }

    @Override
    public Operation visitOperation(OpenAPIModelWalker.Context context, Operation operation) {
        List tags = operation.getTags();
        if (tags != null && !tags.isEmpty()) {
            ArrayList<String> newTags = new ArrayList<String>();
            for (String tag : tags) {
                newTags.add(this.documentNameProcessor.lookupName(NameType.TAG, tag));
            }
            if (!Objects.equals(tags, newTags)) {
                operation.setTags(newTags);
            }
        }
        return operation;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.merge.RenameReferenceVisitor", RenameReferenceVisitor.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
        PATH_REF_PATTERN = Pattern.compile("#/paths/([^/]+)/.*");
    }
}

