/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.ServiceCaller;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.services.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.services.OASValidator;
import io.openliberty.microprofile.openapi20.internal.services.OpenAPIModelOperations;
import io.openliberty.microprofile.openapi20.internal.utils.LoggingUtils;
import io.openliberty.microprofile.openapi20.internal.utils.ServerInfo;
import io.openliberty.microprofile.openapi20.internal.validation.ValidatorUtils;
import io.smallrye.openapi.runtime.OpenApiRuntimeException;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.servers.Server;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIUtils {
    private static final TraceComponent tc = Tr.register(OpenAPIUtils.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private static final ServiceCaller<OASValidator> validatorService = new ServiceCaller(OpenAPIUtils.class, OASValidator.class);
    private static final ServiceCaller<OpenAPIModelOperations> modelOpsService = new ServiceCaller(OpenAPIUtils.class, OpenAPIModelOperations.class);
    static final long serialVersionUID = 907405738164572085L;

    @Trivial
    @FFDCIgnore(value={IOException.class})
    public static String getOpenAPIDocument(OpenAPI openAPIModel, Format format) {
        String oasResult;
        block3: {
            oasResult = null;
            if (openAPIModel != null) {
                try {
                    oasResult = OpenApiSerializer.serialize((OpenAPI)openAPIModel, (Format)format);
                }
                catch (IOException e) {
                    if (!LoggingUtils.isEventEnabled(tc)) break block3;
                    Tr.event((TraceComponent)tc, (String)("Failed to serialize OpenAPI document: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        return oasResult;
    }

    @Trivial
    public static void validateDocument(OpenAPI document) {
        OASValidationResult result = (OASValidationResult)validatorService.run(v -> v.validate(document)).orElseThrow(() -> new NoSuchElementException("validatorService"));
        StringBuilder sbError = new StringBuilder();
        StringBuilder sbWarnings = new StringBuilder();
        if (result.hasEvents()) {
            String warnings;
            result.getEvents().stream().forEach(v -> {
                String message = ValidatorUtils.formatMessage("validationMessage", v.message, v.location);
                if (v.severity == OASValidationResult.ValidationEvent.Severity.ERROR) {
                    sbError.append("\n - " + message);
                } else if (v.severity == OASValidationResult.ValidationEvent.Severity.WARNING) {
                    sbWarnings.append("\n - " + message);
                }
            });
            String errors = sbError.toString();
            if (!errors.isEmpty()) {
                Tr.error((TraceComponent)tc, (String)"OPENAPI_DOCUMENT_VALIDATION_ERROR", (Object[])new Object[]{errors + "\n"});
            }
            if (!(warnings = sbWarnings.toString()).isEmpty()) {
                Tr.warning((TraceComponent)tc, (String)"OPENAPI_DOCUMENT_VALIDATION_WARNING", (Object[])new Object[]{warnings + "\n"});
            }
        }
    }

    @Trivial
    public static boolean containsServersDefinition(OpenAPI openAPIModel) {
        boolean containsServers = false;
        if (openAPIModel != null && openAPIModel.getServers() != null && openAPIModel.getServers().size() > 0) {
            containsServers = true;
        }
        return containsServers;
    }

    public static List<Server> getOpenAPIModelServers(ServerInfo serverInfo, String applicationPath) {
        String port;
        ArrayList<Server> servers = new ArrayList<Server>();
        int httpPort = serverInfo.getHttpPort();
        int httpsPort = serverInfo.getHttpsPort();
        String host = serverInfo.getHost();
        if (httpPort > 0) {
            port = httpPort == 80 ? "" : ":" + httpPort;
            String url = "http://" + host + port;
            if (applicationPath != null) {
                url = url + applicationPath;
            }
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Adding OpenAPI model server: " + url), (Object[])new Object[0]);
            }
            Server server = OASFactory.createServer();
            server.setUrl(url);
            servers.add(server);
        }
        if (httpsPort > 0) {
            port = httpsPort == 443 ? "" : ":" + httpsPort;
            String secureUrl = "https://" + host + port;
            if (applicationPath != null) {
                secureUrl = secureUrl + applicationPath;
            }
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Adding OpenAPI model server: " + secureUrl), (Object[])new Object[0]);
            }
            Server secureServer = OASFactory.createServer();
            secureServer.setUrl(secureUrl);
            servers.add(secureServer);
        }
        return servers;
    }

    private OpenAPIUtils() {
    }

    public static Info getConfiguredInfo(Config config) {
        Optional infoJson = config.getOptionalValue("mp.openapi.extensions.liberty.merged.info", String.class);
        if (!infoJson.isPresent()) {
            return null;
        }
        return modelOpsService.run(modelOps -> {
            try {
                Info info = modelOps.parseInfo((String)infoJson.get());
                if (info.getTitle() != null && info.getVersion() != null) {
                    return info;
                }
                Tr.warning((TraceComponent)tc, (String)"OPENAPI_MERGE_INFO_INVALID_CWWKO1664W", (Object[])new Object[]{"mp.openapi.extensions.liberty.merged.info", infoJson.get()});
                return null;
            }
            catch (OpenApiRuntimeException ex) {
                Tr.warning((TraceComponent)tc, (String)"OPENAPI_MERGE_INFO_PARSE_ERROR_CWWKO1665W", (Object[])new Object[]{"mp.openapi.extensions.liberty.merged.info", infoJson.get(), ex.toString()});
                return null;
            }
        }).orElse(null);
    }

    public static <T> boolean allEqual(Collection<? extends T> collection, BiPredicate<? super T, ? super T> comparator) {
        Iterator<T> i = collection.iterator();
        if (!i.hasNext()) {
            return true;
        }
        T first = i.next();
        while (i.hasNext()) {
            if (OpenAPIUtils.equals(first, i.next(), comparator)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equals(T a, T b, BiPredicate<? super T, ? super T> comparator) {
        if (a == null) {
            return b == null;
        }
        return b == null ? false : comparator.test(a, b);
    }

    @Trivial
    public static <K, V> Map<K, V> notNull(Map<K, V> in) {
        if (in == null) {
            return Collections.emptyMap();
        }
        return in;
    }

    @Trivial
    public static <V> List<V> notNull(List<V> in) {
        if (in == null) {
            return Collections.emptyList();
        }
        return in;
    }
}

