/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.services.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.services.OASValidator;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelVisitor;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.CallbackValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ComponentsValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ContactValidator;
import io.openliberty.microprofile.openapi20.internal.validation.DiscriminatorValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ExampleValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ExtensionValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ExternalDocumentationValidator;
import io.openliberty.microprofile.openapi20.internal.validation.HeaderValidator;
import io.openliberty.microprofile.openapi20.internal.validation.InfoValidator;
import io.openliberty.microprofile.openapi20.internal.validation.LicenseValidator;
import io.openliberty.microprofile.openapi20.internal.validation.LinkValidator;
import io.openliberty.microprofile.openapi20.internal.validation.MediaTypeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.OAuthFlowValidator;
import io.openliberty.microprofile.openapi20.internal.validation.OAuthFlowsValidator;
import io.openliberty.microprofile.openapi20.internal.validation.OpenAPIValidator;
import io.openliberty.microprofile.openapi20.internal.validation.OperationValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ParameterValidator;
import io.openliberty.microprofile.openapi20.internal.validation.PathItemValidator;
import io.openliberty.microprofile.openapi20.internal.validation.PathsValidator;
import io.openliberty.microprofile.openapi20.internal.validation.RequestBodyValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ResponseValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ResponsesValidator;
import io.openliberty.microprofile.openapi20.internal.validation.SchemaValidator;
import io.openliberty.microprofile.openapi20.internal.validation.SecurityRequirementValidator;
import io.openliberty.microprofile.openapi20.internal.validation.SecuritySchemeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ServerValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ServerVariableValidator;
import io.openliberty.microprofile.openapi20.internal.validation.TagValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.internal.validation.XMLValidator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OASValidatorImpl
implements OASValidator {
    private static final TraceComponent tc = Tr.register(OASValidatorImpl.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    @Reference
    protected OpenAPIModelWalker modelWalker;
    static final long serialVersionUID = -9071340614528557385L;

    @Override
    public OASValidationResult validate(OpenAPI model) {
        ValidationOperation validator = new ValidationOperation(model);
        return validator.run();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class ValidationOperation
    implements OpenAPIModelVisitor,
    ValidationHelper {
        protected OASValidationResult result;
        protected final Set<String> operationIds = new HashSet<String>();
        protected final Map<String, Set<String>> linkOperationIds = new HashMap<String, Set<String>>();
        protected final OpenAPI model;
        static final long serialVersionUID = -5649820561934093214L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ValidationOperation(OpenAPI model) {
            this.model = model;
        }

        public OASValidationResult run() {
            this.result = new OASValidationResult();
            this.operationIds.clear();
            this.linkOperationIds.clear();
            OASValidatorImpl.this.modelWalker.walk(this.model, this);
            this.validateLinkOperationIds();
            OASValidationResult _result = this.result;
            this.result = null;
            return _result;
        }

        @Override
        public void addValidationEvent(OASValidationResult.ValidationEvent event) {
            if (this.result != null && event != null) {
                this.result.getEvents().add(event);
            }
        }

        @Override
        public boolean addOperationId(String operationId) {
            return !this.operationIds.add(operationId);
        }

        @Override
        public void addLinkOperationId(String operationId, String location) {
            if (this.linkOperationIds.containsKey(operationId)) {
                this.linkOperationIds.get(operationId).add(location);
            } else {
                HashSet<String> locations = new HashSet<String>();
                locations.add(location);
                this.linkOperationIds.put(operationId, locations);
            }
        }

        public void validateLinkOperationIds() {
            for (String k : this.linkOperationIds.keySet()) {
                if (this.operationIds.contains(k)) continue;
                String message = Tr.formatMessage((TraceComponent)tc, (String)"linkOperationIdInvalid", (Object[])new Object[]{k});
                for (String location : this.linkOperationIds.get(k)) {
                    this.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, location, message));
                }
            }
        }

        @Override
        public void visitOpenAPI(OpenAPIModelWalker.Context context) {
            OpenAPIValidator v = OpenAPIValidator.getInstance();
            v.validate(this, context, context.getModel());
        }

        @Override
        public Components visitComponents(OpenAPIModelWalker.Context context, Components components) {
            ComponentsValidator v = ComponentsValidator.getInstance();
            v.validate(this, context, components);
            return components;
        }

        @Override
        public Object visitExtension(OpenAPIModelWalker.Context context, String key, Object extension) {
            ExtensionValidator v = ExtensionValidator.getInstance();
            v.validate((ValidationHelper)this, context, key, extension);
            return extension;
        }

        @Override
        public ExternalDocumentation visitExternalDocumentation(OpenAPIModelWalker.Context context, ExternalDocumentation extDocs) {
            ExternalDocumentationValidator v = ExternalDocumentationValidator.getInstance();
            v.validate(this, context, extDocs);
            return extDocs;
        }

        @Override
        public Info visitInfo(OpenAPIModelWalker.Context context, Info info) {
            InfoValidator v = InfoValidator.getInstance();
            v.validate(this, context, info);
            return info;
        }

        @Override
        public Paths visitPaths(OpenAPIModelWalker.Context context, Paths paths) {
            PathsValidator v = PathsValidator.getInstance();
            v.validate(this, context, paths);
            return paths;
        }

        @Override
        public SecurityRequirement visitSecurityRequirement(OpenAPIModelWalker.Context context, SecurityRequirement sr) {
            SecurityRequirementValidator v = SecurityRequirementValidator.getInstance();
            v.validate(this, context, sr);
            return sr;
        }

        @Override
        public Server visitServer(OpenAPIModelWalker.Context context, Server server) {
            ServerValidator v = ServerValidator.getInstance();
            v.validate(this, context, server);
            return server;
        }

        @Override
        public Tag visitTag(OpenAPIModelWalker.Context context, Tag tag) {
            TagValidator v = TagValidator.getInstance();
            v.validate(this, context, tag);
            return tag;
        }

        @Override
        public Callback visitCallback(OpenAPIModelWalker.Context context, String key, Callback callback) {
            CallbackValidator v = CallbackValidator.getInstance();
            v.validate((ValidationHelper)this, context, key, callback);
            return callback;
        }

        @Override
        public Example visitExample(OpenAPIModelWalker.Context context, Example example) {
            ExampleValidator v = ExampleValidator.getInstance();
            v.validate(this, context, example);
            return example;
        }

        @Override
        public Example visitExample(OpenAPIModelWalker.Context context, String key, Example example) {
            ExampleValidator v = ExampleValidator.getInstance();
            v.validate((ValidationHelper)this, context, key, example);
            return example;
        }

        @Override
        public Header visitHeader(OpenAPIModelWalker.Context context, String key, Header header) {
            HeaderValidator v = HeaderValidator.getInstance();
            v.validate((ValidationHelper)this, context, key, header);
            return header;
        }

        @Override
        public Link visitLink(OpenAPIModelWalker.Context context, String key, Link link) {
            LinkValidator v = LinkValidator.getInstance();
            v.validate((ValidationHelper)this, context, key, link);
            return link;
        }

        @Override
        public Parameter visitParameter(OpenAPIModelWalker.Context context, Parameter p) {
            ParameterValidator v = ParameterValidator.getInstance();
            v.validate(this, context, p);
            return p;
        }

        @Override
        public Parameter visitParameter(OpenAPIModelWalker.Context context, String key, Parameter p) {
            ParameterValidator v = ParameterValidator.getInstance();
            v.validate((ValidationHelper)this, context, key, p);
            return p;
        }

        @Override
        public RequestBody visitRequestBody(OpenAPIModelWalker.Context context, RequestBody rb) {
            RequestBodyValidator v = RequestBodyValidator.getInstance();
            v.validate(this, context, rb);
            return rb;
        }

        @Override
        public RequestBody visitRequestBody(OpenAPIModelWalker.Context context, String key, RequestBody rb) {
            RequestBodyValidator v = RequestBodyValidator.getInstance();
            v.validate((ValidationHelper)this, context, key, rb);
            return rb;
        }

        @Override
        public APIResponses visitResponses(OpenAPIModelWalker.Context context, APIResponses responses) {
            ResponsesValidator v = ResponsesValidator.getInstance();
            v.validate(this, context, responses);
            return responses;
        }

        @Override
        public APIResponse visitResponse(OpenAPIModelWalker.Context context, String key, APIResponse response) {
            ResponseValidator v = ResponseValidator.getInstance();
            v.validate((ValidationHelper)this, context, key, response);
            return response;
        }

        @Override
        public Schema visitSchema(OpenAPIModelWalker.Context context, Schema schema) {
            SchemaValidator v = SchemaValidator.getInstance();
            v.validate(this, context, schema);
            return schema;
        }

        @Override
        public Schema visitSchema(OpenAPIModelWalker.Context context, String key, Schema schema) {
            SchemaValidator v = SchemaValidator.getInstance();
            v.validate((ValidationHelper)this, context, key, schema);
            return schema;
        }

        @Override
        public SecurityScheme visitSecurityScheme(OpenAPIModelWalker.Context context, String key, SecurityScheme scheme) {
            SecuritySchemeValidator v = SecuritySchemeValidator.getInstance();
            v.validate((ValidationHelper)this, context, key, scheme);
            return scheme;
        }

        @Override
        public PathItem visitPathItem(OpenAPIModelWalker.Context context, String key, PathItem item) {
            PathItemValidator v = PathItemValidator.getInstance();
            v.validate((ValidationHelper)this, context, key, item);
            return item;
        }

        @Override
        public Operation visitOperation(OpenAPIModelWalker.Context context, Operation operation) {
            OperationValidator v = OperationValidator.getInstance();
            v.validate(this, context, operation);
            return operation;
        }

        @Override
        public MediaType visitMediaType(OpenAPIModelWalker.Context context, String key, MediaType mediaType) {
            MediaTypeValidator v = MediaTypeValidator.getInstance();
            v.validate((ValidationHelper)this, context, key, mediaType);
            return mediaType;
        }

        @Override
        public OAuthFlows visitOAuthFlows(OpenAPIModelWalker.Context context, OAuthFlows authFlows) {
            OAuthFlowsValidator v = OAuthFlowsValidator.getInstance();
            v.validate(this, context, authFlows);
            return authFlows;
        }

        @Override
        public OAuthFlow visitOAuthFlow(OpenAPIModelWalker.Context context, OAuthFlow authFlow) {
            OAuthFlowValidator v = OAuthFlowValidator.getInstance();
            v.validate(this, context, authFlow);
            return authFlow;
        }

        @Override
        public Discriminator visitDiscriminator(OpenAPIModelWalker.Context context, Discriminator d) {
            DiscriminatorValidator v = DiscriminatorValidator.getInstance();
            v.validate(this, context, d);
            return d;
        }

        @Override
        public XML visitXML(OpenAPIModelWalker.Context context, XML xml) {
            XMLValidator v = XMLValidator.getInstance();
            v.validate(this, context, xml);
            return xml;
        }

        @Override
        public Contact visitContact(OpenAPIModelWalker.Context context, Contact contact) {
            ContactValidator v = ContactValidator.getInstance();
            v.validate(this, context, contact);
            return contact;
        }

        @Override
        public License visitLicense(OpenAPIModelWalker.Context context, License license) {
            LicenseValidator v = LicenseValidator.getInstance();
            v.validate(this, context, license);
            return license;
        }

        @Override
        public ServerVariable visitServerVariable(OpenAPIModelWalker.Context context, String key, ServerVariable sv) {
            ServerVariableValidator v = ServerVariableValidator.getInstance();
            v.validate((ValidationHelper)this, context, key, sv);
            return sv;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.validation.OASValidatorImpl$ValidationOperation", ValidationOperation.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
        }
    }
}

