/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.jakartasec.cdi.extensions;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.context.SubjectManager;
import io.openliberty.security.jakartasec.identitystore.OpenIdContextImpl;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.json.JsonObject;
import jakarta.security.enterprise.identitystore.openid.OpenIdContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenIdContextBean
implements Bean<OpenIdContext>,
PassivationCapable {
    private static final TraceComponent tc = Tr.register(OpenIdContextBean.class, (String)"JAKARTASEC", (String)"io.openliberty.security.jakartasec.cdi.internal.resources.JakartaSecurity30Messages");
    private final Set<Annotation> qualifiers = new HashSet<Annotation>();
    private final Type type;
    private final Set<Type> types;
    private final String name;
    private final String id;
    static final long serialVersionUID = -2338710028698837729L;

    public OpenIdContextBean(BeanManager beanManager) {
        this.qualifiers.add((Annotation)new AnnotationLiteral<Default>(){
            static final long serialVersionUID = 4066372054955068145L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.security.jakartasec.cdi.extensions.OpenIdContextBean$1", 1.class, (String)"JAKARTASEC", (String)"io.openliberty.security.jakartasec.cdi.internal.resources.JakartaSecurity30Messages");
            }
        });
        this.type = new TypeLiteral<OpenIdContext>(){
            static final long serialVersionUID = 3082858804568904937L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.security.jakartasec.cdi.extensions.OpenIdContextBean$2", 2.class, (String)"JAKARTASEC", (String)"io.openliberty.security.jakartasec.cdi.internal.resources.JakartaSecurity30Messages");
            }
        }.getType();
        this.types = Collections.singleton(this.type);
        this.name = this.getClass().getName() + "@" + this.hashCode() + "[" + this.type + "]";
        this.id = beanManager.hashCode() + "#" + this.name;
    }

    public OpenIdContext create(CreationalContext<OpenIdContext> arg0) {
        return this.getOpenIdContext();
    }

    public void destroy(OpenIdContext arg0, CreationalContext<OpenIdContext> arg1) {
    }

    public String getName() {
        return this.name;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return SessionScoped.class;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public boolean isAlternative() {
        return false;
    }

    public Class<?> getBeanClass() {
        return OpenIdContextBean.class;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    public OpenIdContext getOpenIdContext() {
        OpenIdContext openIdContext;
        Subject subject;
        block13: {
            subject = null;
            openIdContext = null;
            try {
                subject = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                    static final long serialVersionUID = -3770186443804746226L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Object run() throws Exception {
                        return new SubjectManager().getCallerSubject();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"io.openliberty.security.jakartasec.cdi.extensions.OpenIdContextBean$3", 3.class, (String)"JAKARTASEC", (String)"io.openliberty.security.jakartasec.cdi.internal.resources.JakartaSecurity30Messages");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                void pae;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"io.openliberty.security.jakartasec.cdi.extensions.OpenIdContextBean", (String)"130", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block13;
                Tr.debug((TraceComponent)tc, (String)("Exception caught: " + (PrivilegedActionException)pae), (Object[])new Object[0]);
            }
        }
        SubjectHelper subjectHelper = new SubjectHelper();
        if (subject != null && !subjectHelper.isUnauthenticated(subject)) {
            Set openIdContextImplSet;
            block14: {
                final Subject finalSubj = subject;
                openIdContextImplSet = null;
                try {
                    openIdContextImplSet = (Set)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                        static final long serialVersionUID = -7904806275885995175L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Object run() throws Exception {
                            return finalSubj.getPrivateCredentials(OpenIdContextImpl.class);
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"io.openliberty.security.jakartasec.cdi.extensions.OpenIdContextBean$4", 4.class, (String)"JAKARTASEC", (String)"io.openliberty.security.jakartasec.cdi.internal.resources.JakartaSecurity30Messages");
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    void pae;
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"io.openliberty.security.jakartasec.cdi.extensions.OpenIdContextBean", (String)"148", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block14;
                    Tr.debug((TraceComponent)tc, (String)("getPrivateCredentials(OpenIdContextImpl.class) causes Exception: " + (PrivilegedActionException)pae), (Object[])new Object[0]);
                }
            }
            if (openIdContextImplSet == null || openIdContextImplSet.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Got an authenticated subject, but did not find an OpenIdContextImpl", (Object[])new Object[0]);
                }
            } else {
                if (openIdContextImplSet.size() > 1 && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Multiple OpenIdContextImpl instances on the subject!", (Object[])new Object[0]);
                }
                openIdContext = (OpenIdContext)openIdContextImplSet.iterator().next();
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The subject is null or unauthentictaed.", (Object[])new Object[0]);
        }
        if (openIdContext == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"openIdContext is null, returning an empty openIdContext", (Object[])new Object[0]);
            }
            return new OpenIdContextImpl();
        }
        return openIdContext;
    }

    private JsonObject getJsonObject() {
        return null;
    }
}

