/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.internal.StringUtil;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PostParameterHelper {
    private static final TraceComponent tc = Tr.register(PostParameterHelper.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    public static final String INITIAL_URL = "INITIAL_URL";
    public static final String PARAM_NAMES = "PARAM_NAMES";
    public static final String PARAM_VALUES = "PARAM_VALUES";
    public static final String POSTPARAM_COOKIE = "WASPostParam";
    public static final String ATTRIB_HASH_MAP = "ServletRequestWrapperHashmap";
    private static final int LENGTH_INT = 4;
    private static final int OFFSET_REQURL = 0;
    private static final int OFFSET_DATA = 1;
    private final WebAppSecurityConfig webAppSecurityConfig;
    static final long serialVersionUID = 378651211752789888L;

    public PostParameterHelper(WebAppSecurityConfig webAppSecConfig) {
        this.webAppSecurityConfig = webAppSecConfig;
    }

    public void save(HttpServletRequest req, HttpServletResponse res) {
        AuthenticationResult authResult = new AuthenticationResult(AuthResult.SUCCESS, (String)null);
        this.save(req, res, authResult);
        List<Cookie> cookieList = authResult.getCookies();
        if (cookieList != null && cookieList.size() > 0) {
            CookieHelper.addCookiesToResponse(cookieList, res);
        }
    }

    public void save(HttpServletRequest req, HttpServletResponse res, AuthenticationResult authResult) {
        this.save(req, res, authResult, false);
    }

    /*
     * WARNING - void declaration
     */
    public void save(HttpServletRequest req, HttpServletResponse res, AuthenticationResult authResult, boolean keepInput) {
        block8: {
            if (!req.getMethod().equalsIgnoreCase("POST")) {
                return;
            }
            if (!(req instanceof IExtendedRequest)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"It is not an IExtendedRequest object", (Object[])new Object[0]);
                }
                return;
            }
            PostParameterHelper.restorePostParams((IExtendedRequest)((SRTServletRequest)req));
            String reqURL = req.getRequestURI();
            try {
                String postParamSaveMethod = this.webAppSecurityConfig.getPostParamSaveMethod();
                if (postParamSaveMethod.equalsIgnoreCase("Cookie")) {
                    this.saveToCookie((IExtendedRequest)req, reqURL, authResult, keepInput);
                } else if (postParamSaveMethod.equalsIgnoreCase("Session")) {
                    IExtendedRequest extRequest = (IExtendedRequest)req;
                    HashMap params = PostParameterHelper.getInputStreamData(extRequest);
                    this.saveToSession(req, reqURL, params);
                }
            }
            catch (IOException postParamSaveMethod) {
                void exc;
                FFDCFilter.processException((Throwable)postParamSaveMethod, (String)"com.ibm.ws.webcontainer.security.PostParameterHelper", (String)"116", (Object)this, (Object[])new Object[]{req, res, authResult, keepInput});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"IO Exception storing POST parameters onto a cookie or session: ", (Object[])new Object[]{exc});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void saveToCookie(IExtendedRequest req, String reqURL, AuthenticationResult result, boolean keepInput) {
        String strParam;
        block6: {
            strParam = null;
            try {
                strParam = this.serializePostParam(req, reqURL, keepInput);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.security.PostParameterHelper", (String)"136", (Object)this, (Object[])new Object[]{req, reqURL, result, keepInput});
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"IO Exception storing POST parameters onto a cookie: ", (Object[])new Object[]{e});
            }
        }
        if (strParam != null) {
            Cookie paramCookie = new Cookie(POSTPARAM_COOKIE, strParam);
            paramCookie.setMaxAge(-1);
            paramCookie.setPath(reqURL);
            if (this.webAppSecurityConfig.getHttpOnlyCookies()) {
                paramCookie.setHttpOnly(true);
            }
            if (this.webAppSecurityConfig.getSSORequiresSSL()) {
                paramCookie.setSecure(true);
            }
            result.setCookie(paramCookie);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("encoded POST parameters: " + strParam), (Object[])new Object[0]);
        }
    }

    private void saveToSession(HttpServletRequest req, String reqURL, Map params) {
        HttpSession postparamsession = req.getSession(true);
        if (postparamsession != null && params != null && !params.isEmpty()) {
            postparamsession.setAttribute(INITIAL_URL, (Object)reqURL);
            postparamsession.setAttribute(PARAM_NAMES, null);
            postparamsession.setAttribute(PARAM_VALUES, (Object)params);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("URL saved: " + reqURL.toString()), (Object[])new Object[0]);
            }
        }
    }

    public void restore(HttpServletRequest req, HttpServletResponse res) {
        this.restore(req, res, false);
    }

    public void restore(HttpServletRequest req, HttpServletResponse res, boolean anyMethod) {
        String postParamSaveMethod;
        if (!(req instanceof IExtendedRequest)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"It is not an IExtendedRequest object", (Object[])new Object[0]);
            }
            return;
        }
        if (!anyMethod && !req.getMethod().equalsIgnoreCase("GET")) {
            return;
        }
        String reqURL = req.getRequestURI();
        IExtendedRequest extRequest = (IExtendedRequest)req;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" method : " + req.getMethod() + " URL:" + reqURL), (Object[])new Object[0]);
        }
        if ((postParamSaveMethod = this.webAppSecurityConfig.getPostParamSaveMethod()).equalsIgnoreCase("Cookie")) {
            this.restoreFromCookie(extRequest, res, reqURL);
        } else if (postParamSaveMethod.equalsIgnoreCase("Session")) {
            this.restoreFromSession(extRequest, req, reqURL);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void restoreFromSession(IExtendedRequest extRequest, HttpServletRequest req, String reqURL) {
        HttpSession postparamsession;
        block9: {
            postparamsession = req.getSession(false);
            if (postparamsession == null) {
                return;
            }
            String previousReq = (String)postparamsession.getAttribute(INITIAL_URL);
            if (previousReq != null && previousReq.equals(reqURL)) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found the session, restoring POST parameters.", (Object[])new Object[0]);
                    }
                    extRequest.setMethod("POST");
                    Map paramValues = (Map)postparamsession.getAttribute(PARAM_VALUES);
                    if (paramValues != null && !paramValues.isEmpty()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Restoring POST paramameters for URL : " + reqURL), (Object[])new Object[0]);
                        }
                        extRequest.setInputStreamData((HashMap)paramValues);
                    }
                    break block9;
                }
                catch (IOException paramValues) {
                    FFDCFilter.processException((Throwable)paramValues, (String)"com.ibm.ws.webcontainer.security.PostParameterHelper", (String)"246", (Object)this, (Object[])new Object[]{extRequest, req, reqURL});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        void exc;
                        Tr.debug((TraceComponent)tc, (String)"IOException restoring POST parameters onto a cookie: ", (Object[])new Object[]{exc});
                    }
                    break block9;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Parameters NOT restored. Original URL : " + previousReq + " req. URL : " + reqURL), (Object[])new Object[0]);
            }
        }
        postparamsession.setAttribute(INITIAL_URL, null);
        postparamsession.setAttribute(PARAM_NAMES, null);
        postparamsession.setAttribute(PARAM_VALUES, null);
    }

    /*
     * WARNING - void declaration
     */
    private void restoreFromCookie(IExtendedRequest extRequest, HttpServletResponse res, String reqURL) {
        block6: {
            byte[] cookieValueBytes = extRequest.getCookieValueAsBytes(POSTPARAM_COOKIE);
            if (cookieValueBytes == null || cookieValueBytes.length <= 2) {
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found the cookie, restoring POST parameters: " + new String(cookieValueBytes)), (Object[])new Object[0]);
            }
            try {
                HashMap restoredParams = this.deserializePostParam(extRequest, cookieValueBytes, reqURL);
                extRequest.setInputStreamData(restoredParams);
                extRequest.setMethod("POST");
            }
            catch (Exception restoredParams) {
                void e;
                FFDCFilter.processException((Throwable)restoredParams, (String)"com.ibm.ws.webcontainer.security.PostParameterHelper", (String)"280", (Object)this, (Object[])new Object[]{extRequest, res, reqURL});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"Exception restoring POST parameters from the cookie: ", (Object[])new Object[]{e});
            }
        }
        Cookie paramCookie = new Cookie(POSTPARAM_COOKIE, "");
        paramCookie.setPath(reqURL);
        paramCookie.setMaxAge(0);
        if (this.webAppSecurityConfig.getHttpOnlyCookies()) {
            paramCookie.setHttpOnly(true);
        }
        if (this.webAppSecurityConfig.getSSORequiresSSL()) {
            paramCookie.setSecure(true);
        }
        res.addCookie(paramCookie);
    }

    private String serializePostParam(IExtendedRequest req, String reqURL, boolean keepInput) throws IOException, UnsupportedEncodingException, IllegalStateException {
        String output = null;
        HashMap params = PostParameterHelper.getInputStreamData(req);
        if (params != null) {
            long size = req.sizeInputStreamData((Map)params);
            byte[] reqURLBytes = reqURL.getBytes("UTF-8");
            long total = size + (long)reqURLBytes.length + 4L;
            long postParamSaveSize = this.webAppSecurityConfig.getPostParamCookieSize();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("length:" + total + "  maximum length:" + postParamSaveSize), (Object[])new Object[0]);
            }
            if (total < postParamSaveSize) {
                byte[][] data = req.serializeInputStreamData((Map)params);
                StringBuffer sb = new StringBuffer();
                sb.append(StringUtil.toString(Base64Coder.base64Encode((byte[])reqURLBytes)));
                for (int i = 0; i < data.length; ++i) {
                    sb.append(".").append(StringUtil.toString(Base64Coder.base64Encode((byte[])data[i])));
                }
                output = sb.toString();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("encoded length:" + output.length()), (Object[])new Object[0]);
                }
                if (keepInput) {
                    req.setInputStreamData(params);
                }
            } else {
                Tr.warning((TraceComponent)tc, (String)"SEC_FORM_POST_NULL_OR_TOO_LARGE", (Object[])new Object[0]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("encoded POST parameters: " + output), (Object[])new Object[0]);
            }
        } else {
            Tr.warning((TraceComponent)tc, (String)"SEC_FORM_POST_NULL_OR_TOO_LARGE", (Object[])new Object[0]);
        }
        return output;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HashMap deserializePostParam(IExtendedRequest req, byte[] cookieValueBytes, String reqURL) throws IOException, UnsupportedEncodingException, IllegalStateException {
        HashMap output = null;
        List<byte[]> data = this.splitBytes(cookieValueBytes, (byte)46);
        int total = data.size();
        if (total <= 1) throw new IllegalStateException("The data of the post param cookie is too short. The data might be truncated.");
        String url = new String(Base64Coder.base64Decode((byte[])data.get(0)), "UTF-8");
        if (url == null) throw new IllegalStateException("The url in the post param cookie does not match the requested url");
        if (!url.equals(reqURL)) throw new IllegalStateException("The url in the post param cookie does not match the requested url");
        byte[][] bytes = new byte[total - 1][];
        int i = 0;
        while (i < total - 1) {
            bytes[i] = Base64Coder.base64Decode((byte[])data.get(1 + i));
            ++i;
        }
        return req.deserializeInputStreamData((byte[][])bytes);
    }

    private List<byte[]> splitBytes(byte[] array, byte delimiter) {
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        int begin = 0;
        for (int i = 0; i < array.length; ++i) {
            while (i < array.length && array[i] != delimiter) {
                ++i;
            }
            byteArrays.add(Arrays.copyOfRange(array, begin, i));
            begin = i + 1;
        }
        return byteArrays;
    }

    public static void savePostParams(IExtendedRequest request) {
        HashMap postParams;
        boolean bPost = request.getMethod().equalsIgnoreCase("POST");
        if (bPost && (postParams = (HashMap)request.getAttribute(ATTRIB_HASH_MAP)) == null) {
            try {
                postParams = PostParameterHelper.getInputStreamData(request);
                request.setInputStreamData(postParams);
                request.setAttribute(ATTRIB_HASH_MAP, (Object)postParams);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.security.PostParameterHelper", (String)"401", null, (Object[])new Object[]{request});
            }
        }
    }

    public static void restorePostParams(IExtendedRequest request) {
        HashMap postParams = (HashMap)request.getAttribute(ATTRIB_HASH_MAP);
        if (postParams != null) {
            try {
                request.setAttribute(ATTRIB_HASH_MAP, null);
                request.setInputStreamData(postParams);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.security.PostParameterHelper", (String)"414", null, (Object[])new Object[]{request});
            }
        }
    }

    private static HashMap getInputStreamData(IExtendedRequest extRequest) throws IOException {
        long maxAllowedLength = 0x8000000L;
        WebAppSecurityConfig globalConfig = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig();
        if (globalConfig != null) {
            maxAllowedLength = globalConfig.postParamMaxRequestBodySize();
        }
        return extRequest.getInputStreamData(maxAllowedLength);
    }
}

