/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.CancelException;
import com.ibm.ws.install.InstallConstants;
import com.ibm.ws.install.InstallEventListener;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallKernel;
import com.ibm.ws.install.InstallKernelFactory;
import com.ibm.ws.install.InstallKernelInteractive;
import com.ibm.ws.install.InstallLicense;
import com.ibm.ws.install.InstallProgressEvent;
import com.ibm.ws.install.RepositoryConfigUtils;
import com.ibm.ws.install.internal.ArchiveUtils;
import com.ibm.ws.install.internal.ArtifactDownloader;
import com.ibm.ws.install.internal.ArtifactDownloaderUtils;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallKernelImpl;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.MavenRepository;
import com.ibm.ws.install.internal.ProgressBar;
import com.ibm.ws.install.internal.VerifySignatureUtility;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.repository.common.enums.ReadMode;
import com.ibm.ws.repository.connections.DirectoryRepositoryConnection;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.connections.RepositoryConnectionList;
import com.ibm.ws.repository.connections.SingleFileRepositoryConnection;
import com.ibm.ws.repository.connections.liberty.ProductInfoProductDefinition;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.parsers.EsaParser;
import com.ibm.ws.repository.resolver.RepositoryResolutionException;
import com.ibm.ws.repository.resolver.RepositoryResolver;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.internal.EsaResourceImpl;
import com.ibm.ws.repository.resources.writeable.RepositoryResourceWritable;
import com.ibm.ws.repository.strategies.writeable.AddThenDeleteStrategy;
import com.ibm.ws.repository.strategies.writeable.UploadStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.apache.aries.util.manifest.ManifestProcessor;

public class InstallKernelMap
implements Map {
    private static final String MAP_BASED_INSTALL_KERNEL = "mapBasedInstallKernel";
    private static final String REPOSITORIES_PROPERTIES = "repositories.properties";
    private static final String DOWLOAD_EXTERNAL_DEPS = "dowload.external.deps";
    private static final String LOCAL_ESA_DOWNLOAD_DIR = "local.esa.download.dir";
    private static final String USER_AGENT = "user.agent";
    private static final String PROGRESS_MONITOR_MESSAGE = "progress.monitor.message";
    private static final String PROGRESS_MONITOR_CANCELLED = "progress.monitor.cancelled";
    private static final String PROGRESS_MONITOR_SIZE = "progress.monitor.size";
    private static final String TARGET_USER_DIRECTORY = "target.user.directory";
    private static final String INSTALL_KERNEL_INIT_ERROR_MESSAGE = "install.kernel.init.error.message";
    private static final String UNINSTALL_USER_FEATURES = "uninstall.user.features";
    private static final String FORCE_UNINSTALL = "force.uninstall";
    private static final String ACTION_INSTALL_RESULT = "action.install.result";
    private static final String ACTION_UNINSTALL = "action.uninstall";
    private static final String DIRECTORY_BASED_REPOSITORY = "directory.based.repository";
    private static final String MESSAGE_LOCALE = "message.locale";
    private static final String DOWNLOAD_FILETYPE = "download.filetype";
    private static final String DOWNLOAD_LOCAL_DIR_LOCATION = "download.local.dir.location";
    private static final String DOWNLOAD_ARTIFACT_SINGLE = "download.artifact.single";
    private static final String GENERATE_JSON = "generate.json";
    private static final String GENERATE_JSON_GROUP_ID_MAP = "generate.json.group.id.map";
    private static final String TARGET_JSON_DIR = "target.json.dir";
    private static final String LOCALLY_PRESENT_JSONS = "locally.present.jsons";
    private static final String SHORTNAME_HEADER_NAME = "IBM-ShortName";
    private static final String SYMBOLICNAME_HEADER_NAME = "Subsystem-SymbolicName";
    private static final Integer OK = 0;
    private static final Integer CANCELLED = -1;
    private static final Integer ERROR = 1;
    private static final String LICENSE_EPL_PREFIX = "https://www.eclipse.org/legal/epl-";
    private static final String LICENSE_FEATURE_TERMS = "http://www.ibm.com/licenses/wlp-featureterms-v1";
    private static final String LICENSE_FEATURE_TERMS_RESTRICTED = "http://www.ibm.com/licenses/wlp-featureterms-restricted-v1";
    private final String OPEN_LIBERTY_GROUP_ID = "io.openliberty.features";
    private final String WEBSPHERE_LIBERTY_GROUP_ID = "com.ibm.websphere.appserver.features";
    private final String JSON_ARTIFACT_ID = "features";
    private final String OPEN_LIBERTY_PRODUCT_ID = "io.openliberty";
    private final String MAVEN_CENTRAL = "https://repo.maven.apache.org/maven2/";
    private final MavenRepository MAVEN_CENTRAL_REPOSITORY = new MavenRepository("Maven Central", "https://repo.maven.apache.org/maven2/", null, null);
    private final String TEMP_DIRECTORY = Utils.getInstallDir().getAbsolutePath() + File.separator + "tmp" + File.separator;
    private static final String ETC_DIRECTORY = Utils.getInstallDir().getAbsolutePath() + File.separator + "etc" + File.separator;
    private static final String WLP_DIR = Utils.getInstallDir().getAbsolutePath() + File.separator;
    private static final String LICENSE_DIRECTORY = "lafiles" + File.separator;
    private static final String LIB_VERSIONS_DIRECTORY = "lib" + File.separator + "versions" + File.separator;
    private static final String FEATURE_UTILITY_PROPS_FILE = "featureUtility.env";
    private Map<String, Object> envMap = null;
    private final List<File> upgradeFiles = new ArrayList<File>();
    private final List<MavenRepository> workingRepos = new ArrayList<MavenRepository>();
    private final List<String> usrFeatures = new ArrayList<String>();
    private List<File> pubKeys = new ArrayList<File>();
    private final Map data = new HashMap();
    private InstallKernelInteractive installKernel;
    private InstallEventListener ielistener;
    private ActionType actionType = null;
    private boolean usingM2Cache = false;
    private String openLibertyVersion = null;
    private final Logger logger = InstallLogUtils.getInstallLogger();
    private final ProgressBar progressBar = ProgressBar.getInstance();
    private final boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;

    public InstallKernelMap() {
        this.data.put("license.accept", Boolean.FALSE);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object key) {
        if ("install.kernel.init.code".equals(key)) {
            return this.initKernel();
        }
        if ("action.result".equals(key)) {
            if (this.actionType.equals((Object)ActionType.install)) {
                Boolean localESAInstall = (Boolean)this.data.get("install.local.esa");
                if (localESAInstall == null || !localESAInstall.booleanValue()) {
                    return this.install();
                }
                return this.localESAInstall();
            }
            if (this.actionType.equals((Object)ActionType.uninstall)) {
                return this.uninstall();
            }
            if (this.actionType.equals((Object)ActionType.resolve)) {
                Boolean localESAInstall = (Boolean)this.data.get("install.local.esa");
                if (localESAInstall == null || !localESAInstall.booleanValue()) {
                    return this.data.get("action.result");
                }
                return this.singleFileResolve();
            }
            if (this.actionType.equals((Object)ActionType.find)) {
                return this.findFeatures();
            }
            if (this.actionType.equals((Object)ActionType.verify)) {
                return this.verifySignatures();
            }
        } else {
            if ("is.feature.utility".equals(key)) {
                if (this.data.get("is.feature.utility") == null) {
                    return false;
                }
                return this.data.get("is.feature.utility");
            }
            if ("is.install.server.feature".equals(key)) {
                if (this.data.get("is.install.server.feature") == null) {
                    return false;
                }
                return this.data.get("is.install.server.feature");
            }
            if ("json.provided".equals(key)) {
                if (this.data.get("json.provided") == null) {
                    return false;
                }
                return this.data.get("json.provided");
            }
            if (PROGRESS_MONITOR_SIZE.equals(key)) {
                return this.getMonitorSize();
            }
            if ("download.result".equals(key)) {
                Boolean downloadSingleArtifact = (Boolean)this.data.get("download.individual.artifact");
                if (downloadSingleArtifact != null && downloadSingleArtifact.booleanValue()) {
                    return this.downloadArtifact();
                }
                return this.downloadEsas();
            }
            if ("environment.variable.map".equals(key)) {
                if (this.envMap != null) {
                    return this.envMap;
                }
                this.envMap = this.getEnvMap();
                return this.envMap;
            }
            if ("user.public.keys".equals(key)) {
                return this.data.get("user.public.keys");
            }
            if ("cleanup.upgrade".equals(key)) {
                return this.cleanupUpgrade();
            }
            if ("is.open.liberty".equals(key)) {
                return this.isOpenLiberty();
            }
            if (GENERATE_JSON.equals(key)) {
                return this.generateJson();
            }
            if ("download.pubkeys".equals(key)) {
                return this.downloadPublicKeys();
            }
        }
        return this.data.get(key);
    }

    private Set<String> findFeatures() {
        LinkedHashSet<String> returnedFeatures = new LinkedHashSet<String>();
        List jsons = (List)this.get("single.json.file");
        String query = ((String)this.data.get("action.find")).toLowerCase();
        double individualSize = this.progressBar.getMethodIncrement("findFeatures") / (double)jsons.size();
        for (File jsonFile : jsons) {
            try (FileInputStream is = new FileInputStream(jsonFile);){
                JsonReader jsonReader = Json.createReader((InputStream)is);
                JsonArray jsonArray = jsonReader.readArray();
                jsonReader.close();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject json = jsonArray.getJsonObject(i);
                    JsonObject wlpInfo = json.getJsonObject("wlpInformation");
                    String visibility = null;
                    try {
                        visibility = wlpInfo.getJsonString("visibility").getString();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (visibility == null || !visibility.equals("PUBLIC")) continue;
                    String name = null;
                    try {
                        name = json.getJsonString("name").getString();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    String type = wlpInfo.getJsonString("typeLabel").getString();
                    if (wlpInfo.getJsonString("shortName") != null && json.getJsonString("shortDescription") != null) {
                        String shortname = wlpInfo.getJsonString("shortName").getString();
                        String description = json.getJsonString("shortDescription").getString();
                        if (!query.isEmpty() && !shortname.toLowerCase().contains(query) && !description.toLowerCase().contains(query)) continue;
                        returnedFeatures.add(String.format("%s : %s : %s", type, shortname, name));
                        continue;
                    }
                    if (!query.isEmpty() && !name.contains(query)) continue;
                    returnedFeatures.add(String.format("%s : %s ", type, name));
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.updateProgress(individualSize);
            this.progressBar.manuallyUpdate();
            this.fine("Finished processing " + jsonFile.getName());
        }
        return returnedFeatures;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object put(Object key, Object value) {
        if ("license.accept".equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put("license.accept", value);
            return this.data.get(key);
        } else if ("runtime.install.dir".equals(key)) {
            if (!(value instanceof File)) throw new IllegalArgumentException();
            this.data.put("runtime.install.dir", value);
            return this.data.get(key);
        } else if (LOCAL_ESA_DOWNLOAD_DIR.equals(key)) {
            if (!(value instanceof File)) throw new IllegalArgumentException();
            this.data.put(LOCAL_ESA_DOWNLOAD_DIR, value);
            return this.data.get(key);
        } else if (TARGET_JSON_DIR.equals(key)) {
            if (!(value instanceof File)) throw new IllegalArgumentException();
            this.data.put(TARGET_JSON_DIR, value);
            return this.data.get(key);
        } else if (REPOSITORIES_PROPERTIES.equals(key)) {
            if (!(value instanceof File)) throw new IllegalArgumentException();
            this.data.put(REPOSITORIES_PROPERTIES, value);
            System.setProperty("WLP_REPOSITORIES_PROPS", ((File)value).getAbsolutePath());
            try {
                Properties repoProperties = RepositoryConfigUtils.loadRepoProperties();
                if (repoProperties == null) return this.data.get(key);
                this.installKernel.setRepositoryProperties(repoProperties);
                return this.data.get(key);
            }
            catch (InstallException e) {
                this.data.put("action.result", ERROR);
                this.data.put("action.error.message", e.getMessage());
                this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
                throw new RuntimeException(e);
            }
        } else if (DOWLOAD_EXTERNAL_DEPS.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(DOWLOAD_EXTERNAL_DEPS, value);
            return this.data.get(key);
        } else if ("install.local.esa".equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put("install.local.esa", value);
            return this.data.get(key);
        } else if ("cleanup.temp.location".equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put("cleanup.temp.location", value);
            return this.data.get(key);
        } else if ("cleanup.needed".equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put("cleanup.needed", value);
            return this.data.get(key);
        } else if (USER_AGENT.equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put(USER_AGENT, value);
            if (this.installKernel == null) return this.data.get(key);
            this.installKernel.setUserAgent((String)value);
            return this.data.get(key);
        } else if ("json.provided".equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put("json.provided", value);
            return this.data.get(key);
        } else if (GENERATE_JSON.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(GENERATE_JSON, value);
            return this.data.get(key);
        } else if ("is.feature.utility".equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put("is.feature.utility", value);
            return this.data.get(key);
        } else if ("to.extension".equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put("to.extension", value);
            return this.data.get(key);
        } else if ("is.install.server.feature".equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put("is.install.server.feature", value);
            return this.data.get(key);
        } else if ("platforms".equals(key)) {
            if (!(value instanceof Collection)) throw new IllegalArgumentException();
            this.data.put("platforms", value);
            return this.data.get(key);
        } else if ("verify.option".equals(key)) {
            if (value instanceof InstallConstants.VerifyOption) {
                this.data.put("verify.option", value);
                return this.data.get(key);
            } else {
                if (!(value instanceof String)) throw new IllegalArgumentException();
                this.data.put("verify.option", InstallConstants.VerifyOption.valueOf((String)value));
            }
            return this.data.get(key);
        } else if (DOWNLOAD_FILETYPE.equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put(DOWNLOAD_FILETYPE, value);
            return this.data.get(key);
        } else if (DOWNLOAD_LOCAL_DIR_LOCATION.equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put(DOWNLOAD_LOCAL_DIR_LOCATION, value);
            return this.data.get(key);
        } else if ("from.repo".equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put("from.repo", value);
            return this.data.get(key);
        } else if ("environment.variable.map".equals(key)) {
            if (!(value instanceof Map)) throw new IllegalArgumentException();
            this.data.put("environment.variable.map", value);
            return this.data.get(key);
        } else if ("override.environment.variables".equals(key)) {
            if (!(value instanceof Map)) throw new IllegalArgumentException();
            this.overrideEnvMap((Map)value);
            this.setProxy();
            return this.data.get(key);
        } else if (DOWNLOAD_ARTIFACT_SINGLE.equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put(DOWNLOAD_ARTIFACT_SINGLE, value);
            return this.data.get(key);
        } else if ("download.artifact.list".equals(key)) {
            if (!(value instanceof List) && !(value instanceof String)) throw new IllegalArgumentException();
            this.data.put("download.artifact.list", value);
            return this.data.get(key);
        } else if ("download.individual.artifact".equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put("download.individual.artifact", value);
            return this.data.get(key);
        } else if ("download.location".equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put("download.location", value);
            return this.data.get(key);
        } else if (GENERATE_JSON_GROUP_ID_MAP.equals(key)) {
            if (!(value instanceof Map)) throw new IllegalArgumentException();
            this.data.put(GENERATE_JSON_GROUP_ID_MAP, value);
            return this.data.get(key);
        } else if (TARGET_USER_DIRECTORY.equals(key)) {
            if (!(value instanceof File)) throw new IllegalArgumentException();
            this.data.put(TARGET_USER_DIRECTORY, value);
            Utils.setUserDir((File)((File)value));
            return this.data.get(key);
        } else if (MESSAGE_LOCALE.equals(key)) {
            if (!(value instanceof Locale)) throw new IllegalArgumentException();
            this.data.put(MESSAGE_LOCALE, value);
            InstallLogUtils.Messages.setLocale((Locale)value);
            return this.data.get(key);
        } else if (PROGRESS_MONITOR_MESSAGE.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            this.data.put(PROGRESS_MONITOR_MESSAGE, value);
            return this.data.get(key);
        } else if (PROGRESS_MONITOR_CANCELLED.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            this.data.put(PROGRESS_MONITOR_CANCELLED, value);
            return this.data.get(key);
        } else if ("action.install".equals(key)) {
            if (!(value instanceof List) && !(value instanceof File)) throw new IllegalArgumentException();
            Boolean localESAInstall = (Boolean)this.data.get("install.local.esa");
            if (localESAInstall == null || !localESAInstall.booleanValue()) {
                this.resolve(value);
                return this.data.get(key);
            } else {
                this.data.put("action.install", value);
            }
            return this.data.get(key);
        } else if ("action.find".equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put("action.find", value);
            this.actionType = ActionType.find;
            return this.data.get(key);
        } else if ("action.verify".equals(key)) {
            if (!(value instanceof List)) return this.data.get(key);
            this.data.put("action.verify", value);
            this.actionType = ActionType.verify;
            return this.data.get(key);
        } else if (UNINSTALL_USER_FEATURES.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(UNINSTALL_USER_FEATURES, value);
            return this.data.get(key);
        } else if (FORCE_UNINSTALL.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(FORCE_UNINSTALL, value);
            return this.data.get(key);
        } else if (ACTION_UNINSTALL.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            this.data.put(ACTION_UNINSTALL, value);
            this.actionType = ActionType.uninstall;
            return this.data.get(key);
        } else if ("features.to.resolve".equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            Boolean localESAInstall = (Boolean)this.data.get("install.local.esa");
            if (localESAInstall == null || !localESAInstall.booleanValue()) throw new IllegalArgumentException();
            if ((List)this.data.get("single.json.file") == null) throw new IllegalArgumentException();
            this.actionType = ActionType.resolve;
            this.data.put("features.to.resolve", value);
            return this.data.get(key);
        } else if ("single.json.file".equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            Boolean localESAInstall = (Boolean)this.data.get("install.local.esa");
            if (localESAInstall == null || !localESAInstall.booleanValue()) throw new IllegalArgumentException();
            this.data.put("single.json.file", value);
            return this.data.get(key);
        } else if (DIRECTORY_BASED_REPOSITORY.equals(key)) {
            if (!(value instanceof File)) return this.data.get(key);
            this.data.put(DIRECTORY_BASED_REPOSITORY, value);
            return this.data.get(key);
        } else if ("individual.esas".equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            this.data.put("individual.esas", value);
            return this.data.get(key);
        } else if (LOCALLY_PRESENT_JSONS.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            this.data.put(LOCALLY_PRESENT_JSONS, value);
            return this.data.get(key);
        } else if ("install.individual.esas".equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put("install.individual.esas", value);
            return this.data.get(key);
        } else if ("user.public.keys".equals(key)) {
            if (!(value instanceof Collection)) throw new IllegalArgumentException();
            this.data.put("user.public.keys", value);
            return this.data.get(key);
        } else if ("action.error.message".equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put("action.error.message", value);
            return this.data.get(key);
        } else if ("action.exception.stacktrace".equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put("action.exception.stacktrace", value);
            return this.data.get(key);
        } else {
            if (!key.equals("debug")) return this.data.get(key);
            if (!(value instanceof Level)) throw new IllegalArgumentException();
            this.data.put("debug", value);
            ((InstallKernelImpl)this.installKernel).enableConsoleLog((Level)value);
        }
        return this.data.get(key);
    }

    private InstallEventListener getListener() {
        if (this.ielistener == null) {
            this.ielistener = new InstallEventListener(){

                @Override
                public void handleInstallEvent(InstallProgressEvent event) throws Exception {
                    if (InstallKernelMap.this.actionType != null) {
                        List messages;
                        if (InstallKernelMap.this.actionType.equals((Object)ActionType.install)) {
                            List messages2 = (List)InstallKernelMap.this.data.get(InstallKernelMap.PROGRESS_MONITOR_MESSAGE);
                            if (messages2 != null) {
                                messages2.add(event.message);
                                List cancelledList = (List)InstallKernelMap.this.data.get(InstallKernelMap.PROGRESS_MONITOR_CANCELLED);
                                if (((Boolean)cancelledList.get(0)).booleanValue()) {
                                    throw new CancelException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("MSG_CANCEL_INSTALL", new Object[0]), CANCELLED);
                                }
                            }
                        } else if (InstallKernelMap.this.actionType.equals((Object)ActionType.uninstall) && event.state == 255 && (messages = (List)InstallKernelMap.this.data.get(InstallKernelMap.PROGRESS_MONITOR_MESSAGE)) != null) {
                            messages.add(event.message);
                        }
                    }
                }
            };
        }
        return this.ielistener;
    }

    private Integer initKernel() {
        File installDir = (File)this.data.get("runtime.install.dir");
        Utils.setInstallDir((File)installDir);
        this.installKernel = InstallKernelFactory.getInteractiveInstance();
        String userAgent = (String)this.data.get(USER_AGENT);
        this.installKernel.setUserAgent(userAgent != null && !userAgent.isEmpty() ? userAgent : MAP_BASED_INSTALL_KERNEL);
        this.installKernel.setFirePublicAssetOnly(false);
        this.installKernel.addListener(this.getListener(), "PROGRESS");
        this.data.put(INSTALL_KERNEL_INIT_ERROR_MESSAGE, null);
        return OK;
    }

    private void resolve(Object installObject) {
        this.data.put("action.install", null);
        this.data.put("action.result", OK);
        this.data.put(ACTION_INSTALL_RESULT, null);
        this.data.put("action.error.message", null);
        this.data.put("action.exception.stacktrace", null);
        this.actionType = ActionType.resolve;
        if (installObject instanceof List) {
            List assets = (List)installObject;
            try {
                this.installKernel.resolve(assets, false);
                this.checkLicense();
                this.actionType = ActionType.install;
                this.data.put("action.install", installObject);
            }
            catch (InstallException e) {
                this.data.put("action.result", ERROR);
                this.data.put("action.error.message", e.getMessage());
                this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
            }
        } else if (installObject instanceof File) {
            File esaFile = (File)installObject;
            boolean isESA = ArchiveUtils.ArchiveFileType.ESA.isType(esaFile.getName());
            if (isESA) {
                try {
                    String feature = InstallUtils.getFeatureName(esaFile);
                    this.installKernel.resolve(feature, esaFile, "usr");
                    this.checkLicense();
                    this.actionType = ActionType.install;
                    this.data.put("action.install", installObject);
                }
                catch (InstallException e) {
                    this.data.put("action.result", ERROR);
                    this.data.put("action.error.message", e.getMessage());
                    this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
                }
            } else {
                this.data.put("action.result", ERROR);
                this.data.put("action.error.message", InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MAPBASED_ERROR_UNSUPPORTED_FILE", esaFile.getAbsoluteFile()));
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static boolean containsIgnoreCase(Collection<String> featureToInstall, String existingFeature) {
        for (String current : featureToInstall) {
            if (!current.equalsIgnoreCase(existingFeature)) continue;
            return true;
        }
        return false;
    }

    private boolean isOpenLiberty() {
        try {
            for (ProductInfo productInfo : ProductInfo.getAllProductInfo().values()) {
                if (productInfo.getReplacedBy() != null || !productInfo.getId().equals("io.openliberty")) continue;
                return true;
            }
        }
        catch (ProductInfoParseException e) {
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString((Exception)((Object)e)));
        }
        catch (DuplicateProductInfoException e) {
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString((Exception)((Object)e)));
        }
        catch (ProductInfoReplaceException e) {
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString((Exception)((Object)e)));
        }
        return false;
    }

    public Collection<String> singleFileResolve() {
        this.data.put("action.install", null);
        this.data.put("action.result", OK);
        this.data.put(ACTION_INSTALL_RESULT, null);
        this.data.put("action.error.message", null);
        this.data.put("action.exception.stacktrace", null);
        HashSet<ProductInfoProductDefinition> productDefinitions = new HashSet<ProductInfoProductDefinition>();
        Collection resolveResult = null;
        RepositoryResolver resolver = null;
        Collection<String> featuresResolved = new ArrayList<String>();
        boolean isOpenLiberty = false;
        this.openLibertyVersion = this.getLibertyVersion();
        try {
            boolean isInstallServerFeature;
            SingleFileRepositoryConnection repo;
            for (ProductInfo productInfo : ProductInfo.getAllProductInfo().values()) {
                productDefinitions.add(new ProductInfoProductDefinition(productInfo));
                if (productInfo.getReplacedBy() != null || !productInfo.getId().equals("io.openliberty")) continue;
                isOpenLiberty = true;
            }
            RepositoryConnectionList repoList = new RepositoryConnectionList();
            List singleJsonRepos = (List)this.data.get("single.json.file");
            File directoryBasedRepo = (File)this.data.get(DIRECTORY_BASED_REPOSITORY);
            if (directoryBasedRepo != null) {
                DirectoryRepositoryConnection directRepo = new DirectoryRepositoryConnection(directoryBasedRepo, ReadMode.ASSUME_UNCHANGED);
                repoList.add((RepositoryConnection)directRepo);
            }
            File websphereJson = null;
            for (File jsonRepo : singleJsonRepos) {
                if (jsonRepo.getAbsolutePath().contains("com.ibm.websphere.appserver.features".replace(".", "/"))) {
                    websphereJson = jsonRepo;
                }
                SingleFileRepositoryConnection repo2 = new SingleFileRepositoryConnection(jsonRepo);
                repoList.add((RepositoryConnection)repo2);
            }
            ManifestFileProcessor m_ManifestFileProcessor = new ManifestFileProcessor();
            Collection installedFeatures = m_ManifestFileProcessor.getFeatureDefinitions().values();
            int alreadyInstalled = 0;
            Collection featureToInstall = (Collection)this.data.get("features.to.resolve");
            HashMap<String, String> shortNameMap = new HashMap<String, String>();
            if (this.data.get("install.individual.esas") != null) {
                try {
                    if (this.data.get("install.individual.esas").equals(Boolean.TRUE)) {
                        Path tempDir = Files.createTempDirectory("generatedJson", new FileAttribute[0]);
                        tempDir.toFile().deleteOnExit();
                        File individualEsaJson = this.generateJsonFromIndividualESAs(tempDir, shortNameMap);
                        repo = new SingleFileRepositoryConnection(individualEsaJson);
                        repoList.add((RepositoryConnection)repo);
                        ArrayList<String> shortNamesToInstall = new ArrayList<String>();
                        Iterator it = featureToInstall.iterator();
                        while (it.hasNext()) {
                            String feature = (String)it.next();
                            if (!feature.endsWith(".esa") || !shortNameMap.containsKey(feature)) continue;
                            it.remove();
                            shortNamesToInstall.add((String)shortNameMap.get(feature));
                        }
                        featureToInstall.addAll(shortNamesToInstall);
                    }
                }
                catch (NullPointerException e) {
                    this.data.put("action.result", ERROR);
                    this.data.put("action.error.message", e.getMessage());
                    this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
                }
            }
            if (!(isInstallServerFeature = ((Boolean)this.get("is.install.server.feature")).booleanValue())) {
                ArrayList<String> featuresAlreadyPresent = new ArrayList<String>();
                for (Object feature : installedFeatures) {
                    if (!InstallKernelMap.containsIgnoreCase(featureToInstall, feature.getIbmShortName()) && !featureToInstall.contains(feature.getFeatureName())) continue;
                    ++alreadyInstalled;
                    if (feature.getIbmShortName() == null) {
                        featuresAlreadyPresent.add(feature.getFeatureName());
                        continue;
                    }
                    featuresAlreadyPresent.add(feature.getIbmShortName());
                }
                if (alreadyInstalled == featureToInstall.size()) {
                    throw ExceptionUtils.createByKey(22, "ASSETS_ALREADY_INSTALLED", featuresAlreadyPresent);
                }
            }
            boolean isFeatureUtility = (Boolean)this.get("is.feature.utility");
            this.data.put("upgrade.complete", false);
            if (isOpenLiberty && isFeatureUtility && websphereJson != null && this.upgradeRequired(websphereJson)) {
                this.upgradeOL(websphereJson);
                repo = new SingleFileRepositoryConnection(websphereJson);
                repoList.add((RepositoryConnection)repo);
                for (ProductInfo productInfo : ProductInfo.getAllProductInfo().values()) {
                    productDefinitions.add(new ProductInfoProductDefinition(productInfo));
                }
                this.data.put("upgrade.complete", true);
            }
            resolver = new RepositoryResolver(productDefinitions, installedFeatures, Collections.emptySet(), repoList);
            resolveResult = !isInstallServerFeature ? resolver.resolve((Collection)this.data.get("features.to.resolve")) : resolver.resolveAsSet((Collection)this.data.get("features.to.resolve"), (Collection)this.data.get("platforms"));
            if (!resolveResult.isEmpty()) {
                for (List item : resolveResult) {
                    for (RepositoryResource repoResrc : item) {
                        String license;
                        String ibmInstallTo = "";
                        if (repoResrc instanceof EsaResourceImpl) {
                            ibmInstallTo = ((EsaResourceImpl)repoResrc).getIBMInstallTo();
                        }
                        if ((license = repoResrc.getLicenseId()) != null) {
                            Boolean accepted;
                            boolean autoAcceptLicense;
                            boolean isNDRuntime = false;
                            for (ProductInfo productInfo : ProductInfo.getAllProductInfo().values()) {
                                if (!"com.ibm.websphere.appserver".equals(productInfo.getId()) || !"ND".equals(productInfo.getEdition())) continue;
                                isNDRuntime = true;
                                break;
                            }
                            boolean bl = autoAcceptLicense = license.startsWith(LICENSE_EPL_PREFIX) || license.equals(LICENSE_FEATURE_TERMS) || isNDRuntime && license.equals(LICENSE_FEATURE_TERMS_RESTRICTED);
                            if (!(autoAcceptLicense || (accepted = (Boolean)this.data.get("license.accept")) != null && accepted.booleanValue())) {
                                featuresResolved.clear();
                                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_LICENSES_NOT_ACCEPTED", new Object[0]));
                            }
                        }
                        if (repoResrc.getRepositoryConnection() instanceof DirectoryRepositoryConnection) {
                            featuresResolved.add(repoResrc.getId());
                            continue;
                        }
                        String featureCoord = repoResrc.getMavenCoordinates();
                        String featurePath = null;
                        if (featureCoord == null) {
                            if (repoResrc instanceof EsaResourceImpl) {
                                String name = ((EsaResourceImpl)repoResrc).getShortName() == null ? repoResrc.getName() : ((EsaResourceImpl)repoResrc).getShortName();
                                for (String k : shortNameMap.keySet()) {
                                    if (!((String)shortNameMap.get(k)).equals(name)) continue;
                                    featuresResolved.add(k);
                                    featurePath = k;
                                }
                            }
                        } else {
                            featuresResolved.add(featureCoord);
                            featurePath = ArtifactDownloaderUtils.getfilename(featureCoord).toLowerCase() + ".esa";
                        }
                        if (ibmInstallTo != null && !ibmInstallTo.equals("usr")) continue;
                        this.usrFeatures.add(featurePath);
                        this.usrFeatures.add(featureCoord);
                    }
                }
            }
            this.actionType = this.data.get("verify.option") != null && (InstallConstants.VerifyOption)((Object)this.data.get("verify.option")) != InstallConstants.VerifyOption.skip ? ActionType.verify : ActionType.install;
            featuresResolved = InstallKernelMap.keepFirstInstance(featuresResolved);
            return featuresResolved;
        }
        catch (ProductInfoParseException e) {
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString((Exception)((Object)e)));
        }
        catch (DuplicateProductInfoException e) {
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString((Exception)((Object)e)));
        }
        catch (ProductInfoReplaceException e) {
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString((Exception)((Object)e)));
        }
        catch (RepositoryResolutionException e) {
            boolean isFeatureUtility = (Boolean)this.get("is.feature.utility");
            this.data.put("action.result", ERROR);
            InstallException ie = ExceptionUtils.create(e, (Collection<String>)e.getTopLevelFeaturesNotResolved(), (File)this.data.get("runtime.install.dir"), false, isOpenLiberty, isFeatureUtility);
            if (ie != null) {
                this.data.put("action.error.message", ie.getMessage());
                this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(ie));
            }
        }
        catch (InstallException e) {
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
        }
        catch (RepositoryException e) {
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString((Exception)((Object)e)));
        }
        catch (Exception e) {
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
        }
        this.actionType = ActionType.install;
        return featuresResolved;
    }

    private boolean upgradeRequired(File websphereJson) throws InstallException {
        Collection features = (Collection)this.data.get("features.to.resolve");
        boolean upgradeRequired = false;
        try (JsonReader reader = Json.createReader((InputStream)new FileInputStream(websphereJson));){
            JsonArray assetList = reader.readArray();
            int lstSize = assetList.size();
            for (int i = 0; i < lstSize && !upgradeRequired; ++i) {
                if (((JsonValue)assetList.get(i)).getValueType() != JsonValue.ValueType.OBJECT) continue;
                JsonObject featureObject = (JsonObject)assetList.get(i);
                JsonObject wlpFeatureInfo = featureObject.getJsonObject("wlpInformation");
                String lowerCaseShortName = wlpFeatureInfo.getString("lowerCaseShortName", null);
                String name = featureObject.getString("name", null);
                if (lowerCaseShortName != null && this.containsStr(lowerCaseShortName, features)) {
                    upgradeRequired = true;
                    continue;
                }
                if (name == null || !this.containsStr(name, features)) continue;
                upgradeRequired = true;
            }
        }
        catch (FileNotFoundException e) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FAILED_TO_FIND_WEBSPHERE_JSON", websphereJson.getAbsolutePath()));
        }
        return upgradeRequired;
    }

    public void overrideEnvMap(Map<String, Object> overrideMap) {
        this.logger.fine("envmap before:");
        if (overrideMap == null) {
            return;
        }
        if (this.envMap == null) {
            this.envMap = new HashMap<String, Object>();
        }
        this.logger.fine(this.envMap.toString());
        this.envMap.putAll(overrideMap);
        this.logger.fine("printing envmap after");
        this.logger.fine(this.envMap.toString());
    }

    protected void setProxy() {
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        try {
            if (this.envMap.get("https.proxyHost") != null) {
                this.checkValidProxy("https");
                System.setProperty("https.proxyHost", (String)this.envMap.get("https.proxyHost"));
                System.setProperty("https.proxyPort", (String)this.envMap.get("https.proxyPort"));
            }
            if (this.envMap.get("http.proxyHost") != null) {
                this.checkValidProxy("http");
                System.setProperty("http.proxyHost", (String)this.envMap.get("http.proxyHost"));
                System.setProperty("http.proxyPort", (String)this.envMap.get("http.proxyPort"));
                if (this.envMap.get("https.proxyHost") == null) {
                    System.setProperty("https.proxyHost", (String)this.envMap.get("http.proxyHost"));
                    System.setProperty("https.proxyPort", (String)this.envMap.get("http.proxyPort"));
                }
            }
            if (System.getProperty("featureUtility.beta") != null && System.getProperty("featureUtility.beta").equals("true") && this.envMap.get("http.nonProxyHosts") != null) {
                String noProxyHosts = (String)this.envMap.get("http.nonProxyHosts");
                noProxyHosts = noProxyHosts.replace(",", "|");
                System.setProperty("http.nonProxyHosts", noProxyHosts);
            }
        }
        catch (InstallException e) {
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
        }
    }

    protected void checkValidProxy(String protocol) throws InstallException {
        String proxyPort = (String)this.envMap.get(protocol + ".proxyPort");
        if (protocol != null) {
            int proxyPortnum = Integer.parseInt(proxyPort);
            if (((String)this.envMap.get(protocol + ".proxyHost")).isEmpty()) {
                throw ExceptionUtils.createByKey("ERROR_TOOL_PROXY_HOST_MISSING", new Object[0]);
            }
            if (proxyPortnum < 0 || proxyPortnum > 65535) {
                throw ExceptionUtils.createByKey("ERROR_TOOL_INVALID_PROXY_PORT", proxyPort);
            }
            if (this.envMap.get(protocol + "proxyUser") != null && (this.envMap.get(protocol + ".proxyPassword") == null || ((String)this.envMap.get(protocol + ".proxyPassword")).isEmpty())) {
                throw ExceptionUtils.createByKey("ERROR_TOOL_PROXY_PWD_MISSING", new Object[0]);
            }
        }
    }

    private static Collection<String> keepFirstInstance(Collection<String> dupStrCollection) {
        ArrayList<String> uniqueStrCollection = new ArrayList<String>();
        for (String str : dupStrCollection) {
            if (uniqueStrCollection.contains(str)) continue;
            uniqueStrCollection.add(str);
        }
        return uniqueStrCollection;
    }

    private void checkLicense() throws InstallException {
        Boolean accepted;
        Set<InstallLicense> licenses = this.installKernel.getFeatureLicense(Locale.getDefault());
        if (!(licenses.isEmpty() || (accepted = (Boolean)this.data.get("license.accept")) != null && accepted.booleanValue())) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_LICENSES_NOT_ACCEPTED", new Object[0]));
        }
    }

    private Integer getMonitorSize() {
        if (this.actionType != null) {
            if (this.actionType.equals((Object)ActionType.install)) {
                int numInstallResources = this.installKernel.getInstallResourcesSize();
                int numInstallAssets = this.installKernel.getLocalInstallAssetsSize();
                return numInstallResources * 2 + numInstallAssets + 1;
            }
            if (this.actionType.equals((Object)ActionType.uninstall)) {
                return 1;
            }
        }
        return 0;
    }

    public Integer install() {
        this.data.put("action.result", OK);
        this.data.put(ACTION_INSTALL_RESULT, null);
        this.data.put("action.error.message", null);
        this.data.put("action.exception.stacktrace", null);
        try {
            this.installKernel.checkResources();
            Boolean agreedToDownloadDependencies = (Boolean)this.data.get(DOWLOAD_EXTERNAL_DEPS);
            if (agreedToDownloadDependencies == null) {
                agreedToDownloadDependencies = Boolean.TRUE;
            }
            Map<String, Collection<String>> installedAssets = this.installKernel.install("usr", true, agreedToDownloadDependencies);
            this.data.put(ACTION_INSTALL_RESULT, installedAssets);
        }
        catch (CancelException e) {
            this.data.put("action.result", CANCELLED);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
            return CANCELLED;
        }
        catch (InstallException e) {
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
            return ERROR;
        }
        return OK;
    }

    public List<File> downloadFeatures(List<String> featureList, List<String> signatureList) {
        this.data.put("action.error.message", null);
        this.data.put("action.exception.stacktrace", null);
        ArtifactDownloader artifactDownloader = new ArtifactDownloader();
        try {
            Object object;
            String downloadDir;
            String fromRepo = (String)this.data.get("from.repo");
            Boolean cleanupNeeded = (Boolean)this.data.get("cleanup.needed");
            List<MavenRepository> repos = this.getMavenRepo(fromRepo);
            ArrayList<String> copyFeatureList = new ArrayList<String>();
            ArrayList<String> copySignatureList = new ArrayList<String>();
            InstallConstants.VerifyOption verifyOption = (InstallConstants.VerifyOption)((Object)this.data.get("verify.option"));
            if (cleanupNeeded != null && cleanupNeeded.booleanValue()) {
                this.fine("Using temp location: " + this.TEMP_DIRECTORY);
                this.data.put("cleanup.temp.location", this.TEMP_DIRECTORY);
                downloadDir = this.TEMP_DIRECTORY;
            } else {
                downloadDir = this.getDownloadDir((String)this.data.get("download.location"));
            }
            copyFeatureList.addAll(featureList);
            copySignatureList.addAll(signatureList);
            artifactDownloader.setEnvMap(this.envMap);
            for (MavenRepository repo : repos) {
                try {
                    if (!copyFeatureList.isEmpty()) {
                        Set<String> missingFeatures = artifactDownloader.getMissingFeaturesFromRepo(copyFeatureList, this.usrFeatures, repo, verifyOption, false);
                        copyFeatureList.removeAll(missingFeatures);
                        artifactDownloader.synthesizeAndDownloadFeatures(copyFeatureList, this.usrFeatures, downloadDir, repo, verifyOption, false);
                        copyFeatureList = new ArrayList<String>(missingFeatures);
                    }
                    if (copySignatureList.isEmpty()) continue;
                    Set<String> missingSignatures = artifactDownloader.getMissingFeaturesFromRepo(copySignatureList, this.usrFeatures, repo, verifyOption, true);
                    copySignatureList.removeAll(missingSignatures);
                    artifactDownloader.synthesizeAndDownloadFeatures(copySignatureList, this.usrFeatures, downloadDir, repo, verifyOption, true);
                    copySignatureList = new ArrayList<String>(missingSignatures);
                }
                catch (InstallException e) {
                    this.put("action.result", ERROR);
                    this.put("action.error.message", e.getMessage());
                    this.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
                    List<File> list = null;
                    artifactDownloader.close();
                    return list;
                }
            }
            if (copyFeatureList != null && !copyFeatureList.isEmpty()) {
                this.put("action.result", ERROR);
                this.put("action.error.message", ExceptionUtils.createByKey("ERROR_FAILED_TO_DOWNLOAD_ASSETS_FROM_REPO", "required", "feature(s)", repos).getMessage());
                object = null;
                return object;
            }
            if (copySignatureList != null && !copySignatureList.isEmpty() && verifyOption == InstallConstants.VerifyOption.all) {
                this.put("action.result", ERROR);
                this.put("action.error.message", ExceptionUtils.createByKey("ERROR_FAILED_TO_DOWNLOAD_ASSETS_FROM_REPO", "required", "feature signatures(s)", repos).getMessage());
                object = null;
                return object;
            }
            this.fine("Downloaded the following feature signautres from the remote maven repository:" + artifactDownloader.getDownloadedAscs());
            object = artifactDownloader.getDownloadedEsas(featureList);
            return object;
        }
        finally {
            try {
                artifactDownloader.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    public List<File> downloadArtifact() {
        String downloadDir;
        this.data.put("action.error.message", null);
        this.data.put("action.exception.stacktrace", null);
        ArtifactDownloader artifactDownloader = new ArtifactDownloader();
        String fromRepo = (String)this.data.get("from.repo");
        Boolean cleanupNeeded = (Boolean)this.data.get("cleanup.needed");
        if (cleanupNeeded != null && cleanupNeeded.booleanValue()) {
            this.fine("Using temp location: " + this.TEMP_DIRECTORY);
            this.data.put("cleanup.temp.location", this.TEMP_DIRECTORY);
            downloadDir = this.TEMP_DIRECTORY;
        } else {
            downloadDir = this.getDownloadDir((String)this.data.get("download.location"));
        }
        String artifact = (String)this.get(DOWNLOAD_ARTIFACT_SINGLE);
        String filetype = (String)this.get(DOWNLOAD_FILETYPE);
        List<MavenRepository> repos = this.getMavenRepo(fromRepo);
        Throwable encounteredException = null;
        artifactDownloader.setEnvMap(this.envMap);
        for (MavenRepository repo : repos) {
            try {
                artifactDownloader.synthesizeAndDownload(artifact, filetype, downloadDir, repo, true);
                List<File> list = artifactDownloader.getDownloadedFiles();
                return list;
            }
            catch (InstallException e) {
                this.fine(artifact + " not found on the following repo: " + repo);
                encounteredException = e;
            }
        }
        this.put("action.result", ERROR);
        if (encounteredException != null) {
            this.put("action.error.message", encounteredException.getMessage());
            this.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString((Exception)encounteredException));
        }
        Iterator<MavenRepository> iterator = null;
        return iterator;
        finally {
            artifactDownloader.close();
        }
    }

    private String getDownloadDir(String fromDir) {
        String result;
        if (fromDir != null) {
            result = fromDir;
        } else {
            fromDir = this.getM2Cache();
            if (fromDir != null) {
                this.usingM2Cache = true;
                result = this.getM2Cache();
            } else if (this.checkM2Writable()) {
                File newM2 = new File(this.getM2Path().toString());
                result = newM2.toString();
            } else {
                this.fine("Using temp location: " + this.TEMP_DIRECTORY);
                this.data.put("cleanup.temp.location", this.TEMP_DIRECTORY);
                this.data.put("cleanup.needed", true);
                result = this.TEMP_DIRECTORY;
            }
        }
        return result;
    }

    private String getM2Cache() {
        Path m2Path = this.getM2Path();
        if (Files.exists(m2Path, new LinkOption[0]) && Files.isWritable(m2Path)) {
            return m2Path.toString();
        }
        return null;
    }

    private Path getM2Path() {
        return Paths.get(System.getProperty("user.home"), ".m2", "repository", "");
    }

    private boolean checkM2Writable() {
        String userhome = System.getProperty("user.home");
        Path userhomePath = Paths.get(userhome, new String[0]);
        if (!Files.exists(userhomePath, new LinkOption[0]) || !Files.isWritable(userhomePath)) {
            return false;
        }
        Path withM2 = Paths.get(userhome, "/.m2");
        Path withRepository = Paths.get(userhome, "/.m2/repository");
        if (Files.exists(withM2, new LinkOption[0])) {
            if (Files.exists(withRepository, new LinkOption[0])) {
                return Files.isWritable(withRepository);
            }
            return withRepository.toFile().mkdir();
        }
        if (withM2.toFile().mkdir()) {
            return this.checkM2Writable();
        }
        return false;
    }

    private String getRepo(String fromRepo) {
        String repo;
        if (this.envMap.get("FEATURE_REPO_URL") != null) {
            this.fine("Connecting to the following repository: " + this.envMap.get("FEATURE_REPO_URL"));
            repo = (String)this.envMap.get("FEATURE_REPO_URL");
        } else {
            this.fine("Connecting to the following repository: https://repo.maven.apache.org/maven2/");
            repo = "https://repo.maven.apache.org/maven2/";
        }
        return repo;
    }

    private List<MavenRepository> getMavenRepo(String fromRepo) {
        if (this.workingRepos != null && !this.workingRepos.isEmpty()) {
            return this.workingRepos;
        }
        this.checkWorkingRepository();
        return this.workingRepos;
    }

    private void checkWorkingRepository() {
        List repositories = (List)this.envMap.get("FEATURE_UTILITY_MAVEN_REPOSITORIES");
        if (repositories != null) {
            try (ArtifactDownloader artifactDownloader = new ArtifactDownloader();){
                artifactDownloader.setEnvMap(this.envMap);
                for (MavenRepository repository : repositories) {
                    this.logger.fine("Testing connection for repository: " + repository);
                    if (!artifactDownloader.testConnection(repository)) continue;
                    this.workingRepos.add(repository);
                }
            }
        }
        if (this.workingRepos.isEmpty()) {
            this.workingRepos.add(this.MAVEN_CENTRAL_REPOSITORY);
        }
    }

    public File downloadSingleFeature() {
        String downloadDir;
        this.data.put("action.error.message", null);
        this.data.put("action.exception.stacktrace", null);
        ArtifactDownloader artifactDownloader = new ArtifactDownloader();
        String featureList = (String)this.data.get("download.artifact.list");
        String filetype = (String)this.data.get(DOWNLOAD_FILETYPE);
        String fromRepo = (String)this.data.get("from.repo");
        Boolean cleanupNeeded = (Boolean)this.data.get("cleanup.needed");
        if (cleanupNeeded != null && cleanupNeeded.booleanValue()) {
            this.fine("Using temp location: " + this.TEMP_DIRECTORY);
            this.data.put("cleanup.temp.location", this.TEMP_DIRECTORY);
            downloadDir = this.TEMP_DIRECTORY;
        } else {
            downloadDir = this.getDownloadDir((String)this.data.get("download.location"));
        }
        List<MavenRepository> repos = this.getMavenRepo(fromRepo);
        Throwable encounteredException = null;
        for (MavenRepository repo : repos) {
            try {
                artifactDownloader.setEnvMap(this.envMap);
                artifactDownloader.synthesizeAndDownload(featureList, filetype, downloadDir, repo, true);
                File file = artifactDownloader.getDownloadedFiles().get(0);
                return file;
            }
            catch (InstallException e) {
                this.fine(featureList + " not found on the following repo: " + repo);
                encounteredException = e;
            }
        }
        this.put("action.result", ERROR);
        if (encounteredException != null) {
            this.put("action.error.message", encounteredException.getMessage());
            this.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString((Exception)encounteredException));
        }
        Iterator<MavenRepository> iterator = null;
        return iterator;
        finally {
            artifactDownloader.close();
        }
    }

    public Integer localESAInstall() {
        this.data.put("action.result", OK);
        this.data.put(ACTION_INSTALL_RESULT, null);
        this.data.put("action.error.message", null);
        this.data.put("action.exception.stacktrace", null);
        try {
            InstallKernelImpl installKernel = (InstallKernelImpl)this.installKernel;
            File esaFile = (File)this.data.get("action.install");
            String toExtension = (String)this.data.get("to.extension");
            if (toExtension == null) {
                toExtension = "usr";
            }
            Collection<String> installedAssets = installKernel.installLocalFeatureNoResolve(esaFile.getAbsolutePath(), toExtension, true, InstallConstants.ExistsAction.replace);
            this.data.put(ACTION_INSTALL_RESULT, installedAssets);
        }
        catch (InstallException e) {
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
            return ERROR;
        }
        return OK;
    }

    private Integer uninstall() {
        ArrayList<String> uninstallFeatures = this.data.containsKey(ACTION_UNINSTALL) ? new ArrayList<String>((Collection)this.data.get(ACTION_UNINSTALL)) : new ArrayList();
        this.data.put("action.error.message", null);
        try {
            Boolean allowUninstallUserFeatures;
            InstallKernel installKernel = (InstallKernel)((Object)this.installKernel);
            Boolean forceUninstall = this.data.containsKey(FORCE_UNINSTALL) ? (Boolean)this.data.get(FORCE_UNINSTALL) : Boolean.FALSE;
            Boolean bl = allowUninstallUserFeatures = this.data.containsKey(UNINSTALL_USER_FEATURES) ? (Boolean)this.data.get(UNINSTALL_USER_FEATURES) : Boolean.FALSE;
            if (forceUninstall.booleanValue()) {
                if (uninstallFeatures.size() > 1) {
                    this.data.put("action.error.message", InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_NUMBER_OF_FEATURES_FORCE_UNINSTALL", new Object[0]));
                    return ERROR;
                }
                installKernel.uninstallFeaturePrereqChecking((String)uninstallFeatures.get(0), allowUninstallUserFeatures, forceUninstall);
                installKernel.uninstallFeature((String)uninstallFeatures.get(0), forceUninstall);
            } else {
                if (allowUninstallUserFeatures != null && allowUninstallUserFeatures.booleanValue()) {
                    installKernel.uninstallFeaturePrereqChecking(uninstallFeatures);
                } else {
                    installKernel.uninstallCoreFeaturePrereqChecking(uninstallFeatures);
                }
                installKernel.uninstallFeature(uninstallFeatures);
            }
        }
        catch (InstallException e) {
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
            return ERROR;
        }
        return OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateFeatureNameFromManifest(File esa, Map<String, String> shortNameMap) throws IOException {
        String esaLocation = esa.getCanonicalPath();
        try (ZipFile zip = null;){
            zip = new ZipFile(esaLocation);
            Enumeration<? extends ZipEntry> zipEntries = zip.entries();
            ZipEntry subsystemEntry = null;
            while (zipEntries.hasMoreElements()) {
                ZipEntry nextEntry = zipEntries.nextElement();
                if (!"OSGI-INF/SUBSYSTEM.MF".equalsIgnoreCase(nextEntry.getName())) continue;
                subsystemEntry = nextEntry;
                break;
            }
            if (subsystemEntry != null) {
                Manifest m = ManifestProcessor.parseManifest((InputStream)zip.getInputStream(subsystemEntry));
                Attributes manifestAttrs = m.getMainAttributes();
                String featureName = manifestAttrs.getValue(SHORTNAME_HEADER_NAME);
                if (featureName == null) {
                    featureName = manifestAttrs.getValue(SYMBOLICNAME_HEADER_NAME).split(";")[0];
                }
                shortNameMap.put(esa.getCanonicalPath(), featureName);
            }
        }
    }

    private File generateJsonFromIndividualESAs(Path jsonDirectory, Map<String, String> shortNameMap) throws IOException, RepositoryException, InstallException {
        String dir = jsonDirectory.toString();
        List esas = (List)this.data.get("individual.esas");
        File singleJson = new File(dir + File.separator + "SingleJson.json");
        return this.createJson(singleJson, shortNameMap, esas);
    }

    private File generateJsonFromESAList(Path jsonDirectory, Map<String, String> shortNameMap, List<File> esas) throws IOException, RepositoryException, InstallException {
        String dir = jsonDirectory.toString();
        File singleJson = new File(dir + File.separator + "SingleJson.json");
        return this.createJson(singleJson, shortNameMap, esas);
    }

    private File createJson(File singleJson, Map<String, String> shortNameMap, List<File> esas) throws InstallException, RepositoryException {
        for (File esa : esas) {
            try {
                InstallKernelMap.populateFeatureNameFromManifest(esa, shortNameMap);
            }
            catch (IOException e) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_ESA_NOT_FOUND", esa.getAbsolutePath()));
            }
            SingleFileRepositoryConnection mySingleFileRepo = null;
            if (singleJson.exists()) {
                mySingleFileRepo = new SingleFileRepositoryConnection(singleJson);
            } else {
                try {
                    mySingleFileRepo = SingleFileRepositoryConnection.createEmptyRepository((File)singleJson);
                }
                catch (IOException e) {
                    throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_SINGLE_REPO_CONNECTION_FAILED", singleJson.toString(), esa.getAbsolutePath()));
                }
            }
            EsaParser parser = new EsaParser(true);
            RepositoryResourceWritable resource = parser.parseFileToResource(esa, null, null);
            resource.updateGeneratedFields(true);
            resource.setRepositoryConnection((RepositoryConnection)mySingleFileRepo);
            Map fileToGroupIdMap = (Map)this.data.get(GENERATE_JSON_GROUP_ID_MAP);
            if (fileToGroupIdMap != null) {
                resource.setMavenCoordinates(ArtifactDownloaderUtils.getMavenCoordFromPath(esa.getAbsolutePath(), (String)fileToGroupIdMap.get(esa)));
            }
            resource.uploadToMassive((UploadStrategy)new AddThenDeleteStrategy());
        }
        return singleJson;
    }

    private Collection<File> downloadEsas() {
        String fromRepo = this.getDownloadDir((String)this.data.get("from.repo"));
        File rootDir = new File(fromRepo);
        List resolvedFeatures = (List)this.data.get("download.artifact.list");
        Map<String, List> artifactsMap = this.fetchArtifactsFromLocalRepository(rootDir, resolvedFeatures, ".esa");
        List foundFeatures = artifactsMap.get("foundArtifacts");
        List missingFeatures = artifactsMap.get("missingArtifacts");
        List missingSignatures = artifactsMap.get("missingSignatures");
        if (foundFeatures.size() != resolvedFeatures.size() && !missingFeatures.isEmpty() || !missingSignatures.isEmpty()) {
            List missingFeatureIndexes = artifactsMap.get("missingArtifactIndexes");
            List<File> downloadedFeatures = this.downloadFeatures(missingFeatures, missingSignatures);
            if (downloadedFeatures == null) {
                return null;
            }
            this.insertElementsIntoList(foundFeatures, downloadedFeatures, missingFeatureIndexes);
            double increment = this.progressBar.getMethodIncrement("fetchArtifacts") / (double)resolvedFeatures.size() * (double)downloadedFeatures.size();
            this.updateProgress(increment);
            this.fine("Downloaded the following features from the remote maven repository:" + downloadedFeatures);
        } else {
            this.data.put("cleanup.needed", false);
        }
        return foundFeatures;
    }

    private Map<String, List> fetchArtifactsFromLocalRepository(File rootDir, Collection<String> artifacts, String extension) {
        ArrayList<File> foundArtifacts = new ArrayList<File>();
        ArrayList<String> artifactsClone = new ArrayList<String>(artifacts);
        ArrayList<Integer> missingArtifactIndexes = new ArrayList<Integer>();
        ArrayList<String> missingSignatures = new ArrayList<String>();
        String sigExtension = ".asc";
        int index = 0;
        double increment = this.progressBar.getMethodIncrement("fetchArtifacts") / (double)artifacts.size();
        InstallConstants.VerifyOption verify = (InstallConstants.VerifyOption)((Object)this.data.get("verify.option"));
        for (String artifact : artifacts) {
            Path artifactPath;
            this.fine("Processing artifact: " + artifact);
            Path signaturePath = null;
            if (this.isValidEsa(artifact)) {
                artifactPath = Paths.get(artifact, new String[0]);
            } else {
                String[] coord = artifact.split(":");
                String groupId = coord[0];
                String artifactName = coord[1];
                String version = coord[2];
                File groupDir = new File(rootDir, groupId.replace(".", "/"));
                if (!groupDir.exists()) {
                    missingArtifactIndexes.add(index);
                    ++index;
                    continue;
                }
                String artifactFileName = artifactName + "-" + version + extension;
                artifactPath = Paths.get(groupDir.getAbsolutePath().toString(), artifactName, version, artifactFileName);
                if (verify != null) {
                    String signatureFileName = artifactFileName + sigExtension;
                    signaturePath = Paths.get(groupDir.getAbsolutePath().toString(), artifactName, version, signatureFileName);
                }
            }
            if (Files.isRegularFile(artifactPath, new LinkOption[0])) {
                this.fine("Found Artifact at path: " + artifactPath.toString());
                foundArtifacts.add(artifactPath.toFile());
                artifactsClone.remove(artifact);
                if (verify != null && verify != InstallConstants.VerifyOption.skip && signaturePath != null) {
                    if (Files.isRegularFile(signaturePath, new LinkOption[0])) {
                        this.fine("Found signature at path: " + signaturePath.toString());
                    } else {
                        missingSignatures.add(artifact);
                    }
                }
                this.updateProgress(increment);
            } else {
                missingArtifactIndexes.add(index);
            }
            ++index;
        }
        HashMap<String, List> artifactsMap = new HashMap<String, List>();
        artifactsMap.put("foundArtifacts", foundArtifacts);
        artifactsMap.put("missingArtifacts", artifactsClone);
        artifactsMap.put("missingArtifactIndexes", missingArtifactIndexes);
        artifactsMap.put("missingSignatures", missingSignatures);
        return artifactsMap;
    }

    private <T> void insertElementsIntoList(List<T> target, List<T> elements, List<Integer> indexes) {
        int index = 0;
        for (T obj : elements) {
            target.add(indexes.get(index), obj);
            ++index;
        }
    }

    private boolean isValidEsa(String fileName) {
        return ArchiveUtils.ArchiveFileType.ESA.isType(fileName);
    }

    private String getLibertyVersion() {
        if (this.openLibertyVersion != null) {
            return this.openLibertyVersion;
        }
        File propertiesFile = new File(Utils.getInstallDir(), "lib/versions/openliberty.properties");
        String openLibertyVersion = null;
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(propertiesFile);){
            properties.load(input);
            String productId = properties.getProperty("com.ibm.websphere.productId");
            String productVersion = properties.getProperty("com.ibm.websphere.productVersion");
            if (productId.equals("io.openliberty")) {
                openLibertyVersion = productVersion;
            }
        }
        catch (IOException e) {
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
        }
        if (openLibertyVersion == null) {
            InstallException ie = new InstallException("Could not determine the open liberty runtime version.");
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", ie.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(ie));
        }
        this.openLibertyVersion = openLibertyVersion;
        return openLibertyVersion;
    }

    public List<File> getLocalJsonFiles(Set<String> jsonsRequired) throws InstallException {
        String fromRepo = this.getDownloadDir((String)this.data.get("download.location"));
        File fromDir = new File(fromRepo);
        ArrayList<File> jsons = new ArrayList<File>();
        ArrayList<String> foundJsons = new ArrayList<String>();
        for (String jsonCoord : jsonsRequired) {
            String[] coords = jsonCoord.split(":");
            String groupId = coords[0];
            String artifactId = coords[1];
            String version = coords[2];
            String mavenCoordinateDirectory = groupId.replace(".", "/") + "/" + artifactId + "/" + version + "/";
            String jsonFilePath = mavenCoordinateDirectory + "features-" + version + ".json";
            File foundJson = new File(fromDir, jsonFilePath);
            if (!foundJson.exists()) continue;
            jsons.add(foundJson);
            foundJsons.add(jsonCoord);
        }
        this.put(LOCALLY_PRESENT_JSONS, foundJsons);
        return jsons;
    }

    public List<File> getJsonsFromMavenCentral(Set<String> jsonsRequired) throws InstallException {
        ArrayList<File> result = new ArrayList<File>();
        ArrayList<String> jsonsNotFound = new ArrayList<String>();
        this.put(DOWNLOAD_FILETYPE, "json");
        boolean singleArtifactInstall = true;
        this.put("download.individual.artifact", (Object)singleArtifactInstall);
        for (String jsonCoord : jsonsRequired) {
            this.put(DOWNLOAD_ARTIFACT_SINGLE, jsonCoord);
            this.put("download.artifact.list", jsonCoord);
            Object downloaded = this.get("download.result");
            String exceptionMessage = (String)this.get("action.error.message");
            if (exceptionMessage != null && !exceptionMessage.contains("CWWKF1285E")) {
                this.fine("action.exception.stacktrace: " + this.get("action.exception.stacktrace"));
                throw new InstallException(exceptionMessage);
            }
            if (downloaded == null) {
                this.fine("Could not download this json with maven coordinate: " + jsonCoord);
                jsonsNotFound.add(jsonCoord);
                continue;
            }
            if (downloaded instanceof List) {
                if (((List)downloaded).isEmpty()) {
                    jsonsNotFound.add(jsonCoord);
                    continue;
                }
                result.addAll((List)downloaded);
                continue;
            }
            if (!(downloaded instanceof File)) continue;
            if (!((File)downloaded).exists()) {
                jsonsNotFound.add(jsonCoord);
                continue;
            }
            result.add((File)downloaded);
        }
        this.fine("Downloaded the following json files from remote: " + result);
        if (!jsonsNotFound.isEmpty()) {
            InstallException ie = new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ERROR_FAILED_TO_LOCATE_AND_DOWNLOAD_JSONS", jsonsNotFound));
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", ie.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(ie));
        }
        return result;
    }

    private Map<String, Object> getEnvMap() {
        String proxyEnvVarHttps;
        HashMap<String, Object> envMapRet = new HashMap<String, Object>();
        String proxyEnvVarHttp = System.getenv("http_proxy");
        if (proxyEnvVarHttp != null) {
            Map<String, String> httpProxyVariables;
            try {
                httpProxyVariables = this.getProxyVariables(proxyEnvVarHttp, "http");
            }
            catch (InstallException e) {
                this.data.put("action.result", ERROR);
                this.data.put("action.error.message", e.getMessage());
                this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
                return null;
            }
            Set<String> httpProxyVarKeys = httpProxyVariables.keySet();
            for (String string : httpProxyVarKeys) {
                envMapRet.put(string, httpProxyVariables.get(string));
            }
        }
        if ((proxyEnvVarHttps = System.getenv("https_proxy")) != null) {
            Map<String, String> httpsProxyVariables;
            try {
                httpsProxyVariables = this.getProxyVariables(proxyEnvVarHttps, "https");
            }
            catch (InstallException e) {
                this.data.put("action.result", ERROR);
                this.data.put("action.error.message", e.getMessage());
                this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
                return null;
            }
            Set<String> httpsProxyVarKeys = httpsProxyVariables.keySet();
            for (String string : httpsProxyVarKeys) {
                envMapRet.put(string, httpsProxyVariables.get(string));
            }
        }
        if (System.getProperty("featureUtility.beta") != null && System.getProperty("featureUtility.beta").equals("true")) {
            envMapRet.put("http.nonProxyHosts", System.getenv("no_proxy"));
        }
        envMapRet.put("FEATURE_REPO_URL", System.getenv("FEATURE_REPO_URL"));
        envMapRet.put("FEATURE_REPO_USER", System.getenv("FEATURE_REPO_USER"));
        envMapRet.put("FEATURE_REPO_PASSWORD", System.getenv("FEATURE_REPO_PASSWORD"));
        ArrayList<MavenRepository> repos = new ArrayList<MavenRepository>();
        if (System.getenv("FEATURE_REPO_URL") != null) {
            repos.add(new MavenRepository("Environment Variables Repo", System.getenv("FEATURE_REPO_URL"), System.getenv("FEATURE_REPO_USER"), System.getenv("FEATURE_REPO_PASSWORD")));
        }
        envMapRet.put("FEATURE_UTILITY_MAVEN_REPOSITORIES", repos);
        envMapRet.put("FEATURE_LOCAL_REPO", System.getenv("FEATURE_LOCAL_REPO"));
        envMapRet.put("FEATURE_VERIFY", System.getenv("FEATURE_VERIFY"));
        Map<String, String> propsFileMap = this.getFeatureUtilEnvProps();
        if (!propsFileMap.isEmpty()) {
            this.fine("The properties found in featureUtility.env will override latent environment variables of the same name");
            this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_READING_ENV_PROPS_FILE", Utils.getInstallDir().toString()));
            Set<String> set = propsFileMap.keySet();
            for (String key : set) {
                if (key.equals("http_proxy") || key.equals("https_proxy")) {
                    Map<String, String> proxyVar;
                    try {
                        proxyVar = this.getProxyVariables(propsFileMap.get(key), key.split("_")[0]);
                    }
                    catch (InstallException e) {
                        this.data.put("action.result", ERROR);
                        this.data.put("action.error.message", e.getMessage());
                        this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
                        return null;
                    }
                    Set<String> proxyVarKeys = proxyVar.keySet();
                    for (String k : proxyVarKeys) {
                        envMapRet.put(k, proxyVar.get(k));
                    }
                    continue;
                }
                envMapRet.put(key, propsFileMap.get(key));
            }
            if (propsFileMap.containsKey("FEATURE_LOCAL_REPO")) {
                envMapRet.put("FEATURE_LOCAL_REPO", propsFileMap.get("FEATURE_LOCAL_REPO"));
            }
            String string = propsFileMap.get("FEATURE_REPO_URL");
            String user = propsFileMap.get("FEATURE_REPO_USER");
            String pass = propsFileMap.get("FEATURE_REPO_PASSWORD");
            if (string != null) {
                MavenRepository repo = new MavenRepository("featureUtility.env repo", string, user, pass);
                repos = new ArrayList();
                repos.add(repo);
                envMapRet.put("FEATURE_UTILITY_MAVEN_REPOSITORIES", repos);
            }
        }
        return envMapRet;
    }

    private Map<String, String> getProxyVariables(String proxyEnvVar, String protocol) throws InstallException {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] proxyEnvVarSplit = proxyEnvVar.split("@");
        if (proxyEnvVarSplit.length != 1 && proxyEnvVarSplit.length != 2) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_IMPROPER_" + protocol.toUpperCase() + "PROXY_FORMAT", proxyEnvVar));
        }
        if (proxyEnvVarSplit.length == 1) {
            String[] proxyHttpSplit = proxyEnvVar.split(":");
            if (proxyHttpSplit.length != 3) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_IMPROPER_" + protocol.toUpperCase() + "PROXY_FORMAT", proxyEnvVar));
            }
            result.put(protocol + ".proxyHost", proxyHttpSplit[1].replace("/", ""));
            result.put(protocol + ".proxyPort", proxyHttpSplit[2]);
        } else {
            String[] proxyCredentials = proxyEnvVarSplit[0].split(":");
            if (proxyCredentials.length != 3) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_IMPROPER_HTTPSPROXY_FORMAT", proxyEnvVar));
            }
            String[] proxyHostPort = proxyEnvVarSplit[1].split(":");
            if (proxyHostPort.length != 2) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_IMPROPER_HTTPSPROXY_FORMAT", proxyEnvVar));
            }
            result.put(protocol + ".proxyHost", proxyHostPort[0]);
            result.put(protocol + ".proxyPort", proxyHostPort[1]);
            result.put(protocol + ".proxyUser", proxyCredentials[1].replace("/", ""));
            result.put(protocol + ".proxyPassword", proxyCredentials[2]);
        }
        return result;
    }

    private Map<String, String> getFeatureUtilEnvProps() {
        File featureUtilEnvFile = new File(ETC_DIRECTORY + FEATURE_UTILITY_PROPS_FILE);
        HashMap<String, String> propEnvMap = new HashMap<String, String>();
        try {
            Scanner scanner = new Scanner(featureUtilEnvFile);
            this.fine("featureUtility.env exists");
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                String[] splitLine = line.split("=");
                propEnvMap.put(splitLine[0], splitLine[1]);
            }
            scanner.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return propEnvMap;
    }

    private void updateProgress(double increment) {
        this.progressBar.updateProgress(increment);
    }

    private void info(String msg) {
        this.logger.info(msg);
    }

    private void fine(String msg) {
        this.logger.fine(msg);
    }

    private void severe(String msg) {
        this.logger.severe(msg);
    }

    private void upgradeOL(File websphereJson) throws InstallException {
        String downloadDir;
        List featureList = (List)this.data.get("features.to.resolve");
        String fromRepo = this.getDownloadDir((String)this.data.get("from.repo"));
        File rootDir = new File(fromRepo);
        String licenseCoord = this.getLicenseToUpgrade(fromRepo, featureList, websphereJson);
        this.fine("licenseCoord to upgrade to: " + licenseCoord);
        ArrayList<String> upgradeFileObjects = new ArrayList<String>();
        upgradeFileObjects.add(licenseCoord);
        Map<String, List> artifactsMap = this.fetchArtifactsFromLocalRepository(rootDir, upgradeFileObjects, ".zip");
        this.fine("missing license files: " + artifactsMap.get("missingArtifacts").toString());
        this.fine("found license files: " + artifactsMap.get("foundArtifacts").toString());
        if (!artifactsMap.get("missingArtifacts").isEmpty()) {
            this.put(DOWNLOAD_ARTIFACT_SINGLE, licenseCoord);
            this.put(DOWNLOAD_FILETYPE, "zip");
            this.downloadArtifact();
        } else {
            this.data.put("cleanup.needed", false);
        }
        Boolean cleanupNeeded = (Boolean)this.data.get("cleanup.needed");
        if (cleanupNeeded != null && cleanupNeeded.booleanValue()) {
            this.fine("Using temp location: " + this.TEMP_DIRECTORY);
            this.data.put("cleanup.temp.location", this.TEMP_DIRECTORY);
            downloadDir = this.TEMP_DIRECTORY;
        } else {
            downloadDir = this.getDownloadDir((String)this.data.get("download.location"));
        }
        try {
            this.unpackLicenseObject(downloadDir, licenseCoord, WLP_DIR);
        }
        catch (IOException e) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ERROR_FAILED_TO_UNPACK_LICENSE", licenseCoord, downloadDir.toString()));
        }
    }

    private String getLicenseToUpgrade(String fromRepo, List<String> featureList, File websphereJson) throws InstallException {
        String result = null;
        String baseLicenseCoord = "com.ibm.websphere.appserver.features:wlp-base-license:" + this.openLibertyVersion;
        String NDLicenseCoord = "com.ibm.websphere.appserver.features:wlp-nd-license:" + this.openLibertyVersion;
        Set<String> minimalApplicableLicenses = this.getMinLicenses(fromRepo, featureList, baseLicenseCoord, websphereJson);
        this.fine("featurelist: " + featureList.toString());
        this.fine("minlicenses: " + minimalApplicableLicenses.toString());
        result = this.containsStr(NDLicenseCoord, minimalApplicableLicenses) ? NDLicenseCoord : baseLicenseCoord;
        return result;
    }

    private Set<String> getMinLicenses(String fromRepo, List<String> featureList, String defaultLicense, File websphereJson) throws InstallException {
        this.fine("parsing websphere json for minimal license coordinates");
        String baseLicenseCoord = "com.ibm.websphere.appserver.features:wlp-base-license:" + this.openLibertyVersion;
        String NDLicenseCoord = "com.ibm.websphere.appserver.features:wlp-nd-license:" + this.openLibertyVersion;
        boolean isND = false;
        HashSet<String> result = new HashSet<String>();
        ArrayList<String> causedUpgradeND = new ArrayList<String>();
        ArrayList<String> causedUpgradeBASE = new ArrayList<String>();
        try (JsonReader reader = Json.createReader((InputStream)new FileInputStream(websphereJson));){
            JsonArray assetList = reader.readArray();
            for (JsonValue val : assetList) {
                if (val.getValueType() != JsonValue.ValueType.OBJECT) continue;
                JsonObject featureObject = (JsonObject)val;
                JsonObject wlpFeatureInfo = featureObject.getJsonObject("wlpInformation");
                String lowerCaseShortName = wlpFeatureInfo.getString("lowerCaseShortName", null);
                String name = featureObject.getString("name", null);
                String licenseMavenCoordinate = wlpFeatureInfo.getString("licenseMavenCoordinate", defaultLicense);
                if (lowerCaseShortName != null && this.containsStr(lowerCaseShortName, featureList)) {
                    if (licenseMavenCoordinate.contains(NDLicenseCoord)) {
                        causedUpgradeND.add(lowerCaseShortName);
                        isND = true;
                    } else {
                        causedUpgradeBASE.add(lowerCaseShortName);
                    }
                    result.add(licenseMavenCoordinate);
                    continue;
                }
                if (name == null || !this.containsStr(name, featureList)) continue;
                result.add(licenseMavenCoordinate);
            }
        }
        catch (FileNotFoundException e) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ERROR_MAVEN_JSON_NOT_FOUND", "com.ibm.websphere.appserver.features"));
        }
        if (isND) {
            this.data.put("caused.upgrade", causedUpgradeND);
        } else {
            this.data.put("caused.upgrade", causedUpgradeBASE);
        }
        return result;
    }

    private boolean containsStr(String str, Collection<String> cl) {
        for (String s : cl) {
            if (!s.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackLicenseObject(String downloadDir, String licenseCoord, String targetDir) throws IOException {
        String groupId = ArtifactDownloaderUtils.getGroupId(licenseCoord).replace(".", "/") + "/";
        String artifactId = ArtifactDownloaderUtils.getartifactId(licenseCoord);
        String version = ArtifactDownloaderUtils.getVersion(licenseCoord);
        if (!downloadDir.endsWith(File.separator)) {
            downloadDir = downloadDir + File.separator;
        }
        String filename = ArtifactDownloaderUtils.getfilename(licenseCoord) + ".zip";
        File zipFile = new File(downloadDir + groupId + artifactId + "/" + version + "/" + filename);
        FileInputStream fis = new FileInputStream(zipFile);
        ZipInputStream zis = new ZipInputStream(fis);
        try {
            ZipEntry ze = zis.getNextEntry();
            byte[] buf = new byte[2048];
            while (ze != null) {
                if (ze.isDirectory()) {
                    File dir = new File(targetDir + ze.getName());
                    dir.mkdirs();
                } else {
                    File unzippedFile = new File(targetDir + ze.getName());
                    this.upgradeFiles.add(unzippedFile);
                    try (FileOutputStream fos = new FileOutputStream(unzippedFile);){
                        int numBytes;
                        while ((numBytes = zis.read(buf)) > 0) {
                            fos.write(buf, 0, numBytes);
                        }
                    }
                }
                ze = zis.getNextEntry();
            }
        }
        finally {
            zis.closeEntry();
            zis.close();
        }
    }

    private boolean cleanupUpgrade() {
        boolean cleanupSuccess = true;
        for (File f : this.upgradeFiles) {
            if (!f.exists()) continue;
            File parent = f.getParentFile();
            if (!f.delete() || !parent.isDirectory()) continue;
            parent.delete();
        }
        return cleanupSuccess;
    }

    private File generateJson() {
        HashMap<String, String> shortNameMap = new HashMap<String, String>();
        File targetJsonDir = (File)this.data.get(TARGET_JSON_DIR);
        File result = null;
        try {
            result = this.generateJsonFromIndividualESAs(targetJsonDir.toPath(), shortNameMap);
        }
        catch (IOException e) {
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
        }
        catch (RepositoryException e) {
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString((Exception)((Object)e)));
        }
        catch (InstallException e) {
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
        }
        return result;
    }

    public File generateJson(File targetJsonDir, List<File> esas) throws IOException, RepositoryException, InstallException {
        HashMap<String, String> shortNameMap = new HashMap<String, String>();
        File result = this.generateJsonFromESAList(targetJsonDir.toPath(), shortNameMap, esas);
        return result;
    }

    private List<File> downloadPublicKeys() {
        VerifySignatureUtility verifyUtility = new VerifySignatureUtility();
        InstallConstants.VerifyOption verify = (InstallConstants.VerifyOption)((Object)this.data.get("verify.option"));
        Collection usrkeys = (Collection)this.data.get("user.public.keys");
        try {
            this.pubKeys = verifyUtility.downloadPublicKeys(usrkeys, verify, this.envMap);
        }
        catch (InstallException e) {
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
        }
        return this.pubKeys;
    }

    private Integer verifySignatures() {
        InstallConstants.VerifyOption verifyOption = (InstallConstants.VerifyOption)((Object)this.data.get("verify.option"));
        ArrayList<File> failedFeatures = new ArrayList<File>();
        try {
            VerifySignatureUtility verifyUtility = new VerifySignatureUtility();
            verifyUtility.verifySignatures((List)this.data.get("action.verify"), this.pubKeys, failedFeatures);
            if (failedFeatures.isEmpty()) {
                this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("TOOL_FEATURES_VERIFICATION_COMPLETED", new Object[0]));
                this.actionType = ActionType.install;
                return OK;
            }
            if (verifyOption == InstallConstants.VerifyOption.all) {
                this.data.put("action.result", ERROR);
                this.data.put("action.error.message", InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ERROR_FAILED_TO_VERIFY_FEATURE_SIGNATURE", failedFeatures));
                return ERROR;
            }
            if (verifyOption == InstallConstants.VerifyOption.enforce) {
                boolean libertyFeatureFailure = false;
                for (File f : failedFeatures) {
                    if (this.usrFeatures.contains(f.getName().toLowerCase()) || this.usrFeatures.contains(f.getAbsolutePath())) continue;
                    libertyFeatureFailure = true;
                }
                if (libertyFeatureFailure) {
                    this.data.put("action.result", ERROR);
                    this.data.put("action.error.message", InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ERROR_FAILED_TO_VERIFY_FEATURE_SIGNATURE", failedFeatures));
                    return ERROR;
                }
            } else {
                this.logger.warning(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ERROR_FAILED_TO_VERIFY_FEATURE_SIGNATURE", failedFeatures));
            }
            this.actionType = ActionType.install;
            return OK;
        }
        catch (InstallException e) {
            this.data.put("action.result", ERROR);
            this.data.put("action.error.message", e.getMessage());
            this.data.put("action.exception.stacktrace", ExceptionUtils.stacktraceToString(e));
            return OK;
        }
    }

    private static enum ActionType {
        install,
        uninstall,
        resolve,
        find,
        verify;

    }
}

