/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConfigHolder {
    private static final TraceComponent tc = Tr.register(ConfigHolder.class, null, null);
    private static boolean debug = ConfigHolder.getDebugEnabled();
    private static volatile Map<String, Map<String, Object>> configInfo = new HashMap<String, Map<String, Object>>();
    private static volatile Map<String, String> nameMap = new HashMap<String, String>();
    private static volatile Map<String, Map<String, Object>> resolvedConfigInfoCacheByName = new HashMap<String, Map<String, Object>>();
    private static volatile boolean configExists = false;
    static final long serialVersionUID = -7611777207357023832L;

    public static synchronized void addConfig(String id, String name, Map<String, Object> params) {
        if (ConfigHolder.getDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addConfig addConfig is id: " + id + " name = " + name + " params : " + params), (Object[])new Object[0]);
        }
        nameMap.put(id, name);
        if (name != null) {
            configInfo.put(name, params);
        }
        resolvedConfigInfoCacheByName.clear();
    }

    public static synchronized void removeConfig(String objectId) {
        String serviceName;
        if (ConfigHolder.getDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addConfig removeConfig is objectId: " + objectId), (Object[])new Object[0]);
        }
        if ((serviceName = nameMap.get(objectId)) != null) {
            configInfo.remove(serviceName);
        }
        nameMap.remove(objectId);
        resolvedConfigInfoCacheByName.clear();
    }

    public static Object getEnableSchemaValidation(String name) {
        Map<String, Object> props = ConfigHolder.getNameProps(name);
        if (props != null) {
            Object enableSchemaValidation = props.get("enableSchemaValidation");
            if (ConfigHolder.getDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getEnableSchemaValidation is returning: " + enableSchemaValidation), (Object[])new Object[0]);
            }
            return enableSchemaValidation;
        }
        if (ConfigHolder.getDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getEnableSchemaValidation is returning null because no properties exist for name - " + name), (Object[])new Object[0]);
        }
        return null;
    }

    public static Object getIgnoreUnexpectedElements(String name) {
        Map<String, Object> props = ConfigHolder.getNameProps(name);
        if (props != null) {
            Object ignoreUnexpectedElements = props.get("ignoreUnexpectedElements");
            if (ConfigHolder.getDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getIgnoreUnexpectedElements is returning: " + ignoreUnexpectedElements), (Object[])new Object[0]);
            }
            return ignoreUnexpectedElements;
        }
        if (ConfigHolder.getDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getIgnoreUnexpectedElements is returning null because no properties exist for name - " + name), (Object[])new Object[0]);
        }
        return null;
    }

    public static Object getEnableDefaultValidation(String name) {
        Map<String, Object> props = ConfigHolder.getNameProps(name);
        if (props != null) {
            Object enableDefaultValidation = props.get("enableDefaultValidation");
            if (ConfigHolder.getDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getEnableDefaultValidation is returning: " + enableDefaultValidation), (Object[])new Object[0]);
            }
            return enableDefaultValidation;
        }
        if (ConfigHolder.getDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getEnableDefaultValidation is returning null because no properties exist for name - " + name), (Object[])new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getNameProps(String name) {
        boolean debug = ConfigHolder.getDebugEnabled();
        if (configInfo.isEmpty()) {
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)"configInfo is empty, returning null", (Object[])new Object[0]);
            }
            return null;
        }
        if (name != null) {
            Map<String, Map<String, Object>> map = resolvedConfigInfoCacheByName;
            synchronized (map) {
                Map<String, Object> props = resolvedConfigInfoCacheByName.get(name);
                if (props != null) {
                    if (debug) {
                        Tr.debug((TraceComponent)tc, (String)("resolvedConfigInfoCacheByName cache hit, name: " + name + " props: " + props), (Object[])new Object[0]);
                    }
                    return props.isEmpty() ? null : props;
                }
            }
        }
        HashMap<String, Object> mergedProps = new HashMap<String, Object>();
        if (debug) {
            Tr.debug((TraceComponent)tc, (String)("begin name search - configInfo = " + configInfo), (Object[])new Object[0]);
        }
        String foundName = "";
        Class<ConfigHolder> clazz = ConfigHolder.class;
        synchronized (ConfigHolder.class) {
            for (String key : configInfo.keySet()) {
                Map<String, Object> props;
                if (key.equals(name)) {
                    if (debug) {
                        Tr.debug((TraceComponent)tc, (String)("key found - " + key + " adding associated props"), (Object[])new Object[0]);
                    }
                    props = configInfo.get(key);
                    mergedProps.putAll(props);
                    foundName = key;
                    continue;
                }
                if (!key.equals("default")) continue;
                if (debug) {
                    Tr.debug((TraceComponent)tc, (String)("default found - " + key + " adding default props"), (Object[])new Object[0]);
                }
                props = configInfo.get(key);
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    String propsKey = entry.getKey();
                    Object propsValue = entry.getValue();
                    mergedProps.putIfAbsent(propsKey, propsValue);
                    if (!debug) continue;
                    Tr.debug((TraceComponent)tc, (String)("default prop to be added if absent - propsKey " + propsKey + " propsValue " + propsValue), (Object[])new Object[0]);
                }
                if (!foundName.isEmpty()) continue;
                foundName = key;
            }
            if (foundName.contains(name)) {
                resolvedConfigInfoCacheByName.put(name, mergedProps);
            } else if (foundName.contains("default")) {
                resolvedConfigInfoCacheByName.put("default", mergedProps);
            } else {
                if (debug) {
                    Tr.debug((TraceComponent)tc, (String)("No properties found for: " + name), (Object[])new Object[0]);
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return null;
            }
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)("getNameProps final result for name: " + name + " values: " + mergedProps), (Object[])new Object[0]);
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return mergedProps;
        }
    }

    private static boolean getDebugEnabled() {
        return tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled();
    }

    public static boolean checkConfig(Map<String, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"properties are null or empty returning", (Object[])new Object[0]);
            }
            configExists = false;
        } else {
            configExists = true;
        }
        return configExists;
    }

    public static boolean isConfigExists() {
        return configExists;
    }
}

