/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.support;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataSlotService;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.container.service.metadata.extended.ModuleMetaDataExtender;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.metadata.JaxWsModuleInfo;
import com.ibm.ws.jaxws.metadata.JaxWsModuleMetaData;
import com.ibm.ws.jaxws.metadata.JaxWsModuleType;
import com.ibm.ws.jaxws.metadata.builder.JaxWsModuleInfoBuilder;
import com.ibm.ws.jaxws.support.JaxWsMetaDataManager;
import com.ibm.ws.jaxws.utils.JaxWsUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxWsModuleMetaDataListener
implements ModuleMetaDataListener,
ModuleMetaDataExtender {
    private static final TraceComponent tc = Tr.register(JaxWsModuleMetaDataListener.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
    private final Map<JaxWsModuleType, JaxWsModuleInfoBuilder> jaxWsModuleInfoBuilderMap = new ConcurrentHashMap<JaxWsModuleType, JaxWsModuleInfoBuilder>();
    private final AtomicServiceReference<ClassLoadingService> classLoadingServiceSR = new AtomicServiceReference("classLoadingService");
    static final long serialVersionUID = -1964005706638347548L;

    /*
     * WARNING - void declaration
     */
    public ExtendedModuleInfo extendModuleMetaData(ExtendedModuleInfo moduleInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("extendModuleMetaData(" + moduleInfo.getName() + ") : " + moduleInfo), (Object[])new Object[0]);
        }
        ModuleMetaData mmd = moduleInfo.getMetaData();
        Container moduleContainer = moduleInfo.getContainer();
        try {
            if (!JaxWsUtils.isEJBModule(moduleContainer) && !JaxWsUtils.isWebModule(moduleContainer)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unsupported Module, no JaxWsModuleMetaData will be created for " + moduleInfo.getName()), (Object[])new Object[0]);
                }
                return null;
            }
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.jaxws.support.JaxWsModuleMetaDataListener", (String)"72", (Object)this, (Object[])new Object[]{moduleInfo});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unsupported Module, no JaxWsModuleMetaData will be created for " + moduleInfo.getName()), (Object[])new Object[0]);
            }
            return null;
        }
        try {
            JaxWsModuleMetaData jaxWsModuleMetaData = this.createJaxWsModuleMetaData(mmd, moduleContainer, moduleInfo.getClassLoader());
            JaxWsModuleInfo jaxWsModuleInfo = this.createJaxWsModuleInfo(moduleContainer);
            for (ModuleMetaData nestedMMD : moduleInfo.getNestedMetaData()) {
                jaxWsModuleMetaData.getEnclosingModuleMetaDatas().add(nestedMMD);
                JaxWsMetaDataManager.setJaxWsModuleMetaData(nestedMMD, jaxWsModuleMetaData);
            }
            JaxWsModuleInfoBuilder jaxWsModuleInfoBuilder = null;
            if (JaxWsUtils.isWebModule(moduleContainer)) {
                jaxWsModuleInfoBuilder = this.jaxWsModuleInfoBuilderMap.get((Object)JaxWsModuleType.WEB);
            } else if (JaxWsUtils.isEJBModule(moduleContainer)) {
                jaxWsModuleInfoBuilder = this.jaxWsModuleInfoBuilderMap.get((Object)JaxWsModuleType.EJB);
            }
            if (jaxWsModuleInfoBuilder != null) {
                return jaxWsModuleInfoBuilder.build(mmd, moduleContainer, jaxWsModuleInfo);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No JaxWsModuleInfoBuilder added to JaxWsModuleMetaDataListener.", (Object[])new Object[0]);
            }
            return null;
        }
        catch (UnableToAdaptException jaxWsModuleMetaData) {
            void e;
            FFDCFilter.processException((Throwable)jaxWsModuleMetaData, (String)"com.ibm.ws.jaxws.support.JaxWsModuleMetaDataListener", (String)"109", (Object)this, (Object[])new Object[]{moduleInfo});
            throw new IllegalStateException((Throwable)e);
        }
    }

    private JaxWsModuleMetaData createJaxWsModuleMetaData(ModuleMetaData mmd, Container moduleContainer, ClassLoader moduleClassLoader) throws UnableToAdaptException {
        NonPersistentCache overlayCache = (NonPersistentCache)moduleContainer.adapt(NonPersistentCache.class);
        JaxWsModuleMetaData jaxWsModuleMetaData = (JaxWsModuleMetaData)overlayCache.getFromCache(JaxWsModuleMetaData.class);
        if (jaxWsModuleMetaData == null) {
            ClassLoader appContextClassLoader = ((ClassLoadingService)this.classLoadingServiceSR.getServiceWithException()).createThreadContextClassLoader(moduleClassLoader);
            jaxWsModuleMetaData = new JaxWsModuleMetaData(mmd, moduleContainer, appContextClassLoader);
            overlayCache.addToCache(JaxWsModuleMetaData.class, (Object)jaxWsModuleMetaData);
        } else {
            jaxWsModuleMetaData.getEnclosingModuleMetaDatas().add(mmd);
        }
        JaxWsMetaDataManager.setJaxWsModuleMetaData(mmd, jaxWsModuleMetaData);
        return jaxWsModuleMetaData;
    }

    private JaxWsModuleInfo createJaxWsModuleInfo(Container moduleContainer) throws UnableToAdaptException {
        NonPersistentCache overlayCache = (NonPersistentCache)moduleContainer.adapt(NonPersistentCache.class);
        JaxWsModuleInfo jaxWsModuleInfo = (JaxWsModuleInfo)overlayCache.getFromCache(JaxWsModuleInfo.class);
        if (jaxWsModuleInfo == null) {
            if (JaxWsUtils.isWebModule(moduleContainer)) {
                jaxWsModuleInfo = new JaxWsModuleInfo(JaxWsModuleType.WEB);
            } else if (JaxWsUtils.isEJBModule(moduleContainer)) {
                jaxWsModuleInfo = new JaxWsModuleInfo(JaxWsModuleType.EJB);
            }
        }
        overlayCache.addToCache(JaxWsModuleInfo.class, (Object)jaxWsModuleInfo);
        return jaxWsModuleInfo;
    }

    public void moduleMetaDataCreated(MetaDataEvent<ModuleMetaData> event) {
    }

    protected void activate(ComponentContext cc) {
        this.classLoadingServiceSR.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        this.classLoadingServiceSR.deactivate(cc);
    }

    public void moduleMetaDataDestroyed(MetaDataEvent<ModuleMetaData> event) {
        JaxWsModuleMetaData moduleMetaData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("moduleMetaDataDestroyed(" + ((ModuleMetaData)event.getMetaData()).getName() + ") : " + event.getMetaData()), (Object[])new Object[0]);
        }
        if ((moduleMetaData = JaxWsMetaDataManager.getJaxWsModuleMetaData((ModuleMetaData)event.getMetaData())) != null) {
            JaxWsMetaDataManager.setJaxWsModuleMetaData((ModuleMetaData)event.getMetaData(), null);
            if (moduleMetaData.getJ2EEName().equals(((ModuleMetaData)event.getMetaData()).getJ2EEName())) {
                moduleMetaData.destroy();
                ClassLoadingService classLoadingService = (ClassLoadingService)this.classLoadingServiceSR.getService();
                if (classLoadingService != null) {
                    classLoadingService.destroyThreadContextClassLoader(moduleMetaData.getAppContextClassLoader());
                }
            }
        }
    }

    public void setMetaDataSlotService(MetaDataSlotService slotService) {
        JaxWsMetaDataManager.jaxwsApplicationSlot = slotService.reserveMetaDataSlot(ApplicationMetaData.class);
        JaxWsMetaDataManager.jaxwsModuleSlot = slotService.reserveMetaDataSlot(ModuleMetaData.class);
        JaxWsMetaDataManager.jaxwsComponentSlot = slotService.reserveMetaDataSlot(ComponentMetaData.class);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setMetaDataSlotService : applicationSlot=" + JaxWsMetaDataManager.jaxwsApplicationSlot), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("setMetaDataSlotService : moduleSlot=" + JaxWsMetaDataManager.jaxwsModuleSlot), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("setMetaDataSlotService : componentSlot=" + JaxWsMetaDataManager.jaxwsComponentSlot), (Object[])new Object[0]);
        }
    }

    public void unsetMetaDataSlotService(MetaDataSlotService slotService) {
        JaxWsMetaDataManager.jaxwsApplicationSlot = null;
        JaxWsMetaDataManager.jaxwsModuleSlot = null;
        JaxWsMetaDataManager.jaxwsComponentSlot = null;
    }

    public void registerJaxWsModuleInfoBuilder(JaxWsModuleInfoBuilder jaxWsModuleInfoBuilder) {
        this.jaxWsModuleInfoBuilderMap.put(jaxWsModuleInfoBuilder.getSupportType(), jaxWsModuleInfoBuilder);
    }

    public void unregisterJaxWsModuleInfoBuilder(JaxWsModuleInfoBuilder jaxWsModuleInfoBuilder) {
        this.jaxWsModuleInfoBuilderMap.remove((Object)jaxWsModuleInfoBuilder.getSupportType());
    }

    protected void setClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingServiceSR.setReference(ref);
    }

    protected void unsetClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingServiceSR.unsetReference(ref);
    }
}

