/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.threading;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.wsspi.threading.WSExecutorService;
import java.security.AccessController;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.workqueue.AutomaticWorkQueue;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyJaxWsAutomaticWorkQueueImpl
implements AutomaticWorkQueue {
    private static final TraceComponent tc = Tr.register(LibertyJaxWsAutomaticWorkQueueImpl.class, null, null);
    private static final ThreadContextAccessor THREAD_CONTEXT_ACCESSOR = (ThreadContextAccessor)AccessController.doPrivileged(ThreadContextAccessor.getPrivilegedAction());
    private static final ComponentMetaDataAccessorImpl cmdAccessor = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
    private final ScheduledExecutorService scheduleExecutor;
    private final WSExecutorService wsExecutorService;
    private final String name;
    static final long serialVersionUID = 4818025900633206525L;

    public LibertyJaxWsAutomaticWorkQueueImpl(ScheduledExecutorService scheduleExecutor, WSExecutorService executor) {
        this.name = "default";
        this.wsExecutorService = executor;
        this.scheduleExecutor = scheduleExecutor;
    }

    public void execute(Runnable work, long timeout) {
        this.wsExecutorService.executeGlobal((Runnable)new LibertyJaxWsWorker(work));
    }

    public void schedule(Runnable work, long delay) {
        this.scheduleExecutor.schedule(new LibertyJaxWsWorker(work), delay, TimeUnit.MILLISECONDS);
    }

    public void execute(Runnable work) {
        this.wsExecutorService.executeGlobal((Runnable)new LibertyJaxWsWorker(work));
    }

    public String getName() {
        return this.name;
    }

    public boolean isShutdown() {
        return false;
    }

    public void shutdown(boolean processRemainingWorkItems) {
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class LibertyJaxWsWorker
    implements Runnable {
        private final Runnable work;
        private final ClassLoader appContextClassLoader;
        private ComponentMetaData cmd;
        static final long serialVersionUID = 6682814605127838023L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public LibertyJaxWsWorker(Runnable work) {
            this.work = work;
            this.appContextClassLoader = THREAD_CONTEXT_ACCESSOR.getContextClassLoader(Thread.currentThread());
            this.cmd = cmdAccessor.getComponentMetaData();
        }

        @Override
        public void run() {
            ClassLoader oClsLoader = THREAD_CONTEXT_ACCESSOR.getContextClassLoader(Thread.currentThread());
            try {
                THREAD_CONTEXT_ACCESSOR.setContextClassLoader(Thread.currentThread(), this.appContextClassLoader);
                if (this.cmd != null) {
                    cmdAccessor.beginContext(this.cmd);
                }
                this.work.run();
            }
            finally {
                if (this.cmd != null) {
                    cmdAccessor.endContext();
                }
                THREAD_CONTEXT_ACCESSOR.setContextClassLoader(Thread.currentThread(), oClsLoader);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.threading.LibertyJaxWsAutomaticWorkQueueImpl$LibertyJaxWsWorker", LibertyJaxWsWorker.class, null, null);
        }
    }
}

