/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.tools;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;

public class WsToolsUtils {
    public static String getJarFileOfClass(final Class<?> javaClass) {
        ProtectionDomain protectionDomain = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return javaClass.getProtectionDomain();
            }
        });
        String path = protectionDomain.getCodeSource().getLocation().getPath();
        if (WsToolsUtils.isWindows()) {
            path = path.substring(1);
        }
        return path;
    }

    private static boolean isWindows() {
        String OS = System.getProperty("os.name").toLowerCase();
        return OS.contains("win");
    }

    public static int getMajorJavaVersion() {
        String version = System.getProperty("java.version");
        String[] versionElements = version.split("\\D");
        int i = Integer.valueOf(versionElements[0]) == 1 ? 1 : 0;
        return Integer.valueOf(versionElements[i]);
    }

    public static boolean isTargetRequired(String[] args) {
        boolean helpExisted = false;
        boolean versionExisted = false;
        boolean targetExisted = false;
        for (String arg : args) {
            if (arg.equals("-help")) {
                helpExisted = true;
                continue;
            }
            if (arg.equals("-version")) {
                versionExisted = true;
                continue;
            }
            if (!arg.equals("-target")) continue;
            targetExisted = true;
        }
        return args.length > 0 && !helpExisted && !versionExisted && !targetExisted;
    }
}

