/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.netty.internal.tcp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.group.ChannelGroup;
import io.openliberty.netty.internal.BootstrapConfiguration;
import io.openliberty.netty.internal.ChannelInitializerWrapper;
import io.openliberty.netty.internal.impl.NettyFrameworkImpl;
import io.openliberty.netty.internal.tcp.AccessListHandler;
import io.openliberty.netty.internal.tcp.InactivityTimeoutHandler;
import io.openliberty.netty.internal.tcp.MaxOpenConnectionsHandler;
import io.openliberty.netty.internal.tcp.TCPConfigurationImpl;
import io.openliberty.netty.internal.tcp.TCPLoggingHandler;
import io.openliberty.netty.internal.tcp.TCPUtils;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TCPChannelInitializerImpl
extends ChannelInitializerWrapper {
    protected static final TraceComponent tc = Tr.register(TCPChannelInitializerImpl.class, (String[])new String[]{"TCPChannel", "Netty"}, (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages", (String)TCPChannelInitializerImpl.class.getName());
    TCPConfigurationImpl config;
    NettyFrameworkImpl bundle;
    static final long serialVersionUID = 7985925508395963745L;

    public TCPChannelInitializerImpl(BootstrapConfiguration config, NettyFrameworkImpl bundle) {
        this.bundle = bundle;
        this.config = (TCPConfigurationImpl)config;
    }

    protected void initChannel(Channel channel) throws Exception {
        if (this.bundle.isStopping()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Tried to start channel: " + channel + " while framework was shutting down. " + this.bundle), (Object[])new Object[0]);
            }
            channel.close();
            return;
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            channel.pipeline().addFirst("tcpLoggingHandler", (ChannelHandler)new TCPLoggingHandler());
        }
        if (this.config.getInactivityTimeout() > 0) {
            channel.pipeline().addLast("inactivityTimeoutHandler", (ChannelHandler)new InactivityTimeoutHandler(0L, 0L, this.config.getInactivityTimeout(), TimeUnit.MILLISECONDS));
        }
        MaxOpenConnectionsHandler maxHandler = new MaxOpenConnectionsHandler(this.config.getMaxOpenConnections());
        if (this.config.getAccessLists() != null) {
            AccessListHandler includeHandler = new AccessListHandler(this.config.getAccessLists());
            channel.pipeline().addLast("accessListHandler", (ChannelHandler)includeHandler);
        }
        channel.pipeline().addLast("maxConnectionHandler", (ChannelHandler)maxHandler);
        Channel parent = channel.parent();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Initializing channel: " + channel + " found parent to be: " + parent), (Object[])new Object[0]);
        }
        if (parent != null) {
            ChannelGroup group = this.bundle.getActiveChannelsMap().get(parent);
            channel.closeFuture().addListener(innerFuture -> TCPUtils.logChannelStopped(channel));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found group to be: " + group + " for parent: " + parent), (Object[])new Object[0]);
            }
            if (group != null) {
                group.add((Object)channel);
            }
        }
    }
}

