/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.utils.xml.ra;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jca.utils.metagen.MetatypeGenerator;
import com.ibm.ws.jca.utils.xml.metatype.MetatypeAd;
import com.ibm.ws.jca.utils.xml.ra.RaDescription;
import com.ibm.ws.jca.utils.xml.ra.v10.Ra10ConfigProperty;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpConfigOption;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaConfigProperty;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.LinkedList;
import java.util.List;

@Trivial
@XmlType(propOrder={"description", "name", "type", "default", "ignore", "supportsDynamicUpdates", "confidential"})
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class RaConfigProperty {
    private static final TraceComponent tc = Tr.register(RaConfigProperty.class, (String)"rarInstall", (String)"com.ibm.ws.jca.utils.internal.resources.JcaUtilsMessages");
    @XmlTransient
    public boolean isProcessed = false;
    private List<RaDescription> description = new LinkedList<RaDescription>();
    private String name;
    private String type;
    private String defaultValue;
    private Boolean ignore = null;
    private Boolean supportsDynamicUpdates = null;
    private Boolean confidential = null;
    private String id;
    @XmlTransient
    private String wlp_propertyName;
    @XmlTransient
    private String wlp_default;
    @XmlTransient
    private String wlp_action;
    @XmlTransient
    private String wlp_min;
    @XmlTransient
    private String wlp_max;
    @XmlTransient
    private Boolean wlp_ibmFinal;
    @XmlTransient
    private Boolean wlp_required;
    @XmlTransient
    private String wlp_ibmuiGroup;
    @XmlTransient
    private String wlp_type;
    @XmlTransient
    private List<WlpConfigOption> wlp_options = new LinkedList<WlpConfigOption>();
    @XmlTransient
    private String wlp_dynamicImportPackages;
    @XmlTransient
    private Boolean wlp_disableOptionLabelNLS;
    @XmlTransient
    private String wlp_nlsKey;
    static final long serialVersionUID = 7472244518308463178L;

    public String getNLSKey() {
        return this.wlp_nlsKey;
    }

    public boolean isOptionLabelNLSDisabled() {
        return this.wlp_disableOptionLabelNLS != null ? this.wlp_disableOptionLabelNLS : false;
    }

    public boolean addWlpPropertyToMetatype() {
        if (this.wlp_action == null) {
            return false;
        }
        return this.wlp_action.equals("add");
    }

    public String getWlpAction() {
        return this.wlp_action;
    }

    public String getWlpPropertyName() {
        return this.wlp_propertyName;
    }

    public String getWlpDefault() {
        return this.wlp_default;
    }

    public String getDynamicImportPackages() {
        return this.wlp_dynamicImportPackages;
    }

    public String getMin() {
        return this.wlp_min;
    }

    public String getMax() {
        return this.wlp_max;
    }

    public Boolean getIbmFinal() {
        return this.wlp_ibmFinal;
    }

    public Boolean getRequired() {
        return this.wlp_required;
    }

    public String getIbmuiGroup() {
        return this.wlp_ibmuiGroup;
    }

    public String getWlpType() {
        return this.wlp_type;
    }

    public List<WlpConfigOption> getConfigOptions() {
        return this.wlp_options;
    }

    @XmlElement(name="description")
    public void setDescription(List<RaDescription> description) {
        this.description = description;
    }

    public List<RaDescription> getDescription() {
        return this.description;
    }

    @XmlElement(name="config-property-name", required=true)
    public void setName(String name) {
        this.name = MetatypeGenerator.toCamelCase(name);
    }

    public String getName() {
        return this.name != null ? this.name : this.wlp_propertyName;
    }

    @XmlElement(name="config-property-type", required=true)
    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        if (this.type != null && !MetatypeAd.isTypeClassName(this.type)) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9906.invalid.type", (Object[])new Object[]{this.type, this.name}));
        }
        return this.type;
    }

    @XmlElement(name="config-property-value")
    public void setDefault(String defaultValue) {
        if (defaultValue != null) {
            this.defaultValue = defaultValue.replaceAll("\\,", "\\\\,");
        }
    }

    public String getDefault() {
        return this.defaultValue;
    }

    @XmlElement(name="config-property-ignore")
    public void setIgnore(Boolean ignore) {
        this.ignore = ignore;
    }

    public Boolean getIgnore() {
        if (this.wlp_action != null) {
            return this.wlp_action.equals("ignore");
        }
        return this.ignore;
    }

    @XmlElement(name="config-property-supports-dynamic-updates")
    public void setSupportsDynamicUpdates(Boolean supportsDynamicUpdates) {
        this.supportsDynamicUpdates = supportsDynamicUpdates;
    }

    public Boolean getSupportsDynamicUpdates() {
        return this.supportsDynamicUpdates;
    }

    @XmlElement(name="config-property-confidential")
    public void setConfidential(Boolean confidential) {
        this.confidential = confidential;
    }

    public Boolean getConfidential() {
        return this.confidential;
    }

    public void copyRa10Settings(Ra10ConfigProperty ra10ConfigProperty) {
        this.name = ra10ConfigProperty.getConfigPropertyName();
        this.setType(ra10ConfigProperty.getConfigPropertyType());
        this.defaultValue = ra10ConfigProperty.getConfigPropertyValue();
        if (ra10ConfigProperty.getDescription() != null) {
            RaDescription desc = new RaDescription();
            desc.setValue(ra10ConfigProperty.getDescription());
            this.description.add(desc);
        }
    }

    public void copyRaSettings(RaConfigProperty configProperty) {
        this.description = configProperty.getDescription();
        this.name = configProperty.getName();
        this.type = configProperty.getType();
        this.defaultValue = configProperty.getDefault();
        this.ignore = configProperty.getIgnore();
        this.supportsDynamicUpdates = configProperty.getSupportsDynamicUpdates();
        this.confidential = configProperty.getConfidential();
        this.id = configProperty.getId();
        this.wlp_action = configProperty.getWlpAction();
        this.wlp_default = configProperty.getWlpDefault();
        this.wlp_dynamicImportPackages = configProperty.getDynamicImportPackages();
        this.wlp_ibmFinal = configProperty.getIbmFinal();
        this.wlp_ibmuiGroup = configProperty.getIbmuiGroup();
        this.wlp_max = configProperty.getMax();
        this.wlp_min = configProperty.getMin();
        this.wlp_options = configProperty.getConfigOptions();
        this.wlp_required = configProperty.getRequired();
        this.wlp_type = configProperty.getWlpType();
        this.wlp_disableOptionLabelNLS = configProperty.isOptionLabelNLSDisabled();
        this.wlp_nlsKey = configProperty.getNLSKey();
        this.wlp_propertyName = configProperty.getWlpPropertyName();
    }

    public void copyWlpSettings(WlpRaConfigProperty configProperty) {
        this.wlp_action = configProperty.getWlpAction();
        this.wlp_default = configProperty.getWlpDefault();
        this.wlp_dynamicImportPackages = configProperty.getDynamicImportPackages();
        this.wlp_ibmFinal = configProperty.getIbmFinal();
        this.wlp_ibmuiGroup = configProperty.getIbmuiGroup();
        this.wlp_max = configProperty.getMax();
        this.wlp_min = configProperty.getMin();
        this.wlp_options = configProperty.getConfigOptions();
        this.wlp_required = configProperty.getRequired();
        this.wlp_type = configProperty.getWlpType();
        this.wlp_disableOptionLabelNLS = configProperty.isOptionLabelNLSDisabled();
        this.wlp_nlsKey = configProperty.getNLSKey();
        this.wlp_propertyName = configProperty.getWlpPropertyName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('{');
        if (this.name != null) {
            sb.append("name='").append(this.name).append("' ");
        } else {
            sb.append("wlp_propertyName='").append(this.wlp_propertyName).append("' ");
        }
        if (this.type != null) {
            sb.append("type='").append(this.type).append("' ");
        }
        if (this.wlp_action != null) {
            sb.append("wlp_action='").append(this.wlp_action).append("' ");
        }
        if (this.description != null) {
            sb.append("description='").append(this.description).append("' ");
        }
        if (this.confidential != null) {
            sb.append("confidential='").append(this.confidential).append("' ");
        }
        if (this.ignore != null) {
            sb.append("ignore='").append(this.ignore).append("' ");
        }
        if (this.supportsDynamicUpdates != null) {
            sb.append("supportsDynamicUpdates='").append(this.supportsDynamicUpdates).append("' ");
        }
        if (this.defaultValue != null) {
            sb.append("defaultValue='").append(this.defaultValue).append("' ");
        }
        sb.append("isProcessed='").append(this.isProcessed).append("' ");
        if (this.wlp_min != null) {
            sb.append("wlp_min='").append(this.wlp_min).append("' ");
        }
        if (this.wlp_max != null) {
            sb.append("wlp_max='").append(this.wlp_max).append("' ");
        }
        if (this.wlp_ibmFinal != null) {
            sb.append("wlp_ibmFinal='").append(this.wlp_ibmFinal).append("' ");
        }
        if (this.wlp_required != null) {
            sb.append("wlp_required='").append(this.wlp_required).append("' ");
        }
        if (this.wlp_ibmuiGroup != null) {
            sb.append("wlp_ibmuiGroup='").append(this.wlp_ibmuiGroup).append("' ");
        }
        if (this.wlp_type != null) {
            sb.append("wlp_type='").append(this.wlp_type).append("' ");
        }
        if (this.wlp_default != null) {
            sb.append("wlp_default='").append(this.wlp_default).append("' ");
        }
        if (this.wlp_disableOptionLabelNLS != null) {
            sb.append("wlp_disableOptionLabelNLS='").append(this.wlp_disableOptionLabelNLS).append("' ");
        }
        if (this.wlp_nlsKey != null) {
            sb.append("wlp_nlsKey='").append(this.wlp_nlsKey).append("' ");
        }
        if (!this.wlp_options.isEmpty()) {
            sb.append("wlp_options=[");
            for (int i = 0; i < this.wlp_options.size(); ++i) {
                sb.append(this.wlp_options.get(i));
                if (i + 1 == this.wlp_options.size()) continue;
                sb.append(',');
            }
            sb.append("] ");
        }
        sb.append('}');
        return sb.toString();
    }

    public String getId() {
        return this.id;
    }

    @XmlID
    @XmlAttribute(name="id")
    public void setId(String id) {
        this.id = id;
    }
}

