/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal.statemachine;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.AppMessageHelper;
import com.ibm.ws.app.manager.internal.lifecycle.ServiceReg;
import com.ibm.ws.app.manager.internal.monitor.UpdateTrigger;
import com.ibm.ws.app.manager.internal.statemachine.Action;
import com.ibm.ws.app.manager.internal.statemachine.ResourceCallback;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.application.handler.ApplicationHandler;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.framework.BundleContext;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ResolveFileAction
implements Action,
FileMonitor {
    private static final TraceComponent _tc = Tr.register(ResolveFileAction.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.statemachine.ResolveFileAction");
    private final WsLocationAdmin _locAdmin;
    private final String _configPid;
    private final String _configId;
    private final String _location;
    private final AtomicReference<ResourceCallback> _callback = new AtomicReference();
    private final String _name;
    private final BundleContext _ctx;
    private final ServiceReg<FileMonitor> _mon;
    private final UpdateTrigger _trigger;
    private final AtomicReference<File> _file = new AtomicReference();
    private final AtomicReference<Container> _container = new AtomicReference();
    private final List<String> _filesToMonitor = new ArrayList<String>();
    private final AtomicReference<ApplicationHandler<?>> _handler;
    private final ReentrantLock lock;
    static final long serialVersionUID = 2327928727188796943L;

    public ResolveFileAction(BundleContext ctx, long pollRate, UpdateTrigger trigger, WsLocationAdmin locAdmin, String name, String configPid, String configId, String location, ResourceCallback callback, AtomicReference<ApplicationHandler<?>> handler) {
        this._locAdmin = locAdmin;
        this._configPid = configPid;
        this._configId = configId;
        this._location = location;
        this._callback.set(callback);
        this._name = name;
        this._ctx = ctx;
        this._trigger = trigger;
        this._handler = handler;
        this._mon = new ServiceReg();
        this._mon.setProperties(new Hashtable());
        this._mon.setProperty("service.vendor", "IBM");
        this._mon.setProperty("monitor.interval", pollRate);
        this._mon.setProperty("monitor.recurse", false);
        this._mon.setProperty("monitor.filter", ".*");
        this._mon.setProperty("monitor.includeself", true);
        if (trigger != UpdateTrigger.DISABLED) {
            this._mon.setProperty("monitor.type", trigger == UpdateTrigger.MBEAN ? "external" : "timed");
        }
        this._mon.setProperty("monitor.identification", "com.ibm.ws.kernel.monitor.artifact");
        this.lock = new ReentrantLock();
    }

    private void findFile(boolean complete) {
        ResourceCallback callback;
        String s;
        File f = null;
        Iterator<String> iterator = this._filesToMonitor.iterator();
        while (iterator.hasNext() && !(f = new File(s = iterator.next())).exists()) {
        }
        if (f != null && f.exists()) {
            this._file.set(f);
            callback = this._callback.get();
            if (callback != null) {
                this._container.set(callback.setupContainer(this._configPid, this._configId, f));
                if (this._container.get() != null) {
                    if (!complete) {
                        this._mon.unregister();
                    }
                    if ((callback = (ResourceCallback)this._callback.getAndSet(null)) != null) {
                        callback.successfulCompletion(this._container.get(), this._locAdmin.asResource(f, f.isFile()));
                    } else if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"attempted to reuse callback", (Object[])new Object[0]);
                    }
                } else {
                    AppMessageHelper.get(this._handler.get()).error("APPLICATION_AT_LOCATION_NOT_VALID", this._location, this._name);
                    if (complete) {
                        callback = this._callback.getAndSet(null);
                        if (callback != null) {
                            callback.failedCompletion(null);
                        } else if (_tc.isEventEnabled()) {
                            Tr.event((TraceComponent)_tc, (String)"attempted to reuse callback", (Object[])new Object[0]);
                        }
                    } else {
                        callback = this._callback.get();
                        if (callback != null) {
                            callback.pending();
                        }
                    }
                }
            } else if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"attempted to reuse callback", (Object[])new Object[0]);
            }
        } else if (complete) {
            callback = this._callback.getAndSet(null);
            if (callback != null) {
                AppMessageHelper.get(this._handler.get()).warning("APPLICATION_NOT_FOUND", this._name, this._location);
                callback.failedCompletion(null);
            } else if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"attempted to reuse callback", (Object[])new Object[0]);
            }
        } else {
            callback = this._callback.get();
            if (callback != null) {
                callback.pending();
            }
        }
    }

    @Override
    public void execute(ExecutorService executor) {
        File f = new File(this._locAdmin.resolveString(this._location));
        if (f.isAbsolute()) {
            this.resolve(this._location, this._filesToMonitor);
        } else {
            this.resolve("${server.config.dir}/apps/" + this._location, this._filesToMonitor);
            this.resolve("${shared.app.dir}/" + this._location, this._filesToMonitor);
        }
        this._mon.setProperty("monitor.directories", this._filesToMonitor);
        this._mon.setProperty("monitor.files", this._filesToMonitor);
        this._mon.setProperty("monitor.identification", "com.ibm.ws.kernel.monitor.artifact");
        if (this._trigger == UpdateTrigger.DISABLED) {
            this.findFile(true);
        } else {
            this._mon.register(this._ctx, FileMonitor.class, this);
            if (this._container.get() == null && this._file.get() == null && !FrameworkState.isStopping()) {
                AppMessageHelper.get(this._handler.get()).warning("APPLICATION_NOT_FOUND", this._name, this._location);
            }
        }
    }

    private void resolve(String locationStem, List<String> locations) {
        String resolved = this._locAdmin.resolveString(locationStem);
        locations.add(resolved);
        locations.add(resolved + ".xml");
    }

    @Override
    public void cancel() {
        this.lock.lock();
        try {
            this._callback.set(null);
            this._mon.unregister();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onBaseline(Collection<File> baseline) {
        this.onChange(baseline, Collections.emptyList(), Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
        this.lock.lock();
        try {
            if (this._callback.get() == null) {
                return;
            }
            this._file.set(null);
            this.findFile(false);
        }
        finally {
            this.lock.unlock();
        }
    }
}

