/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ECPrivateKey;
import com.ibm.crypto.provider.ECPublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class ECKeyFactory
extends KeyFactorySpi {
    private static String[] z;

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                return new ECPrivateKey(byArray);
            }
            if (keySpec instanceof ECPrivateKeySpec) {
                ECParameterSpec eCParameterSpec = ((ECPrivateKeySpec)keySpec).getParams();
                BigInteger bigInteger = ((ECPrivateKeySpec)keySpec).getS();
                return new ECPrivateKey(bigInteger, eCParameterSpec);
            }
            throw new InvalidKeySpecException(z[0]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeySpecException(invalidParameterSpecException.getMessage());
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof X509EncodedKeySpec) {
                byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
                return new ECPublicKey(byArray);
            }
            if (keySpec instanceof ECPublicKeySpec) {
                ECParameterSpec eCParameterSpec = ((ECPublicKeySpec)keySpec).getParams();
                ECPoint eCPoint = ((ECPublicKeySpec)keySpec).getW();
                return new ECPublicKey(eCPoint, eCParameterSpec);
            }
            throw new InvalidKeySpecException(z[0]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeySpecException(invalidParameterSpecException.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        throw new UnsupportedOperationException(z[1]);
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new UnsupportedOperationException(z[2]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block29: {
            int n2;
            int n3;
            block28: {
                char[] cArray2;
                Object var0;
                block27: {
                    int n4;
                    block26: {
                        char[] cArray3;
                        block25: {
                            int n5;
                            block24: {
                                stringArray = new String[3];
                                var0 = null;
                                char[] cArray4 = "BX|38gY}2-s\u0016d#17E\u007f#+~Pf%)c_`(".toCharArray();
                                cArray3 = cArray4;
                                n5 = cArray4.length;
                                n3 = 0;
                                if (!true) break block24;
                                n5 = n5;
                                if (n5 <= n3) break block25;
                            }
                            do {
                                int n6;
                                cArray3 = cArray3;
                                int n7 = n3;
                                char c2 = cArray3[n7];
                                switch (n3 % 5) {
                                    case 0: {
                                        n6 = 23;
                                        break;
                                    }
                                    case 1: {
                                        n6 = 54;
                                        break;
                                    }
                                    case 2: {
                                        n6 = 15;
                                        break;
                                    }
                                    case 3: {
                                        n6 = 70;
                                        break;
                                    }
                                    default: {
                                        n6 = 72;
                                    }
                                }
                                cArray3[n7] = (char)(c2 ^ n6);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[0] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray5 = "rXh/&rqj2\u0003rO\\6-t\u0016f5hbX|38gY}2-s\u0016i):7sL\r-npn%<xDv".toCharArray();
                        cArray2 = cArray5;
                        n4 = cArray5.length;
                        n3 = 0;
                        if (!true) break block26;
                        n4 = n4;
                        if (n4 <= n3) break block27;
                    }
                    do {
                        int n8;
                        cArray2 = cArray2;
                        int n9 = n3;
                        char c3 = cArray2[n9];
                        switch (n3 % 5) {
                            case 0: {
                                n8 = 23;
                                break;
                            }
                            case 1: {
                                n8 = 54;
                                break;
                            }
                            case 2: {
                                n8 = 15;
                                break;
                            }
                            case 3: {
                                n8 = 70;
                                break;
                            }
                            default: {
                                n8 = 72;
                            }
                        }
                        cArray2[n9] = (char)(c3 ^ n8);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[1] = new String(cArray2).intern();
                var0 = null;
                char[] cArray6 = "rXh/&rb}'&dZn2-\\Svf!d\u0016z(;bF\u007f):cSkf.xD/\u0003\u000b\\Sv\u0000)tB`41".toCharArray();
                cArray = cArray6;
                n2 = cArray6.length;
                n3 = 0;
                if (!true) break block28;
                n2 = n2;
                if (n2 <= n3) break block29;
            }
            do {
                int n10;
                cArray = cArray;
                int n11 = n3;
                char c4 = cArray[n11];
                switch (n3 % 5) {
                    case 0: {
                        n10 = 23;
                        break;
                    }
                    case 1: {
                        n10 = 54;
                        break;
                    }
                    case 2: {
                        n10 = 15;
                        break;
                    }
                    case 3: {
                        n10 = 70;
                        break;
                    }
                    default: {
                        n10 = 72;
                    }
                }
                cArray[n11] = (char)(c4 ^ n10);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[2] = new String(cArray).intern();
        z = stringArray;
    }
}

