/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;

public final class TCPMsgV10 {
    private boolean debug;
    public static final byte PKI_REQ = 0;
    public static final byte POLL_REP = 1;
    public static final byte POLL_REQ = 2;
    public static final byte FIN_REP = 3;
    public static final byte PKI_REP = 5;
    public static final byte ERROR_MSG_REP = 6;
    private static final int versionNumber = 10;
    private byte flag;
    private byte msgType;
    private byte[] value;
    private static final byte[] zero = new byte[1];
    static int i = 0;

    public TCPMsgV10(byte by, byte by2, byte[] byArray) {
        block2: {
            this.debug = false;
            this.setMessage(by, by2, byArray);
            if (!this.debug) break block2;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream("c:\\debug\\tcpmsgv10B" + new Date().getTime() + i++);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                System.out.println("problems with c:\\debug\\tcpmsgv10B perhaps" + exception);
            }
        }
    }

    public TCPMsgV10(byte by, byte[] byArray) {
        block2: {
            this.debug = false;
            this.setMessage((byte)0, by, byArray);
            if (!this.debug) break block2;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream("c:\\debug\\tcpmsgv10A" + new Date().getTime() + i++);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                System.out.println("problems with c:\\debug\\tcpmsgv10A perhaps" + exception);
            }
        }
    }

    public TCPMsgV10(InputStream inputStream) throws IOException {
        block5: {
            this.debug = false;
            byte[] byArray = new byte[4];
            inputStream.read(byArray);
            int n2 = new BigInteger(1, byArray).intValue();
            byte[] byArray2 = new byte[1];
            inputStream.read(byArray2);
            if (byArray2[0] != 10) {
                byte by = byArray2[0];
                throw new IOException("TCPMsgV10 parsing error : invalid version number " + by);
            }
            inputStream.read(byArray2);
            this.flag = byArray2[0];
            inputStream.read(byArray2);
            this.msgType = byArray2[0];
            if (!this.isValidMsgType(this.msgType)) {
                throw new IOException("TCPMsgV10 parsing error : invalid message type");
            }
            int n3 = n2 - 3;
            this.value = new byte[n3];
            int n4 = 0;
            byte[] byArray3 = new byte[n3];
            while (n4 < n3) {
                int n5 = inputStream.read(byArray3);
                System.arraycopy(byArray3, 0, this.value, n4, n5);
                n4 += n5;
            }
            if (!this.debug) break block5;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream("c:\\debug\\tcpmsgv10C" + new Date().getTime() + i++);
                fileOutputStream.write(this.value);
                fileOutputStream.close();
                Thread.dumpStack();
            }
            catch (Exception exception) {
                System.out.println("problems with c:\\debug\\tcpmsgv10C perhaps" + exception);
            }
        }
    }

    public byte getFlag() {
        return this.flag;
    }

    public int getLength() {
        if (this.value == null) {
            return 0;
        }
        return this.value.length + 3;
    }

    public byte getMessageType() {
        return this.msgType;
    }

    public byte[] getValue() {
        if (this.value == null) {
            return null;
        }
        return (byte[])this.value.clone();
    }

    public boolean isConnect() {
        return (this.flag & 1) != 1;
    }

    private boolean isValidMsgType(byte by) {
        return by == 0 || by == 1 || by == 2 || by == 3 || by == 5 || by == 6;
    }

    private void setMessage(byte by, byte by2, byte[] byArray) {
        this.flag = by;
        if (!this.isValidMsgType(by2)) {
            throw new IllegalArgumentException("TCPMsgV10 error : invalid message type");
        }
        this.msgType = by2;
        if (byArray == null) {
            throw new IllegalArgumentException("TCPMsgV10 error : invalid value");
        }
        this.value = byArray;
    }

    public void write(OutputStream outputStream) throws IOException {
        BigInteger bigInteger = BigInteger.valueOf(this.value.length + 3).abs();
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length > 4 && (byArray[0] & 0x80) != 128) {
            throw new IOException("TCPMsgV10 error : message too long");
        }
        int n2 = 4 - byArray.length;
        while (n2 > 0) {
            outputStream.write(zero);
            --n2;
        }
        outputStream.write(byArray);
        byte[] byArray2 = new byte[]{10};
        outputStream.write(byArray2);
        byArray2[0] = this.flag;
        outputStream.write(byArray2);
        byArray2[0] = this.msgType;
        outputStream.write(byArray2);
        outputStream.write(this.value);
    }
}

