/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.spi.BatchSPIManager;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.jbatch.spi.services.IBatchThreadPoolService;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class SPIDelegatingThreadPoolServiceImpl
implements IBatchThreadPoolService {
    private static final String sourceClass = SPIDelegatingThreadPoolServiceImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    static final long serialVersionUID = 401267212106251974L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SPIDelegatingThreadPoolServiceImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.SPIDelegatingThreadPoolServiceImpl", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.SPIDelegatingThreadPoolServiceImpl", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void init(IBatchConfig batchConfig) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.SPIDelegatingThreadPoolServiceImpl", "init", new Object[]{batchConfig});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.SPIDelegatingThreadPoolServiceImpl", "init");
        }
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void shutdown() throws BatchContainerServiceException {
        String method = "shutdown";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        ExecutorService delegateService = BatchSPIManager.getInstance().getExecutorServiceProvider().getExecutorService();
        delegateService.shutdownNow();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Future<?> executeTask(Runnable work, Object config) {
        String method = "executeTask";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        ExecutorService delegateService = BatchSPIManager.getInstance().getExecutorServiceProvider().getExecutorService();
        Future<?> retVal = delegateService.submit(work);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
        return retVal;
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Future<?> executeParallelTask(Runnable work, Object config) {
        String method = "executeParallelTask";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        ExecutorService delegateService = BatchSPIManager.getInstance().getExecutorServiceProvider().getExecutorService();
        Future<?> retVal = delegateService.submit(work);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
        return retVal;
    }
}

