/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.util.Factory;
import org.apache.yoko.util.Wrapper;

public final class VerboseLogging
extends Enum<VerboseLogging> {
    public static final Logger ROOT_LOG;
    public static final Logger CONN_LOG;
    public static final Logger CONN_IN_LOG;
    public static final Logger CONN_OUT_LOG;
    public static final Logger DATA_LOG;
    public static final Logger DATA_IN_LOG;
    public static final Logger DATA_OUT_LOG;
    public static final Logger RETRY_LOG;
    public static final Logger IOR_LOG;
    public static final Logger REQ_LOG;
    public static final Logger REQ_OUT_LOG;
    public static final Logger REQ_IN_LOG;
    public static final Logger MARSHAL_LOG;
    public static final Logger CLASS_LOG;
    private static final /* synthetic */ VerboseLogging[] $VALUES;

    public static VerboseLogging[] values() {
        return (VerboseLogging[])$VALUES.clone();
    }

    public static VerboseLogging valueOf(String name) {
        return Enum.valueOf(VerboseLogging.class, name);
    }

    public static <L extends Throwable> L logged(Logger logger, L loggable, String reason) {
        loggable.addSuppressed(new StackTraceRecord(reason));
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, reason, loggable);
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine(reason + ": " + loggable);
        }
        return loggable;
    }

    public static <W extends Throwable> W wrapped(Logger logger, Exception cause, String reason, Factory<W> wrapperFactory) {
        return (W)VerboseLogging.logged(logger, ((Throwable)wrapperFactory.create()).initCause(cause), reason);
    }

    public static <V extends Throwable, W extends Throwable> W wrapped(Logger logger, V cause, String reason, Wrapper<V, W> wrapperFactory) {
        return (W)VerboseLogging.logged(logger, (Throwable)wrapperFactory.wrap(cause), reason);
    }

    public static <L extends Throwable> L warned(Logger logger, L loggable, String reason) {
        logger.log(Level.WARNING, reason, loggable);
        return loggable;
    }

    private static /* synthetic */ VerboseLogging[] $values() {
        return new VerboseLogging[0];
    }

    static {
        $VALUES = VerboseLogging.$values();
        ROOT_LOG = Logger.getLogger("yoko.verbose");
        CONN_LOG = Logger.getLogger("yoko.verbose.connection");
        CONN_IN_LOG = Logger.getLogger("yoko.verbose.connection.in");
        CONN_OUT_LOG = Logger.getLogger("yoko.verbose.connection.out");
        DATA_LOG = Logger.getLogger("yoko.verbose.data");
        DATA_IN_LOG = Logger.getLogger("yoko.verbose.data.in");
        DATA_OUT_LOG = Logger.getLogger("yoko.verbose.data.out");
        RETRY_LOG = Logger.getLogger("yoko.verbose.retry");
        IOR_LOG = Logger.getLogger("yoko.verbose.ior");
        REQ_LOG = Logger.getLogger("yoko.verbose.request");
        REQ_OUT_LOG = Logger.getLogger("yoko.verbose.request.out");
        REQ_IN_LOG = Logger.getLogger("yoko.verbose.request.in");
        MARSHAL_LOG = Logger.getLogger("yoko.verbose.marshal");
        CLASS_LOG = Logger.getLogger("yoko.verbose.class");
    }

    private static class StackTraceRecord
    extends Exception {
        private static final long serialVersionUID = 1L;

        StackTraceRecord(String reason) {
            super(reason);
        }
    }
}

