/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public final class CollectionExtras
extends Enum<CollectionExtras> {
    private static final /* synthetic */ CollectionExtras[] $VALUES;

    public static CollectionExtras[] values() {
        return (CollectionExtras[])$VALUES.clone();
    }

    public static CollectionExtras valueOf(String name) {
        return Enum.valueOf(CollectionExtras.class, name);
    }

    public static <T> Iterable<T> removeInReverse(List<T> list) {
        final ListIterator listIterator = list.listIterator(list.size());
        return () -> new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return listIterator.hasPrevious();
            }

            @Override
            public T next() {
                Object result = listIterator.previous();
                listIterator.remove();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> List<T> newSynchronizedList() {
        return Collections.synchronizedList(new ArrayList());
    }

    public static <T> Iterable<T> allOf(final Iterable<? extends T> ... iterables) {
        return () -> new Iterator<T>(){
            final Iterator<Iterable<? extends T>> metaIterator;
            Iterator<? extends T> iterator;
            {
                this.metaIterator = Arrays.asList(iterables).iterator();
                this.iterator = Collections.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                while (!this.iterator.hasNext()) {
                    if (!this.metaIterator.hasNext()) {
                        return false;
                    }
                    this.iterator = this.metaIterator.next().iterator();
                }
                return true;
            }

            @Override
            public T next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <U, T extends U> Iterable<T> filterByType(final Iterable<U> iterable, final Class<T> type) {
        return () -> new Iterator<T>(){
            Iterator<U> iterator;
            T next;
            {
                this.iterator = iterable.iterator();
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                if (null != this.next) {
                    return true;
                }
                while (this.iterator.hasNext()) {
                    Object elem = this.iterator.next();
                    if (!type.isInstance(elem)) continue;
                    this.next = type.cast(elem);
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                try {
                    Object t = this.next;
                    return t;
                }
                finally {
                    this.next = null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E extends Enum<E>> Set<E> readOnlyEnumSet(E first, E ... rest) {
        return Collections.unmodifiableSet(EnumSet.of(first, rest));
    }

    private static /* synthetic */ CollectionExtras[] $values() {
        return new CollectionExtras[0];
    }

    static {
        $VALUES = CollectionExtras.$values();
    }
}

