/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorization.jacc.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.jacc.common.PolicyProxy;
import com.ibm.ws.security.authorization.jacc.ejb.EJBSecurityPropagator;
import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContextException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ApplicationStateListener.class})
public class PolicyConfigurationManager
implements ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(PolicyConfigurationManager.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.jacc.internal.resources.JaccAuthorizationMessages");
    private static final Map<String, List<PolicyConfiguration>> pcConfigsMap = new ConcurrentHashMap<String, List<PolicyConfiguration>>();
    private static final Map<String, List<String>> pcModulesMap = new ConcurrentHashMap<String, List<String>>();
    private static final Map<String, List<String>> pcEjbMap = new ConcurrentHashMap<String, List<String>>();
    private static final List<String> pcRunningList = new ArrayList<String>();
    private static PolicyConfigurationFactory pcf = null;
    private static PolicyProxy policyProxy = null;
    private static EJBSecurityPropagator esp = null;
    static final long serialVersionUID = 4494363754807744503L;

    public static void initialize(PolicyProxy policyProxy, PolicyConfigurationFactory pcf) {
        PolicyConfigurationManager.policyProxy = policyProxy;
        PolicyConfigurationManager.pcf = pcf;
        pcConfigsMap.clear();
        pcModulesMap.clear();
        pcRunningList.clear();
    }

    public static void setEJBSecurityPropagator(EJBSecurityPropagator esp) {
        PolicyConfigurationManager.esp = esp;
    }

    public static void linkConfiguration(String appName, PolicyConfiguration pc) throws PolicyContextException {
        List<PolicyConfiguration> pcs = pcConfigsMap.get(appName);
        if (pcs != null) {
            pc.linkConfiguration(pcs.get(0));
        } else {
            pcs = new ArrayList<PolicyConfiguration>();
            pcConfigsMap.put(appName, pcs);
        }
        pcs.add(pc);
    }

    public static void addModule(String appName, String contextId) {
        List<String> ctxIds = pcModulesMap.get(appName);
        if (ctxIds == null) {
            ctxIds = new ArrayList<String>();
            pcModulesMap.put(appName, ctxIds);
        }
        if (!ctxIds.contains(contextId)) {
            ctxIds.add(contextId);
        }
        if (PolicyConfigurationManager.isApplicationRunning(appName)) {
            PolicyConfigurationManager.processEJBs(appName);
            PolicyConfigurationManager.commitModules(appName);
        }
    }

    public static boolean containModule(String appName, String contextId) {
        List<String> ctxIds = pcModulesMap.get(appName);
        return ctxIds != null && ctxIds.contains(contextId);
    }

    public static void removeModule(String appName, String contextId) {
        int index;
        List<String> ctxIds = pcModulesMap.get(appName);
        if (ctxIds != null && (index = ctxIds.indexOf(contextId)) >= 0) {
            ctxIds.remove(index);
            if (ctxIds.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Removing application : " + appName), (Object[])new Object[0]);
                }
                pcModulesMap.remove(appName);
            }
        }
    }

    public static void addEJB(String appName, String contextId) {
        List<String> ctxIds = pcEjbMap.get(appName);
        if (ctxIds == null) {
            ctxIds = new ArrayList<String>();
            pcEjbMap.put(appName, ctxIds);
        }
        if (!ctxIds.contains(contextId)) {
            ctxIds.add(contextId);
        }
        PolicyConfigurationManager.addModule(appName, contextId);
    }

    public static boolean isApplicationRunning(String appName) {
        return pcRunningList.contains(appName);
    }

    protected static void processEJBs(String appName) {
        List<String> ctxIds = pcEjbMap.get(appName);
        if (ctxIds != null) {
            for (String contextId : ctxIds) {
                if (esp != null) {
                    esp.processEJBRoles(pcf, contextId);
                    continue;
                }
                Tr.error((TraceComponent)tc, (String)"JACC_NO_EJB_PLUGIN", (Object[])new Object[0]);
            }
            pcEjbMap.remove(appName);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void commitModules(String appName) {
        List<PolicyConfiguration> pcs = pcConfigsMap.get(appName);
        if (pcs != null) {
            for (PolicyConfiguration pc : pcs) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Comitting PolicyConfigurations : " + pc), (Object[])new Object[0]);
                }
                try {
                    pc.commit();
                }
                catch (PolicyContextException policyContextException) {
                    void pce;
                    FFDCFilter.processException((Throwable)policyContextException, (String)"com.ibm.ws.security.authorization.jacc.common.PolicyConfigurationManager", (String)"151", null, (Object[])new Object[]{appName});
                    String ctxId = null;
                    try {
                        ctxId = pc.getContextID();
                    }
                    catch (PolicyContextException policyContextException2) {
                        FFDCFilter.processException((Throwable)policyContextException2, (String)"com.ibm.ws.security.authorization.jacc.common.PolicyConfigurationManager", (String)"155", null, (Object[])new Object[]{appName});
                        ctxId = "<<UNKNOWN>>";
                    }
                    Tr.error((TraceComponent)tc, (String)"JACC_GET_POLICYCONFIGURATION_FAILURE", (Object[])new Object[]{ctxId, pce});
                }
            }
            policyProxy.refresh();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void removeModules(String appName) {
        List<String> ctxIds = pcModulesMap.get(appName);
        if (ctxIds != null) {
            for (String ctxId : ctxIds) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("contextID : " + ctxId), (Object[])new Object[0]);
                }
                PolicyConfiguration pc = null;
                try {
                    pc = pcf.getPolicyConfiguration(ctxId, false);
                    if (pc == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Deleting PolicyConfigurations : " + pc), (Object[])new Object[0]);
                    }
                    pc.delete();
                }
                catch (PolicyContextException policyContextException) {
                    void pce;
                    FFDCFilter.processException((Throwable)policyContextException, (String)"com.ibm.ws.security.authorization.jacc.common.PolicyConfigurationManager", (String)"179", null, (Object[])new Object[]{appName});
                    Tr.error((TraceComponent)tc, (String)"JACC_GET_POLICYCONFIGURATION_FAILURE", (Object[])new Object[]{ctxId, pce});
                }
            }
            policyProxy.refresh();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"refresh is invoked after deleting PolicyConfigurations", (Object[])new Object[0]);
            }
            pcModulesMap.remove(appName);
            pcConfigsMap.remove(appName);
        }
    }

    public void applicationStarting(ApplicationInfo appInfo) {
    }

    public void applicationStarted(ApplicationInfo appInfo) {
        String appName = appInfo.getDeploymentName();
        if (appName != null) {
            PolicyConfigurationManager.processEJBs(appName);
            PolicyConfigurationManager.commitModules(appName);
            pcRunningList.add(appName);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("commit all modules and refresh is invoked after the application is started. AppName : " + appName), (Object[])new Object[0]);
            }
        }
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        String appName = appInfo.getDeploymentName();
        if (appName != null) {
            PolicyConfigurationManager.removeModules(appName);
            pcRunningList.remove(appName);
        }
    }
}

