/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorization.jacc.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.jacc.JaccService;
import com.ibm.ws.security.authorization.jacc.MethodInfo;
import com.ibm.ws.security.authorization.jacc.RoleInfo;
import com.ibm.ws.security.authorization.jacc.common.PolicyConfigurationManager;
import com.ibm.ws.security.authorization.jacc.common.PolicyProxy;
import com.ibm.ws.security.authorization.jacc.common.ProviderServiceProxy;
import com.ibm.ws.security.authorization.jacc.ejb.EJBSecurityPropagator;
import com.ibm.ws.security.authorization.jacc.ejb.EJBSecurityValidator;
import com.ibm.ws.security.authorization.jacc.ejb.EJBService;
import com.ibm.ws.security.authorization.jacc.web.ServletService;
import com.ibm.ws.security.authorization.jacc.web.WebSecurityPropagator;
import com.ibm.ws.security.authorization.jacc.web.WebSecurityValidator;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import jakarta.security.jacc.EJBMethodPermission;
import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import jakarta.security.jacc.WebUserDataPermission;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={JaccService.class}, name="com.ibm.ws.security.authorization.jacc", configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class JaccServiceImpl
implements JaccService {
    private static final TraceComponent tc = Tr.register(JaccServiceImpl.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.jacc.internal.resources.JaccAuthorizationMessages");
    private static final String JACC_EJB_METHOD_ARGUMENT = "RequestMethodArgumentsRequired";
    static final String KEY_JACC_PROVIDER_SERVICE_PROXY = "jaccProviderServiceProxy";
    private final String KEY_LOCATION_ADMIN = "locationAdmin";
    private final AtomicServiceReference<ProviderServiceProxy> jaccProviderServiceProxy = new AtomicServiceReference("jaccProviderServiceProxy");
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    private static final String KEY_SERVLET_SERVICE = "servletService";
    private final AtomicServiceReference<ServletService> servletServiceRef = new AtomicServiceReference("servletService");
    private static final String KEY_EJB_SERVICE = "ejbService";
    private final AtomicServiceReference<EJBService> ejbServiceRef = new AtomicServiceReference("ejbService");
    private String policyName = null;
    private String factoryName = null;
    private PolicyProxy policyProxy = null;
    private PolicyConfigurationFactory pcf = null;
    static final long serialVersionUID = 1907797548138963948L;

    @Reference(service=ProviderServiceProxy.class, policy=ReferencePolicy.DYNAMIC, name="jaccProviderServiceProxy")
    protected void setJaccProviderServiceProxy(ServiceReference<ProviderServiceProxy> reference) {
        this.jaccProviderServiceProxy.setReference(reference);
    }

    protected void unsetJaccProviderServiceProxy(ServiceReference<ProviderServiceProxy> reference) {
        this.jaccProviderServiceProxy.unsetReference(reference);
    }

    @Reference(service=WsLocationAdmin.class, name="locationAdmin")
    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> reference) {
        this.locationAdminRef.setReference(reference);
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> reference) {
        this.locationAdminRef.unsetReference(reference);
    }

    @Reference(service=ServletService.class, name="servletService", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setServletService(ServiceReference<ServletService> reference) {
        this.servletServiceRef.setReference(reference);
    }

    protected void unsetServletService(ServiceReference<ServletService> reference) {
        this.servletServiceRef.unsetReference(reference);
    }

    @Reference(service=EJBService.class, name="ejbService", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEJBService(ServiceReference<EJBService> reference) {
        this.ejbServiceRef.setReference(reference);
    }

    protected void unsetEJBService(ServiceReference<EJBService> reference) {
        this.ejbServiceRef.unsetReference(reference);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.jaccProviderServiceProxy.activate(cc);
        ProviderServiceProxy serviceProxy = (ProviderServiceProxy)this.jaccProviderServiceProxy.getService();
        if (serviceProxy != null) {
            this.policyName = serviceProxy.getPolicyName();
            this.factoryName = serviceProxy.getFactoryName();
        }
        Tr.info((TraceComponent)tc, (String)"JACC_SERVICE_STARTING", (Object[])new Object[]{this.policyName, this.factoryName});
        this.locationAdminRef.activate(cc);
        this.servletServiceRef.activate(cc);
        this.ejbServiceRef.activate(cc);
        if (this.loadClasses()) {
            Tr.info((TraceComponent)tc, (String)"JACC_SERVICE_STARTED", (Object[])new Object[]{this.policyName, this.factoryName});
        } else {
            Tr.info((TraceComponent)tc, (String)"JACC_SERVICE_START_FAILURE", (Object[])new Object[]{this.policyName, this.factoryName});
        }
    }

    @Modified
    protected void modify(Map<String, Object> props) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.locationAdminRef.deactivate(cc);
        this.jaccProviderServiceProxy.deactivate(cc);
        this.servletServiceRef.deactivate(cc);
        this.ejbServiceRef.deactivate(cc);
        Tr.info((TraceComponent)tc, (String)"JACC_SERVICE_STOPPED", (Object[])new Object[]{this.policyName});
    }

    public boolean loadClasses() {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = -5422570454035875426L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public Boolean run() {
                JaccServiceImpl.this.policyProxy = ((ProviderServiceProxy)JaccServiceImpl.this.jaccProviderServiceProxy.getService()).getPolicyProxy();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("policy object" + JaccServiceImpl.this.policyProxy), (Object[])new Object[0]);
                }
                if (JaccServiceImpl.this.policyProxy == null) {
                    Exception e = new Exception("Policy object is null.");
                    Tr.error((TraceComponent)tc, (String)"JACC_POLICY_INSTANTIATION_FAILURE", (Object[])new Object[]{JaccServiceImpl.this.policyName, e});
                    return Boolean.FALSE;
                }
                try {
                    JaccServiceImpl.this.policyProxy.setPolicy();
                    JaccServiceImpl.this.policyProxy.refresh();
                }
                catch (ClassCastException e) {
                    void cce;
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authorization.jacc.internal.JaccServiceImpl$1", (String)"174", (Object)this, (Object[])new Object[0]);
                    Tr.error((TraceComponent)tc, (String)"JACC_POLICY_INSTANTIATION_FAILURE", (Object[])new Object[]{JaccServiceImpl.this.policyName, cce});
                    return Boolean.FALSE;
                }
                JaccServiceImpl.this.pcf = ((ProviderServiceProxy)JaccServiceImpl.this.jaccProviderServiceProxy.getService()).getPolicyConfigFactory();
                if (JaccServiceImpl.this.pcf != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("factory object : " + JaccServiceImpl.this.pcf), (Object[])new Object[0]);
                    }
                } else {
                    Tr.error((TraceComponent)tc, (String)"JACC_FACTORY_INSTANTIATION_FAILURE", (Object[])new Object[]{JaccServiceImpl.this.factoryName});
                    return Boolean.FALSE;
                }
                PolicyConfigurationManager.initialize(JaccServiceImpl.this.policyProxy, JaccServiceImpl.this.pcf);
                return Boolean.TRUE;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authorization.jacc.internal.JaccServiceImpl$1", 1.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.jacc.internal.resources.JaccAuthorizationMessages");
            }
        });
        return result;
    }

    @Override
    public void propagateWebConstraints(String applicationName, String moduleName, Object webAppConfig) {
        WebSecurityPropagator wsp = this.getWsp((ServletService)this.servletServiceRef.getService());
        if (wsp != null) {
            this.propagateWebConstraints(wsp, applicationName, moduleName, webAppConfig);
        } else {
            Tr.error((TraceComponent)tc, (String)"JACC_NO_WEB_PLUGIN", (Object[])new Object[0]);
        }
    }

    protected void propagateWebConstraints(WebSecurityPropagator wsp, String applicationName, String moduleName, Object webAppConfig) {
        wsp.propagateWebConstraints(this.pcf, this.getContextId(applicationName, moduleName), webAppConfig);
    }

    @Override
    public boolean isSSLRequired(String applicationName, String moduleName, String uriName, String methodName, Object req) {
        return !this.checkDataConstraints(applicationName, moduleName, uriName, methodName, req, null);
    }

    @Override
    public boolean isAccessExcluded(String applicationName, String moduleName, String uriName, String methodName, Object req) {
        return !this.checkDataConstraints(applicationName, moduleName, uriName, methodName, req, "CONFIDENTIAL");
    }

    protected boolean checkDataConstraints(String applicationName, String moduleName, String uriName, String methodName, Object req, String transportType) {
        boolean result = false;
        WebSecurityValidator wsv = this.getWsv((ServletService)this.servletServiceRef.getService());
        if (wsv != null) {
            result = this.checkDataConstraints(wsv, applicationName, moduleName, uriName, methodName, req, transportType);
        } else {
            Tr.error((TraceComponent)tc, (String)"JACC_NO_WEB_PLUGIN", (Object[])new Object[0]);
        }
        return result;
    }

    protected boolean checkDataConstraints(WebSecurityValidator wsv, String applicationName, String moduleName, String uriName, String methodName, Object req, String transportType) {
        boolean result = false;
        String[] methodNameArray = new String[]{methodName};
        uriName = this.substituteAsterisk(uriName);
        WebUserDataPermission webUDPerm = new WebUserDataPermission(uriName, methodNameArray, transportType);
        result = wsv.checkDataConstraints(this.getContextId(applicationName, moduleName), req, webUDPerm, this.policyProxy);
        return result;
    }

    @Override
    public boolean isAuthorized(String applicationName, String moduleName, String uriName, String methodName, Object req, Subject subject) {
        boolean result = false;
        WebSecurityValidator wsv = this.getWsv((ServletService)this.servletServiceRef.getService());
        if (wsv != null) {
            result = this.isAuthorized(wsv, applicationName, moduleName, uriName, methodName, req, subject);
        } else {
            Tr.error((TraceComponent)tc, (String)"JACC_NO_WEB_PLUGIN", (Object[])new Object[0]);
        }
        return result;
    }

    protected boolean isAuthorized(WebSecurityValidator wsv, String applicationName, String moduleName, String uriName, String methodName, Object req, Subject subject) {
        Object authResult = null;
        Object subjectName = null;
        String[] methodNameArray = new String[]{methodName};
        uriName = this.substituteAsterisk(uriName);
        WebResourcePermission webPerm = new WebResourcePermission(uriName, methodNameArray);
        boolean isAuthorized = wsv.checkResourceConstraints(this.getContextId(applicationName, moduleName), req, (Permission)webPerm, subject, this.policyProxy);
        return isAuthorized;
    }

    @Override
    public boolean isSubjectInRole(String applicationName, String moduleName, String servletName, String role, Object req, Subject subject) {
        boolean result = false;
        WebSecurityValidator wsv = this.getWsv((ServletService)this.servletServiceRef.getService());
        if (wsv != null) {
            result = this.isSubjectInRole(wsv, applicationName, moduleName, servletName, role, req, subject);
        } else {
            Tr.error((TraceComponent)tc, (String)"JACC_NO_WEB_PLUGIN", (Object[])new Object[0]);
        }
        return result;
    }

    protected boolean isSubjectInRole(WebSecurityValidator wsv, String applicationName, String moduleName, String servletName, String role, Object req, Subject subject) {
        WebRoleRefPermission webRolePerm = new WebRoleRefPermission(servletName, role);
        return wsv.checkResourceConstraints(this.getContextId(applicationName, moduleName), req, (Permission)webRolePerm, subject, this.policyProxy);
    }

    @Override
    public void propagateEJBRoles(String applicationName, String moduleName, String beanName, Map<String, String> roleLinkMap, Map<RoleInfo, List<MethodInfo>> methodMap) {
        EJBSecurityPropagator esp = this.getEsp((EJBService)this.ejbServiceRef.getService());
        if (esp != null) {
            this.propagateEJBRoles(esp, applicationName, moduleName, beanName, roleLinkMap, methodMap);
        } else {
            Tr.error((TraceComponent)tc, (String)"JACC_NO_EJB_PLUGIN", (Object[])new Object[0]);
        }
    }

    protected void propagateEJBRoles(EJBSecurityPropagator esp, String applicationName, String moduleName, String beanName, Map<String, String> roleLinkMap, Map<RoleInfo, List<MethodInfo>> methodMap) {
        PolicyConfigurationManager.setEJBSecurityPropagator(esp);
        esp.propagateEJBRoles(this.getContextId(applicationName, moduleName), applicationName, beanName, roleLinkMap, methodMap);
    }

    @Override
    public boolean isAuthorized(String applicationName, String moduleName, String beanName, String methodName, String methodInterface, String methodSignature, List<Object> methodParameters, Object bean, Subject subject) {
        EJBSecurityValidator esv = this.getEsv((EJBService)this.ejbServiceRef.getService());
        if (esv != null) {
            return this.isAuthorized(esv, applicationName, moduleName, beanName, methodName, methodInterface, methodSignature, methodParameters, bean, subject);
        }
        Tr.error((TraceComponent)tc, (String)"JACC_NO_EJB_PLUGIN", (Object[])new Object[0]);
        return false;
    }

    protected boolean isAuthorized(EJBSecurityValidator esv, String applicationName, String moduleName, String beanName, String methodName, String methodInterface, String methodSignature, List<Object> methodParameters, Object bean, Subject subject) {
        String[] methodSignatureArray = this.convertMethodSignature(methodSignature);
        EJBMethodPermission ejbPerm = new EJBMethodPermission(beanName, methodName, methodInterface, methodSignatureArray);
        return esv.checkResourceConstraints(this.getContextId(applicationName, moduleName), methodParameters, bean, (Permission)ejbPerm, subject, this.policyProxy);
    }

    @Override
    public boolean isSubjectInRole(String applicationName, String moduleName, String beanName, String methodName, List<Object> methodParameters, String role, Object bean, Subject subject) {
        EJBSecurityValidator esv = this.getEsv((EJBService)this.ejbServiceRef.getService());
        if (esv != null) {
            return this.isSubjectInRole(esv, applicationName, moduleName, beanName, methodName, methodParameters, role, bean, subject);
        }
        Tr.error((TraceComponent)tc, (String)"JACC_NO_EJB_PLUGIN", (Object[])new Object[0]);
        return false;
    }

    protected boolean isSubjectInRole(EJBSecurityValidator esv, String applicationName, String moduleName, String beanName, String methodName, List<Object> methodParameters, String role, Object bean, Subject subject) {
        EJBRoleRefPermission ejbPerm = new EJBRoleRefPermission(beanName, role);
        return esv.checkResourceConstraints(this.getContextId(applicationName, moduleName), methodParameters, bean, (Permission)ejbPerm, subject, this.policyProxy);
    }

    @Override
    public boolean areRequestMethodArgumentsRequired() {
        String value;
        Object obj;
        boolean result = false;
        ProviderServiceProxy reference = (ProviderServiceProxy)this.jaccProviderServiceProxy.getService();
        if (reference != null && (obj = reference.getProperty(JACC_EJB_METHOD_ARGUMENT)) instanceof String && "true".equalsIgnoreCase(value = (String)obj)) {
            result = true;
        }
        return result;
    }

    private String getContextId(String applicationName, String moduleName) {
        StringBuffer output = new StringBuffer();
        WsLocationAdmin locationAdmin = (WsLocationAdmin)this.locationAdminRef.getService();
        output.append(this.getHostName()).append("#").append(locationAdmin.resolveString("${wlp.user.dir}").replace('\\', '/')).append("#").append(locationAdmin.getServerName()).append("#");
        output.append(applicationName).append("#").append(moduleName);
        return output.toString();
    }

    private String[] convertMethodSignature(String methodSignature) {
        String s;
        int index;
        ArrayList<String> methodSignatureList = new ArrayList<String>();
        if (methodSignature != null && methodSignature.length() > 0 && (index = methodSignature.indexOf(":")) != -1 && (s = methodSignature.substring(index + 1)) != null && s.length() > 0) {
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                methodSignatureList.add(st.nextToken());
            }
        }
        return methodSignatureList.toArray(new String[methodSignatureList.size()]);
    }

    private String substituteAsterisk(String uriName) {
        if (uriName != null && uriName.endsWith("/*")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The URI ends with \"/*\" which is substituted by \"/|\"", (Object[])new Object[0]);
            }
            uriName = uriName.substring(0, uriName.lastIndexOf("*")) + "|";
        }
        return uriName;
    }

    private String getHostName() {
        String hostName = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 2627518715934922053L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                try {
                    return InetAddress.getLocalHost().getCanonicalHostName().toLowerCase();
                }
                catch (UnknownHostException unknownHostException) {
                    FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.security.authorization.jacc.internal.JaccServiceImpl$2", (String)"414", (Object)this, (Object[])new Object[0]);
                    return "localhost";
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authorization.jacc.internal.JaccServiceImpl$2", 2.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.jacc.internal.resources.JaccAuthorizationMessages");
            }
        });
        return hostName;
    }

    protected EJBSecurityPropagator getEsp(EJBService es) {
        if (es != null) {
            return es.getPropagator();
        }
        return null;
    }

    protected EJBSecurityValidator getEsv(EJBService es) {
        if (es != null) {
            return es.getValidator();
        }
        return null;
    }

    protected WebSecurityPropagator getWsp(ServletService ws) {
        if (ws != null) {
            return ws.getPropagator();
        }
        return null;
    }

    protected WebSecurityValidator getWsv(ServletService ws) {
        if (ws != null) {
            return ws.getValidator();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void resetPolicyContextHandlerInfo() {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                    static final long serialVersionUID = -3021393609303518549L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Object run() {
                        PolicyContext.setHandlerData(null);
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authorization.jacc.internal.JaccServiceImpl$3", 3.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.jacc.internal.resources.JaccAuthorizationMessages");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.authorization.jacc.internal.JaccServiceImpl", (String)"465", (Object)this, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Exception when resetting setHandlerData. Ignoring.. " + e.getException()), (Object[])new Object[0]);
            }
        }
    }
}

