/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.DynamicContentProvider;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.CacheProxyResponse;
import com.ibm.ws.cache.servlet.MementoEntry;
import com.ibm.ws.cache.servlet.ResponseSideEffect;
import com.ibm.ws.cache.servlet.ServletWrapper;
import com.ibm.ws.cache.web.ExternalCacheFragment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cache.GenerateContents;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class FragmentComposerMemento
implements Serializable,
GenerateContents {
    private static final long serialVersionUID = 0x50002002L;
    private static TraceComponent tc = Tr.register(FragmentComposerMemento.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static int traceCount = 0;
    private Object[] contents;
    private boolean consumeSubfragments = false;
    private boolean containsESI = false;
    private ExternalCacheFragment externalCacheFragment = null;
    private String externalCacheGroupId = null;
    private int outputStyle = 3;
    private String contentType = null;
    private String characterEncoding = null;
    private CacheProxyRequest.Attribute[] attributes = null;
    private byte[] attributeBytes = null;

    public boolean getConsumeSubfragments() {
        return this.consumeSubfragments;
    }

    public void setConsumeSubfragments(boolean consumeSubfragments) {
        this.consumeSubfragments = consumeSubfragments;
    }

    public void setContainsESIContent(boolean b) {
        this.containsESI = b;
    }

    public void setOutputStyle(int outputStyle) {
        this.outputStyle = outputStyle;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setCharacterEncoding(String charEnc) {
        this.characterEncoding = charEnc;
    }

    public boolean getContainsESIContent() {
        return this.containsESI;
    }

    public void addContents(Object[] contents) {
        this.contents = contents;
    }

    public void addAttributes(CacheProxyRequest.Attribute[] changedAttrs) {
        this.attributes = changedAttrs;
    }

    public void addAttributeBytes(byte[] changedAttrBytes) {
        this.attributeBytes = changedAttrBytes;
    }

    public void displayPage(Servlet s, CacheProxyRequest request, CacheProxyResponse response) throws ServletException, IOException {
        int number = -1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            number = traceCount++;
            Tr.debug((TraceComponent)tc, (String)("displayPage BEGINS " + number), (Object[])new Object[0]);
        }
        if (this.containsESI) {
            response.setContainsESIContent(this.containsESI);
        }
        if (this.contentType != null) {
            response.setContentType(this.contentType);
        }
        if (!response.isCommitted()) {
            response.setHeader("CACHED_RESPONSE", "true");
        }
        if (this.characterEncoding != null) {
            response.setCharacterEncoding(this.characterEncoding);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setting response charEncoding to " + this.characterEncoding), (Object[])new Object[0]);
            }
        }
        ServletOutputStream outputStream = null;
        if (1 == this.outputStyle) {
            outputStream = response.getOutputStream();
        }
        PrintWriter printWriter = null;
        if (2 == this.outputStyle) {
            printWriter = response.getWriter();
        }
        this.displayFragment(s, request, response, (OutputStream)outputStream, printWriter, this.contents);
        if (this.attributes != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setting last unready attributes: ", (Object[])new Object[]{this.attributes});
            }
            request.setAttributeTableUnReadied(this.attributes);
            request.readyAttributes();
        } else if (this.attributeBytes != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setting last unready attribute bytes", (Object[])new Object[0]);
            }
            request.setAttributeTableBytes(this.attributeBytes);
            request.readyAttributes();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("displayPage ENDS " + number), (Object[])new Object[0]);
        }
    }

    public void displayFragment(Servlet s, CacheProxyRequest request, CacheProxyResponse response, OutputStream outputStream, PrintWriter printWriter, Object[] contents) throws ServletException, IOException {
        for (int i = 0; i < contents.length; ++i) {
            byte[] bytes;
            Object object = contents[i];
            if (object instanceof byte[]) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" writing array ='" + new String((byte[])object) + "'"), (Object[])new Object[0]);
                }
                if (outputStream == null && printWriter == null) {
                    outputStream = response.getOutputStream();
                }
                if (outputStream != null) {
                    outputStream.write((byte[])object);
                    continue;
                }
                if (printWriter == null) continue;
                printWriter.write(new String((byte[])object));
                continue;
            }
            if (object instanceof char[]) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" writing array ='" + new String((char[])object) + "'"), (Object[])new Object[0]);
                }
                if (printWriter == null && outputStream == null) {
                    printWriter = response.getWriter();
                }
                if (printWriter != null) {
                    printWriter.write((char[])object);
                    continue;
                }
                if (outputStream == null) continue;
                outputStream.write(new String((char[])object).getBytes());
                continue;
            }
            if (object instanceof String) {
                if (this.consumeSubfragments && response.getResponse().isCommitted()) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)"Cannot set content-type header. Response already committed", (Object[])new Object[0]);
                    continue;
                }
                response.setContentType((String)object);
                continue;
            }
            if (object instanceof ResponseSideEffect) {
                ResponseSideEffect responseSideEffect = (ResponseSideEffect)object;
                if (this.consumeSubfragments && response.getResponse().isCommitted()) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)("Cannot set header. Response already committed. Header was: " + responseSideEffect.toString()), (Object[])new Object[0]);
                    continue;
                }
                responseSideEffect.performSideEffect(response);
                continue;
            }
            if (object instanceof DynamicContentProvider) {
                DynamicContentProvider dynamicContentProvider = (DynamicContentProvider)object;
                if (this.outputStyle == 1) {
                    dynamicContentProvider.provideDynamicContent((HttpServletRequest)request, outputStream);
                }
                if (this.outputStyle != 2) continue;
                dynamicContentProvider.provideDynamicContent((HttpServletRequest)request, printWriter);
                continue;
            }
            MementoEntry mementoEntry = (MementoEntry)object;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" handling mementoEntry with template: " + mementoEntry.getTemplate()), (Object[])new Object[0]);
            }
            if ((bytes = mementoEntry.getAttributeTableBytes()) != null) {
                request.setAttributeTableBytes(bytes);
            } else {
                request.setAttributeTableUnReadied(mementoEntry.getAttributeTable());
            }
            if (!this.consumeSubfragments || this.consumeSubfragments && mementoEntry.getDoNotConsume()) {
                if (mementoEntry.getInclude() || mementoEntry.isAsync()) {
                    if (mementoEntry.getNamedDispatch()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Using NamedDispatcher for servletName:" + mementoEntry.getTemplate() + " contextPath: " + mementoEntry.getContextPath()), (Object[])new Object[0]);
                        }
                        if (mementoEntry.getContextPath() != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Including across webapps to " + mementoEntry.getContextPath()), (Object[])new Object[0]);
                            }
                            if (s instanceof ServletWrapper) {
                                ((ServletWrapper)s).getServletContext().getContext(mementoEntry.getContextPath()).getNamedDispatcher(mementoEntry.getTemplate()).include((ServletRequest)request, (ServletResponse)response);
                            } else {
                                ((HttpServlet)s).getServletContext().getContext(mementoEntry.getContextPath()).getNamedDispatcher(mementoEntry.getTemplate()).include((ServletRequest)request, (ServletResponse)response);
                            }
                        } else {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("including in same webapp to " + mementoEntry.getContextPath()), (Object[])new Object[0]);
                            }
                            if (s instanceof ServletWrapper) {
                                ((ServletWrapper)s).getServletContext().getNamedDispatcher(mementoEntry.getTemplate()).include((ServletRequest)request, (ServletResponse)response);
                            } else {
                                ((HttpServlet)s).getServletContext().getNamedDispatcher(mementoEntry.getTemplate()).include((ServletRequest)request, (ServletResponse)response);
                            }
                        }
                    } else if (mementoEntry.getContextPath() != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Including across webapps to " + mementoEntry.getContextPath()), (Object[])new Object[0]);
                        }
                        if (s instanceof ServletWrapper) {
                            ((ServletWrapper)s).getServletContext().getContext(mementoEntry.getContextPath()).getRequestDispatcher(mementoEntry.getTemplate()).include((ServletRequest)request, (ServletResponse)response);
                        } else {
                            ((HttpServlet)s).getServletContext().getContext(mementoEntry.getContextPath()).getRequestDispatcher(mementoEntry.getTemplate()).include((ServletRequest)request, (ServletResponse)response);
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("including in same webapp to " + mementoEntry.getContextPath()), (Object[])new Object[0]);
                        }
                        request.getRequestDispatcher(mementoEntry.getTemplate()).include((ServletRequest)request, (ServletResponse)response);
                    }
                } else if (mementoEntry.getNamedDispatch()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Using NamedDispatcher for servletName:" + mementoEntry.getTemplate() + " contextPath: " + mementoEntry.getContextPath()), (Object[])new Object[0]);
                    }
                    if (mementoEntry.getContextPath() != null) {
                        if (s instanceof ServletWrapper) {
                            ((ServletWrapper)s).getServletContext().getContext(mementoEntry.getContextPath()).getNamedDispatcher(mementoEntry.getTemplate()).forward((ServletRequest)request, (ServletResponse)response);
                        } else {
                            ((HttpServlet)s).getServletContext().getContext(mementoEntry.getContextPath()).getNamedDispatcher(mementoEntry.getTemplate()).forward((ServletRequest)request, (ServletResponse)response);
                        }
                    } else if (s instanceof ServletWrapper) {
                        ((ServletWrapper)s).getServletContext().getNamedDispatcher(mementoEntry.getTemplate()).forward((ServletRequest)request, (ServletResponse)response);
                    } else {
                        ((HttpServlet)s).getServletContext().getNamedDispatcher(mementoEntry.getTemplate()).forward((ServletRequest)request, (ServletResponse)response);
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Using RequestDispatcher for servletName:" + mementoEntry.getTemplate() + " contextPath: " + mementoEntry.getContextPath()), (Object[])new Object[0]);
                    }
                    if (mementoEntry.getContextPath() != null) {
                        if (s instanceof ServletWrapper) {
                            ((ServletWrapper)s).getServletContext().getContext(mementoEntry.getContextPath()).getRequestDispatcher(mementoEntry.getTemplate()).forward((ServletRequest)request, (ServletResponse)response);
                        } else {
                            ((HttpServlet)s).getServletContext().getContext(mementoEntry.getContextPath()).getRequestDispatcher(mementoEntry.getTemplate()).forward((ServletRequest)request, (ServletResponse)response);
                        }
                    } else {
                        request.getRequestDispatcher(mementoEntry.getTemplate()).forward((ServletRequest)request, (ServletResponse)response);
                    }
                }
            } else {
                request.readyAttributes();
                this.displayFragment(s, request, response, outputStream, printWriter, mementoEntry.getContents());
            }
            CacheProxyRequest.Attribute[] eAttributes = mementoEntry.getEndAttributeTable();
            byte[] eAttributeBytes = mementoEntry.getEndAttributeTableBytes();
            if (eAttributes != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setting last unready attributes: " + eAttributes), (Object[])new Object[0]);
                }
                request.setAttributeTableUnReadied(eAttributes);
                request.readyAttributes();
                continue;
            }
            if (eAttributeBytes == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setting last unready attribute bytes", (Object[])new Object[0]);
            }
            request.setAttributeTableBytes(eAttributeBytes);
            request.readyAttributes();
        }
    }

    public void viewContents(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream outputStream = null;
        PrintStream printStream = null;
        PrintWriter printWriter = null;
        for (int i = 0; i < this.contents.length; ++i) {
            CacheProxyRequest.Attribute[] tmp;
            Object object = this.contents[i];
            if (object instanceof byte[]) {
                if (outputStream == null) {
                    outputStream = response.getOutputStream();
                }
                outputStream.write((byte[])object);
                continue;
            }
            if (object instanceof char[]) {
                if (printWriter == null) {
                    printWriter = response.getWriter();
                }
                printWriter.write((char[])object);
                continue;
            }
            if (object instanceof String) {
                if (this.outputStyle == 2) {
                    if (printWriter == null) {
                        printWriter = response.getWriter();
                    }
                    printWriter.println("<xmp>setContentType: " + object + "</xmp>");
                    continue;
                }
                if (outputStream == null) {
                    outputStream = response.getOutputStream();
                }
                if (printStream == null) {
                    printStream = new PrintStream((OutputStream)outputStream);
                }
                printStream.println("<xmp>setContentType: " + object + "</xmp>");
                continue;
            }
            if (object instanceof ResponseSideEffect) {
                if (this.outputStyle == 2) {
                    if (printWriter == null) {
                        printWriter = response.getWriter();
                    }
                    printWriter.println("<xmp>sideEffect: " + object + "</xmp>");
                    continue;
                }
                if (outputStream == null) {
                    outputStream = response.getOutputStream();
                }
                if (printStream == null) {
                    printStream = new PrintStream((OutputStream)outputStream);
                }
                printStream.println("<xmp>sideEffect: " + object + "</xmp>");
                continue;
            }
            if (object instanceof DynamicContentProvider) {
                if (this.outputStyle == 2) {
                    if (printWriter == null) {
                        printWriter = response.getWriter();
                    }
                    printWriter.println("<xmp>[DynamicContentProvider: " + object.getClass() + "]</xmp><br>");
                    continue;
                }
                if (outputStream == null) {
                    outputStream = response.getOutputStream();
                }
                if (printStream == null) {
                    printStream = new PrintStream((OutputStream)outputStream);
                }
                printStream.println("<xmp>[DynamicContentProvider: " + object.getClass() + "]</xmp><br>");
                continue;
            }
            if (!(object instanceof MementoEntry)) {
                throw new IllegalStateException("each element in contents should be a String, ResponseSideEffect, or a MementoEntry");
            }
            MementoEntry mementoEntry = (MementoEntry)object;
            if (this.outputStyle == 2) {
                if (printWriter == null) {
                    printWriter = response.getWriter();
                }
                if ((tmp = mementoEntry.getAttributeTable()) != null) {
                    printWriter.println("<xmp>[modified request attributes: " + tmp + "]<br></xmp>");
                }
                if (this.consumeSubfragments && !mementoEntry.getDoNotConsume()) {
                    printWriter.println("<xmp>[CONSUMED include: " + mementoEntry.getTemplate() + "]</xmp><br>");
                    continue;
                }
                printWriter.println("<xmp>[include: " + mementoEntry.getTemplate() + "]</xmp><br>");
                continue;
            }
            if (outputStream == null) {
                outputStream = response.getOutputStream();
            }
            if (printStream == null) {
                printStream = new PrintStream((OutputStream)outputStream);
            }
            if ((tmp = mementoEntry.getAttributeTable()) != null) {
                printStream.println("<xmp>[modified request attributes: " + tmp + "]</xmp><br>");
            }
            if (this.consumeSubfragments && !mementoEntry.getDoNotConsume()) {
                printStream.println("<xmp>[CONSUMED include: " + mementoEntry.getTemplate() + "]</xmp><br>");
                continue;
            }
            printStream.println("<xmp>[include: " + mementoEntry.getTemplate() + "]</xmp><br>");
        }
        if (this.attributes != null) {
            if (printStream != null) {
                printStream.println("<xmp>[modified request attributes: " + this.attributes + "]</xmp><br>");
            } else {
                if (printWriter == null) {
                    printWriter = response.getWriter();
                }
                printWriter.println("<xmp>[modified request attributes: " + this.attributes + "]</xmp><br>");
            }
        } else if (this.attributeBytes != null) {
            if (printStream != null) {
                printStream.println("<xmp>[modified request attributes (serialized for distribution): " + this.attributeBytes + "]</xmp><br>");
            } else {
                if (printWriter == null) {
                    printWriter = response.getWriter();
                }
                printWriter.println("<xmp>[modified request attributes (serialized for distribution): " + this.attributeBytes + "]</xmp><br>");
            }
        }
    }

    public byte[] generateContents() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(baos);
        this.generateFragment(baos, printStream, this.contents);
        if (this.attributes != null) {
            printStream.println("<xmp>[modified request attributes: " + this.attributes + "]</xmp><br>");
        } else if (this.attributeBytes != null) {
            printStream.println("<xmp>[modified request attributes (serialized for distribution): ");
            printStream.write(this.attributeBytes, 0, this.attributeBytes.length);
            printStream.println("]</xmp><br>");
        }
        return baos.toByteArray();
    }

    private void generateFragment(ByteArrayOutputStream baos, PrintStream printStream, Object[] contents) {
        for (int i = 0; i < contents.length; ++i) {
            Object object = contents[i];
            if (object instanceof byte[]) {
                try {
                    printStream.write((byte[])object);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.servlet.FragmentComposerMemento.generateContents", (String)"384", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"dynacache.error", (Object[])new Object[]{e.getMessage()});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("error generating contents in FCM: " + e.getMessage()), (Object[])new Object[0]);
                }
                continue;
            }
            if (object instanceof char[]) {
                try {
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF8");
                    osw.write((char[])object);
                    osw.flush();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.servlet.FragmentComposerMemento.generateContents", (String)"395", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"dynacache.error", (Object[])new Object[]{e.getMessage()});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("error generating contents in FCM: " + e.getMessage()), (Object[])new Object[0]);
                }
                continue;
            }
            if (object instanceof String) {
                printStream.println("<xmp>setContentType: " + object + "</xmp>");
                continue;
            }
            if (object instanceof ResponseSideEffect) {
                printStream.println("<xmp>sideEffect: " + object + "</xmp>");
                continue;
            }
            if (object instanceof DynamicContentProvider) {
                try {
                    printStream.println("<xmp>[DynamicContentProvider: " + object.getClass() + "]</xmp><br>");
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.servlet.FragmentComposerMemento.generateContents", (String)"395", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"dynacache.error", (Object[])new Object[]{e.getMessage()});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("error generating contents in FCM: " + e.getMessage()), (Object[])new Object[0]);
                }
                continue;
            }
            if (!(object instanceof MementoEntry)) {
                throw new IllegalStateException("each element in contents ArrayList should be a char/byte array, ResponseSideEffect, or a MementoEntry");
            }
            MementoEntry mementoEntry = (MementoEntry)object;
            if (this.consumeSubfragments && !mementoEntry.getDoNotConsume()) {
                printStream.println("<xmp>[CONSUMED include: " + mementoEntry.getTemplate() + "]</xmp><br>");
                this.generateFragment(baos, printStream, mementoEntry.contents);
                continue;
            }
            printStream.println("<xmp>[include: " + mementoEntry.getTemplate() + "]</xmp><br>");
        }
    }

    public ExternalCacheFragment getExternalCacheFragment() {
        return this.externalCacheFragment;
    }

    public void setExternalCacheFragment(ExternalCacheFragment externalCacheFragment) {
        this.externalCacheFragment = externalCacheFragment;
    }

    public String getExternalCacheGroupId() {
        return this.externalCacheGroupId;
    }

    public void setExternalCacheGroupId(String externalCacheGroupId) {
        this.externalCacheGroupId = externalCacheGroupId;
    }

    public int hashCode() {
        int hc = 0;
        for (int i = 0; i < this.contents.length; ++i) {
            Object object = this.contents[i];
            if (object instanceof byte[]) {
                hc += object.hashCode();
                continue;
            }
            if (object instanceof char[]) {
                hc += object.hashCode();
                continue;
            }
            if (object instanceof String || object instanceof ResponseSideEffect || object instanceof DynamicContentProvider || !(object instanceof MementoEntry)) continue;
            MementoEntry mementoEntry = (MementoEntry)object;
            if (!this.consumeSubfragments || mementoEntry.getDoNotConsume()) continue;
            hc += mementoEntry.hashCode();
        }
        return hc;
    }
}

