/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.tx.jta.XAResourceFactory;
import com.ibm.tx.jta.XAResourceNotAvailableException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XAReturnCodeHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import jakarta.transaction.SystemException;
import java.lang.reflect.Method;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XARminst {
    protected XAResource _XARes;
    protected Object _XAResourceFactory;
    private static final TraceComponent tc = Tr.register(XARminst.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");

    public XARminst(XAResource xaRes, Object xaResFactory) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"XARminst", (Object[])new Object[]{xaRes, xaResFactory});
        }
        this._XARes = xaRes;
        this._XAResourceFactory = xaResFactory;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"XARminst");
        }
    }

    public XAResource getXaResource() {
        return this._XARes;
    }

    public Xid[] recover() throws XAResourceNotAvailableException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover", (Object[])new Object[]{this._XARes});
        }
        Xid[] returnedXidArray = null;
        if (this._XARes != null) {
            int flags = 0x1800000;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Driving xares.recover() on resource with flags", (Object[])new Object[]{this._XARes, Util.printFlag(0x1800000)});
            }
            try {
                returnedXidArray = this._XARes.recover(0x1800000);
            }
            catch (XAException xae) {
                FFDCFilter.processException((Throwable)xae, (String)(this.getClass().getName() + ".recover"), (String)"109", (Object)this);
                int errorCode = xae.errorCode;
                if (errorCode == -7) {
                    Tr.warning((TraceComponent)tc, (String)"WTRN0037_XA_RECOVER_ERROR", (Object[])new Object[]{this._XARes, XAReturnCodeHelper.convertXACode(errorCode), xae});
                    throw new XAResourceNotAvailableException(xae);
                }
                if (errorCode == -3) {
                    Tr.error((TraceComponent)tc, (String)"WTRN0037_XA_RECOVER_ERROR", (Object[])new Object[]{this._XARes, XAReturnCodeHelper.convertXACode(errorCode), xae});
                    Class<?> c = xae.getClass();
                    if (c.getName().equals("oracle.jdbc.xa.OracleXAException")) {
                        try {
                            Method m = c.getMethod("getOracleError", null);
                            Integer result = (Integer)m.invoke(c, (Object[])null);
                            Tr.error((TraceComponent)tc, (String)"WTRN0100_GENERIC_ERROR", (Object[])new Object[]{"Oracle error returned - " + result});
                        }
                        catch (Throwable m) {
                            // empty catch block
                        }
                    }
                    throw new XAResourceNotAvailableException(xae);
                }
                if (errorCode == -5) {
                    Xid[] array1 = null;
                    Xid[] array2 = null;
                    try {
                        int x;
                        array1 = this._XARes.recover(0x1000000);
                        array2 = this._XARes.recover(0x800000);
                        if (array1 == null) {
                            array1 = new Xid[]{};
                        }
                        if (array2 == null) {
                            array2 = new Xid[]{};
                        }
                        returnedXidArray = new Xid[array1.length + array2.length];
                        for (x = 0; x < array1.length; ++x) {
                            returnedXidArray[x] = array1[x];
                        }
                        for (x = 0; x < array2.length; ++x) {
                            returnedXidArray[x + array1.length] = array2[x];
                        }
                    }
                    catch (Throwable t) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Caught exception re-driving recover", (Object[])new Object[]{t});
                        }
                        Tr.error((TraceComponent)tc, (String)"WTRN0037_XA_RECOVER_ERROR", (Object[])new Object[]{this._XARes, XAReturnCodeHelper.convertXACode(errorCode), xae});
                        throw new SystemException();
                    }
                }
                Tr.error((TraceComponent)tc, (String)"WTRN0037_XA_RECOVER_ERROR", (Object[])new Object[]{this._XARes, XAReturnCodeHelper.convertXACode(errorCode), xae});
                throw new SystemException();
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".recover"), (String)"149", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Resource {0} threw unexpected exception", (Object[])new Object[]{this._XARes, t});
                }
                throw new XAResourceNotAvailableException(new Exception(t));
            }
        }
        if (returnedXidArray == null) {
            returnedXidArray = new Xid[]{};
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recover");
        }
        return returnedXidArray;
    }

    public void rollback(Xid xid) throws XAException {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"rollback", (Object[])new Object[]{this._XARes, xid});
            }
            try {
                this._XARes.rollback(xid);
            }
            catch (XAException xae) {
                FFDCFilter.processException((Throwable)xae, (String)"com.ibm.ws.Transaction.JTA.XARminst.rollback", (String)"295", (Object)this);
                int errorCode = xae.errorCode;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("XAException: error code " + XAReturnCodeHelper.convertXACode(errorCode)), (Object[])new Object[]{xae});
                }
                if (errorCode == 6 || errorCode == 7 || errorCode == 5 || errorCode == 8) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"rollback returned heuristic", (Object[])new Object[0]);
                    }
                    try {
                        this._XARes.forget(xid);
                    }
                    catch (XAException xae2) {
                        FFDCFilter.processException((Throwable)xae2, (String)"com.ibm.ws.Transaction.JTA.XARminst.rollback", (String)"676", (Object)this);
                        errorCode = xae2.errorCode;
                        if (errorCode != -4) {
                            Tr.error((TraceComponent)tc, (String)"WTRN0054_XA_FORGET_ERROR", (Object[])new Object[]{XAReturnCodeHelper.convertXACode(errorCode), xae2});
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"rollback", (Object)xae2);
                            }
                            throw xae2;
                        }
                        break block14;
                    }
                }
                if (errorCode == -4 || errorCode == -3 || errorCode >= 100 && errorCode <= 107) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"rollback complete", (Object[])new Object[0]);
                    }
                }
                Tr.warning((TraceComponent)tc, (String)"WTRN0031_XA_ROLLBACK_FAILED", (Object[])new Object[]{xid, xae});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"rollback", (Object)xae);
                }
                throw xae;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rollback");
        }
    }

    public void closeConnection() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeConnection", (Object[])new Object[0]);
        }
        try {
            if (this._XAResourceFactory != null && this._XARes != null) {
                ((XAResourceFactory)this._XAResourceFactory).destroyXAResource(this._XARes);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.Transaction.JTA.XARminst.closeConnection", (String)"250", (Object)this);
            Tr.audit((TraceComponent)tc, (String)"WTRN0038_ERR_DESTROYING_XARESOURCE", (Object[])new Object[]{t});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeConnection");
        }
    }
}

