/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.annotation.support.async;

import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndStrategies;
import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndStrategy;
import io.opentelemetry.instrumentation.api.annotation.support.async.Jdk8AsyncOperationEndStrategy;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

final class AsyncOperationEndStrategiesImpl
extends AsyncOperationEndStrategies {
    private final List<AsyncOperationEndStrategy> strategies = new CopyOnWriteArrayList<AsyncOperationEndStrategy>();

    AsyncOperationEndStrategiesImpl() {
        this.registerStrategy(Jdk8AsyncOperationEndStrategy.INSTANCE);
    }

    @Override
    public void registerStrategy(AsyncOperationEndStrategy strategy) {
        this.strategies.add(Objects.requireNonNull(strategy));
    }

    @Override
    public void unregisterStrategy(AsyncOperationEndStrategy strategy) {
        this.strategies.remove(strategy);
    }

    @Override
    @Nullable
    public AsyncOperationEndStrategy resolveStrategy(Class<?> returnType) {
        for (AsyncOperationEndStrategy strategy : this.strategies) {
            if (!strategy.supports(returnType)) continue;
            return strategy;
        }
        return null;
    }
}

