/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.SpanSuppressor;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import java.util.Map;
import java.util.Set;

final class SpanSuppressors {
    private SpanSuppressors() {
    }

    static final class BySpanKey
    implements SpanSuppressor {
        private final Set<SpanKey> spanKeys;

        BySpanKey(Set<SpanKey> spanKeys) {
            this.spanKeys = spanKeys;
        }

        @Override
        public Context storeInContext(Context context, SpanKind spanKind, Span span) {
            for (SpanKey spanKey : this.spanKeys) {
                context = spanKey.storeInContext(context, span);
            }
            return context;
        }

        @Override
        public boolean shouldSuppress(Context parentContext, SpanKind spanKind) {
            for (SpanKey spanKey : this.spanKeys) {
                if (spanKey.fromContextOrNull(parentContext) != null) continue;
                return false;
            }
            return true;
        }
    }

    static final class DelegateBySpanKind
    implements SpanSuppressor {
        private final Map<SpanKind, SpanSuppressor> delegates;

        DelegateBySpanKind(Map<SpanKind, SpanSuppressor> delegates) {
            this.delegates = delegates;
        }

        @Override
        public Context storeInContext(Context context, SpanKind spanKind, Span span) {
            SpanSuppressor delegate = this.delegates.get((Object)spanKind);
            if (delegate == null) {
                return context;
            }
            return delegate.storeInContext(context, spanKind, span);
        }

        @Override
        public boolean shouldSuppress(Context parentContext, SpanKind spanKind) {
            SpanSuppressor delegate = this.delegates.get((Object)spanKind);
            if (delegate == null) {
                return false;
            }
            return delegate.shouldSuppress(parentContext, spanKind);
        }
    }

    static enum Noop implements SpanSuppressor
    {
        INSTANCE;


        @Override
        @CanIgnoreReturnValue
        public Context storeInContext(Context context, SpanKind spanKind, Span span) {
            return context;
        }

        @Override
        public boolean shouldSuppress(Context parentContext, SpanKind spanKind) {
            return false;
        }
    }
}

