/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.network.internal;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.network.ClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.AddressAndPort;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.FallbackAddressPortExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.NetworkAttributes;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import jakarta.annotation.Nullable;

public final class InternalClientAttributesExtractor<REQUEST, RESPONSE> {
    private final ClientAttributesGetter<REQUEST, RESPONSE> getter;
    private final FallbackAddressPortExtractor<REQUEST> fallbackAddressPortExtractor;
    private final boolean emitStableUrlAttributes;
    private final boolean emitOldHttpAttributes;

    public InternalClientAttributesExtractor(ClientAttributesGetter<REQUEST, RESPONSE> getter, FallbackAddressPortExtractor<REQUEST> fallbackAddressPortExtractor, boolean emitStableUrlAttributes, boolean emitOldHttpAttributes) {
        this.getter = getter;
        this.fallbackAddressPortExtractor = fallbackAddressPortExtractor;
        this.emitStableUrlAttributes = emitStableUrlAttributes;
        this.emitOldHttpAttributes = emitOldHttpAttributes;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        AddressAndPort clientAddressAndPort = this.extractClientAddressAndPort(request);
        if (this.emitStableUrlAttributes) {
            AttributesExtractorUtil.internalSet(attributes, NetworkAttributes.CLIENT_ADDRESS, clientAddressAndPort.address);
            if (clientAddressAndPort.port != null && clientAddressAndPort.port > 0) {
                AttributesExtractorUtil.internalSet(attributes, NetworkAttributes.CLIENT_PORT, Long.valueOf(clientAddressAndPort.port.intValue()));
            }
        }
        if (this.emitOldHttpAttributes) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_CLIENT_IP, clientAddressAndPort.address);
        }
    }

    public void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response) {
        AddressAndPort clientAddressAndPort = this.extractClientAddressAndPort(request);
        String clientSocketAddress = this.getter.getClientSocketAddress(request, response);
        Integer clientSocketPort = this.getter.getClientSocketPort(request, response);
        if (clientSocketAddress != null && !clientSocketAddress.equals(clientAddressAndPort.address)) {
            if (this.emitStableUrlAttributes) {
                AttributesExtractorUtil.internalSet(attributes, NetworkAttributes.CLIENT_SOCKET_ADDRESS, clientSocketAddress);
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_PEER_ADDR, clientSocketAddress);
            }
        }
        if (clientSocketPort != null && clientSocketPort > 0) {
            if (this.emitStableUrlAttributes && !clientSocketPort.equals(clientAddressAndPort.port)) {
                AttributesExtractorUtil.internalSet(attributes, NetworkAttributes.CLIENT_SOCKET_PORT, Long.valueOf(clientSocketPort.intValue()));
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_PEER_PORT, Long.valueOf(clientSocketPort.intValue()));
            }
        }
    }

    private AddressAndPort extractClientAddressAndPort(REQUEST request) {
        AddressAndPort addressAndPort = new AddressAndPort();
        addressAndPort.address = this.getter.getClientAddress(request);
        addressAndPort.port = this.getter.getClientPort(request);
        if (addressAndPort.address == null && addressAndPort.port == null) {
            this.fallbackAddressPortExtractor.extract(addressAndPort, request);
        }
        return addressAndPort;
    }
}

