/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.internal.cache;

import io.opentelemetry.instrumentation.api.internal.cache.MapBackedCache;
import io.opentelemetry.instrumentation.api.internal.cache.WeakLockFreeCache;
import io.opentelemetry.instrumentation.api.internal.cache.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import jakarta.annotation.Nullable;
import java.util.function.Function;

public interface Cache<K, V> {
    public static <K, V> Cache<K, V> weak() {
        return new WeakLockFreeCache();
    }

    public static <K, V> Cache<K, V> bounded(int capacity) {
        ConcurrentLinkedHashMap map = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(capacity).build();
        return new MapBackedCache(map);
    }

    public V computeIfAbsent(K var1, Function<? super K, ? extends V> var2);

    @Nullable
    public V get(K var1);

    public void put(K var1, V var2);

    public void remove(K var1);
}

