/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import io.opentelemetry.sdk.metrics.internal.state.AsynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.Measurement;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SdkObservableMeasurement
implements ObservableLongMeasurement,
ObservableDoubleMeasurement {
    private static final Logger logger = Logger.getLogger(SdkObservableMeasurement.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final InstrumentDescriptor instrumentDescriptor;
    private final List<AsynchronousMetricStorage<?, ?>> storages;
    @Nullable
    private volatile RegisteredReader activeReader;
    private volatile long startEpochNanos;
    private volatile long epochNanos;

    private SdkObservableMeasurement(InstrumentationScopeInfo instrumentationScopeInfo, InstrumentDescriptor instrumentDescriptor, List<AsynchronousMetricStorage<?, ?>> storages) {
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.instrumentDescriptor = instrumentDescriptor;
        this.storages = storages;
    }

    public static SdkObservableMeasurement create(InstrumentationScopeInfo instrumentationScopeInfo, InstrumentDescriptor instrumentDescriptor, List<AsynchronousMetricStorage<?, ?>> storages) {
        return new SdkObservableMeasurement(instrumentationScopeInfo, instrumentDescriptor, storages);
    }

    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    public void setActiveReader(RegisteredReader registeredReader, long startEpochNanos, long epochNanos) {
        this.activeReader = registeredReader;
        this.startEpochNanos = startEpochNanos;
        this.epochNanos = epochNanos;
    }

    public void unsetActiveReader() {
        this.activeReader = null;
    }

    InstrumentDescriptor getInstrumentDescriptor() {
        return this.instrumentDescriptor;
    }

    List<AsynchronousMetricStorage<?, ?>> getStorages() {
        return this.storages;
    }

    @Override
    public void record(long value) {
        this.record(value, Attributes.empty());
    }

    @Override
    public void record(long value, Attributes attributes) {
        this.doRecord(Measurement.longMeasurement(this.startEpochNanos, this.epochNanos, value, attributes));
    }

    @Override
    public void record(double value) {
        this.record(value, Attributes.empty());
    }

    @Override
    public void record(double value, Attributes attributes) {
        this.doRecord(Measurement.doubleMeasurement(this.startEpochNanos, this.epochNanos, value, attributes));
    }

    private void doRecord(Measurement measurement) {
        RegisteredReader activeReader = this.activeReader;
        if (activeReader == null) {
            this.throttlingLogger.log(Level.FINE, "Measurement recorded for instrument " + this.instrumentDescriptor.getName() + " outside callback registered to instrument. Dropping measurement.");
            return;
        }
        for (AsynchronousMetricStorage<?, ?> storage : this.storages) {
            if (!storage.getRegisteredReader().equals(activeReader)) continue;
            storage.record(measurement);
        }
    }
}

