/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.servlet.ServletContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.resteasy.cdi.CdiConstructorInjector;
import org.jboss.resteasy.cdi.CdiPropertyInjector;
import org.jboss.resteasy.cdi.ResteasyCdiExtension;
import org.jboss.resteasy.cdi.i18n.LogMessages;
import org.jboss.resteasy.cdi.i18n.Messages;
import org.jboss.resteasy.core.InjectorFactoryImpl;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ValueInjector;
import org.jboss.resteasy.spi.metadata.Parameter;
import org.jboss.resteasy.spi.metadata.ResourceClass;
import org.jboss.resteasy.spi.metadata.ResourceConstructor;
import org.jboss.resteasy.spi.metadata.ResourceLocator;

public class CdiInjectorFactory
implements InjectorFactory {
    public static final String BEAN_MANAGER_ATTRIBUTE_PREFIX = "org.jboss.weld.environment.servlet.";
    private final BeanManager manager;
    private final InjectorFactory delegate = new InjectorFactoryImpl();
    private final ResteasyCdiExtension extension;
    private final Map<Class<?>, Type> sessionBeanInterface;

    public CdiInjectorFactory() {
        this.manager = this.lookupBeanManager();
        this.extension = this.lookupResteasyCdiExtension();
        this.sessionBeanInterface = this.extension.getSessionBeanInterface();
    }

    public CdiInjectorFactory(BeanManager manager) {
        this.manager = manager;
        this.extension = this.lookupResteasyCdiExtension();
        this.sessionBeanInterface = this.extension.getSessionBeanInterface();
    }

    public ValueInjector createParameterExtractor(Parameter parameter, ResteasyProviderFactory providerFactory) {
        return this.delegate.createParameterExtractor(parameter, providerFactory);
    }

    public MethodInjector createMethodInjector(ResourceLocator method, ResteasyProviderFactory factory) {
        return this.delegate.createMethodInjector(method, factory);
    }

    public PropertyInjector createPropertyInjector(ResourceClass resourceClass, ResteasyProviderFactory providerFactory) {
        return new CdiPropertyInjector(this.delegate.createPropertyInjector(resourceClass, providerFactory), resourceClass.getClazz(), this.sessionBeanInterface, this.manager);
    }

    public ConstructorInjector createConstructor(ResourceConstructor constructor, ResteasyProviderFactory providerFactory) {
        Class clazz = constructor.getConstructor().getDeclaringClass();
        ConstructorInjector injector = this.cdiConstructor(clazz);
        if (injector != null) {
            return injector;
        }
        LogMessages.LOGGER.debug(Messages.MESSAGES.noCDIBeansFound(clazz));
        return this.delegate.createConstructor(constructor, providerFactory);
    }

    public ConstructorInjector createConstructor(Constructor constructor, ResteasyProviderFactory factory) {
        Class clazz = constructor.getDeclaringClass();
        ConstructorInjector injector = this.cdiConstructor(clazz);
        if (injector != null) {
            return injector;
        }
        LogMessages.LOGGER.debug(Messages.MESSAGES.noCDIBeansFound(clazz));
        return this.delegate.createConstructor(constructor, factory);
    }

    protected ConstructorInjector cdiConstructor(Class<?> clazz) {
        if (!this.manager.getBeans(clazz, new Annotation[0]).isEmpty()) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.usingCdiConstructorInjector(clazz));
            return new CdiConstructorInjector(clazz, this.manager);
        }
        if (this.sessionBeanInterface.containsKey(clazz)) {
            Type intfc = this.sessionBeanInterface.get(clazz);
            LogMessages.LOGGER.debug(Messages.MESSAGES.usingInterfaceForLookup(intfc, clazz));
            return new CdiConstructorInjector(intfc, this.manager);
        }
        return null;
    }

    public PropertyInjector createPropertyInjector(Class resourceClass, ResteasyProviderFactory factory) {
        return new CdiPropertyInjector(this.delegate.createPropertyInjector(resourceClass, factory), resourceClass, this.sessionBeanInterface, this.manager);
    }

    public ValueInjector createParameterExtractor(Class injectTargetClass, AccessibleObject injectTarget, String defaultName, Class type, Type genericType, Annotation[] annotations, ResteasyProviderFactory factory) {
        return this.delegate.createParameterExtractor(injectTargetClass, injectTarget, defaultName, type, genericType, annotations, factory);
    }

    public ValueInjector createParameterExtractor(Class injectTargetClass, AccessibleObject injectTarget, String defaultName, Class type, Type genericType, Annotation[] annotations, boolean useDefault, ResteasyProviderFactory factory) {
        return this.delegate.createParameterExtractor(injectTargetClass, injectTarget, defaultName, type, genericType, annotations, useDefault, factory);
    }

    protected BeanManager lookupBeanManager() {
        BeanManager beanManager = this.lookupBeanManagerInJndi("java:comp/BeanManager");
        if (beanManager != null) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.foundBeanManagerAtJavaComp());
            return beanManager;
        }
        beanManager = this.lookupBeanManagerInJndi("java:app/BeanManager");
        if (beanManager != null) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.foundBeanManagerAtJavaApp());
            return beanManager;
        }
        beanManager = CdiInjectorFactory.lookupBeanManagerCDIUtil();
        if (beanManager != null) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.foundBeanManagerViaCDI());
            return beanManager;
        }
        beanManager = CdiInjectorFactory.lookupBeanManagerViaServletContext();
        if (beanManager != null) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.foundBeanManagerInServletContext());
            return beanManager;
        }
        throw new RuntimeException(Messages.MESSAGES.unableToLookupBeanManager());
    }

    private BeanManager lookupBeanManagerInJndi(String name) {
        try {
            InitialContext ctx = new InitialContext();
            LogMessages.LOGGER.debug(Messages.MESSAGES.doingALookupForBeanManager(name));
            return (BeanManager)ctx.lookup(name);
        }
        catch (NamingException e) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.unableToObtainBeanManager(name));
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.unableToPerformJNDILookups());
            return null;
        }
    }

    private static BeanManager lookupBeanManagerViaServletContext() {
        BeanManager beanManager = null;
        try {
            ServletContext servletContext = (ServletContext)ResteasyContext.getContextData(ServletContext.class);
            if (servletContext != null) {
                beanManager = (BeanManager)servletContext.getAttribute(BEAN_MANAGER_ATTRIBUTE_PREFIX + BeanManager.class.getName());
                if (beanManager != null) {
                    LogMessages.LOGGER.debug(Messages.MESSAGES.foundBeanManagerInServletContext());
                    return beanManager;
                }
                beanManager = (BeanManager)servletContext.getAttribute(BeanManager.class.getName());
                if (beanManager != null) {
                    LogMessages.LOGGER.debug(Messages.MESSAGES.foundBeanManagerInServletContext());
                    return beanManager;
                }
            }
        }
        catch (NoClassDefFoundError e) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.unableToFindServletContextClass(), e);
        }
        catch (Exception e) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.errorOccurredLookingUpServletContext(), e);
        }
        return beanManager;
    }

    public static BeanManager lookupBeanManagerCDIUtil() {
        BeanManager bm = null;
        try {
            bm = CDI.current().getBeanManager();
        }
        catch (NoClassDefFoundError e) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.unableToFindCDIClass(), e);
        }
        catch (Exception e) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.errorOccurredLookingUpViaCDIUtil(), e);
        }
        return bm;
    }

    private ResteasyCdiExtension lookupResteasyCdiExtension() {
        Set beans = this.manager.getBeans(ResteasyCdiExtension.class, new Annotation[0]);
        Bean bean = this.manager.resolve(beans);
        if (bean == null) {
            throw new IllegalStateException(Messages.MESSAGES.unableToObtainResteasyCdiExtension());
        }
        CreationalContext context = this.manager.createCreationalContext((Contextual)bean);
        return (ResteasyCdiExtension)this.manager.getReference(bean, ResteasyCdiExtension.class, context);
    }
}

