/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.tracing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.core.Configuration;
import java.util.ArrayList;
import java.util.List;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.tracing.api.RESTEasyTracing;
import org.jboss.resteasy.tracing.api.RESTEasyTracingConfig;
import org.jboss.resteasy.tracing.api.RESTEasyTracingLevel;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class RESTEasyTracingUtils {
    static final List<String> SUMMARY_HEADERS;
    static final long serialVersionUID = -6914437081508602843L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private RESTEasyTracingUtils() {
    }

    static String getTracingThreshold(RESTEasyTracingLevel appThreshold, HttpRequest request) {
        String thresholdText = RESTEasyTracingUtils.getHeaderString(request, "X-RESTEasy-Tracing-Threshold");
        return thresholdText == null ? appThreshold.toString() : thresholdText;
    }

    static String getHeaderString(HttpRequest request, String header) {
        if (request == null) {
            return null;
        }
        if (request.getHttpHeaders() != null) {
            return request.getHttpHeaders().getHeaderString(header);
        }
        return null;
    }

    static String toStringOrNA(Object object) {
        if (object == null) {
            return "n/a";
        }
        return String.valueOf(object);
    }

    static boolean isTracingSupportEnabled(RESTEasyTracingConfig type, HttpRequest request) {
        return type == RESTEasyTracingConfig.ALL || type == RESTEasyTracingConfig.ON_DEMAND && RESTEasyTracingUtils.getHeaderString(request, "X-RESTEasy-Tracing-Accept") != null;
    }

    static RESTEasyTracingConfig getRESTEasyTracingConfig(Configuration configuration) {
        Object tracingText = configuration.getProperty("resteasy.server.tracing.type");
        RESTEasyTracingConfig result = tracingText != null ? RESTEasyTracingConfig.valueOf((String)tracingText) : RESTEasyTracingConfig.OFF;
        return result;
    }

    static String getTracingLoggerNameSuffix(HttpRequest request) {
        return RESTEasyTracingUtils.getHeaderString(request, "X-RESTEasy-Tracing-Logger");
    }

    static RESTEasyTracingLevel getRESTEasyTracingThreshold(Configuration configuration) {
        Object thresholdText = configuration.getProperty("resteasy.server.tracing.threshold");
        return thresholdText == null ? RESTEasyTracing.DEFAULT_LEVEL : RESTEasyTracingLevel.valueOf((String)thresholdText);
    }

    protected static String getTracingInfoFormat(HttpRequest request) {
        return RESTEasyTracingUtils.getHeaderString(request, "X-RESTEasy-Tracing-Accept-Format");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.tracing.RESTEasyTracingUtils", RESTEasyTracingUtils.class, null, null);
        SUMMARY_HEADERS = new ArrayList<String>();
        SUMMARY_HEADERS.add("Accept".toLowerCase());
        SUMMARY_HEADERS.add("Accept-Encoding".toLowerCase());
        SUMMARY_HEADERS.add("Accept-Charset".toLowerCase());
        SUMMARY_HEADERS.add("Accept-Language".toLowerCase());
        SUMMARY_HEADERS.add("Content-Type".toLowerCase());
        SUMMARY_HEADERS.add("Content-Length".toLowerCase());
    }
}

