/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigEvaluatorException;
import com.ibm.websphere.config.ConfigUpdateException;
import com.ibm.websphere.config.WSConfigurationHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.config.xml.internal.BundleProcessor;
import com.ibm.ws.config.xml.internal.ConfigEvaluator;
import com.ibm.ws.config.xml.internal.MetaTypeRegistry;
import com.ibm.ws.config.xml.internal.SimpleElement;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSConfigurationHelperImpl
implements WSConfigurationHelper {
    private final MetaTypeRegistry metatypeRegistry;
    private final ConfigEvaluator configEvaluator;
    private final BundleProcessor bundleProcessor;
    static final long serialVersionUID = 7392672050397403629L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public WSConfigurationHelperImpl(MetaTypeRegistry registry, ConfigEvaluator ce, BundleProcessor bundleProcessor) {
        this.metatypeRegistry = registry;
        this.configEvaluator = ce;
        this.bundleProcessor = bundleProcessor;
    }

    @Override
    public Dictionary<String, Object> getMetaTypeDefaultProperties(String factoryPid) throws ConfigEvaluatorException {
        MetaTypeRegistry.RegistryEntry registry = this.metatypeRegistry.getRegistryEntry(factoryPid);
        if (registry == null) {
            return null;
        }
        SimpleElement element = new SimpleElement(factoryPid);
        ConfigEvaluator.EvaluationResult result = this.configEvaluator.evaluate(element, registry, "", true);
        return result.getProperties();
    }

    @Override
    public void addDefaultConfiguration(String pid, Dictionary<String, String> properties) throws ConfigUpdateException {
        this.bundleProcessor.addDefaultConfiguration(pid, properties);
    }

    @Override
    public void addDefaultConfiguration(InputStream defaultConfig) throws ConfigUpdateException {
        this.bundleProcessor.addDefaultConfiguration(defaultConfig);
    }

    @Override
    public boolean removeDefaultConfiguration(String pid) throws ConfigUpdateException {
        return this.bundleProcessor.removeDefaultConfiguration(pid);
    }

    @Override
    public boolean removeDefaultConfiguration(String pid, String id) throws ConfigUpdateException {
        return this.bundleProcessor.removeDefaultConfiguration(pid, id);
    }

    @Override
    @Trivial
    public Object convert(String pid, String attributeID, String strVal) {
        ExtendedAttributeDefinition ad;
        Map<String, ExtendedAttributeDefinition> attributeMap;
        MetaTypeRegistry.RegistryEntry ent = this.metatypeRegistry.getRegistryEntryByPidOrAlias(pid);
        if (ent != null && (attributeMap = ent.getAttributeMap()) != null && (ad = attributeMap.get(attributeID)) != null) {
            int type = ad.getType();
            try {
                if (type == 11) {
                    return Boolean.valueOf(strVal);
                }
                if (type == 6) {
                    return Byte.valueOf(strVal);
                }
                if (type == 5) {
                    return Character.valueOf(strVal.charAt(0));
                }
                if (type == 7) {
                    return Double.valueOf(strVal);
                }
                if (type == 8) {
                    return Float.valueOf(strVal);
                }
                if (type == 3) {
                    return Integer.valueOf(strVal);
                }
                if (type == 2) {
                    return Long.valueOf(strVal);
                }
                if (type == 4) {
                    return Short.valueOf(strVal);
                }
                if (type == 1000) {
                    return MetatypeUtils.evaluateDuration((String)strVal, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                if (type == 1004) {
                    return MetatypeUtils.evaluateDuration((String)strVal, (TimeUnit)TimeUnit.SECONDS);
                }
                if (type == 1005) {
                    return MetatypeUtils.evaluateDuration((String)strVal, (TimeUnit)TimeUnit.MINUTES);
                }
                if (type == 1006) {
                    return MetatypeUtils.evaluateDuration((String)strVal, (TimeUnit)TimeUnit.HOURS);
                }
                if (ad.isObscured() || type == 1003 || type == 1008) {
                    return new SerializableProtectedString(strVal.toCharArray());
                }
                if (type == 1007) {
                    return Enum.valueOf(OnErrorUtil.OnError.class, strVal.trim().toUpperCase());
                }
                if (type == 1012) {
                    return MetatypeUtils.evaluateToken((String)strVal);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.xml.internal.WSConfigurationHelperImpl", (String)"142", (Object)this, (Object[])new Object[]{pid, attributeID, strVal});
            }
        }
        return strVal;
    }

    @Override
    @Trivial
    public Integer getMetaTypeAttributeCardinality(String pid, String attributeID) {
        return this.metatypeRegistry.getAttributeCardinality(pid, attributeID);
    }

    @Override
    public String getMetaTypeAttributeName(String pid, String attributeID) {
        return this.metatypeRegistry.getAttributeName(pid, attributeID);
    }

    @Override
    public String getMetaTypeElementName(String pid) {
        return this.metatypeRegistry.getElementName(pid);
    }

    @Override
    public boolean registryEntryExists(String pid) {
        return this.metatypeRegistry.getRegistryEntryByPidOrAlias(pid) != null;
    }

    @Override
    public String aliasFor(String pid, String baseAlias) {
        MetaTypeRegistry.RegistryEntry ent = this.metatypeRegistry.getRegistryEntryByPidOrAlias(pid);
        String alias = ent.getAlias();
        if (alias != null) {
            return alias;
        }
        String extendsAlias = ent.getExtendsAlias();
        if (extendsAlias == null) {
            return baseAlias;
        }
        if (extendsAlias.startsWith("!")) {
            return extendsAlias.substring(1);
        }
        return baseAlias == null ? extendsAlias : baseAlias + "." + extendsAlias;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.WSConfigurationHelperImpl", WSConfigurationHelperImpl.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    }
}

