/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.processor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class QualifierProxy
implements InvocationHandler {
    private static final TraceComponent tc = Tr.register(QualifierProxy.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.resources.CWWKCMessages");
    private final int hashCode;
    private final List<Method> methods;
    private final Class<?> qualifierClass;
    private final String stringValue;
    static final long serialVersionUID = 2382228557152725214L;

    QualifierProxy(Class<?> qualifierClass) {
        this.qualifierClass = qualifierClass;
        String qualifierClassName = qualifierClass.getName();
        Method[] m = qualifierClass.getMethods();
        this.methods = new ArrayList<Method>(m.length - 4);
        int hash = 0;
        StringBuilder s = new StringBuilder(m.length * 30 + qualifierClassName.length()).append('@').append(qualifierClassName).append('(');
        boolean first = true;
        for (Method method : m) {
            int h;
            Object[] array;
            String name;
            if (method.getParameterCount() != 0 || "annotationType".equals(name = method.getName()) || "hashCode".equals(name) || "toString".equals(name)) continue;
            this.methods.add(method);
            Object value = method.getDefaultValue();
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            s.append(name).append('=');
            if (value instanceof Object[]) {
                array = (Object[])value;
                h = Arrays.hashCode(array);
                s.append(Arrays.toString(array));
            } else if (value instanceof int[]) {
                array = (int[])value;
                h = Arrays.hashCode((int[])array);
                s.append(Arrays.toString((int[])array));
            } else if (value instanceof long[]) {
                array = (long[])value;
                h = Arrays.hashCode((long[])array);
                s.append(Arrays.toString((long[])array));
            } else if (value instanceof boolean[]) {
                array = (boolean[])value;
                h = Arrays.hashCode((boolean[])array);
                s.append(Arrays.toString((boolean[])array));
            } else if (value instanceof double[]) {
                array = (double[])value;
                h = Arrays.hashCode((double[])array);
                s.append(Arrays.toString((double[])array));
            } else if (value instanceof float[]) {
                array = (float[])value;
                h = Arrays.hashCode((float[])array);
                s.append(Arrays.toString((float[])array));
            } else if (value instanceof short[]) {
                array = (short[])value;
                h = Arrays.hashCode((short[])array);
                s.append(Arrays.toString((short[])array));
            } else if (value instanceof byte[]) {
                array = (byte[])value;
                h = Arrays.hashCode((byte[])array);
                s.append(Arrays.toString((byte[])array));
            } else if (value instanceof char[]) {
                array = (char[])value;
                h = Arrays.hashCode((char[])array);
                s.append(Arrays.toString((char[])array));
            } else {
                h = value.hashCode();
                s.append(value);
            }
            hash += 127 * name.hashCode() ^ h;
        }
        this.stringValue = s.append(")[QualifierProxy]").toString();
        this.hashCode = hash;
    }

    @ManualTrace
    private boolean equals(Object proxy, Object other) {
        boolean equal;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"equals", (Object[])new Object[]{proxy == null ? null : proxy.toString(), other == null ? null : other.toString()});
        }
        if (proxy == other) {
            equal = true;
        } else if (this.qualifierClass.isInstance(other)) {
            try {
                InvocationHandler otherHandler;
                boolean isProxy = Proxy.isProxyClass(other.getClass());
                InvocationHandler invocationHandler = otherHandler = isProxy ? Proxy.getInvocationHandler(other) : null;
                if (otherHandler instanceof QualifierProxy) {
                    equal = ((QualifierProxy)otherHandler).qualifierClass.equals(this.qualifierClass);
                }
                if (this.methods.size() == 0) {
                    equal = true;
                }
                equal = true;
                for (Method method : this.methods) {
                    Object value1 = method.getDefaultValue();
                    Object value2 = method.invoke(other, new Object[0]);
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("comparing " + method.getName()), (Object[])new Object[]{value1, value2});
                    }
                    if (equal = value1 instanceof Object[] ? Arrays.equals((Object[])value1, (Object[])value2) : (value1 instanceof int[] ? Arrays.equals((int[])value1, (int[])value2) : (value1 instanceof long[] ? Arrays.equals((long[])value1, (long[])value2) : (value1 instanceof boolean[] ? Arrays.equals((boolean[])value1, (boolean[])value2) : (value1 instanceof double[] ? Arrays.equals((double[])value1, (double[])value2) : (value1 instanceof float[] ? Arrays.equals((float[])value1, (float[])value2) : (value1 instanceof short[] ? Arrays.equals((short[])value1, (short[])value2) : (value1 instanceof byte[] ? Arrays.equals((byte[])value1, (byte[])value2) : (value1 instanceof char[] ? Arrays.equals((char[])value1, (char[])value2) : Objects.equals(value1, value2)))))))))) continue;
                }
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        } else {
            equal = false;
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"equals", (Object)equal);
        }
        return equal;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        int numParams = method.getParameterCount();
        if (numParams == 0 && "hashCode".equals(methodName)) {
            return this.hashCode;
        }
        if (numParams == 0 && "toString".equals(methodName)) {
            return this.stringValue;
        }
        if (numParams == 0 && "annotationType".equals(methodName)) {
            return this.qualifierClass;
        }
        if (numParams == 1 && "equals".equals(methodName)) {
            return this.equals(proxy, args[0]);
        }
        return method.getDefaultValue();
    }
}

