/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.rmi.CORBA.Util;
import org.apache.yoko.rmi.impl.MethodDescriptor;
import org.apache.yoko.rmi.impl.RMIPersistentStub;
import org.apache.yoko.rmi.impl.RMIServant;
import org.apache.yoko.rmi.impl.RMIState;
import org.apache.yoko.rmi.impl.RMIStub;
import org.apache.yoko.rmi.impl.StubHandler;
import org.apache.yoko.util.Streams;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ServantObject;
import org.omg.CORBA.portable.UnknownException;

public class RMIStubHandler
implements StubHandler,
Serializable {
    static final Logger logger = Logger.getLogger(RMIStubHandler.class.getName());
    static final RMIStubHandler instance = new RMIStubHandler();

    protected RMIStubHandler() {
    }

    @Override
    public Object stubWriteReplace(RMIStub stub) {
        return new RMIPersistentStub(stub, stub._descriptor.type);
    }

    @Override
    public Object invoke(RMIStub stub, MethodDescriptor method, Object[] args) throws Throwable {
        if (null == method) {
            return this.stubWriteReplace(stub);
        }
        String method_name = method.getIDLName();
        logger.finer("invoking " + method_name);
        return stub._is_local() ? this.invokeLocal(stub, method, args, method_name) : this.invokeRemote(stub, method, args, method_name);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object invokeRemote(RMIStub stub, MethodDescriptor method, Object[] args, String method_name) throws Throwable {
        while (true) {
            InputStream in = null;
            try {
                OutputStream out = stub._request(method_name, method.responseExpected());
                method.writeArguments(out, args);
                in = stub._invoke(out);
                Object object = method.readResult(in);
                stub._releaseReply(in);
                return object;
            }
            catch (RemarshalException out) {
                stub._releaseReply(in);
                continue;
                catch (ApplicationException ex) {
                    try {
                        method.readException(ex.getInputStream());
                        continue;
                    }
                    catch (Throwable exx) {
                        logger.log(Level.FINE, "rmi1::" + method_name + " " + exx.getMessage(), exx);
                        throw RMIStubHandler.addLocalTrace(method, exx);
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    catch (UnknownException ex2) {
                        logger.log(Level.FINER, "rmi2::" + method_name + " " + ex2.getMessage(), ex2);
                        logger.log(Level.FINER, "rmi2::" + method_name + " " + ex2.originalEx.getMessage(), ex2.originalEx);
                        throw RMIStubHandler.addLocalTrace(method, ex2.originalEx);
                        catch (SystemException ex3) {
                            RemoteException exx = Util.mapSystemException((SystemException)ex3);
                            logger.log(Level.FINER, "rmi3::" + method_name + " " + exx.getMessage(), exx);
                            throw exx;
                        }
                        catch (Throwable ex4) {
                            logger.log(Level.FINER, "rmi4::" + method_name + " " + ex4.getMessage(), ex4);
                            throw ex4;
                        }
                    }
                }
            }
            finally {
                stub._releaseReply(in);
                continue;
            }
            break;
        }
    }

    private Object invokeLocal(RMIStub stub, MethodDescriptor method, Object[] args, String method_name) throws Throwable {
        ServantObject so = stub._servant_preinvoke(method_name, RMIServant.class);
        if (!(so.servant instanceof RMIServant)) {
            return this.invokeRemote(stub, method, args, method_name);
        }
        RMIServant servant = (RMIServant)so.servant;
        RMIState target_state = servant.getRMIState();
        ORB orb = target_state.getORB();
        RMIState currentState = RMIState.current();
        boolean same_state = currentState == target_state;
        try {
            Method m = method.getReflectedMethod();
            Object return_value = servant.invoke_method(m, method.copyArguments(args, same_state, orb));
            Object object = method.copyResult(return_value, same_state, orb);
            return object;
        }
        catch (SystemException ex) {
            throw Util.mapSystemException((SystemException)ex);
        }
        finally {
            stub._servant_postinvoke(so);
        }
    }

    private static Throwable addLocalTrace(MethodDescriptor desc, Throwable ex) {
        Method m = desc.getReflectedMethod();
        StackTraceElement separatorElement = new StackTraceElement(m.getDeclaringClass().getName(), m.getName(), "--- RMI/IIOP INVOCATION ---", -2000);
        Throwable lex = new Throwable("Client-Side RMI Trace");
        StackTraceElement[] combinedTrace = (StackTraceElement[])Streams.concatStreams((Stream[])new Stream[]{Arrays.stream(ex.getStackTrace()), Stream.of(separatorElement), ((Stream)Arrays.stream(lex.getStackTrace()).sequential()).skip(1L)}).toArray(StackTraceElement[]::new);
        ex.setStackTrace(combinedTrace);
        return ex;
    }
}

