/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.BaseDestination;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.Controllable;
import com.ibm.ws.sib.admin.ControllableRegistrationService;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsEngineComponent;
import com.ibm.ws.sib.admin.JsMEConfig;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.LWMConfig;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.admin.SIBFileStore;
import com.ibm.ws.sib.admin.SIBPersistenceException;
import com.ibm.ws.sib.admin.SIBTransactionException;
import com.ibm.ws.sib.admin.internal.JsAdminFactory;
import com.ibm.ws.sib.admin.internal.JsBusImpl;
import com.ibm.ws.sib.admin.internal.JsDestinationCache;
import com.ibm.ws.sib.admin.internal.JsLocalizer;
import com.ibm.ws.sib.admin.internal.JsMainImpl;
import com.ibm.ws.sib.admin.internal.SIBFileStoreImpl;
import com.ibm.ws.sib.comms.server.ServerCommsDiagnosticDump;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.processor.Administrator;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;

public class BaseMessagingEngineImpl
implements JsEngineComponent,
LWMConfig,
Controllable {
    private static final TraceComponent tc = SibTr.register(BaseMessagingEngineImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.internal.BaseMessagingEngineImpl";
    private boolean _sentServerStarted = false;
    private volatile boolean _sentServerStopping = false;
    private final JsDestinationCache oldDestCache = null;
    protected SIBFileStoreImpl _fs = null;
    protected static final int STATE_UNINITIALIZED = 0;
    protected static final int STATE_INITIALIZING = 1;
    protected static final int STATE_INITIALIZED = 2;
    protected static final int STATE_JOINING = 3;
    protected static final int STATE_JOINED = 4;
    protected static final int STATE_AUTOSTARTING = 5;
    protected static final int STATE_STARTING = 6;
    protected static final int STATE_STARTED = 7;
    protected static final int STATE_STOPPING = 8;
    protected static final int STATE_STOPPING_MEMBER = 9;
    protected static final int STATE_STOPPED = 10;
    protected static final int STATE_DESTROYING = 11;
    protected static final int STATE_DESTROYED = 12;
    protected static final int STATE_FAILED = 13;
    protected String[] states = new String[]{"Uninitialized", "Initializing", "Initialized", "Joining", "Joined", "Autostarting", "Starting", "Started", "Stopping", "StoppingMember", "Stopped", "Destroying", "Destroyed", "Failed!"};
    protected int _state = 0;
    protected CopyOnWriteArrayList<ComponentList> jmeComponents = new CopyOnWriteArrayList();
    protected Object stateChangeLock = new Object(){};
    protected static final int NUM_STOP_PHASES = 5;
    protected static final int STOP_PHASE_0 = 0;
    protected static final int STOP_PHASE_1 = 1;
    protected static final int STOP_PHASE_2 = 2;
    protected static final int STOP_PHASE_3 = 3;
    protected static final int STOP_PHASE_4 = 4;
    protected Vector<ComponentList>[] stopSequence = new Vector[5];
    protected JsMainImpl _mainImpl;
    protected JsAdminFactory jsaf = null;
    protected JsBusImpl _bus;
    protected JsMEConfig _me = null;
    protected String _name;
    protected String _uuid = null;
    protected Administrator _mpAdmin = null;
    protected JsEngineComponent _messageProcessor;
    protected MessageStore _messageStore;
    protected JsEngineComponent _trm;
    protected JsLocalizer _localizer = null;
    private final ArrayList _lpConfig = new ArrayList();
    protected ControllableRegistrationService _mbeanFactory;
    protected String dumpDir = null;
    private final Object lockObject = new Object(){};
    protected long meHighMessageThreshold;

    public BaseMessagingEngineImpl(JsMainImpl mainImpl, JsBusImpl bus, JsMEConfig me) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"BaseMessagingEngineImpl", (Object)new Object[]{mainImpl, bus, me});
        }
        this._mainImpl = mainImpl;
        this._bus = bus;
        this._me = me;
        this._name = me.getMessagingEngine().getName();
        SIBFileStore filestore = me.getSibFilestore();
        if (filestore == null) {
            this._fs = new SIBFileStoreImpl();
        } else {
            this._fs = new SIBFileStoreImpl();
            this._fs.setMaxPermanentFileStoreSize(filestore.getMaxPermanentFileStoreSize());
            this._fs.setMaxTemporaryFileStoreSize(filestore.getMaxTemporaryFileStoreSize());
            this._fs.setMinPermanentFileStoreSize(filestore.getMinPermanentFileStoreSize());
            this._fs.setMinTemporaryFileStoreSize(filestore.getMinTemporaryFileStoreSize());
            this._fs.setUnlimitedPermanentStoreSize(filestore.isUnlimitedPermanentStoreSize());
            this._fs.setUnlimitedTemporaryStoreSize(filestore.isUnlimitedTemporaryStoreSize());
            this._fs.setPath(filestore.getPath());
            this._fs.setLogFileSize(filestore.getLogFileSize());
        }
        this._localizer = new JsLocalizer(this);
        HashMap lpList = me.getMessagingEngine().getSibLocalizationPointList();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"BaseMessagingEngineImpl", (Object)this);
        }
    }

    public ControllableRegistrationService getMBeanFactory() {
        String thisMethodName = "getMBeanFactory";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName);
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)this._mbeanFactory);
        }
        return this._mbeanFactory;
    }

    public void initialize(JsMessagingEngine engine) throws Exception {
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)"com.ibm.ws.sib.admin.internal.BaseMessagingEngineImpl: a subclass has not overriden initialize()");
    }

    public void start(int mode) throws Exception {
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)"com.ibm.ws.sib.admin.internal.BaseMessagingEngineImpl: a subclass has not overriden start()");
    }

    public void start() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Start ME, mode defaulting to ME_START_DEFAULT");
        }
        this.start(0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void start(String mode) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start", (Object)mode);
        }
        this.start();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void startConditional() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startConditional", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Activating MBean for ME " + this.getName()));
        }
        this.setState(6);
        this.start(0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startConditional");
        }
    }

    public final void serverStarted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"serverStarted", (Object)this);
        }
        if (this.okayToSendServerStarted()) {
            Iterator<ComponentList> vIter = this.jmeComponents.iterator();
            while (vIter.hasNext()) {
                vIter.next().getRef().serverStarted();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"serverStarted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean okayToSendServerStarted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"okayToSendServerStarted", (Object)this);
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (!this._sentServerStarted && this._state == 7 && this._mainImpl.isServerStarted()) {
                this._sentServerStarted = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"okayToSendServerStarted", (Object)new Boolean(this._sentServerStarted));
        }
        return this._sentServerStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean okayToSendServerStopping() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"okayToSendServerStopping", (Object)this);
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (!this._sentServerStopping && (this._state == 7 || this._state == 5 || this._state == 6) && this._mainImpl.isServerStopping()) {
                this._sentServerStopping = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"okayToSendServerStopping", (Object)new Boolean(this._sentServerStopping));
        }
        return this._sentServerStopping;
    }

    public final void serverStopping() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"serverStopping", (Object)this);
        }
        if (this.okayToSendServerStopping()) {
            Iterator<ComponentList> vIter = this.jmeComponents.iterator();
            while (vIter.hasNext()) {
                vIter.next().getRef().serverStopping();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"serverStopping");
        }
    }

    public void stop(int mode) {
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)"com.ibm.ws.sib.admin.internal.BaseMessagingEngineImpl: a subclass has not overriden stop()");
    }

    public void stop() {
        String thisMethodName = "stop";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
        }
        if (this._state == 8) {
            SibTr.error((TraceComponent)tc, (String)"ME_STATE_CHECK_SIAS0028", (Object)new Object[]{this._name, this.getState()});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"stop");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Stop ME, mode defaulting to ME_STOP_IMMEDIATE");
        }
        this.stop(0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public void stop(String mode) {
        String thisMethodName = "stop";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)mode);
        }
        this.stop();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public void stopConditional(int mode) {
        String thisMethodName = "stopConditional";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)Integer.toString(mode));
        }
        this.setState(8);
        this.stop(mode);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Deactivating MBean for ME " + this.getName()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public void destroy() {
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)"com.ibm.ws.sib.admin.internal.BaseMessagingEngineImpl: a subclass has not overriden destroy()");
    }

    public final boolean datastoreExists() {
        String thisMethodName = "datastoreExists";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)new Boolean(false));
        }
        return false;
    }

    public final boolean filestoreExists() {
        String thisMethodName = "filestoreExists";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)new Boolean(false));
        }
        return true;
    }

    public final LWMConfig getBus() {
        String thisMethodName = "getBus";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
        return this._bus;
    }

    public final String getBusName() {
        String thisMethodName = "getBusName";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
        }
        String retVal = this._bus.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)retVal);
        }
        return retVal;
    }

    public final int getMessageStoreType() {
        String thisMethodName = "getMessageStoreType";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
        }
        int msType = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)new Integer(msType));
        }
        return msType;
    }

    public final LWMConfig getDatastore() {
        String thisMethodName = "getDatastore";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, null);
        }
        return null;
    }

    public final LWMConfig getFilestore() {
        String thisMethodName = "getFilestore";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)this._fs);
        }
        return this._fs;
    }

    public JsEngineComponent getEngineComponent(String className) {
        String thisMethodName = "getEngineComponent";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)className);
        }
        JsEngineComponent foundEngineComponent = null;
        Iterator<ComponentList> vIter = this.jmeComponents.iterator();
        while (vIter.hasNext() && foundEngineComponent == null) {
            ComponentList c = vIter.next();
            if (!c.getClassName().equals(className)) continue;
            foundEngineComponent = c.getRef();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, foundEngineComponent);
        }
        return foundEngineComponent;
    }

    public <EngineComponent> EngineComponent getEngineComponent(Class<EngineComponent> clazz) {
        String thisMethodName = "getEngineComponent";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, clazz);
        }
        JsEngineComponent foundEngineComponent = null;
        Iterator<ComponentList> vIter = this.jmeComponents.iterator();
        while (vIter.hasNext() && foundEngineComponent == null) {
            ComponentList c = vIter.next();
            if (!clazz.isInstance(c.getRef())) continue;
            foundEngineComponent = c.getRef();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, foundEngineComponent);
        }
        return (EngineComponent)foundEngineComponent;
    }

    public <EngineComponent> EngineComponent[] getEngineComponents(Class<EngineComponent> clazz) {
        String thisMethodName = "getEngineComponents";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, clazz);
        }
        ArrayList<JsEngineComponent> foundComponents = new ArrayList<JsEngineComponent>();
        Iterator<ComponentList> vIter = this.jmeComponents.iterator();
        while (vIter.hasNext()) {
            JsEngineComponent ec = vIter.next().getRef();
            if (!clazz.isInstance(ec)) continue;
            foundComponents.add(ec);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, foundComponents);
        }
        return foundComponents.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public final Object getEObject() {
        String thisMethodName = "getEObject";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)this._me);
        }
        return this._me;
    }

    public final JsMEConfig getMeConfig() {
        String thisMethodName = "getMeConfig";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)this._me);
        }
        return this._me;
    }

    public JsEngineComponent getMessageProcessor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageProcessor", (Object)this);
            SibTr.exit((TraceComponent)tc, (String)"getMessageProcessor", (Object)this._messageProcessor);
        }
        return this._messageProcessor;
    }

    public JsEngineComponent getTRMComponent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTRMComponent", (Object)this);
            SibTr.exit((TraceComponent)tc, (String)"getTRMComponent", (Object)this._trm);
        }
        return this._trm;
    }

    @Deprecated
    public JsEngineComponent getMessageProcessor(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageProcessor", (Object)this);
            SibTr.exit((TraceComponent)tc, (String)"getMessageProcessor", (Object)this._messageProcessor);
        }
        return this._messageProcessor;
    }

    public Object getMessageStore() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageStore", (Object)this);
            SibTr.exit((TraceComponent)tc, (String)"getMessageStore", null);
        }
        return this._messageStore;
    }

    public LWMConfig getMQClientLink(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQClientLink", (Object)name);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMQClientLink", null);
        }
        return null;
    }

    public LWMConfig getMQLink(String name) {
        String thisMethodName = "getMQLink";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)name);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, null);
        }
        return null;
    }

    public JsEngineComponent getMQLinkEngineComponent(String name) {
        String thisMethodName = "getMQLinkEngineComponent";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)name);
        }
        JsEngineComponent rc = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, rc);
        }
        return rc;
    }

    public LWMConfig getGatewayLink(String name) {
        String thisMethodName = "getGatewayLink";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)name);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
        return null;
    }

    public JsEngineComponent getGatewayLinkEngineComponent(String name) {
        String thisMethodName = "getGatewayLinkEngineComponent";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)name);
        }
        JsEngineComponent rc = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, rc);
        }
        return rc;
    }

    public String getName() {
        String thisMethodName = "getName";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)this._name);
        }
        return this._name;
    }

    private void resolveExceptionDestination(BaseDestinationDefinition dd) {
        String ed;
        String thisMethodName = "resolveExceptionDestination";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)dd.getName());
        }
        if (dd.isLocal() && (ed = ((DestinationDefinition)dd).getExceptionDestination()) != null && ed.equals("$DEFAULT_EXCEPTION_DESTINATION")) {
            ((DestinationDefinition)dd).setExceptionDestination("_SYSTEM.Exception.Destination." + this.getName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public void getSIBDestination(String busName, String name, DestinationDefinition dd) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        String thisMethodName = "getSIBDestination";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)new Object[]{busName, name, dd.getName()});
        }
        if (this.oldDestCache == null) {
            this._bus.getDestinationCache().getSIBDestination(busName, name, dd);
        } else {
            this.oldDestCache.getSIBDestination(busName, name, dd);
        }
        this.resolveExceptionDestination((BaseDestinationDefinition)dd);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public BaseDestinationDefinition getSIBDestination(String busName, String name) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        String thisMethodName = "getSIBDestination";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)new Object[]{busName, name});
        }
        BaseDestinationDefinition bdd = null;
        bdd = this.oldDestCache == null ? (BaseDestinationDefinition)this._bus.getDestinationCache().getSIBDestination(busName, name).clone() : (BaseDestinationDefinition)this.oldDestCache.getSIBDestination(busName, name).clone();
        this.resolveExceptionDestination(bdd);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)bdd);
        }
        return bdd;
    }

    public BaseDestinationDefinition getSIBDestinationByUuid(String busName, String uuid) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        String thisMethodName = "getSIBDestinationByUuid";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)new Object[]{busName, uuid});
        }
        BaseDestinationDefinition bdd = this.getSIBDestinationByUuid(busName, uuid, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)bdd);
        }
        return bdd;
    }

    BaseDestinationDefinition getSIBDestinationByUuid(String bus, String key, boolean newCache) throws SIBExceptionDestinationNotFound, SIBExceptionBase {
        String thisMethodName = "getSIBDestinationByUuid";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)new Object[]{bus, key, new Boolean(newCache)});
        }
        BaseDestinationDefinition bdd = null;
        bdd = this.oldDestCache == null || newCache ? (BaseDestinationDefinition)this._bus.getDestinationCache().getSIBDestinationByUuid(bus, key).clone() : (BaseDestinationDefinition)this.oldDestCache.getSIBDestinationByUuid(bus, key).clone();
        this.resolveExceptionDestination(bdd);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)bdd);
        }
        return bdd;
    }

    public Set getSIBDestinationLocalitySet(String busName, String uuid, boolean newCache) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        String thisMethodName = "getSIBDestinationLocalitySet";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)new Object[]{busName, uuid, new Boolean(newCache)});
        }
        if (this.oldDestCache == null || newCache) {
            Set retVal = this._bus.getDestinationCache().getSIBDestinationLocalitySet(busName, uuid);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getSIBDestinationLocalitySet", (Object)retVal);
            }
            return retVal;
        }
        Set retVal = this.oldDestCache.getSIBDestinationLocalitySet(busName, uuid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)retVal);
        }
        return retVal;
    }

    public Set getSIBDestinationLocalitySet(String busName, String uuid) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        String thisMethodName = "getSIBDestinationLocalitySet";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)new Object[]{busName, uuid});
        }
        Set retVal = this.getSIBDestinationLocalitySet(busName, uuid, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)retVal);
        }
        return retVal;
    }

    public final String getState() {
        String thisMethodName = "getState";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)this.states[this._state]);
        }
        return this.states[this._state];
    }

    public String getUuid() {
        String thisMethodName = "getUuid";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)this._uuid);
        }
        return this._uuid;
    }

    public final boolean isStarted() {
        boolean retVal;
        String thisMethodName = "isStarted";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
        }
        boolean bl = retVal = this._state == 7;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)Boolean.toString(retVal));
        }
        return retVal;
    }

    public final void loadLocalizations() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"loadLocalizations", (Object)this);
        }
        this._localizer.loadLocalizations();
        try {
            this.setJsDestinationUUIDCache(this._localizer.updatedDestDefList);
        }
        catch (Exception e) {
            SibTr.entry((TraceComponent)tc, (String)"Exception while updating UUID Destination Cache in ", (Object)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"loadLocalizations");
        }
    }

    private int setJsDestinationUUIDCache(ArrayList list) throws Exception {
        SibTr.entry((TraceComponent)tc, (String)"setJsDestinationUUIDCache");
        int result = 0;
        try {
            JsDestinationCache dCache = this._bus.getDestinationCache();
            dCache.populateUuidCache(list);
            result = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            SibTr.error((TraceComponent)tc, (String)"Exception during UUID cache update after loadlocalizations");
        }
        SibTr.exit((TraceComponent)tc, (String)"setJsDestinationUUIDCache");
        return result;
    }

    public void setConfig(LWMConfig me) {
        String thisMethodName = "setConfig";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)new Object[]{me});
        }
        this.meHighMessageThreshold = this._me.getMessagingEngine().getHighMessageThreshold();
        Iterator<ComponentList> vIter = this.jmeComponents.iterator();
        while (vIter.hasNext()) {
            vIter.next().getRef().setConfig(me);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    protected final void setState(int state) {
        String thisMethodName = "setState";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)Integer.toString(state));
        }
        this._state = state;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public final String state() {
        String thisMethodName = "state";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
        }
        String state = this.getState();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)state);
        }
        return state;
    }

    final boolean addLocalizationPoint(LWMConfig lp, DestinationDefinition dd) {
        String thisMethodName = "addLocalizationPoint";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)lp);
        }
        boolean success = this._localizer.addLocalizationPoint(lp, dd);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)success);
        }
        return success;
    }

    final void alterLocalizationPoint(BaseDestination dest, LWMConfig lp) {
        String thisMethodName = "alterLocalizationPoint";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)lp);
        }
        try {
            this._localizer.alterLocalizationPoint(dest, lp);
        }
        catch (Exception e) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    final void deleteLocalizationPoint(JsBus bus, LWMConfig dest) {
        String thisMethodName = "deleteLocalizationPoint";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)dest);
        }
        try {
            this._localizer.deleteLocalizationPoint(bus, dest);
        }
        catch (SIBExceptionBase ex) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)ex));
        }
        catch (SIException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    final ArrayList getLPConfigObjects() {
        String thisMethodName = "getLPConfigObjects";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)this._lpConfig);
        }
        return this._lpConfig;
    }

    final void setLPConfigObjects(List config) {
        String thisMethodName = "setLPConfigObjects";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)("Number of LPs =" + config.size()));
        }
        this._lpConfig.clear();
        this._lpConfig.addAll(config);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public boolean isEventNotificationPropertySet() {
        String thisMethodName = "isEventNotificationPropertySet";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
        }
        boolean enabled = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)Boolean.toString(enabled));
        }
        return enabled;
    }

    public JsMainImpl getMainImpl() {
        String thisMethodName = "getMainImpl";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)this._mainImpl);
        }
        return this._mainImpl;
    }

    public void setMEUUID(SIBUuid8 uuid) {
        this._me.getMessagingEngine().setUuid(uuid.toString());
        this._uuid = uuid.toString();
    }

    public void busReloaded(Object newBus, boolean busChanged, boolean destChg, boolean medChg) {
    }

    public void engineReloaded(Object engine) {
    }

    public void setCustomProperty(String name, String value) {
    }

    protected final JsEngineComponent loadClass(String className, int stopSeq, boolean reportError) {
        JsEngineComponent retValue;
        String thisMethodName;
        block14: {
            thisMethodName = "loadClass";
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)new Object[]{className, Integer.toString(stopSeq), Boolean.toString(reportError)});
            }
            Class<?> myClass = null;
            retValue = null;
            int _seq = stopSeq;
            if (_seq < 0 || _seq > 5) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("loadClass: stopSeq is out of bounds " + stopSeq));
                }
            } else {
                try {
                    myClass = Class.forName(className);
                    retValue = (JsEngineComponent)myClass.newInstance();
                    ComponentList compList = new ComponentList(className, retValue);
                    this.jmeComponents.add(compList);
                    this.stopSequence[_seq].addElement(compList);
                }
                catch (ClassNotFoundException e) {
                    if (reportError) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.internal.BaseMessagingEngineImpl.loadClass", (String)"3", (Object)this);
                        SibTr.error((TraceComponent)tc, (String)"CLASS_LOAD_FAILURE_SIAS0013", (Object)className);
                        SibTr.exception((TraceComponent)tc, (Exception)e);
                    }
                }
                catch (InstantiationException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.internal.BaseMessagingEngineImpl.loadClass", (String)"1", (Object)this);
                    if (reportError) {
                        SibTr.error((TraceComponent)tc, (String)"CLASS_LOAD_FAILURE_SIAS0013", (Object)className);
                        SibTr.exception((TraceComponent)tc, (Exception)e);
                    }
                }
                catch (Throwable e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.internal.BaseMessagingEngineImpl.loadClass", (String)"2", (Object)this);
                    if (!reportError) break block14;
                    SibTr.error((TraceComponent)tc, (String)"CLASS_LOAD_FAILURE_SIAS0013", (Object)className);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (retValue == null) {
                SibTr.debug((TraceComponent)tc, (String)"loadClass: failed");
            } else {
                SibTr.debug((TraceComponent)tc, (String)"loadClass: OK");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)retValue);
        }
        return retValue;
    }

    public long getMEThreshold() {
        return this.meHighMessageThreshold;
    }

    public String[] listPreparedTransactions() {
        String thisMethodName = "listPreparedTransactions";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName);
        }
        String[] col = null;
        if (this._messageStore != null) {
            col = this._messageStore.listPreparedTransactions();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)col);
        }
        return col;
    }

    public void resetDestination(String name) throws Exception {
        String thisMethodName = "resetDestination";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)name);
        }
        if (this._messageProcessor != null && this._mpAdmin != null) {
            try {
                this._mpAdmin.getMPRuntimeControl().resetDestination(name);
            }
            catch (SIMPRuntimeOperationFailedException e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"resetDestination", (Object)((Object)e));
                }
                throw new Exception(e.getMessage());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    private byte[] getData(byte[] in, Integer size) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getData", (Object)new Object[]{in, size});
        }
        byte[] tmp = null;
        if (in != null) {
            int len = 1024;
            if (size > 0) {
                len = size;
            }
            if (len > in.length) {
                len = in.length;
            }
            tmp = new byte[len];
            System.arraycopy(in, 0, tmp, 0, len);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getData", (Object)tmp);
        }
        return tmp;
    }

    public void commitPreparedTransaction(String xid) throws SIBTransactionException, SIBPersistenceException {
        String thisMethodName = "commitPreparedTransaction";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)xid);
        }
        if (this._messageStore != null) {
            try {
                this._messageStore.commitPreparedTransaction(xid);
            }
            catch (TransactionException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl.commitPreparedTransaction", (String)"1:3417:1.79", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"commitPreparedTransaction", (Object)"SIBTransactionException");
                }
                throw new SIBTransactionException(e.getMessage());
            }
            catch (PersistenceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl.commitPreparedTransaction", (String)"1:3430:1.79", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"commitPreparedTransaction", (Object)"SIBPersistenceException");
                }
                throw new SIBPersistenceException(e.getMessage());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public void rollbackPreparedTransaction(String xid) throws SIBTransactionException, SIBPersistenceException {
        String thisMethodName = "rollbackPreparedTransaction";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)xid);
        }
        if (this._messageStore != null) {
            try {
                this._messageStore.rollbackPreparedTransaction(xid);
            }
            catch (TransactionException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl.rollbackPreparedTransaction", (String)"1:3476:1.79", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"rollbackPreparedTransaction", (Object)"SIBTransactionException");
                }
                throw new SIBTransactionException(e.getMessage());
            }
            catch (PersistenceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl.rollbackPreparedTransaction", (String)"1:3489:1.79", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"rollbackPreparedTransaction", (Object)"SIBPersistenceException");
                }
                throw new SIBPersistenceException(e.getMessage());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public void dump(String dumpSpec) {
        String methodName = "dump";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)methodName, (Object)dumpSpec);
        }
        FormattedWriter fw = null;
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String dumpFile = "SIBdump-" + this.getName() + "-" + dateFormat.format(date) + ".xml";
        try {
            String dumpFilePath = dumpFile;
            if (this.dumpDir != null) {
                dumpFilePath = String.valueOf(this.dumpDir) + dumpFile;
            }
            FileOutputStream fos = new FileOutputStream(dumpFilePath);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            fw = new FormattedWriter((Writer)osw);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl.dump", (String)"1:2837:1.79", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (fw != null) {
            try {
                fw.introducer("xml version=\"1.0\" encoding=\"UTF-8\"");
                fw.comment(" Dump taken at " + new SimpleDateFormat("HH:mm:ss:SSS").format(date) + " on " + new SimpleDateFormat("dd MMMM yyyy").format(date) + " ");
                fw.newLine();
                fw.nameSpace("xmi");
                fw.startTag("XMI xmi:version=\"1.2\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:admin=\"?\" xmlns:comms=\"?\" xmlns:mfp=\"?\" xmlns:msgstore=\"?\" xmlns:processor=\"?\" xmlns:security=\"?\" xmlns:trm=\"?\"");
                fw.indent();
                fw.newLine();
                fw.nameSpace("");
                fw.startTag("sib");
                fw.indent();
                fw.newLine();
                fw.nameSpace("processor");
                if (this._messageProcessor != null) {
                    this.dump(dumpSpec, "com.ibm.ws.sib.processor.impl.MessageProcessor", this._messageProcessor, fw);
                }
                fw.nameSpace("comms");
                ServerCommsDiagnosticDump.dump((FormattedWriter)fw, (String)dumpSpec);
                fw.nameSpace("msgstore");
                if (this._messageStore != null) {
                    this.dump(dumpSpec, "com.ibm.ws.sib.msgstore.impl.MessageStoreImpl", (JsEngineComponent)this._messageStore, fw);
                }
                fw.nameSpace("trm");
                JsEngineComponent _trm = this.getEngineComponent("com.ibm.ws.sib.trm.TrmMeMainImpl");
                if (_trm != null) {
                    this.dump(dumpSpec, "com.ibm.ws.sib.trm.TrmMeMainImpl", _trm, fw);
                }
                fw.outdent();
                fw.newLine();
                fw.nameSpace("");
                fw.endTag("sib");
                fw.outdent();
                fw.newLine();
                fw.nameSpace("xmi");
                fw.endTag("XMI");
                fw.newLine();
                fw.flush();
                fw.close();
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl.dump", (String)"1:2897:1.79", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    private void dump(String dumpSpec, String className, JsEngineComponent comp, FormattedWriter fw) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dump", (Object)new Object[]{dumpSpec, className, comp, fw});
        }
        StringTokenizer st = new StringTokenizer(dumpSpec, ":");
        int i = 0;
        boolean matched = false;
        while (st.hasMoreTokens() && !matched) {
            String arg;
            String pkg;
            ++i;
            String item = st.nextToken();
            int j = item.indexOf(61);
            if (j < 0) {
                pkg = item.trim();
                arg = "";
            } else {
                pkg = item.substring(0, j).trim();
                arg = item.substring(j + 1).trim();
            }
            boolean fullMatch = true;
            if (pkg.endsWith("*")) {
                fullMatch = false;
                pkg = pkg.substring(0, pkg.length() - 1);
            }
            if (fullMatch) {
                if (pkg.equals(className)) {
                    matched = true;
                }
            } else {
                int keyLength = pkg.length();
                String component = className;
                if (pkg.endsWith(".") && !component.endsWith(".")) {
                    component = String.valueOf(component) + ".";
                }
                if (component.length() >= keyLength && pkg.equals(component.substring(0, keyLength))) {
                    matched = true;
                }
            }
            if (matched && comp instanceof MessageProcessor) {
                ((MessageProcessor)comp).dump(fw, arg);
            }
            if (!matched || !(comp instanceof MessageStore)) continue;
            ((MessageStore)comp).dump(fw, arg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dump");
        }
    }

    public String getConfigId() {
        return null;
    }

    public String getId() {
        return null;
    }

    public String getRemoteEngineUuid() {
        return null;
    }

    class ComponentList {
        private final String _className;
        private final JsEngineComponent _componentRef;

        ComponentList(String className, JsEngineComponent c) {
            this._className = className;
            this._componentRef = c;
        }

        String getClassName() {
            return this._className;
        }

        JsEngineComponent getRef() {
            return this._componentRef;
        }
    }
}

