/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.gd.Stream;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.SIMPItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProtocolItemStream;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.InternalOutputStreamSetControl;
import com.ibm.ws.sib.processor.runtime.impl.LinkPublicationPointControl;
import com.ibm.ws.sib.processor.runtime.impl.LinkReceiverControl;
import com.ibm.ws.sib.processor.runtime.impl.LinkTransmitterControl;
import com.ibm.ws.sib.processor.runtime.impl.SourceStreamSetControl;
import com.ibm.ws.sib.processor.runtime.impl.TargetStreamSetControl;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class StreamSet
extends SIMPItem
implements ControllableResource {
    private Type type;
    private String linkTarget;
    private ControlAdapter controlAdapter = null;
    private long initialData = -1L;
    private boolean persistent = false;
    private static final int maxReliabilityIndex = Reliability.MAX_INDEX;
    private SIMPTransactionManager txManager = null;
    private ProtocolItemStream itemStream = null;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int PERSISTENT_VERSION = 2;
    private SIBUuid8 remoteMEUuid = null;
    private SIBUuid12 streamID = null;
    private SIBUuid12 destID = null;
    private SIBUuid8 busID = null;
    private static TraceComponent tc = SibTr.register(StreamSet.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private long[] subsetIDs;
    private ReliabilitySubset[] subsets;

    public StreamSet() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"StreamSet");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"StreamSet", (Object)this);
        }
    }

    public StreamSet(SIBUuid12 streamID, long initialData, Type type) {
        this(streamID, null, initialData, type);
    }

    public StreamSet(SIBUuid12 streamID, SIBUuid8 remoteMEUuid, long initialData, Type type) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"StreamSet", (Object)new Object[]{streamID, remoteMEUuid, initialData, type});
        }
        this.streamID = streamID;
        this.remoteMEUuid = remoteMEUuid;
        this.initialData = initialData;
        this.type = type;
        this.initialize();
        this.createNonPersistentSubsets();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"StreamSet", (Object)this);
        }
    }

    public StreamSet(SIBUuid12 streamID, SIBUuid8 remoteMEUuid, SIBUuid12 destID, SIBUuid8 busID, ProtocolItemStream itemStream, SIMPTransactionManager txManager, long initialData, Type type, TransactionCommon tran, String linkTarget) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"StreamSet", (Object)new Object[]{streamID, remoteMEUuid, destID, busID, itemStream, txManager, initialData, type, tran, linkTarget});
        }
        this.streamID = streamID;
        this.remoteMEUuid = remoteMEUuid;
        this.destID = destID;
        this.busID = busID;
        this.itemStream = itemStream;
        this.txManager = txManager;
        this.initialData = initialData;
        this.type = type;
        this.linkTarget = linkTarget;
        this.initialize();
        this.persistent = true;
        this.createPersistentSubsets(tran);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"StreamSet", (Object)this);
        }
    }

    private void initialize() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initialize");
        }
        this.subsets = new ReliabilitySubset[maxReliabilityIndex + 1];
        this.subsetIDs = new long[maxReliabilityIndex + 1];
        for (int i = 0; i < this.subsetIDs.length; ++i) {
            this.subsetIDs[i] = -1L;
        }
        this.createControlAdapter();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public Type getType() {
        Type localType = this.type;
        if (localType == Type.LINK_REMOTE_SOURCE) {
            localType = Type.LINK_SOURCE;
        }
        return localType;
    }

    protected void setStream(int priority, Reliability reliability, Stream stream) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStream", (Object)new Object[]{new Integer(priority), reliability, stream});
        }
        ReliabilitySubset subset = this.getSubset(reliability);
        subset.setStream(priority, stream);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setStream");
        }
    }

    public void updateCellule(SIBUuid8 newRemoteMEUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateCellule", (Object)newRemoteMEUuid);
        }
        this.remoteMEUuid = newRemoteMEUuid;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateCellule");
        }
    }

    private int getIndex(Reliability reliability) {
        return reliability.getIndex();
    }

    private Reliability getReliability(int index) {
        return Reliability.getReliabilityByIndex((int)index);
    }

    private void createPersistentSubsets(TransactionCommon tran) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createPersistentSubsets", (Object)tran);
        }
        for (int i = 0; i < this.subsets.length; ++i) {
            this.createPersistentSubset(this.getReliability(i), tran);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createPersistentSubsets");
        }
    }

    private ReliabilitySubset createPersistentSubset(Reliability reliability, TransactionCommon tran) throws SIResourceException {
        ReliabilitySubset subset;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createPersistentSubset", (Object)new Object[]{reliability});
        }
        this.subsets[this.getIndex((Reliability)reliability)] = subset = new ReliabilitySubset(reliability, this.initialData);
        if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
            try {
                Transaction msTran = this.txManager.resolveAndEnlistMsgStoreTransaction(tran);
                this.itemStream.addItem(subset, msTran);
                this.subsetIDs[this.getIndex((Reliability)reliability)] = subset.getID();
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.StreamSet.createPersistentSubset", (String)"1:398:1.67", (Object)this);
                this.subsetIDs[this.getIndex((Reliability)reliability)] = -1L;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.exit((TraceComponent)tc, (String)"createPersistentSubset", (Object)((Object)e));
                }
            }
        } else {
            this.subsetIDs[this.getIndex((Reliability)reliability)] = -1L;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createPersistentSubset", (Object)((Object)subset));
        }
        return subset;
    }

    private void createNonPersistentSubsets() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createNonPersistentSubsets");
        }
        for (int i = 0; i < this.subsets.length; ++i) {
            this.createNonPersistentSubset(this.getReliability(i));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createNonPersistentSubsets");
        }
    }

    private ReliabilitySubset createNonPersistentSubset(Reliability reliability) {
        ReliabilitySubset subset;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createNonPersistentSubset", (Object)new Object[]{reliability});
        }
        this.subsets[this.getIndex((Reliability)reliability)] = subset = new ReliabilitySubset(reliability, this.initialData);
        this.subsetIDs[this.getIndex((Reliability)reliability)] = -1L;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createNonPersistentSubset", (Object)((Object)subset));
        }
        return subset;
    }

    public Stream getStream(int priority, Reliability reliability) throws SIResourceException {
        return this.getSubset(reliability).getStream(priority);
    }

    private ReliabilitySubset getSubset(Reliability reliability) throws SIResourceException {
        ReliabilitySubset subset;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSubset", (Object)reliability);
        }
        if ((subset = this.subsets[this.getIndex(reliability)]) == null && this.persistent) {
            subset = this.createPersistentSubset(reliability, (TransactionCommon)this.txManager.createAutoCommitTransaction());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubset");
        }
        return subset;
    }

    @Override
    public void getPersistentData(ObjectOutputStream dos) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPersistentData", (Object)dos);
        }
        try {
            MessagingEngine cellule = new MessagingEngine(this.remoteMEUuid);
            byte[] celluleBytes = cellule.getBytes();
            int celluleBytesLen = celluleBytes.length;
            byte[] streamBytes = this.streamID.toByteArray();
            int streamBytesLen = streamBytes.length;
            byte[] destBytes = this.destID.toByteArray();
            int destBytesLen = destBytes.length;
            byte[] busBytes = this.busID.toByteArray();
            int busBytesLen = busBytes.length;
            byte[] copy = new byte[celluleBytesLen + streamBytesLen + destBytesLen + busBytesLen];
            System.arraycopy(celluleBytes, 0, copy, 0, celluleBytesLen);
            System.arraycopy(streamBytes, 0, copy, celluleBytesLen, streamBytesLen);
            System.arraycopy(destBytes, 0, copy, celluleBytesLen + streamBytesLen, destBytesLen);
            System.arraycopy(busBytes, 0, copy, celluleBytesLen + streamBytesLen + destBytesLen, busBytesLen);
            dos.write(copy);
            dos.writeLong(this.initialData);
            dos.writeInt(this.type.toInt());
            dos.writeInt(this.subsets.length);
            for (int i = 0; i < this.subsets.length; ++i) {
                dos.writeLong(this.subsetIDs[i]);
                dos.writeInt(this.subsets[i].getReliability().toInt());
            }
            dos.writeObject(this.linkTarget);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.StreamSet.getPersistentData", (String)"1:545:1.67", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.StreamSet", "1:552:1.67", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.StreamSet", "1:562:1.67", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    @Override
    public void restore(ObjectInputStream dis, int dataVersion) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{dis, new Integer(dataVersion)});
        }
        this.itemStream = (ProtocolItemStream)this.getItemStream();
        this.persistent = true;
        try {
            int j;
            Reliability reliability;
            byte[] celluleBytes = new byte[9];
            dis.read(celluleBytes, 0, 9);
            this.remoteMEUuid = new MessagingEngine(celluleBytes).getUuid();
            byte[] streamIDBytes = new byte[12];
            dis.read(streamIDBytes, 0, 12);
            this.streamID = new SIBUuid12(streamIDBytes);
            byte[] destIDBytes = new byte[12];
            dis.read(destIDBytes, 0, 12);
            this.destID = new SIBUuid12(destIDBytes);
            byte[] busIDBytes = new byte[8];
            dis.read(busIDBytes, 0, 8);
            this.busID = new SIBUuid8(busIDBytes);
            this.initialData = dis.readLong();
            this.type = Type.getType(dis.readInt());
            int numberOfSubsets = dis.readInt();
            this.initialize();
            ReliabilitySubset[] newSubsets = new ReliabilitySubset[numberOfSubsets];
            long[] newSubsetIDs = new long[numberOfSubsets];
            for (int i = 0; i < numberOfSubsets; ++i) {
                long subsetID = dis.readLong();
                reliability = Reliability.getReliability((int)dis.readInt());
                if (subsetID != -1L) {
                    ReliabilitySubset subset = (ReliabilitySubset)this.getItemStream().findById(subsetID);
                    if (subset != null) {
                        subset.setReliability(reliability);
                        newSubsets[this.getIndex((Reliability)reliability)] = subset;
                    } else {
                        subsetID = -1L;
                    }
                }
                newSubsetIDs[i] = subsetID;
            }
            for (j = 0; j < numberOfSubsets && newSubsetIDs[j] == -1L; ++j) {
            }
            for (int i = 0; i < maxReliabilityIndex + 1; ++i) {
                ReliabilitySubset subset = null;
                reliability = null;
                if (j < numberOfSubsets) {
                    subset = newSubsets[j];
                    reliability = subset.getReliability();
                }
                if (reliability != this.getReliability(i)) continue;
                this.subsets[i] = subset;
                this.subsetIDs[i] = newSubsetIDs[j++];
                while (j < numberOfSubsets && newSubsetIDs[j] == -1L) {
                    ++j;
                }
            }
            if (dataVersion >= 2) {
                this.linkTarget = (String)dis.readObject();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.StreamSet.restore", (String)"1:680:1.67", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.StreamSet", "1:687:1.67", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.StreamSet", "1:697:1.67", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        writer.newLine();
        writer.taggedValue("remoteMEUuid", (Object)this.remoteMEUuid);
        writer.newLine();
        writer.taggedValue("streamID", (Object)this.streamID);
        writer.newLine();
        writer.taggedValue("initialData", this.initialData);
        writer.newLine();
        writer.taggedValue("type", (Object)this.type);
    }

    public SIBUuid8 getRemoteMEUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRemoteMEUuid");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteMEUuid", (Object)this.remoteMEUuid);
        }
        return this.remoteMEUuid;
    }

    public SIBUuid12 getDestUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDestUuid");
            SibTr.exit((TraceComponent)tc, (String)"getDestUuid", (Object)this.destID);
        }
        return this.destID;
    }

    protected void setDestUuid(SIBUuid12 destID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestUuid", (Object)destID);
        }
        this.destID = destID;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestUuid");
        }
    }

    public SIBUuid8 getBusUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBusUuid");
            SibTr.exit((TraceComponent)tc, (String)"getBusUuid", (Object)this.busID);
        }
        return this.busID;
    }

    public int getStorageStrategy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getStorageStrategy");
        }
        int storageStrategy = 4;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStorageStrategy", (Object)new Integer(storageStrategy));
        }
        return storageStrategy;
    }

    public boolean isPersistent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isPersistent");
            SibTr.exit((TraceComponent)tc, (String)"isPersistent", (Object)this.persistent);
        }
        return this.persistent;
    }

    public SIBUuid12 getStreamID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getStreamID");
            SibTr.exit((TraceComponent)tc, (String)"getStreamID", (Object)this.streamID);
        }
        return this.streamID;
    }

    public void setStreamID(SIBUuid12 streamID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setStreamID");
            SibTr.exit((TraceComponent)tc, (String)"setStreamID", (Object)streamID);
        }
        this.streamID = streamID;
    }

    protected void setPersistentData(int priority, Reliability reliability, long completedPrefix) throws SIResourceException {
        this.getSubset(reliability).setPersistentData(priority, completedPrefix);
    }

    protected long getPersistentData(int priority, Reliability reliability) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)new Object[]{new Integer(priority), reliability});
        }
        long prefix = this.getSubset(reliability).getPersistentData(priority);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)new Long(prefix));
        }
        return prefix;
    }

    public Iterator<Stream> iterator() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"iterator");
        }
        ArrayList<Stream> streams = new ArrayList<Stream>();
        for (int j = 0; j < maxReliabilityIndex + 1; ++j) {
            ReliabilitySubset subset = this.getSubset(this.getReliability(j));
            if (subset == null) continue;
            for (int i = 0; i < 10; ++i) {
                Stream stream = subset.getStream(i);
                if (stream == null) continue;
                streams.add(stream);
            }
        }
        Iterator<Stream> itr = streams.iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"iterator", itr);
        }
        return itr;
    }

    public void requestUpdate(Reliability reliability, TransactionCommon tran) throws SIResourceException {
        ReliabilitySubset subset;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"requestUpdate", (Object)new Object[]{reliability, tran});
        }
        if (!(subset = this.getSubset(reliability)).isUpdating()) {
            if (tran == null) {
                tran = this.txManager.createAutoCommitTransaction();
            }
            try {
                Transaction msTran = this.txManager.resolveAndEnlistMsgStoreTransaction(tran);
                subset.requestUpdate(msTran);
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.StreamSet.requestUpdate", (String)"1:917:1.67", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"requestUpdate", (Object)"SIStoreException");
                }
                throw new SIResourceException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requestUpdate");
        }
    }

    public void remove() throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"remove");
        }
        LocalTransaction tran = this.txManager.createLocalTransaction(true);
        try {
            for (int i = 0; i < this.subsets.length; ++i) {
                if (this.subsets[i] == null || !this.subsets[i].isInStore()) continue;
                this.subsets[i].remove((Transaction)tran, this.subsets[i].getLockID());
            }
            this.remove((Transaction)tran, this.getLockID());
            tran.commit();
        }
        catch (SIIncorrectCallException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"remove", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.StreamSet.remove", (String)"1:1228:1.67", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"remove", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public void initializeNonPersistent(SIMPTransactionManager txManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initializeNonPersistent", (Object)txManager);
        }
        this.txManager = txManager;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    @Override
    public ControlAdapter getControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getControlAdapter");
        }
        if (this.controlAdapter == null) {
            this.createControlAdapter();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)this.controlAdapter);
        }
        return this.controlAdapter;
    }

    @Override
    public void createControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createControlAdapter");
        }
        if (this.type == Type.SOURCE) {
            this.controlAdapter = new SourceStreamSetControl(this.remoteMEUuid, this);
        } else if (this.type == Type.LINK_SOURCE) {
            this.controlAdapter = new LinkTransmitterControl(this.remoteMEUuid, this, true);
        } else if (this.type == Type.LINK_REMOTE_SOURCE) {
            this.controlAdapter = new LinkTransmitterControl(this.remoteMEUuid, this, false);
        } else if (this.type == Type.TARGET) {
            this.controlAdapter = new TargetStreamSetControl(this);
        } else if (this.type == Type.LINK_TARGET) {
            this.controlAdapter = new LinkReceiverControl(this, this.linkTarget);
        } else if (this.type == Type.INTERNAL_OUTPUT) {
            this.controlAdapter = new InternalOutputStreamSetControl(this);
        } else if (this.type == Type.LINK_INTERNAL_OUTPUT) {
            this.controlAdapter = new LinkPublicationPointControl(this);
        } else if (this.type == Type.INTERNAL_INPUT) {
            // empty if block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    @Override
    public void dereferenceControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dereferenceControlAdapter");
        }
        if (this.controlAdapter != null) {
            this.controlAdapter.dereferenceControllable();
            this.controlAdapter = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControlAdapter");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    @Override
    public int getPersistentVersion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPersistentVersion");
            SibTr.exit((TraceComponent)tc, (String)"getPersistentVersion", (Object)2);
        }
        return 2;
    }

    public static class Type {
        public static final Type SOURCE = new Type(0, "SOURCE");
        public static final Type TARGET = new Type(1, "TARGET");
        public static final Type INTERNAL_OUTPUT = new Type(2, "INTERNAL_OUTPUT");
        public static final Type INTERNAL_INPUT = new Type(3, "INTERNAL_INPUT");
        public static final Type LINK_SOURCE = new Type(4, "LINK_SOURCE");
        public static final Type LINK_TARGET = new Type(5, "LINK_TARGET");
        public static final Type LINK_INTERNAL_OUTPUT = new Type(6, "LINK_INTERNAL_OUTPUT");
        public static final Type LINK_REMOTE_SOURCE = new Type(7, "LINK_REMOTE_SOURCE");
        private final int value;
        private final String name;
        private static final Type[] set = new Type[]{SOURCE, TARGET, INTERNAL_OUTPUT, INTERNAL_INPUT, LINK_SOURCE, LINK_TARGET, LINK_INTERNAL_OUTPUT, LINK_REMOTE_SOURCE};

        private Type(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int toInt() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }

        public static Type getType(int value) {
            return set[value];
        }
    }

    public static class ReliabilitySubset
    extends SIMPItem {
        private Reliability reliability;
        private long[] persistentData;
        private Stream[] streams;
        private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
        private static TraceComponent tc = SibTr.register(ReliabilitySubset.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

        public ReliabilitySubset() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"ReliabilitySubset");
            }
            this.initialize(-1L);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ReliabilitySubset", (Object)((Object)this));
            }
        }

        public void setReliability(Reliability reliability) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"setReliability", (Object)reliability);
            }
            this.reliability = reliability;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setReliability");
            }
        }

        public ReliabilitySubset(Reliability reliability, long initialData) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"ReliabilitySubset", (Object)new Object[]{reliability, initialData});
            }
            this.reliability = reliability;
            this.initialize(initialData);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ReliabilitySubset", (Object)((Object)this));
            }
        }

        private void initialize(long initialData) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"initialize", (Object)initialData);
            }
            this.streams = new Stream[10];
            this.persistentData = new long[10];
            for (int i = 0; i < 10; ++i) {
                this.persistentData[i] = initialData;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"initialize");
            }
        }

        public Reliability getReliability() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getReliability");
                SibTr.exit((TraceComponent)tc, (String)"getReliability", (Object)this.reliability);
            }
            return this.reliability;
        }

        public Stream getStream(int priority) {
            return this.streams[priority];
        }

        public void setStream(int priority, Stream stream) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"setStream", (Object)new Object[]{priority, stream});
                SibTr.exit((TraceComponent)tc, (String)"setStream");
            }
            this.streams[priority] = stream;
        }

        public long getCompletedPrefix(int priority) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getCompletedPrefix", (Object)priority);
                SibTr.exit((TraceComponent)tc, (String)"getCompletedPrefix", (Object)this.streams[priority].getCompletedPrefix());
            }
            return this.streams[priority].getCompletedPrefix();
        }

        public void setPersistentData(long[] completedPrefixes) {
            this.persistentData = completedPrefixes;
        }

        public void setPersistentData(int priority, long completedPrefix) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"setPersistentData", (Object)new Object[]{priority, completedPrefix});
                SibTr.exit((TraceComponent)tc, (String)"setPersistentData");
            }
            this.persistentData[priority] = completedPrefix;
        }

        public long getPersistentData(int priority) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getPersistentData", (Object)priority);
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)this.persistentData[priority]);
            }
            return this.persistentData[priority];
        }

        @Override
        public void getPersistentData(ObjectOutputStream dos) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getPersistentData", (Object)dos);
            }
            try {
                for (int i = 0; i < this.streams.length; ++i) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)(" persistentData[" + i + "] : " + this.persistentData[i]));
                    }
                    dos.writeLong(this.persistentData[i]);
                }
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.StreamSet.ReliabilitySubset.getPersistentData", (String)"1:1084:1.67", (Object)((Object)this));
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.ReliabilitySubset", "1:1091:1.67", e});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.ReliabilitySubset", "1:1101:1.67", e}, null), (Throwable)e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
            }
        }

        @Override
        public void restore(ObjectInputStream dis, int dataVersion) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{dis, new Integer(dataVersion)});
            }
            try {
                for (int i = 0; i < this.streams.length; ++i) {
                    long completedPrefix = dis.readLong();
                    this.setPersistentData(i, completedPrefix);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.StreamSet.ReliabilitySubset.restore", (String)"1:1135:1.67", (Object)((Object)this));
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.StreamSet.ReliabilitySubset", "1:1142:1.67", e});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"restore", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.StreamSet.ReliabilitySubset", "1:1151:1.67", e}, null), (Throwable)e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore");
            }
        }

        public void xmlWriteOn(FormattedWriter writer) throws IOException {
            int i;
            writer.newLine();
            writer.taggedValue("reliability", (Object)this.reliability);
            boolean equal = true;
            for (i = 1; i < this.streams.length; ++i) {
                if (this.persistentData[i] == this.persistentData[i - 1]) continue;
                equal = false;
            }
            if (equal) {
                writer.newLine();
                writer.taggedValue("allData", this.persistentData[0]);
            } else {
                for (i = 1; i < this.streams.length; ++i) {
                    if (this.persistentData[i] == 0L) continue;
                    writer.newLine();
                    writer.taggedValue("subsetData_" + i, this.persistentData[i]);
                }
            }
        }

        public int getStorageStrategy() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getStorageStrategy");
            }
            int storageStrategy = this.reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) <= 0 ? 1 : (this.reliability.compareTo((Object)Reliability.RELIABLE_NONPERSISTENT) <= 0 ? 2 : (this.reliability.compareTo((Object)Reliability.RELIABLE_PERSISTENT) <= 0 ? 3 : 4));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getStorageStrategy", (Object)new Integer(storageStrategy));
            }
            return storageStrategy;
        }
    }
}

