/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.PtoPOutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerManager;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.LinkRemoteQueuePoint;
import com.ibm.ws.sib.processor.runtime.impl.MPRuntimeEvent;
import com.ibm.ws.sib.processor.runtime.impl.XmitPoint;
import com.ibm.ws.sib.processor.runtime.impl.XmitPointControl;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Properties;

public class PtoPXmitMsgsItemStream
extends PtoPMessageItemStream {
    private static final TraceComponent tc = SibTr.register(PtoPXmitMsgsItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public PtoPXmitMsgsItemStream() {
    }

    public PtoPXmitMsgsItemStream(BaseDestinationHandler destinationHandler, SIBUuid8 messagingEngineUuid) {
        super(destinationHandler, messagingEngineUuid, true);
    }

    @Override
    public boolean reallocateMsgs() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reallocateMsgs");
        }
        boolean success = true;
        try {
            if (this.getOutputHandler() instanceof PtoPOutputHandler) {
                ((PtoPOutputHandler)this.getOutputHandler()).reallocateMsgs(this.getDestinationHandler(), false, false);
            } else {
                success = false;
            }
        }
        catch (SIException e) {
            success = false;
        }
        if (success) {
            long itemCount = -1L;
            long availableCount = -1L;
            long removingCount = -1L;
            try {
                itemCount = this.getStatistics().getTotalItemCount();
                availableCount = this.getStatistics().getAvailableItemCount();
                removingCount = this.getStatistics().getRemovingItemCount();
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPXmitMsgsItemStream.reallocateMsgs", (String)"1:160:1.56", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            if (itemCount > 0L) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Messages remain on stream: " + itemCount + " : " + availableCount + " : " + removingCount));
                }
                success = false;
            } else if (this.isToBeDeleted() || this.destinationHandler.isToBeDeleted()) {
                ExternalAutoCommitTransaction transaction = this.getDestinationHandler().getTxManager().createAutoCommitTransaction();
                try {
                    this.removeItemStream((Transaction)transaction, -2L);
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPXmitMsgsItemStream.reallocateMsgs", (String)"1:193:1.56", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    success = false;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reallocateMsgs", (Object)new Boolean(success));
        }
        return success;
    }

    @Override
    public void reconstitute(BaseDestinationHandler destinationHandler) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)destinationHandler);
        }
        super.reconstitute(destinationHandler);
        this._destHighMsgs = destinationHandler.getMessageProcessor().getHighMessageThreshold();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitute");
        }
    }

    @Override
    public void createControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        if (!this.destinationHandler.isLink()) {
            XmitPoint rqm = (XmitPoint)this.destinationHandler.getRemoteQueuePointControl(this.getLocalizingMEUuid(), true);
            this.controlAdapter = new XmitPointControl(rqm, this, this.destinationHandler);
        } else {
            this.controlAdapter = new LinkRemoteQueuePoint(this.destinationHandler, this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter", (Object)this.controlAdapter);
        }
    }

    @Override
    public void deregisterControlAdapterMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
        this.getControlAdapter().deregisterControlAdapterMBean();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
        this.getControlAdapter().registerControlAdapterAsMBean();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    public void fireDepthThresholdReachedEvent(ControlAdapter cAdapter, boolean reachedHigh, long numMsgs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent", (Object)new Object[]{cAdapter, new Boolean(reachedHigh), new Long(numMsgs), this.messagingEngineUuid});
        }
        String meName = this.destinationHandler.getMessageProcessor().getMessagingEngineName();
        String message = null;
        Properties props = new Properties();
        String evType = null;
        if (this.destinationHandler.isLink()) {
            String busName = ((LinkHandler)this.destinationHandler).getBusName();
            evType = "SIB.link.depth.threshold.reached";
            props.put("foreign.bus.name", busName);
            props.put("link.name", this.destinationHandler.getName());
            props.put("link.UUID", this.destinationHandler.getUuid().toString());
            if (reachedHigh) {
                message = nls.getFormattedMessage("NOTIFY_SIBLINK_DEPTH_THRESHOLD_REACHED_CWSIP0559", new Object[]{this.destinationHandler.getName(), busName, meName}, null);
                if (this.mp.getCustomProperties().getOutputLinkThresholdEventsToLog()) {
                    SibTr.info((TraceComponent)tc, (String)"NOTIFY_SIBLINK_DEPTH_THRESHOLD_REACHED_CWSIP0559", (Object)new Object[]{this.destinationHandler.getName(), busName, meName});
                }
            } else {
                message = nls.getFormattedMessage("NOTIFY_SIBLINK_DEPTH_THRESHOLD_REACHED_CWSIP0560", new Object[]{this.destinationHandler.getName(), busName, meName}, null);
                if (this.mp.getCustomProperties().getOutputLinkThresholdEventsToLog()) {
                    SibTr.info((TraceComponent)tc, (String)"NOTIFY_SIBLINK_DEPTH_THRESHOLD_REACHED_CWSIP0560", (Object)new Object[]{this.destinationHandler.getName(), busName, meName});
                }
            }
        } else {
            evType = "SIB.remote.messagepoint.depth.threshold.reached";
            props.put("destination.name", this.destinationHandler.getName());
            props.put("destination.UUID", this.destinationHandler.getUuid().toString());
            if (reachedHigh) {
                message = nls.getFormattedMessage("NOTIFY_REMOTE_DEPTH_THRESHOLD_REACHED_CWSIP0555", new Object[]{meName, this.destinationHandler.getName(), this.messagingEngineUuid.toString()}, null);
                if (this.mp.getCustomProperties().getOutputDestinationThresholdEventsToLog()) {
                    SibTr.info((TraceComponent)tc, (String)"NOTIFY_REMOTE_DEPTH_THRESHOLD_REACHED_CWSIP0555", (Object)new Object[]{meName, this.destinationHandler.getName(), this.messagingEngineUuid.toString()});
                }
            } else {
                message = nls.getFormattedMessage("NOTIFY_REMOTE_DEPTH_THRESHOLD_REACHED_CWSIP0556", new Object[]{meName, this.destinationHandler.getName(), this.messagingEngineUuid.toString()}, null);
                if (this.mp.getCustomProperties().getOutputDestinationThresholdEventsToLog()) {
                    SibTr.info((TraceComponent)tc, (String)"NOTIFY_REMOTE_DEPTH_THRESHOLD_REACHED_CWSIP0556", (Object)new Object[]{meName, this.destinationHandler.getName(), this.messagingEngineUuid.toString()});
                }
            }
        }
        if (this._isEventNotificationEnabled) {
            props.put("remote.messaging.engine.UUID", this.messagingEngineUuid.toString());
            if (reachedHigh) {
                props.put("depth.threshold.reached", "depth.threshold.reached.high");
            } else {
                props.put("depth.threshold.reached", "depth.threshold.reached.low");
            }
            props.put("messages", String.valueOf(numMsgs));
            if (cAdapter != null) {
                MPRuntimeEvent MPevent = new MPRuntimeEvent(evType, message, props);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent", (Object)("Drive runtimeEventOccurred against Control adapter: " + cAdapter));
                }
                cAdapter.runtimeEventOccurred(MPevent);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent", (Object)"Control adapter is null, cannot fire event");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent");
        }
    }

    @Override
    protected void issueDepthIntervalMessage(long depth) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"issueDepthIntervalMessage", (Object)new Long(depth));
        }
        if (this.destinationHandler.isLink()) {
            SibTr.info((TraceComponent)tc, (String)"REMOTE_LINK_DESTINATION_DEPTH_INTERVAL_REACHED_CWSIP0789", (Object)new Object[]{new Long(depth), this.destinationHandler.getMessageProcessor().getMessagingEngineName(), ((LinkHandler)this.destinationHandler).getBusName(), this.destinationHandler.getName()});
        } else {
            SibTr.info((TraceComponent)tc, (String)"REMOTE_DESTINATION_DEPTH_INTERVAL_REACHED_CWSIP0788", (Object)new Object[]{new Long(depth), this.destinationHandler.getMessageProcessor().getMessagingEngineName(), this.destinationHandler.getName(), SIMPUtils.getMENameFromUuid(((PtoPOutputHandler)this.getOutputHandler()).getTargetMEUuid().toString())});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"issueDepthIntervalMessage");
        }
    }

    @Override
    public ConsumerManager getConsumerManager() {
        return null;
    }

    @Override
    public void dereferenceConsumerManager() {
    }

    @Override
    public boolean isSendAllowed() {
        return false;
    }
}

