/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.SibRaEngineComponent;
import com.ibm.ws.sib.ra.impl.SibRaConnection;
import com.ibm.ws.sib.ra.impl.SibRaConnectionInfo;
import com.ibm.ws.sib.ra.impl.SibRaConnectionRequestInfo;
import com.ibm.ws.sib.ra.impl.SibRaManagedConnectionFactory;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionEvent;
import jakarta.resource.spi.ConnectionEventListener;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.DissociatableManagedConnection;
import jakarta.resource.spi.LazyEnlistableConnectionManager;
import jakarta.resource.spi.LazyEnlistableManagedConnection;
import jakarta.resource.spi.LocalTransaction;
import jakarta.resource.spi.LocalTransactionException;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionMetaData;
import jakarta.resource.spi.ResourceAdapterInternalException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

final class SibRaManagedConnection
implements ManagedConnection,
LazyEnlistableManagedConnection,
DissociatableManagedConnection {
    private final SibRaManagedConnectionFactory _factory;
    private final SICoreConnection _coreConnection;
    private final SibRaConnectionInfo _connectionInfo;
    private final Set _eventListeners = Collections.synchronizedSet(new HashSet());
    private PrintWriter _logWriter;
    private final Set _connections = Collections.synchronizedSet(new HashSet());
    private SibRaLocalTransaction _localTransaction;
    private SibRaXaResource _xaResource;
    private ManagedConnectionMetaData _metaData;
    private final SibRaConnectionListener _connectionListener;
    private Exception _connectionException;
    private boolean _validConnection = true;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaManagedConnection.class);
    private static final TraceComponent LOCAL_TRAN_TRACE = SibRaUtils.getTraceComponent(SibRaLocalTransaction.class);
    private static final TraceComponent XA_RESOURCE_TRACE = SibRaUtils.getTraceComponent(SibRaXaResource.class);
    private static TraceComponent LISTENER_TRACE = SibRaUtils.getTraceComponent(SibRaConnectionListener.class);
    private static final TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";
    private static final String FFDC_PROBE_5 = "5";
    private static final String FFDC_PROBE_6 = "6";
    private static final String FFDC_PROBE_7 = "7";
    private static final String FFDC_PROBE_8 = "8";
    private static final String FFDC_PROBE_9 = "9";
    private static final String FFDC_PROBE_10 = "10";
    private static final String FFDC_PROBE_11 = "11";
    private static final String FFDC_PROBE_12 = "12";

    SibRaManagedConnection(SibRaManagedConnectionFactory factory, SibRaConnectionInfo connectionInfo, SICoreConnection coreConnection) throws SIConnectionDroppedException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaManagedConnection", (Object)new Object[]{factory, connectionInfo, coreConnection});
        }
        this._factory = factory;
        this._connectionInfo = connectionInfo;
        this._coreConnection = coreConnection;
        this._connectionListener = new SibRaConnectionListener();
        this._coreConnection.addConnectionListener((SICoreConnectionListener)this._connectionListener);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaManagedConnection");
        }
    }

    public Object getConnection(Subject containerSubject, ConnectionRequestInfo requestInfo) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getConnection", (Object)new Object[]{SibRaUtils.subjectToString(containerSubject), requestInfo});
        }
        SibRaConnection connection = null;
        if (requestInfo instanceof SibRaConnectionRequestInfo) {
            SibRaConnectionRequestInfo sibRaRequestInfo = (SibRaConnectionRequestInfo)requestInfo;
            SICoreConnection coreConnection = null;
            try {
                this._connectionException = null;
                coreConnection = this._coreConnection.cloneConnection();
            }
            catch (SIConnectionUnavailableException exception) {
                this.connectionErrorOccurred((Exception)((Object)exception), false);
                this._connectionException = exception;
                this._validConnection = false;
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection.getConnection", (String)FFDC_PROBE_1, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                this.connectionErrorOccurred((Exception)((Object)exception), false);
                this._connectionException = exception;
                this._validConnection = false;
            }
            catch (SIErrorException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection.getConnection", (String)FFDC_PROBE_7, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                this.connectionErrorOccurred((Exception)((Object)exception), false);
                this._connectionException = exception;
                this._validConnection = false;
            }
            if (coreConnection != null) {
                sibRaRequestInfo.setCoreConnection(coreConnection);
                connection = new SibRaConnection(this, sibRaRequestInfo, coreConnection);
                this._connections.add(connection);
            } else {
                connection = new SibRaConnection(this, sibRaRequestInfo, coreConnection);
            }
        } else {
            ResourceAdapterInternalException exception = new ResourceAdapterInternalException(NLS.getFormattedMessage("UNRECOGNISED_REQUEST_INFO_CWSIV0401", new Object[]{requestInfo, SibRaConnectionRequestInfo.class}, null));
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getConnection", (Object)connection);
        }
        return connection;
    }

    public void destroy() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"destroy");
        }
        for (SibRaConnection connection : this._connections) {
            connection.invalidate();
        }
        try {
            this._coreConnection.close(true);
        }
        catch (SIConnectionLostException iterator) {
        }
        catch (SIConnectionDroppedException iterator) {
        }
        catch (SIException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection.destroy", (String)FFDC_PROBE_2, (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new ResourceException(NLS.getFormattedMessage("CONNECTION_CLOSE_CWSIV0402", new Object[]{exception}, null), (Throwable)exception);
        }
        catch (SIErrorException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection.destroy", (String)FFDC_PROBE_8, (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new ResourceException(NLS.getFormattedMessage("CONNECTION_CLOSE_CWSIV0402", new Object[]{exception}, null), (Throwable)exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"destroy");
        }
    }

    public void cleanup() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"cleanup");
        }
        for (SibRaConnection connection : this._connections) {
            connection.invalidate();
        }
        if (this._connectionException != null) {
            ResourceException exception = new ResourceException("Skip logging for this failing connection");
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"cleanup");
        }
    }

    public void associateConnection(Object connection) throws ResourceAdapterInternalException {
        SibRaConnection sibRaConnection;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"associateConnection", (Object)connection);
        }
        if (connection instanceof SibRaConnection) {
            sibRaConnection = (SibRaConnection)connection;
            SibRaManagedConnection oldManagedConnection = sibRaConnection.getManagedConnection();
            if (oldManagedConnection != null) {
                oldManagedConnection._connections.remove(connection);
            }
        } else {
            ResourceAdapterInternalException exception = new ResourceAdapterInternalException(NLS.getFormattedMessage("UNRECOGNISED_CONNECTION_CWSIV0403", new Object[]{connection, SibRaConnection.class}, null));
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
            throw exception;
        }
        sibRaConnection.setManagedConnection(this);
        this._connections.add(sibRaConnection);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"associateConnection");
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"addConnectionEventListener", (Object)listener);
        }
        this._eventListeners.add(listener);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"addConnectionEventListener");
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"removeConnectionEventListener", (Object)listener);
        }
        this._eventListeners.remove(listener);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"removeConnectionEventListener");
        }
    }

    public XAResource getXAResource() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getXAResource");
        }
        if (this._xaResource == null) {
            this._xaResource = new SibRaXaResource();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getXAResource", (Object)this._xaResource);
        }
        return this._xaResource;
    }

    public LocalTransaction getLocalTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getLocalTransaction");
        }
        if (this._localTransaction == null) {
            this._localTransaction = new SibRaLocalTransaction();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getLocalTransaction", (Object)this._localTransaction);
        }
        return this._localTransaction;
    }

    public ManagedConnectionMetaData getMetaData() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getMetaData");
        }
        if (this._metaData == null) {
            this._metaData = new SibRaMetaData();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getMetaData", (Object)this._metaData);
        }
        return this._metaData;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this._logWriter = logWriter;
    }

    public PrintWriter getLogWriter() {
        return this._logWriter;
    }

    public void dissociateConnections() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"dissociateConnections");
        }
        for (SibRaConnection connection : this._connections) {
            connection.setManagedConnection(null);
        }
        this._connections.clear();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"dissociateConnections");
        }
    }

    boolean matches(SibRaConnectionInfo connectionInfo, SICoreConnection coreConnection) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"matches", (Object)new Object[]{connectionInfo, coreConnection});
        }
        boolean match = !this.isValid() ? false : (coreConnection != null ? this._coreConnection.isEquivalentTo(coreConnection) : this._connectionInfo.equals(connectionInfo));
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"matches", (Object)match);
        }
        return match;
    }

    SITransaction getContainerTransaction(ConnectionManager connectionManager) throws ResourceException {
        SITransaction currentTransaction;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getContainerTransaction", (Object)connectionManager);
        }
        if ((currentTransaction = this.getCurrentTransaction()) == null && connectionManager instanceof LazyEnlistableConnectionManager) {
            ((LazyEnlistableConnectionManager)connectionManager).lazyEnlist((ManagedConnection)this);
            currentTransaction = this.getCurrentTransaction();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getContainerTransaction", (Object)currentTransaction);
        }
        return currentTransaction;
    }

    private SITransaction getCurrentTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getCurrentTransaction");
        }
        SIUncoordinatedTransaction currentTransaction = null;
        if (this._localTransaction != null) {
            currentTransaction = this._localTransaction.getCurrentTransaction();
        }
        if (currentTransaction == null && this._xaResource != null) {
            currentTransaction = this._xaResource.getCurrentTransaction();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getCurrentTransaction", (Object)currentTransaction);
        }
        return currentTransaction;
    }

    void localTransactionStarted(SibRaConnection connection) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"localTransactionStarted", (Object)connection);
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 2);
        event.setConnectionHandle((Object)connection);
        for (ConnectionEventListener listener : this._eventListeners) {
            listener.localTransactionStarted(event);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"localTransactionStarted");
        }
    }

    void localTransactionCommitted(SibRaConnection connection) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"localTransactionCommitted", (Object)connection);
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 3);
        event.setConnectionHandle((Object)connection);
        for (ConnectionEventListener listener : this._eventListeners) {
            listener.localTransactionCommitted(event);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"localTransactionStarted");
        }
    }

    void localTransactionRolledBack(SibRaConnection connection) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"localTransactionRolledBack", (Object)connection);
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 4);
        event.setConnectionHandle((Object)connection);
        for (ConnectionEventListener listener : this._eventListeners) {
            listener.localTransactionRolledback(event);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"localTransactionRolledBack");
        }
    }

    void connectionClosed(SibRaConnection connection) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"connectionClosed", (Object)connection);
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle((Object)connection);
        for (ConnectionEventListener listener : this._eventListeners) {
            listener.connectionClosed(event);
        }
        this._connections.remove(connection);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"connectionClosed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void connectionErrorOccurred(Exception exception, boolean callJCAListener) {
        String methodName = "connectionErrorOccurred";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"connectionErrorOccurred", (Object)new Object[]{exception, callJCAListener});
        }
        if (!SibRaEngineComponent.isServerStopping()) {
            ArrayList copy;
            ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, exception);
            Set set = this._eventListeners;
            synchronized (set) {
                copy = new ArrayList(this._eventListeners);
            }
            if (callJCAListener) {
                for (Object object : copy) {
                    if (!(object instanceof ConnectionEventListener)) continue;
                    ((ConnectionEventListener)object).connectionErrorOccurred(event);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"connectionErrorOccurred");
        }
    }

    public Exception getConnectionException() {
        return this._connectionException;
    }

    public boolean isValid() {
        return this._validConnection;
    }

    private final class SibRaConnectionListener
    implements SICoreConnectionListener {
        private SibRaConnectionListener() {
        }

        public void asynchronousException(ConsumerSession consumer, Throwable exception) {
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                String methodName = "asynchronousException";
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"asynchronousException", (Object)new Object[]{consumer, exception});
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"asynchronousException");
            }
        }

        public void meQuiescing(SICoreConnection connection) {
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                String methodName = "meQuiescing";
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meQuiescing", (Object)connection);
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meQuiescing");
            }
        }

        public void commsFailure(SICoreConnection connection, SIConnectionLostException exception) {
            String methodName = "commsFailure";
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"commsFailure", (Object)new Object[]{connection, exception});
            }
            SibRaManagedConnection.this.connectionErrorOccurred((Exception)exception, false);
            SibRaManagedConnection.this._validConnection = false;
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"commsFailure");
            }
        }

        public void meTerminated(SICoreConnection connection) {
            String methodName = "meTerminated";
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meTerminated", (Object)connection);
            }
            SibRaManagedConnection.this.connectionErrorOccurred(null, false);
            SibRaManagedConnection.this._validConnection = false;
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meTerminated");
            }
        }
    }

    private final class SibRaXaResource
    implements XAResource {
        private final SIXAResource _delegateXaResource;

        public SibRaXaResource() throws ResourceException {
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaXaResource");
            }
            try {
                this._delegateXaResource = SibRaManagedConnection.this._coreConnection.getSIXAResource();
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection$SibRaXaResource.SibRaXaResource", (String)SibRaManagedConnection.FFDC_PROBE_6, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (Exception)((Object)exception));
                }
                throw new ResourceException(NLS.getFormattedMessage("XARESOURCE_CREATE_CWSIV0408", new Object[]{exception}, null), (Throwable)exception);
            }
            catch (SIErrorException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection$SibRaXaResource.SibRaXaResource", (String)SibRaManagedConnection.FFDC_PROBE_12, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (Exception)((Object)exception));
                }
                throw new ResourceException(NLS.getFormattedMessage("XARESOURCE_CREATE_CWSIV0408", new Object[]{exception}, null), (Throwable)exception);
            }
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaXaResource");
            }
        }

        @Override
        public void commit(Xid xid, boolean onePhase) throws XAException {
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"commit", (Object)new Object[]{xid, onePhase});
            }
            this._delegateXaResource.commit(xid, onePhase);
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"commit");
            }
        }

        @Override
        public void end(Xid xid, int flags) throws XAException {
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"end", (Object)new Object[]{xid, flags});
            }
            this._delegateXaResource.end(xid, flags);
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"end");
            }
        }

        @Override
        public void forget(Xid xid) throws XAException {
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"forget", (Object)xid);
            }
            this._delegateXaResource.forget(xid);
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"forget");
            }
        }

        @Override
        public int getTransactionTimeout() throws XAException {
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"getTransactionTimeout");
            }
            int result = this._delegateXaResource.getTransactionTimeout();
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"getTransactionTimeout", (Object)result);
            }
            return result;
        }

        @Override
        public boolean isSameRM(XAResource other) throws XAException {
            boolean sameRm;
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"isSameRM", (Object)other);
            }
            if (other instanceof SibRaXaResource) {
                SibRaXaResource otherSibRaXaResource = (SibRaXaResource)other;
                sameRm = this._delegateXaResource.isSameRM((XAResource)otherSibRaXaResource._delegateXaResource);
            } else {
                sameRm = this._delegateXaResource.isSameRM(other);
            }
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"isSameRM", (Object)sameRm);
            }
            return sameRm;
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"prepare", (Object)xid);
            }
            int result = this._delegateXaResource.prepare(xid);
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"prepare", (Object)result);
            }
            return result;
        }

        @Override
        public Xid[] recover(int flags) throws XAException {
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"recover", (Object)flags);
            }
            Xid[] result = this._delegateXaResource.recover(flags);
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"recover", (Object)result);
            }
            return result;
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"rollback", (Object)xid);
            }
            this._delegateXaResource.rollback(xid);
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"rollback");
            }
        }

        @Override
        public boolean setTransactionTimeout(int timeout) throws XAException {
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"setTransactionTimeout", (Object)timeout);
            }
            boolean result = this._delegateXaResource.setTransactionTimeout(timeout);
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"setTransactionTimeout", (Object)result);
            }
            return result;
        }

        @Override
        public void start(Xid xid, int flags) throws XAException {
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"start", (Object)new Object[]{xid, flags});
            }
            this._delegateXaResource.start(xid, flags);
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"start");
            }
        }

        private SIXAResource getCurrentTransaction() {
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"getCurrentTransaction");
            }
            SIXAResource currentTransaction = this._delegateXaResource.isEnlisted() ? this._delegateXaResource : null;
            if (TraceComponent.isAnyTracingEnabled() && XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"getCurrentTransaction", (Object)currentTransaction);
            }
            return currentTransaction;
        }
    }

    private final class SibRaLocalTransaction
    implements LocalTransaction {
        private SIUncoordinatedTransaction _uncoordinatedTransaction;

        private SibRaLocalTransaction() {
        }

        public void begin() throws ResourceException {
            if (TraceComponent.isAnyTracingEnabled() && LOCAL_TRAN_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (String)"begin");
            }
            if (this._uncoordinatedTransaction != null) {
                LocalTransactionException exception = new LocalTransactionException(NLS.getString("ACTIVE_LOCAL_TRAN_CWSIV0404"));
                if (TraceComponent.isAnyTracingEnabled() && LOCAL_TRAN_TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (Exception)exception);
                }
                throw exception;
            }
            try {
                this._uncoordinatedTransaction = SibRaManagedConnection.this._coreConnection.createUncoordinatedTransaction();
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection$SibRaLocalTransaction.begin", (String)SibRaManagedConnection.FFDC_PROBE_3, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && LOCAL_TRAN_TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (Exception)((Object)exception));
                }
                throw new ResourceException(NLS.getFormattedMessage("LOCAL_TRAN_BEGIN_CWSIV0405", new Object[]{exception}, null), (Throwable)exception);
            }
            catch (SIErrorException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection$SibRaLocalTransaction.begin", (String)SibRaManagedConnection.FFDC_PROBE_9, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && LOCAL_TRAN_TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (Exception)((Object)exception));
                }
                throw new ResourceException(NLS.getFormattedMessage("LOCAL_TRAN_BEGIN_CWSIV0405", new Object[]{exception}, null), (Throwable)exception);
            }
            if (TraceComponent.isAnyTracingEnabled() && LOCAL_TRAN_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (String)"begin");
            }
        }

        public void commit() throws ResourceException {
            if (TraceComponent.isAnyTracingEnabled() && LOCAL_TRAN_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (String)"commit");
            }
            if (this._uncoordinatedTransaction == null) {
                for (SibRaConnection connection : SibRaManagedConnection.this._connections) {
                    connection.commitApplicationLocalTransaction();
                }
            } else {
                try {
                    this._uncoordinatedTransaction.commit();
                }
                catch (SIException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection$SibRaLocalTranssaction.commit", (String)SibRaManagedConnection.FFDC_PROBE_4, (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && LOCAL_TRAN_TRACE.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (Exception)((Object)exception));
                    }
                    throw new ResourceException(NLS.getFormattedMessage("LOCAL_TRAN_COMMIT_CWSIV0406", new Object[]{exception}, null), (Throwable)exception);
                }
                catch (SIErrorException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection$SibRaLocalTranssaction.commit", (String)SibRaManagedConnection.FFDC_PROBE_10, (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && LOCAL_TRAN_TRACE.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (Exception)((Object)exception));
                    }
                    throw new ResourceException(NLS.getFormattedMessage("LOCAL_TRAN_COMMIT_CWSIV0406", new Object[]{exception}, null), (Throwable)exception);
                }
                finally {
                    this._uncoordinatedTransaction = null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && LOCAL_TRAN_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (String)"commit");
            }
        }

        /*
         * Unable to fully structure code
         */
        public void rollback() throws ResourceException {
            if (TraceComponent.isAnyTracingEnabled() && SibRaManagedConnection.access$600().isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)SibRaManagedConnection.access$600(), (String)"rollback");
            }
            if (this._uncoordinatedTransaction == null) {
                for (SibRaConnection connection : SibRaManagedConnection.access$900(SibRaManagedConnection.this)) {
                    connection.rollbackApplicationLocalTransaction();
                }
            } else {
                try {
                    this._uncoordinatedTransaction.rollback();
                }
                catch (SIException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection$SibRaLocalTranssaction.rollback", (String)"5", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !SibRaManagedConnection.access$600().isEventEnabled()) ** GOTO lbl24
                    SibTr.exception((Object)this, (TraceComponent)SibRaManagedConnection.access$600(), (Exception)exception);
                }
                catch (SIErrorException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection$SibRaLocalTranssaction.rollback", (String)"11", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !SibRaManagedConnection.access$600().isEventEnabled()) ** GOTO lbl24
                    SibTr.exception((Object)this, (TraceComponent)SibRaManagedConnection.access$600(), (Exception)exception);
                }
                finally {
                    this._uncoordinatedTransaction = null;
                }
            }
lbl24:
            // 6 sources

            if (TraceComponent.isAnyTracingEnabled() && SibRaManagedConnection.access$600().isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)SibRaManagedConnection.access$600(), (String)"rollback");
            }
        }

        private SIUncoordinatedTransaction getCurrentTransaction() {
            return this._uncoordinatedTransaction;
        }
    }

    private final class SibRaMetaData
    implements ManagedConnectionMetaData {
        private SibRaMetaData() {
        }

        public String getEISProductName() {
            return "";
        }

        public String getEISProductVersion() {
            return "";
        }

        public int getMaxConnections() {
            return 0;
        }

        public String getUserName() {
            return SibRaManagedConnection.this._connectionInfo.getUserName();
        }
    }
}

