/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.CosNaming.tnaming;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.yoko.orb.CosNaming.NamingContextBase;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIteratorHelper;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingIteratorPOA;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.BindingTypeHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class TransientNamingContext
extends NamingContextBase {
    protected HashMap bindings = new HashMap();
    protected Object rootContext = null;

    public TransientNamingContext(ORB orb, POA poa) throws Exception {
        this(orb, poa, null);
        byte[] objectId = poa.activate_object((Servant)this);
        this.rootContext = poa.id_to_reference(objectId);
    }

    public TransientNamingContext(ORB orb, POA poa, Object root) throws Exception {
        super(orb, poa);
        this.rootContext = root;
    }

    @Override
    public NamingContext new_context() throws SystemException {
        try {
            TransientNamingContext newContext = new TransientNamingContext(this.orb, this.poa, this.rootContext);
            byte[] objectId = this.poa.activate_object((Servant)newContext);
            Object obj = this.poa.id_to_reference(objectId);
            return NamingContextHelper.narrow((Object)obj);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw (INTERNAL)new INTERNAL("Unable to create new naming context").initCause((Throwable)e);
        }
    }

    @Override
    public synchronized void destroy() throws NotEmpty {
        if (!this.bindings.isEmpty()) {
            throw new NotEmpty();
        }
        try {
            byte[] objectId = this.poa.servant_to_id((Servant)this);
            if (objectId != null) {
                this.poa.deactivate_object(objectId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void list(int how_many, BindingListHolder bl, BindingIteratorHolder bi) throws SystemException {
        TransientBindingIterator iterator = new TransientBindingIterator(this.poa, (HashMap)this.bindings.clone());
        iterator.next_n(how_many, bl);
        try {
            byte[] objectId = this.poa.activate_object((Servant)iterator);
            Object obj = this.poa.id_to_reference(objectId);
            bi.value = BindingIteratorHelper.narrow((Object)obj);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw (INTERNAL)new INTERNAL("Unable to activate BindingIterator").initCause((Throwable)e);
        }
    }

    @Override
    protected Object resolveObject(NameComponent n, BindingTypeHolder type) throws SystemException {
        if (n.id.length() == 0 && n.kind.length() == 0) {
            type.value = BindingType.ncontext;
            return this.rootContext;
        }
        BindingKey key = new BindingKey(n);
        BoundObject obj = (BoundObject)this.bindings.get(key);
        if (obj == null) {
            return null;
        }
        type.value = obj.type;
        return obj.boundObject;
    }

    @Override
    protected void bindObject(NameComponent n, Object obj, BindingTypeHolder type) throws SystemException {
        this.bindings.put(new BindingKey(n), new BoundObject(n, obj, type.value));
    }

    @Override
    protected Object unbindObject(NameComponent n) throws SystemException {
        BindingKey key = new BindingKey(n);
        BoundObject obj = (BoundObject)this.bindings.remove(key);
        if (obj != null) {
            return obj.boundObject;
        }
        return null;
    }

    public Object getRootContext() {
        return this.rootContext;
    }

    public class TransientBindingIterator
    extends BindingIteratorPOA {
        private POA poa;
        private HashMap bindings;
        private Iterator iterator;

        public TransientBindingIterator(POA poa, HashMap bindings) {
            this.poa = poa;
            this.bindings = bindings;
            this.iterator = bindings.values().iterator();
        }

        public boolean next_one(BindingHolder b) {
            if (this.iterator.hasNext()) {
                BoundObject obj = (BoundObject)this.iterator.next();
                b.value = new Binding(new NameComponent[]{obj.name}, obj.type);
                return true;
            }
            b.value = new Binding(new NameComponent[0], BindingType.nobject);
            return false;
        }

        public boolean next_n(int how_many, BindingListHolder bl) {
            ArrayList<Binding> accum = new ArrayList<Binding>();
            BindingHolder holder = new BindingHolder();
            for (int i = 0; i < how_many && this.next_one(holder); ++i) {
                accum.add(holder.value);
            }
            bl.value = accum.toArray(new Binding[accum.size()]);
            return accum.isEmpty();
        }

        public void destroy() {
            try {
                byte[] objectId = this.poa.servant_to_id((Servant)this);
                if (objectId != null) {
                    this.poa.deactivate_object(objectId);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class BindingKey {
        public NameComponent name;
        private int hashval = 0;

        public BindingKey(NameComponent n) {
            this.name = n;
            if (this.name.id != null) {
                this.hashval += this.name.id.hashCode();
            }
            if (this.name.kind != null) {
                this.hashval += this.name.kind.hashCode();
            }
        }

        public int hashCode() {
            return this.hashval;
        }

        public boolean equals(java.lang.Object other) {
            if (other == null || !(other instanceof BindingKey)) {
                return false;
            }
            BindingKey otherKey = (BindingKey)other;
            if (this.name.id != null) {
                if (otherKey.name.id == null) {
                    return false;
                }
                if (!this.name.id.equals(otherKey.name.id)) {
                    return false;
                }
            } else if (otherKey.name.id != null) {
                return false;
            }
            if (this.name.kind != null) {
                if (otherKey.name.kind == null) {
                    return false;
                }
                if (!this.name.kind.equals(otherKey.name.kind)) {
                    return false;
                }
            } else if (otherKey.name.kind != null) {
                return false;
            }
            return true;
        }
    }

    public class BoundObject {
        public NameComponent name;
        public BindingType type;
        public Object boundObject;

        public BoundObject(NameComponent name, Object boundObject, BindingType type) {
            this.name = name;
            this.boundObject = boundObject;
            this.type = type;
        }
    }
}

