/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.logging.VerboseLogging;
import org.apache.yoko.orb.OB.GIOPConnection;
import org.apache.yoko.orb.OB.OAInterface;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.OCI.ConnectorInfo;
import org.apache.yoko.orb.OCI.Transport;
import org.apache.yoko.util.Assert;
import org.omg.CORBA.SystemException;

abstract class GIOPServerStarter {
    static final Logger logger = Logger.getLogger(GIOPServerStarter.class.getName());
    protected final ORBInstance orbInstance_;
    protected final Acceptor acceptor_;
    protected final OAInterface oaInterface_;
    protected final Vector connections_ = new Vector();
    protected ServerState serverState;

    protected void finalize() throws Throwable {
        Assert.ensure((this.serverState == ServerState.CLOSED ? 1 : 0) != 0);
        super.finalize();
    }

    protected void logCloseAcceptor() {
        if (VerboseLogging.CONN_IN_LOG.isLoggable(Level.FINE)) {
            VerboseLogging.CONN_IN_LOG.fine("stopped accepting connections\n" + this.acceptor_.get_info().describe());
        }
    }

    protected void reapWorkers() {
        int i = 0;
        while (i < this.connections_.size()) {
            GIOPConnection connection = (GIOPConnection)this.connections_.elementAt(i);
            if (connection.destroyed()) {
                this.connections_.removeElementAt(i);
                continue;
            }
            ++i;
        }
    }

    GIOPServerStarter(ORBInstance orbInstance, Acceptor acceptor, OAInterface oaInterface) {
        this.orbInstance_ = orbInstance;
        this.acceptor_ = acceptor;
        this.oaInterface_ = oaInterface;
        this.serverState = ServerState.HOLDING;
        try {
            if (VerboseLogging.CONN_IN_LOG.isLoggable(Level.FINE)) {
                VerboseLogging.CONN_IN_LOG.fine("accepting connections\n" + this.acceptor_.get_info().describe());
            }
            this.acceptor_.listen();
        }
        catch (SystemException ex) {
            this.acceptor_.close();
            this.serverState = ServerState.CLOSED;
            throw ex;
        }
    }

    public synchronized GIOPConnection getMatchingConnection(ConnectorInfo connInfo) {
        this.reapWorkers();
        for (int i = 0; i < this.connections_.size(); ++i) {
            Transport transport;
            GIOPConnection worker = (GIOPConnection)this.connections_.elementAt(i);
            if (worker.isOutbound() || (transport = worker.transport()) == null || !transport.get_info().endpoint_alias_match(connInfo)) continue;
            return worker;
        }
        return null;
    }

    public abstract void setState(ServerState var1);

    static enum ServerState {
        ACTIVE,
        HOLDING,
        CLOSED;


        public boolean cannotTransitionTo(ServerState next) {
            if (this == next) {
                return true;
            }
            if (this == HOLDING) {
                return false;
            }
            return this.compareTo(next) > 0;
        }
    }
}

