/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import org.apache.yoko.io.ReadBuffer;
import org.apache.yoko.orb.OB.CodeSetReader;
import org.apache.yoko.util.MinorCodes;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;

final class UTF8Reader
extends CodeSetReader {
    UTF8Reader() {
    }

    @Override
    public char read_char(ReadBuffer readBuffer) throws DATA_CONVERSION {
        char value;
        byte first = readBuffer.readByte();
        if ((first & 0x80) == 0) {
            return (char)first;
        }
        if ((first & 0xF8) == 192) {
            value = (char)(first & 0x1F);
        } else if ((first & 0xF8) == 224) {
            value = (char)(first & 0xF);
            if ((readBuffer.peekByte() & 0xC0) != 128) {
                throw new DATA_CONVERSION(MinorCodes.describeDataConversion((int)1095974915), 1095974915, CompletionStatus.COMPLETED_NO);
            }
            value = (char)(value << 6);
            value = (char)(value | readBuffer.readByte() & 0x3F);
        } else {
            throw new DATA_CONVERSION(MinorCodes.describeDataConversion((int)1095974914), 1095974914, CompletionStatus.COMPLETED_NO);
        }
        if ((readBuffer.peekByte() & 0xC0) != 128) {
            throw new DATA_CONVERSION(MinorCodes.describeDataConversion((int)1095974915), 1095974915, CompletionStatus.COMPLETED_NO);
        }
        value = (char)(value << 6);
        value = (char)(value | readBuffer.readByte() & 0x3F);
        return value;
    }

    @Override
    public char read_wchar(ReadBuffer readBuffer, int len) throws DATA_CONVERSION {
        return this.read_char(readBuffer);
    }

    @Override
    public int count_wchar(char first) {
        if ((first & 0x80) == 0) {
            return 1;
        }
        if ((first & 0xF8) == 192) {
            return 2;
        }
        if ((first & 0xF8) == 224) {
            return 3;
        }
        throw new DATA_CONVERSION(MinorCodes.describeDataConversion((int)1095974914), 1095974914, CompletionStatus.COMPLETED_NO);
    }

    @Override
    public void set_flags(int flags) {
    }
}

