/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.smallrye.metrics.cdi.adapters51;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics50.helper.Util;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.RegistryScope;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@ApplicationScoped
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MetricRegistryProducerAdapter {
    private static final TraceComponent tc = Tr.register(MetricRegistryProducerAdapter.class, null, null);
    static Class<?> srMetricsProducerClass = Util.SR_METRIC_REGISTRY_PRODUCER_CLASS;
    static Object srMetricsProducerObj;
    static final long serialVersionUID = -5038739855255016876L;

    @Produces
    @RegistryScope
    @Default
    public MetricRegistry getMetricRegistry(InjectionPoint ip) {
        if (srMetricsProducerObj == null) {
            return null;
        }
        MetricRegistry mr = null;
        try {
            Method method = srMetricsProducerObj.getClass().getMethod("getMetricRegistry", InjectionPoint.class);
            mr = (MetricRegistry)method.invoke(srMetricsProducerObj, ip);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.cdi.adapters51.MetricRegistryProducerAdapter", (String)"80", (Object)this, (Object[])new Object[]{ip});
        }
        return mr;
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    public static MetricRegistry getApplicationRegistry() {
        if (srMetricsProducerObj == null) {
            return null;
        }
        MetricRegistry mr = null;
        try {
            Method method = srMetricsProducerObj.getClass().getMethod("getApplicationRegistry", new Class[0]);
            mr = (MetricRegistry)method.invoke(srMetricsProducerObj, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.cdi.adapters51.MetricRegistryProducerAdapter", (String)"100", null, (Object[])new Object[0]);
        }
        return mr;
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.BASE)
    public static MetricRegistry getBaseRegistry() {
        if (srMetricsProducerObj == null) {
            return null;
        }
        MetricRegistry mr = null;
        try {
            Method method = srMetricsProducerObj.getClass().getMethod("getBaseRegistry", new Class[0]);
            mr = (MetricRegistry)method.invoke(srMetricsProducerObj, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.cdi.adapters51.MetricRegistryProducerAdapter", (String)"120", null, (Object[])new Object[0]);
        }
        return mr;
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.VENDOR)
    public static MetricRegistry getVendorRegistry() {
        if (srMetricsProducerObj == null) {
            return null;
        }
        MetricRegistry mr = null;
        try {
            Method method = srMetricsProducerObj.getClass().getMethod("getVendorRegistry", new Class[0]);
            mr = (MetricRegistry)method.invoke(srMetricsProducerObj, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.cdi.adapters51.MetricRegistryProducerAdapter", (String)"140", null, (Object[])new Object[0]);
        }
        return mr;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        if (srMetricsProducerClass == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The SmallRye MetricRegistryProducer class was not resolved.", (Object[])new Object[0]);
            }
        } else {
            try {
                srMetricsProducerObj = srMetricsProducerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.cdi.adapters51.MetricRegistryProducerAdapter", (String)"58", null, (Object[])new Object[0]);
            }
        }
    }
}

