/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.monitor;

import com.ibm.websphere.monitor.annotation.Args;
import com.ibm.websphere.monitor.annotation.Monitor;
import com.ibm.websphere.monitor.annotation.ProbeAtEntry;
import com.ibm.websphere.monitor.annotation.ProbeAtReturn;
import com.ibm.websphere.monitor.annotation.ProbeSite;
import com.ibm.websphere.monitor.annotation.PublishedMetric;
import com.ibm.websphere.monitor.annotation.This;
import com.ibm.websphere.monitor.meters.MeterCollection;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherLink;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.http.HttpRequest;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import io.openliberty.http.monitor.HttpServerStats;
import io.openliberty.http.monitor.HttpStatAttributes;
import io.openliberty.http.monitor.metrics.MetricsManager;
import jakarta.servlet.GenericServlet;
import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Monitor(group={"HTTP"})
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HttpServerStatsMonitor
extends StatisticActions {
    private static final TraceComponent tc = Tr.register(HttpServerStatsMonitor.class, null, null);
    private static final ThreadLocal<HttpStatAttributes> tl_httpStats = new ThreadLocal();
    private static final ThreadLocal<Long> tl_startNanos = new ThreadLocal();
    private static final ConcurrentHashMap<String, Set<String>> appNameToStat = new ConcurrentHashMap();
    private static HttpServerStatsMonitor instance;
    @PublishedMetric
    public MeterCollection<HttpServerStats> HttpConnByRoute;
    static final long serialVersionUID = -8008154116969702307L;

    public HttpServerStatsMonitor() {
        if (instance == null) {
            instance = this;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.format("Multiple attempts to create %s. We already have an instance", HttpServerStatsMonitor.class.getName()), (Object[])new Object[0]);
        }
        this.HttpConnByRoute = new MeterCollection("HttpMetrics", (Object)this);
    }

    public static HttpServerStatsMonitor getInstance() {
        if (instance != null) {
            return instance;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.format("No instance of %s found", HttpServerStatsMonitor.class.getName()), (Object[])new Object[0]);
        }
        return null;
    }

    @ProbeAtReturn
    @ProbeSite(clazz="com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherLink", method="sendResponse", args="com.ibm.wsspi.http.channel.values.StatusCodes,java.lang.String,java.lang.Exception,boolean")
    public void atSendResponseReturn(@This Object probedHttpDispatcherLinkObj) {
        long elapsedNanos = System.nanoTime() - tl_startNanos.get();
        HttpStatAttributes retrievedHttpStatAttr = tl_httpStats.get();
        if (retrievedHttpStatAttr == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to retrieve HttpStatAttributes. Unable to record time.", (Object[])new Object[0]);
            }
            return;
        }
        this.updateHttpStatDuration(retrievedHttpStatAttr, Duration.ofNanos(elapsedNanos), null);
    }

    private void resolveNetwortProtocolInfo(String protocolInfo, HttpStatAttributes httpStat) {
        String[] networkInfo = protocolInfo.trim().split("/");
        String networkProtocolName = null;
        String networkVersion = "";
        if (networkInfo.length == 1) {
            networkProtocolName = networkInfo[0].toLowerCase();
        } else if (networkInfo.length == 2) {
            networkProtocolName = networkInfo[0];
            networkVersion = networkInfo[1];
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.format("More values than expected when parsing protocol information: [%s]", protocolInfo), (Object[])new Object[0]);
        }
        httpStat.setNetworkProtocolName(networkProtocolName);
        httpStat.setNetworkProtocolVersion(networkVersion);
    }

    /*
     * WARNING - void declaration
     */
    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherLink", method="sendResponse", args="com.ibm.wsspi.http.channel.values.StatusCodes,java.lang.String,java.lang.Exception,boolean")
    public void atSendResponse(@This Object probedHttpDispatcherLinkObj, @Args Object[] myargs) {
        tl_httpStats.set(null);
        tl_startNanos.set(System.nanoTime());
        HttpStatAttributes httpStatAttributes = new HttpStatAttributes();
        if (myargs.length > 0) {
            if (myargs[0] != null && myargs[0] instanceof StatusCodes) {
                StatusCodes statCode = (StatusCodes)myargs[0];
                httpStatAttributes.setResponseStatus(statCode.getIntCode());
            }
            if (myargs[2] != null && myargs[2] instanceof Exception) {
                Exception exception = (Exception)myargs[2];
                httpStatAttributes.setException(exception);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Could not resolve response code", (Object[])new Object[0]);
        }
        if (probedHttpDispatcherLinkObj != null) {
            block10: {
                HttpDispatcherLink httpDispatcherLink = (HttpDispatcherLink)probedHttpDispatcherLinkObj;
                httpStatAttributes.setServerName(httpDispatcherLink.getRequestedHost());
                httpStatAttributes.setServerPort(httpDispatcherLink.getRequestedPort());
                try {
                    HttpRequest httpRequest = httpDispatcherLink.getRequest();
                    httpStatAttributes.setHttpRoute(httpRequest.getURI());
                    httpStatAttributes.setRequestMethod(httpRequest.getMethod());
                    httpStatAttributes.setScheme(httpRequest.getScheme());
                    this.resolveNetwortProtocolInfo(httpRequest.getVersion(), httpStatAttributes);
                }
                catch (Exception httpRequest) {
                    void e;
                    FFDCFilter.processException((Throwable)httpRequest, (String)"io.openliberty.http.monitor.HttpServerStatsMonitor", (String)"177", (Object)((Object)this), (Object[])new Object[]{probedHttpDispatcherLinkObj, myargs});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                    Tr.debug((TraceComponent)tc, (String)String.format("Exception occured %s" + e, new Object[0]), (Object[])new Object[0]);
                }
            }
            tl_httpStats.set(httpStatAttributes);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Failed to obtain HttpDispatcherLink Object from probe", (Object[])new Object[0]);
        }
    }

    public void updateHttpStatDuration(HttpStatAttributes httpStatAttributes, Duration duration, String appName) {
        if (!httpStatAttributes.validate()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)String.format("Invalid HTTP Stats attributes : \n %s", httpStatAttributes.toString()), (Object[])new Object[0]);
            }
            return;
        }
        String key = this.resolveStatsKey(httpStatAttributes);
        HttpServerStats hss = (HttpServerStats)this.HttpConnByRoute.get(key);
        if (hss == null && (hss = this.initializeHttpStat(key, httpStatAttributes, appName)) == null) {
            return;
        }
        hss.updateDuration(duration);
        if (MetricsManager.getInstance() != null) {
            MetricsManager.getInstance().updateHttpMetrics(httpStatAttributes, duration);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No Available Metric runtimes to forward HTTP stats to.", (Object[])new Object[0]);
        }
    }

    private synchronized HttpServerStats initializeHttpStat(String key, HttpStatAttributes statAttri, String appName) {
        if (this.HttpConnByRoute.get(key) != null) {
            return (HttpServerStats)this.HttpConnByRoute.get(key);
        }
        HttpServerStats httpMetricStats = new HttpServerStats(statAttri);
        this.HttpConnByRoute.put(key, (Object)httpMetricStats);
        if (this.HttpConnByRoute.get(key) == null) {
            return null;
        }
        if (appName != null) {
            appNameToStat.compute(appName, (appNameKey, currValSet) -> {
                if (currValSet == null) {
                    HashSet<String> hs = new HashSet<String>();
                    hs.add(key);
                    return hs;
                }
                currValSet.add(key);
                return currValSet;
            });
        }
        return httpMetricStats;
    }

    public void removeStat(String appName) {
        Set<String> retSet = appNameToStat.get(appName);
        if (retSet != null) {
            for (String statName : retSet) {
                this.HttpConnByRoute.remove(statName);
            }
        }
    }

    private String resolveStatsKey(HttpStatAttributes httpStatAttributes) {
        Optional<String> httpRoute = httpStatAttributes.getHttpRoute();
        Optional<String> errorType = httpStatAttributes.getErrorType();
        String requestMethod = httpStatAttributes.getRequestMethod();
        Optional<Integer> responseStatus = httpStatAttributes.getResponseStatus();
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append("method:" + requestMethod);
        responseStatus.ifPresent(status -> sb.append(";status:" + status));
        httpRoute.ifPresent(route -> sb.append(";httpRoute:" + route.replace("*", "\\*")));
        errorType.ifPresent(error -> sb.append(";errorType:" + error));
        sb.append("\"");
        return sb.toString();
    }

    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ws.webcontainer.servlet.ServletWrapper", method="destroy")
    public void atServletDestroy(@This GenericServlet s) {
        String appName = (String)s.getServletContext().getAttribute("com.ibm.websphere.servlet.enterprise.application.name");
        this.removeStat(appName);
    }
}

