/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Optional;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HttpStatAttributes {
    String requestMethod;
    String scheme;
    String networkProtocolName;
    String networkProtocolVersion;
    String serverName;
    int serverPort;
    Optional<Exception> exception = Optional.ofNullable(null);
    Optional<String> errorType = Optional.ofNullable(null);
    Optional<String> httpRoute = Optional.ofNullable(null);
    Optional<Integer> responseStatus = Optional.ofNullable(null);
    static final long serialVersionUID = 3884131047434281728L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public boolean validate() {
        return this.requestMethod != null && this.scheme != null && this.networkProtocolName != null && this.networkProtocolVersion != null && this.serverName != null && this.serverPort != 0;
    }

    public Optional<String> getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String error) {
        this.errorType = Optional.ofNullable(error);
    }

    public Optional<Exception> getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = Optional.ofNullable(exception);
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getNetworkProtocolName() {
        return this.networkProtocolName;
    }

    public String getNetworkProtocolVersion() {
        return this.networkProtocolVersion;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Optional<String> getHttpRoute() {
        return this.httpRoute;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public Optional<Integer> getResponseStatus() {
        return this.responseStatus;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setHttpRoute(String httpRoute) {
        this.httpRoute = Optional.ofNullable(httpRoute);
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setNetworkProtocolName(String networkProtocolName) {
        this.networkProtocolName = networkProtocolName;
    }

    public void setNetworkProtocolVersion(String networkProtocolVersion) {
        this.networkProtocolVersion = networkProtocolVersion;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setResponseStatus(int responseStatus) {
        this.responseStatus = Optional.ofNullable(responseStatus);
        if (responseStatus >= 500) {
            this.setErrorType(String.valueOf(responseStatus));
        }
    }

    public String toString() {
        return String.format(" ------- \nRequest Method (mandatory): [%s] \nScheme (mandatory): [%s] \nNetwork Protocol Name (optional): [%s] \nNetwork Protocol Version (mandatory): [%s] \nServer Name (mandatory): [%s] \nServer Port (mandatory): [%d] \nHTTP Route (Optional: can be empty): [%s] \nResponse Status (Optional: can be -1): [%d] \nError Type(Optional - can be empty): [%s]", this.requestMethod, this.scheme, this.networkProtocolName, this.networkProtocolVersion, this.serverName, this.serverPort, this.httpRoute.orElse(""), this.responseStatus.orElse(-1), this.errorType.orElse(""));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.http.monitor.HttpStatAttributes", HttpStatAttributes.class, null, null);
    }
}

